/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiffShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckDiffMapper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDiffShareRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDiffVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeSettlementCheckDiffRepository
extends ServiceImpl<AuditFeeSettlementCheckDiffMapper, AuditFeeSettlementCheckDiff> {
    @Autowired
    private AuditFeeSettlementCheckDiffShareRepository auditFeeSettlementCheckDiffShareRepository;

    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AuditFeeSettlementCheckDiff::getCode, codes)).remove();
        LambdaQueryWrapper deleteShareWrapper = new LambdaQueryWrapper();
        deleteShareWrapper.in(AuditFeeSettlementCheckDiffShare::getCode, codes);
        this.auditFeeSettlementCheckDiffShareRepository.remove((Wrapper)deleteShareWrapper);
    }

    public List<AuditFeeSettlementCheckDiffVo> findAllByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return new ArrayList<AuditFeeSettlementCheckDiffVo>(0);
        }
        return ((AuditFeeSettlementCheckDiffMapper)this.baseMapper).findWithShareByCodes(Lists.newArrayList((Object[])new String[]{code}), TenantUtils.getTenantCode());
    }

    public void saveWithShare(List<AuditFeeSettlementCheckDiff> diffList) {
        if (CollectionUtils.isEmpty(diffList)) {
            return;
        }
        ArrayList shares = new ArrayList(diffList.size());
        diffList.forEach(e -> {
            e.setId(null);
            AuditFeeSettlementCheckDiffShare share = new AuditFeeSettlementCheckDiffShare();
            share.setCode(e.getCode());
            share.setFeeDiffLedgerCode(e.getFeeDiffLedgerCode());
            share.setDeductAmount(e.getDeductAmount());
            shares.add(share);
        });
        this.saveBatch(diffList);
        this.auditFeeSettlementCheckDiffShareRepository.saveBatch(shares);
    }
}

