/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckSettlement;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckSettlementMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeSettlementCheckSettlementRepository
extends ServiceImpl<AuditFeeSettlementCheckSettlementMapper, AuditFeeSettlementCheckSettlement> {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public List<AuditFeeSettlementCheckSettlement> findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditFeeSettlementCheckSettlement::getCode, (Object)code)).list();
    }

    public AuditFeeSettlementCheckSettlement findByDetailCode(String settlementDetailCode) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        query.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        query.eq(AuditFeeSettlementCheckSettlement::getSettlementDetailCode, (Object)settlementDetailCode);
        query.last("limit 1");
        return (AuditFeeSettlementCheckSettlement)((Object)this.getOne((Wrapper)query));
    }

    public Page<AuditFeeSettlementCheckSettlementVo> findByConditions(Page<AuditFeeSettlementCheckSettlementVo> page, AuditFeeSettlementCheckSettlementDto dto) {
        return ((AuditFeeSettlementCheckSettlementMapper)this.baseMapper).findByConditions(page, dto);
    }

    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AuditFeeSettlementCheckSettlement::getCode, codes)).remove();
    }

    public List<AuditFeeSettlementCheckSettlement> findByCodeAndSettlementDetailCodes(String code, List<String> settlementDetailCodes) {
        if (StringUtils.isEmpty((CharSequence)code) || CollectionUtils.isEmpty(settlementDetailCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeSettlementCheckSettlement::getCode, (Object)code)).in(AuditFeeSettlementCheckSettlement::getSettlementDetailCode, settlementDetailCodes)).list();
    }

    public List<String> findSettlementDetailCodeBySettlementDetailCodes(List<String> settlementDetailCodes) {
        if (CollectionUtils.isEmpty(settlementDetailCodes)) {
            return new ArrayList<String>(0);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{AuditFeeSettlementCheckSettlement::getSettlementDetailCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeSettlementCheckSettlement::getSettlementDetailCode, settlementDetailCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeSettlementCheckSettlement::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<String> findSettlementDetailCodeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<String>(0);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{AuditFeeSettlementCheckSettlement::getSettlementDetailCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeSettlementCheckSettlement::getCode, codes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeSettlementCheckSettlement::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<AuditFeeSettlementCheckSettlementDto> findAllByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeSettlementCheckSettlement::getCode, (Object)code)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditFeeSettlementCheckSettlement.class, AuditFeeSettlementCheckSettlementDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public AuditFeeSettlementCheckSettlement findFirstByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        AuditFeeSettlementCheckSettlement settlement = ((AuditFeeSettlementCheckSettlementMapper)this.baseMapper).findFirstByCode(code);
        return settlement;
    }
}

