/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.track;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailExtend;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailLedger;
import com.biz.crm.tpm.business.audit.fee.local.mapper.track.AuditFeeDiffTrackDetailMapper;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailExtendRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeDiffTrackDetailRepository
extends ServiceImpl<AuditFeeDiffTrackDetailMapper, AuditFeeDiffTrackDetail> {
    @Autowired
    private AuditFeeDiffTrackDetailExtendRepository auditFeeDiffTrackDetailExtendRepository;
    @Autowired
    private AuditFeeDiffTrackDetailLedgerRepository auditFeeDiffTrackDetailLedgerRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public Page<AuditFeeDiffTrackDetailVo> findByConditions(Page<AuditFeeDiffTrackDetailVo> page, AuditFeeDiffTrackDetailDto dto) {
        return ((AuditFeeDiffTrackDetailMapper)this.baseMapper).findByConditions(page, dto);
    }

    public AuditFeeDiffTrackDetail findById(String id) {
        AuditFeeDiffTrackDetail auditFeeDiffTrackDetail = (AuditFeeDiffTrackDetail)((Object)((AuditFeeDiffTrackDetailMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (auditFeeDiffTrackDetail == null) {
            return null;
        }
        AuditFeeDiffTrackDetailExtend extend = this.auditFeeDiffTrackDetailExtendRepository.findById(auditFeeDiffTrackDetail.getId());
        if (extend == null) {
            return auditFeeDiffTrackDetail;
        }
        BeanUtils.copyProperties((Object)((Object)extend), (Object)((Object)auditFeeDiffTrackDetail));
        return auditFeeDiffTrackDetail;
    }

    public List<AuditFeeDiffTrackDetailVo> findByPlanCodeList(List<String> planCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planCodeList)) {
            return new ArrayList<AuditFeeDiffTrackDetailVo>();
        }
        List<AuditFeeDiffTrackDetailVo> detailPLanList = ((AuditFeeDiffTrackDetailMapper)this.baseMapper).findByPlanCodeList(planCodeList);
        List<AuditFeeDiffTrackDetailLedger> diffList = this.auditFeeDiffTrackDetailLedgerRepository.findByPlanCodeList(planCodeList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(diffList)) {
            Collection diffVoList = this.nebulaToolkitService.copyCollectionByBlankList(diffList, AuditFeeDiffTrackDetailLedger.class, AuditFeeDiffTrackDetailLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<AuditFeeDiffTrackDetailLedgerVo>> detailCodeDiffMap = diffVoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getDetailCode));
            for (AuditFeeDiffTrackDetailVo vo : detailPLanList) {
                vo.setAuditFeeDiffTrackDetailLedgerList(detailCodeDiffMap.get(vo.getDetailCode()));
            }
        }
        return detailPLanList;
    }

    public void createBatch(List<AuditFeeDiffTrackDetailDto> detailDtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailDtoList)) {
            return;
        }
        for (AuditFeeDiffTrackDetailDto dto : detailDtoList) {
            AuditFeeDiffTrackDetail auditFeeDiffTrackDetail = (AuditFeeDiffTrackDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffTrackDetail.class, HashSet.class, ArrayList.class, new String[0]));
            auditFeeDiffTrackDetail.setIsClose(BooleanEnum.FALSE.getCapital());
            auditFeeDiffTrackDetail.setCowManagerState(InterfacePushStateEnum.NOT_PUSH.getCode());
            this.initInfo(auditFeeDiffTrackDetail);
            if (auditFeeDiffTrackDetail.getDetailCode() == null) {
                auditFeeDiffTrackDetail.setDetailCode((String)this.generateCodeService.generateCode("DHD", 1).get(0));
            }
            List diffList = dto.getAuditFeeDiffTrackDetailLedgerList();
            BigDecimal salesAmount = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)diffList)) {
                for (AuditFeeDiffTrackDetailLedgerDto diffDto : diffList) {
                    Validate.notNull((Object)diffDto.getUsedAmount(), (String)"\u5dee\u5f02\u8d39\u7528\u4f7f\u7528\u91d1\u989d\u4e3a\u7a7a", (Object[])new Object[0]);
                    AuditFeeDiffTrackDetailLedger diffTrackDetailLedger = (AuditFeeDiffTrackDetailLedger)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)diffDto, AuditFeeDiffTrackDetailLedger.class, HashSet.class, ArrayList.class, new String[0]));
                    this.initInfo(diffTrackDetailLedger);
                    diffTrackDetailLedger.setDetailCode(auditFeeDiffTrackDetail.getDetailCode());
                    diffTrackDetailLedger.setPlanCode(auditFeeDiffTrackDetail.getPlanCode());
                    this.auditFeeDiffTrackDetailLedgerRepository.save((Object)diffTrackDetailLedger);
                    salesAmount = salesAmount.add(diffTrackDetailLedger.getUsedAmount());
                }
            }
            auditFeeDiffTrackDetail.setSalesAmount(salesAmount);
            this.save((Object)auditFeeDiffTrackDetail);
            AuditFeeDiffTrackDetailExtend extend = (AuditFeeDiffTrackDetailExtend)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffTrackDetailExtend.class, HashSet.class, ArrayList.class, new String[0]));
            extend.setId(auditFeeDiffTrackDetail.getId());
            this.auditFeeDiffTrackDetailExtendRepository.save((Object)extend);
        }
    }

    public void removeBatchByPlanCodeList(List<String> planCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(planCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeDiffTrackDetail::getPlanCode, planCodeList)).update();
        this.auditFeeDiffTrackDetailLedgerRepository.removeBatchByPlanCodeList(planCodeList);
    }

    public List<AuditFeeDiffTrackDetailVo> findByTemplateConfigCodeList(List<String> templateConfigCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(templateConfigCodeList)) {
            return new ArrayList<AuditFeeDiffTrackDetailVo>();
        }
        return ((AuditFeeDiffTrackDetailMapper)this.baseMapper).findByTemplateConfigCodeList(templateConfigCodeList);
    }

    public List<AuditFeeDiffTrackDetail> findByIds(List<String> ids) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return new ArrayList<AuditFeeDiffTrackDetail>(0);
        }
        ArrayList<AuditFeeDiffTrackDetail> auditFeeDiffTrackDetailList = new ArrayList<AuditFeeDiffTrackDetail>();
        for (String id : ids) {
            AuditFeeDiffTrackDetail byId = this.findById(id);
            auditFeeDiffTrackDetailList.add(byId);
        }
        return auditFeeDiffTrackDetailList;
    }

    private void initInfo(TenantFlagOpEntity entity) {
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setId(UUID.randomUUID().toString().replace("-", ""));
    }

    public Page<AuditFeeDiffTrackDetailVo> auditFindByConditions(Page<AuditFeeDiffTrackDetailVo> page, AuditFeeDiffTrackDetailDto dto) {
        return ((AuditFeeDiffTrackDetailMapper)this.baseMapper).auditFindByConditions(page, dto);
    }

    public void updateDetailPlanCowManagerState(List<String> successCodes) {
        if (CollectionUtils.isEmpty(successCodes)) {
            return;
        }
    }

    public void updateAlreadyAuditAmountByValidationPass(List<AuditFeeDiffTrackDetailDto> updateList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(updateList)) {
            return;
        }
        ((AuditFeeDiffTrackDetailMapper)this.baseMapper).updateAlreadyAuditAmountByValidationPass(updateList, TenantUtils.getTenantCode());
    }

    public List<AuditFeeDiffTrackDetailVo> findByDetailCodes(List<String> detailCodes) {
        return ((AuditFeeDiffTrackDetailMapper)this.baseMapper).findByDetailCodes(detailCodes, TenantUtils.getTenantCode());
    }

    public List<String> findEndCastFormByDetailCodes(List<String> detailCodes) {
        return ((AuditFeeDiffTrackDetailMapper)this.baseMapper).findEndCastFormByDetailCodes(detailCodes, TenantUtils.getTenantCode());
    }

    public List<AuditFeeDiffTrackDetailVo> pushCowManagerManual() {
        return ((AuditFeeDiffTrackDetailMapper)this.baseMapper).findNeedBePushCowManagerButNot(TenantUtils.getTenantCode());
    }
}

