/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.track;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrack;
import com.biz.crm.tpm.business.audit.fee.local.mapper.track.AuditFeeDiffTrackMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeDiffTrackRepository
extends ServiceImpl<AuditFeeDiffTrackMapper, AuditFeeDiffTrack> {
    public Page<AuditFeeDiffTrackVo> findByConditions(Page<AuditFeeDiffTrackVo> page, AuditFeeDiffTrackDto dto) {
        return ((AuditFeeDiffTrackMapper)this.baseMapper).findByConditions(page, dto);
    }

    public AuditFeeDiffTrack findById(String id) {
        return (AuditFeeDiffTrack)((Object)((AuditFeeDiffTrackMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<AuditFeeDiffTrack> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public AuditFeeDiffTrack findByPlanCode(String planCode) {
        if (planCode == null) {
            return null;
        }
        return (AuditFeeDiffTrack)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeDiffTrack::getPlanCode, (Object)planCode)).last("limit 1")).one());
    }

    public void updateProcessStatusAndProcessNo(List<String> codeList, String processStatus, String processNo) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(AuditFeeDiffTrack.class).set(AuditFeeDiffTrack::getProcessStatus, (Object)processStatus)).set(AuditFeeDiffTrack::getProcessNo, (Object)processNo)).in(AuditFeeDiffTrack::getPlanCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void updateProcessStatus(List<String> codeList, String processStatus) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(AuditFeeDiffTrack.class).set(AuditFeeDiffTrack::getProcessStatus, (Object)processStatus)).in(AuditFeeDiffTrack::getPlanCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void initInfo(TenantFlagOpEntity entity) {
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setId(UUID.randomUUID().toString().replace("-", ""));
    }

    public AuditFeeDiffTrack findByProcessNo(String processNo) {
        return (AuditFeeDiffTrack)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeDiffTrack::getProcessNo, (Object)processNo)).one());
    }
}

