/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckDetailExportsDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchResultEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditCheckDetailExportsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.base.CaseFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditCheckDetailExportProcess
implements ExportProcess<AuditCheckDetailExportsVo> {
    @Autowired(required=false)
    private AuditFeeCheckMapper auditFeeCheckMapper;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    private static final String CACHE_KEY = "tpm:AuditCheckDetailExportProcess:";
    private static final String SOURCE_TYPE = "source_type";
    private static final String DETAIL_PLAN = "detail_plan";
    private static final String COST = "cost";
    private static final String DIFF = "diff";

    public Integer getTotal(Map<String, Object> params) {
        AuditCheckDetailExportsDto dto = this.transferParamToDto(params);
        Integer total = this.getTotalTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private Integer getTotalTotal(AuditCheckDetailExportsDto dto) {
        Integer detailPlanTotal = this.auditFeeCheckMapper.getTotal(dto, "1");
        Integer costTotal = this.auditFeeCheckMapper.getTotal(dto, "2");
        return detailPlanTotal + costTotal;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditCheckDetailExportsDto dto = this.transferParamToDto(params);
        dto.setOffset(Integer.valueOf(vo.getPageNo() * this.getPageSize()));
        dto.setLimit(this.getPageSize());
        List<AuditCheckDetailExportsVo> data = this.findDataAll(vo, dto);
        this.codeToDesc(data);
        return JSON.parseArray((String)JSON.toJSONString(data));
    }

    public List<AuditCheckDetailExportsVo> findDataAll(ExportTaskProcessVo vo, AuditCheckDetailExportsDto dto) {
        AuditCheckDetailExportsDto pageDto;
        Integer limit = dto.getLimit();
        ArrayList<AuditCheckDetailExportsVo> result = new ArrayList<AuditCheckDetailExportsVo>();
        String key = CACHE_KEY + vo.getTaskCode() + ":" + SOURCE_TYPE;
        Object sourceType = this.redisService.get(key);
        if (Objects.isNull(sourceType) || DETAIL_PLAN.equals(sourceType.toString())) {
            pageDto = this.getCachePage(vo, dto, DETAIL_PLAN, 0);
            List<AuditCheckDetailExportsVo> detailPlanVos = this.auditFeeCheckMapper.findData(pageDto, "1");
            this.buildCachePage(vo, dto, DETAIL_PLAN, detailPlanVos.size());
            result.addAll(detailPlanVos);
        }
        if (result.size() == limit.intValue()) {
            this.redisService.set(key, (Object)DETAIL_PLAN, 21600L);
            return result;
        }
        if (Objects.isNull(sourceType) || COST.equals(sourceType.toString())) {
            pageDto = this.getCachePage(vo, dto, COST, result.size());
            List<AuditCheckDetailExportsVo> costVos = this.auditFeeCheckMapper.findData(pageDto, "2");
            this.buildCachePage(vo, dto, COST, costVos.size());
            result.addAll(costVos);
        }
        if (result.size() == limit.intValue()) {
            this.redisService.set(key, (Object)COST, 21600L);
            return result;
        }
        this.redisService.del(key);
        return result;
    }

    private AuditCheckDetailExportsDto getCachePage(ExportTaskProcessVo vo, AuditCheckDetailExportsDto dto, String sourceType, Integer offset) {
        String key = CACHE_KEY + vo.getTaskCode() + ":" + sourceType;
        Object o = this.redisService.get(key);
        if (Objects.isNull(o)) {
            dto.setLimit(Integer.valueOf(dto.getLimit() - offset));
            return dto;
        }
        return (AuditCheckDetailExportsDto)JSONObject.parseObject((String)o.toString(), AuditCheckDetailExportsDto.class);
    }

    private void buildCachePage(ExportTaskProcessVo vo, AuditCheckDetailExportsDto dto, String sourceType, Integer currSize) {
        String key = CACHE_KEY + vo.getTaskCode() + ":" + sourceType;
        AuditCheckDetailExportsDto cacheVo = new AuditCheckDetailExportsDto();
        BeanUtils.copyProperties((Object)dto, (Object)cacheVo);
        cacheVo.setOffset(Integer.valueOf(dto.getOffset() + currSize));
        this.redisService.set(key, (Object)JSONObject.toJSONString((Object)cacheVo), 21600L);
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u8d39\u7528\u6838\u5bf9\u660e\u7ec6\u5bfc\u51fa";
    }

    public Class<AuditCheckDetailExportsVo> findCrmExcelVoClass() {
        return AuditCheckDetailExportsVo.class;
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public AuditCheckDetailExportsDto transferParamToDto(Map<String, Object> params) {
        HashMap<String, Object> lowerCamelParamMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (!param.contains("_")) continue;
            String lowerCamelParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, param.substring(0, param.lastIndexOf("_")));
            lowerCamelParamMap.put(lowerCamelParam, entry.getValue());
        }
        AuditCheckDetailExportsDto dto = (AuditCheckDetailExportsDto)JSONObject.parseObject((String)JSON.toJSONString(lowerCamelParamMap), AuditCheckDetailExportsDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }

    public void codeToDesc(List<AuditCheckDetailExportsVo> data) {
        Map formatDictMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_format");
        Map unitDictMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
        Map templateTypeDictMap = this.dictToolkitService.findMapByDictTypeCode("tpm_deduction_matching_template_type");
        Map regionDictMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        for (AuditCheckDetailExportsVo exportsVo : data) {
            MatchResultEnum resultEnum;
            MatchStatusEnum statusEnum;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)formatDictMap.get(exportsVo.getBusinessFormatCode())))) {
                exportsVo.setBusinessFormatCode((String)formatDictMap.get(exportsVo.getBusinessFormatCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)unitDictMap.get(exportsVo.getBusinessUnitCode())))) {
                exportsVo.setBusinessUnitCode((String)unitDictMap.get(exportsVo.getBusinessUnitCode()));
            }
            if (Objects.nonNull(statusEnum = MatchStatusEnum.getEnumByCode((String)exportsVo.getMatchStatus()))) {
                exportsVo.setMatchStatus(statusEnum.getDesc());
            }
            if (Objects.nonNull(resultEnum = MatchResultEnum.getEnumByCode((String)exportsVo.getMatchResult()))) {
                exportsVo.setMatchResult(resultEnum.getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)exportsVo.getIsShare())) {
                for (BooleanEnum booleanEnum : BooleanEnum.values()) {
                    if (!StringUtils.equals((CharSequence)booleanEnum.getCapital(), (CharSequence)exportsVo.getIsShare())) continue;
                    exportsVo.setIsShare(booleanEnum.getSure());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)templateTypeDictMap.get(exportsVo.getMatchTemplateType())))) {
                exportsVo.setMatchTemplateType((String)templateTypeDictMap.get(exportsVo.getMatchTemplateType()));
            }
            if (Objects.nonNull(exportsVo.getReconciliationDate())) {
                exportsVo.setReconciliationDateStr(DateUtil.dateToStr((Date)exportsVo.getReconciliationDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM));
            }
            if (Objects.nonNull(exportsVo.getReconciliationDateTime())) {
                exportsVo.setReconciliationDateTimeStr(DateUtil.dateToStr((Date)exportsVo.getReconciliationDateTime(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)regionDictMap.get(exportsVo.getAreaCode())))) {
                exportsVo.setAreaCode((String)regionDictMap.get(exportsVo.getAreaCode()));
            }
            if (Objects.nonNull(exportsVo.getBeginTime())) {
                exportsVo.setBeginTimeStr(DateUtil.dateToStr((Date)exportsVo.getBeginTime(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss));
            }
            if (Objects.nonNull(exportsVo.getEndTime())) {
                exportsVo.setEndTimeStr(DateUtil.dateToStr((Date)exportsVo.getEndTime(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss));
            }
            if (!Objects.nonNull(exportsVo.getDocumentsDate())) continue;
            exportsVo.setDocumentsDateStr(DateUtil.dateToStr((Date)exportsVo.getDocumentsDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss));
        }
    }
}

