/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.service.exports.vo.AuditFeeCheckCostExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeCheckCostExportProcess
implements ExportProcess<AuditFeeCheckCostExportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckCostExportProcess.class);
    @Autowired(required=false)
    private AuditFeeCheckCostVoCacheService checkCostVoCacheService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getTotal(Map<String, Object> params) {
        log.info("\u8d39\u7528\u6838\u5bf9-\u8d39\u7528\u5355\u5bfc\u51fa-getTotal");
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u672a\u4f20\u5165cacheKey", (Object[])new Object[0]);
        long total = this.checkCostVoCacheService.findCacheListSize(String.valueOf(cacheKey));
        Validate.isTrue((total < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Math.toIntExact(total);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        log.info("\u8d39\u7528\u6838\u5bf9-\u8d39\u7528\u5355\u5bfc\u51fa-getData");
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u672a\u4f20\u5165cacheKey", (Object[])new Object[0]);
        List dataList = this.checkCostVoCacheService.findCacheList(String.valueOf(cacheKey));
        List<AuditFeeCheckCostExportVo> exportVoList = this.adjustData(dataList);
        return this.toJSONArray(exportVoList);
    }

    private List<AuditFeeCheckCostExportVo> adjustData(List<AuditFeeCheckCostVo> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return new ArrayList<AuditFeeCheckCostExportVo>(0);
        }
        List exportVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dataList, AuditFeeCheckCostVo.class, AuditFeeCheckCostExportVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map regionDictMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        for (AuditFeeCheckCostExportVo exportVo : exportVoList) {
            exportVo.setDeductionAmountTaxStr(String.valueOf(exportVo.getDeductionAmountTax()));
            exportVo.setBusinessAreaStr((String)regionDictMap.get(exportVo.getBusinessArea()));
        }
        return exportVoList;
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_CHECK_COST_EXPORT";
    }

    public String getBusinessName() {
        return "\u8d39\u7528\u6838\u5bf9-\u8d39\u7528\u5355\u5bfc\u51fa";
    }
}

