/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.service.exports.vo.AuditFeeCheckDetailPlanExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeCheckDetailPlanExportProcess
implements ExportProcess<AuditFeeCheckDetailPlanExportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckDetailPlanExportProcess.class);
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoCacheService auditFeeCheckDetailPlanVoCacheService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Integer getTotal(Map<String, Object> params) {
        log.info("\u8d39\u7528\u6838\u5bf9-\u7ec6\u6848\u5bfc\u51fa-getTotal");
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u672a\u4f20\u5165cacheKey", (Object[])new Object[0]);
        long total = this.auditFeeCheckDetailPlanVoCacheService.findCacheListSize(String.valueOf(cacheKey));
        Validate.isTrue((total < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Math.toIntExact(total);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        log.info("\u8d39\u7528\u6838\u5bf9-\u7ec6\u6848\u5bfc\u51fa-getData");
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u672a\u4f20\u5165cacheKey", (Object[])new Object[0]);
        List dataList = this.auditFeeCheckDetailPlanVoCacheService.findCacheList(String.valueOf(cacheKey));
        List<AuditFeeCheckDetailPlanExportVo> exportVoList = this.adjustData(dataList);
        return this.toJSONArray(exportVoList);
    }

    private List<AuditFeeCheckDetailPlanExportVo> adjustData(List<AuditFeeCheckDetailPlanVo> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return new ArrayList<AuditFeeCheckDetailPlanExportVo>(0);
        }
        List exportVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dataList, AuditFeeCheckDetailPlanVo.class, AuditFeeCheckDetailPlanExportVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditFeeCheckDetailPlanExportVo exportVo : exportVoList) {
            exportVo.setActivityBeginDateStr(DateUtil.formatDate((Date)exportVo.getActivityBeginDate()));
            exportVo.setActivityEndDateStr(DateUtil.formatDate((Date)exportVo.getActivityEndDate()));
            exportVo.setApplyAmountStr(this.avoidNullToString(exportVo.getApplyAmount()));
            exportVo.setPredictionAuditAmountStr(this.avoidNullToString(exportVo.getPredictionAuditAmount()));
            exportVo.setAlreadyAuditAmountStr(this.avoidNullToString(exportVo.getAlreadyAuditAmount()));
            exportVo.setCanAuditAmountStr(this.avoidNullToString(exportVo.getCanAuditAmount()));
            exportVo.setAuditFeeCheckShareAmountStr(this.avoidNullToString(exportVo.getAuditFeeCheckShareAmount()));
            exportVo.setToBeSupplementedAmountStr(this.avoidNullToString(exportVo.getToBeSupplementedAmount()));
            exportVo.setThisAuditAmountStr(this.avoidNullToString(exportVo.getThisAuditAmount()));
        }
        return exportVoList;
    }

    private String avoidNullToString(Object o) {
        return o == null ? null : String.valueOf(o);
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_CHECK_DETAIL_PLAN_EXPORT";
    }

    public String getBusinessName() {
        return "\u8d39\u7528\u6838\u5bf9-\u7ec6\u6848\u5bfc\u51fa";
    }
}

