/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckSettlementService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeSettlementCheckSettlementExportsProcess
implements ExportProcess<AuditFeeSettlementCheckSettlementExportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeSettlementCheckSettlementExportsProcess.class);
    @Autowired
    private AuditFeeSettlementCheckSettlementService settlementService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Integer total = this.settlementService.getTotal((String)params.get("cacheKey"));
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        AuditFeeSettlementCheckSettlementDto dto = new AuditFeeSettlementCheckSettlementDto();
        Page cachePage = this.settlementService.findCachePageList((Pageable)pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0L) {
            return new JSONArray();
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)cachePage.getRecords(), AuditFeeSettlementCheckSettlementVo.class, AuditFeeSettlementCheckSettlementExportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.buildDate(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    private void buildDate(Collection<AuditFeeSettlementCheckSettlementExportVo> exportsVos) {
        Map regionDictMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        if (CollectionUtils.isNotEmpty(exportsVos)) {
            exportsVos.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)regionDictMap.get(e.getBusinessArea())))) {
                    e.setBusinessArea((String)regionDictMap.get(e.getBusinessArea()));
                }
            });
        }
    }

    public String getBusinessCode() {
        return "AUDIT_FEE_SETTLEMENT_CHECK_SETTLEMENT_EXPORT";
    }

    public String getBusinessName() {
        return "\u7ed3\u7b97\u6838\u5bf9-\u7ed3\u7b97\u5355\u5bfc\u51fa";
    }
}

