/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDetailPlanMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideExportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeVerifyDecideExportProcess
implements ExportProcess<AuditFeeVerifyDecideExportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVerifyDecideExportProcess.class);
    @Resource
    private AuditFeeCheckDetailPlanMapper auditFeeCheckDetailPlanMapper;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        AuditFeeVerifyDecideDto dto = this.transferParamToDto(params);
        Integer total = this.auditFeeCheckDetailPlanMapper.findAuditFeeVerifyDecideExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditFeeVerifyDecideDto dto = this.transferParamToDto(params);
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditFeeVerifyDecideVo> result = this.auditFeeCheckDetailPlanMapper.findAuditFeeVerifyDecideByConditionsNew(page, dto);
        Collection exportVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result.getRecords(), AuditFeeVerifyDecideVo.class, AuditFeeVerifyDecideExportVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.codeToDesc(new ArrayList<AuditFeeVerifyDecideExportVo>(exportVos));
        return JSONArray.parseArray((String)JSON.toJSONString((Object)exportVos));
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_VERIFY_DECIDE_EXPORT";
    }

    public String getBusinessName() {
        return "\u6263\u8d39\u6838\u5b9a\u8868\u5bfc\u51fa";
    }

    public Class<AuditFeeVerifyDecideExportVo> findCrmExcelVoClass() {
        return AuditFeeVerifyDecideExportVo.class;
    }

    public AuditFeeVerifyDecideDto transferParamToDto(Map<String, Object> params) {
        HashMap<String, Object> lowerCamelParamMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (!param.contains("_")) continue;
            String lowerCamelParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, param.substring(0, param.lastIndexOf("_")));
            lowerCamelParamMap.put(lowerCamelParam, entry.getValue());
        }
        AuditFeeVerifyDecideDto dto = (AuditFeeVerifyDecideDto)JSONObject.parseObject((String)JSON.toJSONString(lowerCamelParamMap), AuditFeeVerifyDecideDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }

    public void codeToDesc(List<AuditFeeVerifyDecideExportVo> exportVos) {
        List businessUnitDict = this.dictDataVoService.findByDictTypeCode("mdm_business_unit");
        Map<String, String> businessUnitDictMap = businessUnitDict.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        List businessFormatDict = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        Map<String, String> businessFormatDictMap = businessFormatDict.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        List regionDictType = this.dictDataVoService.findByDictTypeCode("MDM_CUSTOMIZE_ORG");
        Map<String, String> regionMap = regionDictType.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        for (AuditFeeVerifyDecideExportVo exportVo : exportVos) {
            if (StringUtils.isNotBlank((CharSequence)exportVo.getBusinessFormatCode())) {
                exportVo.setBusinessFormatName(businessFormatDictMap.get(exportVo.getBusinessFormatCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getBusinessUnitCode())) {
                exportVo.setBusinessUnitName(businessUnitDictMap.get(exportVo.getBusinessUnitCode()));
            }
            if (!StringUtils.isNotBlank((CharSequence)exportVo.getActivityOrgCode())) continue;
            exportVo.setActivityOrgName(regionMap.get(exportVo.getActivityOrgCode()));
        }
    }
}

