/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosService;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeCheckPosImportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
public class AuditFeeCheckPosImportProcess
implements ImportProcess<AuditFeeCheckPosImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosImportProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeCheckPosService auditFeeCheckPosService;
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeCheckPosImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = Maps.newHashMap();
        Assert.notEmpty(data, (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
        Assert.notEmpty(data.values(), (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
        try {
            this.baseVal(data, errorMap);
            if (CollectionUtil.isNotEmpty((Map)errorMap)) {
                return errorMap;
            }
            this.dataVal(data, errorMap);
            if (CollectionUtil.isEmpty((Map)errorMap)) {
                this.saveData(new ArrayList<AuditFeeCheckPosImportVo>(data.values()));
            }
        }
        catch (Exception e) {
            log.error("POS\u6d3b\u52a8\u6838\u5bf9\u6279\u91cf\u5bfc\u5165\u8c03\u6574");
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return errorMap;
    }

    private void saveData(ArrayList<AuditFeeCheckPosImportVo> auditFeeCheckPosImportVos) {
        List posImportVosGroupList = Lists.partition(auditFeeCheckPosImportVos, (int)400);
        Map<String, String> codeMap = auditFeeCheckPosImportVos.stream().collect(Collectors.toMap(AuditFeeCheckPosImportVo::getMatchCode, AuditFeeCheckPosImportVo::getActivityDetailItemCode, (n, o) -> n));
        posImportVosGroupList.forEach(list -> {
            List<String> matchCodeList = list.stream().map(AuditFeeCheckPosImportVo::getMatchCode).distinct().collect(Collectors.toList());
            List<AuditFeeCheckPos> checkPosList = this.auditFeeCheckPosRepository.findByMatchCodeList(matchCodeList);
            if (CollectionUtil.isEmpty(checkPosList)) {
                return;
            }
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(checkPosList, AuditFeeCheckPos.class, AuditFeeCheckPosDto.class, HashSet.class, ArrayList.class, new String[0]);
            dtoList.forEach(dto -> {
                dto.setActivityDetailItemCode((String)codeMap.get(dto.getMatchCode()));
                this.auditFeeCheckPosService.update((AuditFeeCheckPosDto)dto);
            });
        });
    }

    private void dataVal(LinkedHashMap<Integer, AuditFeeCheckPosImportVo> data, Map<Integer, String> errorMap) {
        ArrayList matchCodeList = Lists.newArrayList();
        ArrayList activityDetailItemCodeList = Lists.newArrayList();
        data.values().forEach(vo -> {
            if (StringUtil.isNotEmpty((CharSequence)vo.getMatchCode())) {
                matchCodeList.add(vo.getMatchCode());
            }
            if (StringUtil.isNotEmpty((CharSequence)vo.getActivityDetailItemCode())) {
                activityDetailItemCodeList.add(vo.getActivityDetailItemCode());
            }
        });
        int size = 400;
        if (CollectionUtil.isNotEmpty((Collection)matchCodeList)) {
            List matchCodeGroupList = Lists.partition((List)matchCodeList, (int)size);
            HashSet businessUnitCodeSet = Sets.newHashSet();
            AtomicReference businessUnitCode = new AtomicReference();
            matchCodeGroupList.forEach(list -> {
                List<AuditFeeCheckPos> checkPosList = this.auditFeeCheckPosRepository.findByMatchCodeList((List<String>)list);
                if (CollectionUtil.isNotEmpty(checkPosList)) {
                    Map<String, AuditFeeCheckPos> posMap = checkPosList.stream().collect(Collectors.toMap(AuditFeeCheckPos::getMatchCode, v -> v, (n, o) -> n));
                    data.forEach((index, vo) -> {
                        AuditFeeCheckPos pos = (AuditFeeCheckPos)((Object)((Object)((Object)posMap.get(vo.getMatchCode()))));
                        if (Objects.nonNull((Object)pos)) {
                            String errInfo;
                            businessUnitCode.set(pos.getBusinessUnitCode());
                            businessUnitCodeSet.add(pos.getBusinessUnitCode());
                            this.validateIsTrue(businessUnitCodeSet.size() == 1, "\u5355\u6b21\u53ea\u80fd\u5bfc\u5165\u4e00\u4e2a\u4e1a\u52a1\u7684\u6570\u636e! || ");
                            if (BooleanEnum.TRUE.getCapital().equals(pos.getMatchStatus())) {
                                this.validateIsTrue(false, "POS\u6838\u5bf9\u5df2\u786e\u8ba4! || ");
                            } else {
                                vo.setMatch(true);
                            }
                            if (BooleanEnum.TRUE.getCapital().equals(pos.getIsMatchCost())) {
                                this.validateIsTrue(pos.getActivityDetailItemCode().equals(vo.getActivityDetailItemCode()), "POS\u6838\u5bf9\u5355[" + pos.getMatchCode() + "]\u5df2\u5173\u8054\u8d39\u7528\u6838\u5bf9[" + pos.getFeeCheckMatchCode() + "]\uff0c\u8bf7\u5148\u5bf9\u8d39\u7528\u6838\u5bf9\u64cd\u4f5c\u53d6\u6d88\u5339\u914d\u540e\u518d\u5904\u7406POS\u6570\u636e!");
                            }
                            if ((errInfo = this.validateGetErrorInfo()) != null) {
                                errorMap.put((Integer)index, errorMap.getOrDefault(index, "") + errInfo);
                            }
                        }
                    });
                }
            });
            data.forEach((index, vo) -> {
                this.validateIsTrue(vo.isMatch(), "POS\u6838\u5bf9\u5355\u53f7\u4e0d\u5b58\u5728! || ");
                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errorMap.put((Integer)index, errorMap.getOrDefault(index, "") + errInfo);
                }
            });
            if (CollectionUtil.isNotEmpty(errorMap)) {
                return;
            }
            if (CollectionUtil.isNotEmpty((Collection)activityDetailItemCodeList)) {
                AuditFeePredictionDto dto = new AuditFeePredictionDto();
                dto.setBusinessUnitCode((String)businessUnitCode.get());
                PageRequest pageable = PageRequest.of((int)1, (int)size);
                List activityDetailItemCodeGroupList = Lists.partition((List)activityDetailItemCodeList, (int)size);
                activityDetailItemCodeGroupList.forEach(arg_0 -> this.lambda$dataVal$12(dto, (Pageable)pageable, data, arg_0));
            }
            data.forEach((index, vo) -> {
                this.validateIsTrue(vo.isActivityDetailItem(), "\u6d3b\u52a8\u7f16\u7801\u4e0d\u5b58\u5728! || ");
                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errorMap.put((Integer)index, errorMap.getOrDefault(index, "") + errInfo);
                }
            });
        }
    }

    private void baseVal(LinkedHashMap<Integer, AuditFeeCheckPosImportVo> data, Map<Integer, String> errorMap) {
        data.forEach((index, vo) -> {
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getMatchCode()), "POS\u6838\u5bf9\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a! || ");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityDetailItemCode()), "\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a! || ");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errorMap.put((Integer)index, errInfo);
            }
        });
    }

    public Class<AuditFeeCheckPosImportVo> findCrmExcelVoClass() {
        return AuditFeeCheckPosImportVo.class;
    }

    public String getTemplateCode() {
        return "AUDIT_FEE_CHECK_POS_IMPORT";
    }

    public String getTemplateName() {
        return "POS\u6d3b\u52a8\u6838\u5bf9\u6279\u91cf\u5bfc\u5165\u8c03\u6574";
    }

    private /* synthetic */ void lambda$dataVal$12(AuditFeePredictionDto dto, Pageable pageable, LinkedHashMap data, List list) {
        dto.setDetailPlanItemCodes(list);
        Page detailPlanVoPage = this.auditFeeCheckDetailPlanVoService.findDetailPlanByConditionsForImport(pageable, dto);
        if (CollectionUtil.isNotEmpty((Collection)detailPlanVoPage.getRecords())) {
            Map<String, AuditFeeCheckDetailPlanVo> planVoMap = detailPlanVoPage.getRecords().stream().collect(Collectors.toMap(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode, v -> v, (n, o) -> n));
            data.forEach((index, vo) -> {
                AuditFeeCheckDetailPlanVo detailPlanVo = (AuditFeeCheckDetailPlanVo)planVoMap.get(vo.getActivityDetailItemCode());
                if (Objects.nonNull(detailPlanVo)) {
                    vo.setActivityDetailCode(detailPlanVo.getDetailPlanCode());
                    vo.setActivityDetailName(detailPlanVo.getDetailPlanName());
                    vo.setActivityDetailItemCode(detailPlanVo.getDetailPlanItemCode());
                    vo.setActivityDetailItemName(detailPlanVo.getDetailPlanName());
                    vo.setActivityDetailItem(true);
                }
            });
        }
    }
}

