/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.imports;

import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.mn.common.base.util.MnBeanUtils;
import com.biz.crm.mn.common.ie.sdk.process.MnImportProcess;
import com.biz.crm.mn.common.ie.sdk.vo.MnCrmExcelVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffDisposeDetailImportVo;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose.AuditFeeDiffDisposeDetailPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Component
public class AuditFeeDiffDisposeDetailImportProcess
extends MnImportProcess<AuditFeeDiffDisposeDetailImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeDetailImportProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private AuditFeeDiffDisposeDetailPageCacheHelper cacheHelper;
    @Autowired
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    public Integer getHeadTitleRowIndex() {
        return 0;
    }

    public Map<Integer, String> analysisHeadFieldMap(Map<String, Object> params, Map<Integer, String> headMap) {
        String templateConfigCode = String.valueOf(params.get("templateConfigCode"));
        Assert.hasText((String)templateConfigCode, (String)"\u5dee\u5f02\u8d39\u7528\u6a21\u7248\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ActivitiesTemplateConfigVo templateConfigVo = this.activitiesTemplateSdkService.findByCode(templateConfigCode);
        Assert.notNull((Object)templateConfigVo, (String)"\u672a\u67e5\u5230\u5dee\u5f02\u8d39\u7528\u6a21\u7248\u4fe1\u606f");
        Map<String, String> templateFieldMap = templateConfigVo.getDetails().stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getTitle())).collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getTitle, ActivitiesTemplateConfigDetailVo::getField, (o, n) -> n));
        HashMap headFieldMap = Maps.newHashMap();
        for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
            headFieldMap.put(entry.getKey(), templateFieldMap.get(entry.getValue()));
        }
        return headFieldMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeDiffDisposeDetailImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List importMaps = data.values().stream().map(MnCrmExcelVo::getData).collect(Collectors.toList());
        List importVos = MnBeanUtils.mapListToBeanList(importMaps, AuditFeeDiffDisposeDetailDto.class, (boolean)false);
        String cacheKey = String.valueOf(params.get("cacheKey"));
        Assert.hasText((String)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            this.initDict();
            this.validate(importVos);
            importVos.forEach(dto -> this.cacheHelper.importSave(cacheKey, (AuditFeeDiffDisposeDetailDto)dto));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e);
            log.error("\u5dee\u5f02\u8d39\u7528\u5904\u7406\u660e\u7ec6\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return null;
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit"}));
    }

    private void validate(List<AuditFeeDiffDisposeDetailDto> dto) {
        this.verifyDictCode(dto);
    }

    private void verifyDictCode(List<AuditFeeDiffDisposeDetailDto> dto) {
    }

    private String findDictValueOrCode(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictValue().equals(dictValue) || a.getDictCode().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Class<AuditFeeDiffDisposeDetailImportVo> findCrmExcelVoClass() {
        return AuditFeeDiffDisposeDetailImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_DETAIL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6838\u9500\u5dee\u5f02\u8d39\u7528\u5904\u7406\u660e\u7ec6\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_DETAIL_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6838\u9500\u5dee\u5f02\u8d39\u7528\u5904\u7406\u660e\u7ec6\u5bfc\u5165";
    }
}

