/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffDisposeImportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class IAuditFeeDiffDisposeImportProcess
implements ImportProcess<AuditFeeDiffDisposeImportVo> {
    private static final Logger log = LoggerFactory.getLogger(IAuditFeeDiffDisposeImportProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeDiffDisposeImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<AuditFeeDiffDisposeImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        try {
            this.initDict();
            AuditFeeDiffDisposeDto dto = this.validate(first.get());
            this.auditFeeDiffDisposeVoService.importSave(dto);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e);
            log.error("\u5dee\u5f02\u8d39\u7528\u5904\u7406\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return null;
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit", "tpm_expense_center", "MDM_CUSTOMIZE_ORG"}));
    }

    private AuditFeeDiffDisposeDto validate(AuditFeeDiffDisposeImportVo vo) {
        AuditFeeDiffDisposeDto dto = (AuditFeeDiffDisposeDto)this.nebulaToolkitService.copyObjectByBlankList((Object)vo, AuditFeeDiffDisposeDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.verifyDictCode(dto);
        return dto;
    }

    private void verifyDictCode(AuditFeeDiffDisposeDto dto) {
    }

    private String findDictValueOrCode(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictValue().equals(dictValue) || a.getDictCode().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    public Integer getBatchCount() {
        return 1;
    }

    public Class<AuditFeeDiffDisposeImportVo> findCrmExcelVoClass() {
        return AuditFeeDiffDisposeImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6838\u9500\u5dee\u5f02\u8d39\u7528\u5904\u7406\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FEE_DIFF_DISPOSE_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6838\u9500\u5dee\u5f02\u8d39\u7528\u5904\u7406\u5bfc\u5165";
    }
}

