/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.audit.fee.sdk.vo.AuditFeeRespVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeCheckCostVoCacheServiceImpl
implements AuditFeeCheckCostVoCacheService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckCostVoCacheServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private AuditFeeCheckCostVoService auditFeeCheckCostVoService;

    public Page<AuditFeeCheckCostVo> findCachePageList(Pageable pageable, String cacheKey, String matchCode) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheKey);
            page.setTotal(total.longValue());
            List objects = this.redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)objects)) {
                List voList = objects;
                page.setRecords(voList);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)matchCode)) {
            List dtoList = this.auditFeeCheckCostVoService.findDetailByMatchCode(matchCode);
            log.info("\u5546\u8d85\u8d39\u7528\u6838\u5bf9-\u8d39\u7528\u5355\u6570\u636e\uff1a" + JSONArray.toJSONString((Object)dtoList));
            if (!CollectionUtils.isEmpty((Collection)dtoList)) {
                this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), dtoList.toArray());
            }
            page.setTotal((long)dtoList.size());
            long start = page.offset();
            if (page.getTotal() > start) {
                long end = page.offset() + page.getSize();
                if (page.getTotal() < end) {
                    end = page.getTotal();
                }
                List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                page.setRecords(recordDtoList);
            }
        }
        return page;
    }

    public void addItemCache(String cacheKey, List<AuditFeeRespVo> saveList) {
        List objects;
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        HashSet newSet = Sets.newHashSet();
        HashMap saveItemMap = Maps.newHashMap();
        ArrayList auditFeeCheckCostVoList = new ArrayList();
        if (!CollectionUtils.isEmpty(saveList)) {
            ArrayList companyCodes = new ArrayList();
            saveList.forEach(e -> {
                AuditFeeCheckCostVo costVo = (AuditFeeCheckCostVo)this.nebulaToolkitService.copyObjectByWhiteList(e, AuditFeeCheckCostVo.class, HashSet.class, ArrayList.class, new String[0]);
                costVo.setId(null);
                costVo.setCompanyCostCode(e.getTpmDeductionCode());
                costVo.setDeductionAmountTax(e.getAmount());
                auditFeeCheckCostVoList.add(costVo);
                companyCodes.add(e.getTpmDeductionCode());
            });
            List existByCompanyCodes = this.auditFeeCheckCostVoService.findExistByCompanyCodes(companyCodes);
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)existByCompanyCodes), (String)("\u8d39\u7528\u5355\u7f16\u7801" + Arrays.toString(existByCompanyCodes.toArray()) + "\u5df2\u7ecf\u5b58\u5728\u8d39\u7528\u6838\u5bf9\u6570\u636e\u4e2d"));
            saveItemMap.putAll(auditFeeCheckCostVoList.stream().collect(Collectors.toMap(AuditFeeCheckCostVo::getCompanyCostCode, Function.identity(), (a, b) -> a)));
        }
        if (!CollectionUtils.isEmpty((Collection)(objects = this.redisService.lRange(redisCacheKey, 0L, -1L)))) {
            for (Object object : objects) {
                AuditFeeCheckCostVo item = (AuditFeeCheckCostVo)object;
                newSet.add(saveItemMap.getOrDefault(item.getDeductionCode(), item));
            }
        }
        newSet.addAll(auditFeeCheckCostVoList);
        this.redisService.del(redisCacheKey);
        if (!CollectionUtils.isEmpty((Collection)newSet)) {
            this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newSet.toArray());
        }
    }

    public void copyItemListCache(String cacheKey, List<AuditFeeCheckCostVo> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        ArrayList copyList = Lists.newArrayList();
        for (Object object : objects) {
            AuditFeeCheckCostVo item = (AuditFeeCheckCostVo)object;
            if (saveItemMap.containsKey(item.getId())) {
                AuditFeeCheckCostVo newItem = (AuditFeeCheckCostVo)saveItemMap.get(item.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newItem.getChecked())) {
                    AuditFeeCheckCostVo copyItem = (AuditFeeCheckCostVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)newItem, AuditFeeCheckCostVo.class, HashSet.class, ArrayList.class, new String[0]);
                    copyItem.setId(UUID.randomUUID().toString().replace("-", ""));
                    copyItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    copyItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    copyList.add(copyItem);
                }
                newList.add(newItem);
                continue;
            }
            newList.add(item);
        }
        newList.addAll(0, copyList);
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public void saveCurrentPageCache(String cacheKey, List<AuditFeeCheckCostVo> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map saveItemMap = saveList.stream().collect(Collectors.toMap(AuditFeeCheckCostVo::getCompanyCostCode, Function.identity()));
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        ArrayList newList = Lists.newArrayList();
        for (Object object : objects) {
            AuditFeeCheckCostVo item = (AuditFeeCheckCostVo)object;
            newList.add(saveItemMap.getOrDefault(item.getCompanyCostCode(), item));
        }
        this.redisService.del(redisCacheKey);
        this.redisService.lPushAll(redisCacheKey, Long.valueOf(86400L), newList.toArray());
    }

    public List<AuditFeeCheckCostVo> findCacheList(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return Lists.newArrayList();
        }
        List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
        return objects;
    }

    public void clearCache(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        this.redisService.del(redisCacheKey);
    }

    public void deleteCacheList(String cacheKey, List<String> deleteIds) {
        if (!CollectionUtils.isEmpty(deleteIds)) {
            String redisCacheKey = this.getRedisCacheKey(cacheKey);
            List objects = this.redisService.lRange(redisCacheKey, 0L, -1L);
            if (deleteIds.size() == objects.size()) {
                this.clearCache(cacheKey);
            } else {
                for (Object object : objects) {
                    AuditFeeCheckCostVo item = (AuditFeeCheckCostVo)object;
                    if (!deleteIds.contains(item.getId())) continue;
                    this.redisService.lRemove(redisCacheKey, 0L, object);
                }
            }
        }
    }

    public long findCacheListSize(String cacheKey) {
        String redisCacheKey = this.getRedisCacheKey(cacheKey);
        if (!this.redisService.hasKey(redisCacheKey).booleanValue()) {
            return 0L;
        }
        return this.redisService.lSize(redisCacheKey);
    }

    private String getRedisCacheKey(String cacheKey) {
        return "audit_fee:item_cache:cost:" + cacheKey;
    }
}

