/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckCostDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="auditFeeCheckCostService")
public class AuditFeeCheckCostVoServiceImpl
implements AuditFeeCheckCostVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckCostVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeCostService auditFeeCostService;

    public Page<AuditFeeCheckCostVo> findByConditions(Pageable pageable, AuditFeeCheckCostDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckCostDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeCheckCostRepository.findByConditions((Page<AuditFeeCheckCostVo>)page, dto);
    }

    public List<AuditFeeCheckCostVo> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty((CharSequence)matchCode)) {
            return new ArrayList<AuditFeeCheckCostVo>();
        }
        List<AuditFeeCheckCost> auditFeeCheckCosts = this.auditFeeCheckCostRepository.findDetailByMatchCode(matchCode);
        if (CollectionUtils.isEmpty(auditFeeCheckCosts)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeCheckCosts, AuditFeeCheckCost.class, AuditFeeCheckCostVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<AuditFeeCheckCostVo> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckCost> costVos = this.auditFeeCheckCostRepository.findByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(costVos)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(costVos, AuditFeeCheckCost.class, AuditFeeCheckCostVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<String> findExistByCompanyCodes(List<String> companyCodes) {
        if (CollectionUtils.isEmpty(companyCodes)) {
            return Lists.newArrayList();
        }
        return this.auditFeeCheckCostRepository.findExistByCompanyCodes(companyCodes);
    }
}

