/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="auditFeeCheckDetailPlanService")
public class AuditFeeCheckDetailPlanVoServiceImpl
implements AuditFeeCheckDetailPlanVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckDetailPlanVoServiceImpl.class);
    @Autowired
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeePredictionService auditFeePredictionService;

    public Page<AuditFeeCheckDetailPlanVo> findByConditions(Pageable pageable, AuditFeeCheckDetailPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDetailPlanDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeCheckDetailPlanRepository.findByConditions((Page<AuditFeeCheckDetailPlanVo>)page, dto);
    }

    public AuditFeeCheckDetailPlanVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeCheckDetailPlan auditFeeCheckDetailPlan = this.auditFeeCheckDetailPlanRepository.findById(id);
        if (auditFeeCheckDetailPlan == null) {
            return null;
        }
        return (AuditFeeCheckDetailPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeCheckDetailPlan, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<AuditFeeCheckDetailPlanVo> findDetailPlanByConditions(Pageable pageable, AuditFeePredictionDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessFormatCode(), (String)"\u8bf7\u4f20\u5165\u4e1a\u6001", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessUnitCode(), (String)"\u8bf7\u4f20\u5165\u4e1a\u52a1\u5355\u5143", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSystemCode(), (String)"\u8bf7\u4f20\u5165\u96f6\u552e\u5546\u7f16\u7801", (Object[])new Object[0]);
        return this.findDetailPlanByConditionsForImport(pageable, dto);
    }

    public Page<AuditFeeCheckDetailPlanVo> findDetailPlanByConditionsForImport(Pageable pageable, AuditFeePredictionDto dto) {
        List<String> noConfirmByDetailPlanItemCodeList;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto.setWholeAudit(BooleanEnum.FALSE.getCapital());
        dto.setNoRollbackBudgetTagFlag(Boolean.valueOf(true));
        dto.setCanAuditAmountNotNull(Boolean.valueOf(false));
        if (StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)dto.getBusinessUnitCode())) {
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
        } else {
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
        }
        Boolean notPosSearch = dto.getNotPosSearch();
        if (notPosSearch != null && notPosSearch.booleanValue() && CollectionUtils.isNotEmpty(noConfirmByDetailPlanItemCodeList = this.auditFeeCheckDetailPlanRepository.findNoConfirmByDetailPlanItemCodeList(null))) {
            dto.setNotInDetailPlanItemCodes(noConfirmByDetailPlanItemCodeList);
        }
        Page<AuditFeePredictionVo> auditFeePredictionVoPage = this.auditFeePredictionService.findByConditions(pageable, dto);
        return (Page)auditFeePredictionVoPage.convert(e -> {
            AuditFeeCheckDetailPlanVo detailPlanVo = this.predictionConversionPlanItem((AuditFeePredictionVo)e);
            detailPlanVo.setId(null);
            return detailPlanVo;
        });
    }

    private AuditFeeCheckDetailPlanVo predictionConversionPlanItem(AuditFeePredictionVo itemVo) {
        AuditFeeCheckDetailPlan detailPlan = this.auditFeeCheckDetailPlanRepository.initOne();
        AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = (AuditFeeCheckDetailPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailPlan, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        feeCheckDetailPlanVo.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
        feeCheckDetailPlanVo.setDetailPlanCode(itemVo.getDetailPlanCode());
        feeCheckDetailPlanVo.setDetailPlanName(itemVo.getDetailPlanName());
        feeCheckDetailPlanVo.setActivityBeginDate(itemVo.getActivityBeginDate());
        feeCheckDetailPlanVo.setActivityEndDate(itemVo.getActivityEndDate());
        feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format((Date)itemVo.getActivityYearMonth(), (String)"yyyy-MM"));
        feeCheckDetailPlanVo.setSystemCode(itemVo.getSystemCode());
        feeCheckDetailPlanVo.setSystemName(itemVo.getSystemName());
        feeCheckDetailPlanVo.setRegion(itemVo.getRegion());
        feeCheckDetailPlanVo.setRegionName(itemVo.getRegion());
        feeCheckDetailPlanVo.setProvinceCode(itemVo.getProvinceCode());
        feeCheckDetailPlanVo.setProvinceName(itemVo.getProvinceName());
        feeCheckDetailPlanVo.setActivityTypeCode(itemVo.getActivityTypeCode());
        feeCheckDetailPlanVo.setActivityTypeName(itemVo.getActivityTypeName());
        feeCheckDetailPlanVo.setActivityFormCode(itemVo.getActivityFormCode());
        feeCheckDetailPlanVo.setActivityFormName(itemVo.getActivityFormName());
        feeCheckDetailPlanVo.setAuditForm(itemVo.getAuditForm());
        feeCheckDetailPlanVo.setBuyWay(itemVo.getBuyWay());
        feeCheckDetailPlanVo.setCustomerCode(itemVo.getCustomerCode());
        feeCheckDetailPlanVo.setCustomerName(itemVo.getCustomerName());
        feeCheckDetailPlanVo.setTerminalCode(itemVo.getTerminalCode());
        feeCheckDetailPlanVo.setTerminalName(itemVo.getTerminalName());
        feeCheckDetailPlanVo.setProductCode(itemVo.getProductCode());
        feeCheckDetailPlanVo.setProductName(itemVo.getProductName());
        feeCheckDetailPlanVo.setScheduleName(itemVo.getScheduleName());
        feeCheckDetailPlanVo.setApplyAmount(itemVo.getApplyAmount());
        feeCheckDetailPlanVo.setPredictionAuditAmount(itemVo.getPredictionAuditAmount());
        feeCheckDetailPlanVo.setAlreadyAuditAmount(itemVo.getAlreadyAuditAmount());
        feeCheckDetailPlanVo.setCanAuditAmount(itemVo.getCanAuditAmount());
        feeCheckDetailPlanVo.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
        feeCheckDetailPlanVo.setSalesInstitutionName(itemVo.getSalesInstitutionName());
        feeCheckDetailPlanVo.setSingleApplicationFee(itemVo.getSingleApplicationFee());
        feeCheckDetailPlanVo.setRemark(itemVo.getRemark());
        return feeCheckDetailPlanVo;
    }

    public List<AuditFeeCheckDetailPlanVo> createBatch(List<AuditFeeCheckDetailPlanVo> detailPlanVos) {
        if (CollectionUtils.isEmpty(detailPlanVos)) {
            return new ArrayList<AuditFeeCheckDetailPlanVo>();
        }
        List<String> matchCodeList = detailPlanVos.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getAuditFeeCheckCode())).map(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
        this.auditFeeCheckDetailPlanRepository.removeByMatchCodeList(matchCodeList);
        detailPlanVos.forEach(vo -> {
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            vo.setId(UuidCrmUtil.general());
        });
        if (CollectionUtils.isEmpty(matchCodeList)) {
            this.auditFeeCheckDetailPlanRepository.save(detailPlanVos);
        } else {
            this.auditFeeCheckDetailPlanRepository.saveWithShare(detailPlanVos);
        }
        return detailPlanVos;
    }

    public List<AuditFeeCheckDetailPlanVo> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlan> planVos = this.auditFeeCheckDetailPlanRepository.findByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(planVos)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(planVos, AuditFeeCheckDetailPlan.class, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditFeeCheckDetailPlanVo> findByDetailItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlan> list = this.auditFeeCheckDetailPlanRepository.findByDetailPlanItemCodeList(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckDetailPlan.class, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditFeeCheckDetailPlanVo> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlan> list = this.auditFeeCheckDetailPlanRepository.findDetailByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckDetailPlan.class, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

