/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDiffShare;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDiffRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDiffShareRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDiffVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AuditFeeCheckDiffVoServiceImpl
implements AuditFeeCheckDiffVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckDiffVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckDiffRepository auditFeeCheckDiffRepository;
    @Autowired(required=false)
    private AuditFeeCheckDiffShareRepository auditFeeCheckDiffShareRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    public Page<AuditFeeCheckDiffVo> findByConditions(Pageable pageable, AuditFeeCheckDiffDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDiffDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeCheckDiffRepository.findByConditions((Page<AuditFeeCheckDiffVo>)page, dto);
    }

    public Page<AuditFeeCheckDiffVo> findDiffLedgerByConditions(Pageable pageable, AuditFeeCheckDiffDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessFormatCode(), (String)"\u8bf7\u4f20\u5165\u4e1a\u6001", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessUnitCode(), (String)"\u8bf7\u4f20\u5165\u4e1a\u52a1\u5355\u5143", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRetailerCode(), (String)"\u8bf7\u4f20\u5165\u96f6\u552e\u5546\u7f16\u7801", (Object[])new Object[0]);
        AuditFeeDiffLedgerDto diffLedgerDto = new AuditFeeDiffLedgerDto();
        BeanUtils.copyProperties((Object)dto, (Object)diffLedgerDto);
        diffLedgerDto.setStatus(AuditStateEnum.CONFIRMED.getCode());
        diffLedgerDto.setBeRecoveredAmountNotZero(BooleanEnum.TRUE.getCapital());
        Page diffLedgerVoPage = this.auditFeeDiffLedgerVoService.findByConditions(pageable, diffLedgerDto);
        Page checkDiffVoPage = new Page(diffLedgerVoPage.getCurrent(), diffLedgerVoPage.getSize(), diffLedgerVoPage.getTotal());
        if (CollectionUtils.isNotEmpty((Collection)diffLedgerVoPage.getRecords())) {
            checkDiffVoPage = (Page)diffLedgerVoPage.convert(e -> {
                AuditFeeCheckDiffVo checkDiffVo = (AuditFeeCheckDiffVo)this.nebulaToolkitService.copyObjectByWhiteList(e, AuditFeeCheckDiffVo.class, HashSet.class, ArrayList.class, new String[0]);
                checkDiffVo.setAuditFeeCheckDeductCode(null);
                return checkDiffVo;
            });
        }
        return checkDiffVoPage;
    }

    public List<AuditFeeCheckDiffVo> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty((CharSequence)matchCode)) {
            return new ArrayList<AuditFeeCheckDiffVo>();
        }
        return this.auditFeeCheckDiffRepository.findDetailByMatchCode(matchCode);
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.auditFeeCheckDiffRepository.updateDelFlagByMatchCodes(matchCodes);
        this.auditFeeCheckDiffShareRepository.updateDelFlagByMatchCodes(matchCodes);
    }

    public List<AuditFeeCheckDiffVo> createBatch(List<AuditFeeCheckDiffVo> checkDiffVos) {
        if (CollectionUtils.isEmpty(checkDiffVos)) {
            return new ArrayList<AuditFeeCheckDiffVo>();
        }
        ArrayList diffShares = new ArrayList();
        checkDiffVos.forEach(diffVo -> {
            diffVo.setId(UUID.randomUUID().toString().replace("-", ""));
            diffVo.setTenantCode(TenantUtils.getTenantCode());
            diffVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            diffVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            AuditFeeCheckDiffShare diffShare = new AuditFeeCheckDiffShare();
            diffShare.setId(UUID.randomUUID().toString().replace("-", ""));
            diffShare.setTenantCode(TenantUtils.getTenantCode());
            diffShare.setAuditFeeCheckDeductCode(diffVo.getAuditFeeCheckDeductCode());
            diffShare.setFeeDiffLedgerCode(diffVo.getFeeDiffLedgerCode());
            diffShare.setDeductAmount(diffVo.getDeductAmount());
            diffShares.add(diffShare);
        });
        Collection auditFeeCheckCosts = this.nebulaToolkitService.copyCollectionByWhiteList(checkDiffVos, AuditFeeCheckDiffVo.class, AuditFeeCheckDiff.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeCheckDiffRepository.saveBatch(auditFeeCheckCosts);
        this.auditFeeCheckDiffShareRepository.saveBatch(diffShares);
        return checkDiffVos;
    }
}

