/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosHead;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosHeadRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosHeadService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AuditFeeCheckPosHeadServiceImpl
implements AuditFeeCheckPosHeadService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosHeadServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckPosHeadRepository auditFeeCheckPosHeadRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(AuditFeeCheckPosHeadDto dto) {
        Assert.notNull((Object)dto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        dto.setId(null);
        if (StringUtil.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtil.isEmpty((CharSequence)dto.getMatchHeadCode())) {
            dto.setMatchHeadCode((String)this.generateCodeService.generateCode("PH", 1).get(0));
        }
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        AuditFeeCheckPosHead entity = (AuditFeeCheckPosHead)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeCheckPosHead.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditFeeCheckPosHeadRepository.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createList(List<AuditFeeCheckPosHeadDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        AtomicInteger index = new AtomicInteger(0);
        String tenantCode = TenantUtils.getTenantCode();
        dtoList.forEach(dto -> {
            dto.setId(null);
            dto.setTenantCode(tenantCode);
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (StringUtil.isEmpty((CharSequence)dto.getMatchHeadCode())) {
                index.getAndIncrement();
            }
        });
        if (index.get() > 0) {
            List codeList = this.generateCodeService.generateCode("PH", index.get());
            dtoList.forEach(dto -> {
                if (StringUtil.isEmpty((CharSequence)dto.getMatchHeadCode())) {
                    dto.setMatchHeadCode((String)codeList.get(index.decrementAndGet()));
                }
            });
        }
        Collection entityList = this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, AuditFeeCheckPosHeadDto.class, AuditFeeCheckPosHead.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeCheckPosHeadRepository.saveBatch(entityList);
    }
}

