/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosHead;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosHeadRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosHeadVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosHeadVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AuditFeeCheckPosHeadVoServiceImpl
implements AuditFeeCheckPosHeadVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosHeadVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckPosHeadRepository auditFeeCheckPosHeadRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeCheckPosLedgerRepository auditFeeCheckPosLedgerRepository;
    @Autowired(required=false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    public Page<AuditFeeCheckPosHeadVo> findByConditions(Pageable pageable, AuditFeeCheckPosHeadDto dto) {
        return this.auditFeeCheckPosHeadRepository.findByConditions(pageable, dto);
    }

    public AuditFeeCheckPosHeadVo findByIdOrCode(String id, String matchHeadCode) {
        Map<String, BigDecimal> decimalMap;
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)matchHeadCode)) {
            return null;
        }
        AuditFeeCheckPosHead entity = this.auditFeeCheckPosHeadRepository.findByIdOrCode(id, matchHeadCode);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        AuditFeeCheckPosHeadVo posHeadVo = (AuditFeeCheckPosHeadVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeCheckPosHeadVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<AuditFeeCheckPosLedger> posLedgerList = this.auditFeeCheckPosLedgerRepository.findByMatchHeadCode(entity.getMatchHeadCode());
        if (CollectionUtil.isNotEmpty(posLedgerList) && CollectionUtil.isNotEmpty(decimalMap = posLedgerList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getFeeDiffLedgerCode())).filter(k -> Objects.nonNull(k.getDeductAmount())).collect(Collectors.toMap(AuditFeeCheckPosLedger::getFeeDiffLedgerCode, AuditFeeCheckPosLedger::getDeductAmount, (n, o) -> n)))) {
            List diffLedgerVoList = this.auditFeeDiffLedgerVoService.findDetailByCodes(new ArrayList<String>(decimalMap.keySet()));
            if (CollectionUtil.isNotEmpty((Collection)diffLedgerVoList)) {
                diffLedgerVoList.forEach(item -> item.setDeductAmount(decimalMap.getOrDefault(item.getFeeDiffLedgerCode(), BigDecimal.ZERO)));
            }
            posHeadVo.setLedgerVoList(diffLedgerVoList);
        }
        return posHeadVo;
    }
}

