/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetSpecificationDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetSpecificationVoService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.vo.InvoiceExpenseSheetSpecificationVo;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataResultVo;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosPullKmsDataService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeCheckPosConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.PosDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.RetailersSystemTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuditFeeCheckPosPullKmsDataServiceImpl
implements AuditFeeCheckPosPullKmsDataService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosPullKmsDataServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;
    @Autowired(required=false)
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private InvoiceExpenseSheetSpecificationVoService invoiceExpenseSheetSpecificationVoService;
    @Autowired(required=false)
    private AuditFeeCheckPosMatchActivityService auditFeeCheckPosMatchActivityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void pullKmsDataAsync(AbstractCrmUserIdentity userIdentity, String beginDate, String endDate) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        String yearMonthDay = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        String lockKey = "audit_fee:update_kms_pos:lock:" + yearMonthDay;
        boolean lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
        Assert.isTrue((boolean)lockSuccess, (String)("\u4e0a\u6b21\u64cd\u4f5c[" + yearMonthDay + "]\u8fd8\u672a\u5b8c\u6210,\u672c\u6b21\u4e0d\u6267\u884c!"));
        try {
            this.pullKmsData(beginDate, endDate);
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    @Override
    public void pullKmsData(String beginDate, String endDate) {
        log.info("=====>    \u62c9\u53d6KMS\u7684\u6570\u636e\u53c2\u6570beginDate[{}] endDate[{}]    <=====", (Object)beginDate, (Object)endDate);
        List<String> dayList = this.buildDayList(beginDate, endDate);
        PageRequest templatePageable = PageRequest.of((int)1, (int)40);
        TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
        templateDto.setTenantCode(TenantUtils.getTenantCode());
        templateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page templatePage = null;
        List<SalesDataDto> salesDataDtoList = this.buildSalesDataDto(dayList);
        List<InvoiceExpenseSheetSpecificationDto> specificationDtoList = this.buildInvoiceExpenseSheetSpecificationDataDto(dayList);
        HashMap onlyKeyMap = Maps.newHashMap();
        Map productUnitConvertMap = this.dictToolkitService.findConvertMapByDictTypeCode("product_base_unit");
        Map productUnitMap = this.dictToolkitService.findMapByDictTypeCode("product_base_unit");
        do {
            templatePage = this.tpmDeductionMatchingTemplateService.findByConditions((Pageable)templatePageable, templateDto);
            log.info("=====>    \u6263\u8d39\u5339\u914d\u6a21\u7248[{}/{}]\u9875 size[{}]    <=====", new Object[]{templatePage.getCurrent(), templatePage.getPages(), templatePage.getSize()});
            List templatePageRecords = templatePage.getRecords();
            if (CollectionUtil.isEmpty((Collection)templatePageRecords)) {
                return;
            }
            Map<String, TpmDeductionDetailMappingVo> detailMappingVoMap = this.buildDetailMappingVoMap(templatePageRecords);
            if (CollectionUtil.isEmpty(detailMappingVoMap)) {
                log.error("=====>   \u62c9\u53d6KMS\u7684\u6570\u636e,\u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801[{}]\u672a\u914d\u7f6e\u5546\u8d85\u6620\u5c04\u4fe1\u606f   <=====", JSON.toJSON((Object)templatePageRecords));
                return;
            }
            long currentPage = templatePage.getCurrent();
            long totalPage = templatePage.getPages();
            long pageSize = templatePage.getRecords().size();
            AtomicInteger index = new AtomicInteger(1);
            templatePageRecords.stream().filter(k -> detailMappingVoMap.containsKey(k.getApplyMappingCode())).forEach(item -> {
                log.info("=====>   \u5546\u8d85\u6263\u8d39\u9690\u5c04\u7f16\u7801[{}] \u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801[{}] [{}/{}]\u9875 size[{}/{}]    <=====", new Object[]{item.getApplyMappingCode(), item.getCode(), currentPage, totalPage, index.getAndIncrement(), pageSize});
                if (CollectionUtil.isEmpty((Collection)item.getPosAllowances())) {
                    log.error("=====>   \u62c9\u53d6KMS\u7684\u6570\u636e,\u5546\u8d85\u6263\u8d39\u9690\u5c04\u7f16\u7801[{}]\u672a\u914d\u7f6e\u4fe1\u606f!\u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801[{}]   <=====", (Object)item.getApplyMappingCode(), (Object)item.getCode());
                    return;
                }
                TpmDeductionDetailMappingVo detailMappingVo = (TpmDeductionDetailMappingVo)detailMappingVoMap.get(item.getApplyMappingCode());
                if (Objects.isNull(detailMappingVo)) {
                    log.error("=====>   \u62c9\u53d6KMS\u7684\u6570\u636e,\u5546\u8d85\u6263\u8d39\u9690\u5c04\u7f16\u7801[{}]\u672a\u627e\u5230\u6570\u636e!\u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801[{}]   <=====", (Object)item.getApplyMappingCode(), (Object)item.getCode());
                    return;
                }
                item.getPosAllowances().forEach(templateVo -> {
                    PosDataSourceEnum posDataSourceEnum = PosDataSourceEnum.getEnumByCode((String)templateVo.getDataSource());
                    if (Objects.isNull(posDataSourceEnum)) {
                        log.error("=====>   \u62c9\u53d6KMS\u7684\u6570\u636e,\u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801[{}]\u4fe1\u606f\u6570\u636e\u6765\u6e90\u4e0d\u5408\u6cd5!POS\u4fe1\u606f[{}]   <=====", (Object)item.getCode(), (Object)templateVo.getDataSource());
                        return;
                    }
                    String onlKey = StringUtil.trimToEmpty((String)detailMappingVo.getResaleCommercialCode()) + StringUtil.trimToEmpty((String)detailMappingVo.getSalesInstitutionCode()) + StringUtil.trimToEmpty((String)detailMappingVo.getBusinessFormatCode()) + StringUtil.trimToEmpty((String)detailMappingVo.getBusinessUnitCode()) + StringUtil.trimToEmpty((String)posDataSourceEnum.getCode());
                    if (onlyKeyMap.containsKey(onlKey) && ((Boolean)onlyKeyMap.get(onlKey)).booleanValue()) {
                        log.error("=====>   \u62c9\u53d6KMS\u7684\u6570\u636e,\u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801[{}]\u7ef4\u5ea6\u91cd\u590d,\u8df3\u8fc7\u672c\u6b21\u62c9\u53d6;onlyKey[{}]   <=====", (Object)item.getCode(), (Object)onlKey);
                        return;
                    }
                    onlyKeyMap.putIfAbsent(onlKey, false);
                    switch (posDataSourceEnum) {
                        case RETAILER_POS: {
                            this.pullPosData(salesDataDtoList, detailMappingVo, (TpmDeductionMatchingTemplateVo)item, productUnitConvertMap, onlKey, onlyKeyMap);
                            break;
                        }
                        case FEE_DETAIL: {
                            this.pullFeeData(specificationDtoList, detailMappingVo, (TpmDeductionMatchingTemplateVo)item, productUnitMap, onlKey, onlyKeyMap);
                            break;
                        }
                        default: {
                            log.error("=====>   \u62c9\u53d6KMS\u7684\u6570\u636e,\u6570\u636e\u7c7b\u578b:{}[{}]\u4e0d\u5408\u6cd5!   <=====", (Object)posDataSourceEnum.getCode(), (Object)posDataSourceEnum.getDesc());
                        }
                    }
                });
            });
            templatePageable = templatePageable.next();
        } while (templatePage.hasNext());
        log.info("=====>   \u62c9\u53d6KMS\u7684POS\u6570\u636e end \u5f00\u59cb\u65f6\u95f4[{}]\u7ed3\u675f\u65f6\u95f4[{}]   <=====", (Object)beginDate, (Object)endDate);
    }

    private List<String> buildDayList(String beginDateStr, String endDateStr) {
        Date endDate;
        Date beginDate;
        List dayList;
        if (StringUtil.isEmpty((String)beginDateStr)) {
            beginDateStr = DateUtil.formatDate((Date)DateUtil.dateAddDay((Date)new Date(), (Integer)AuditFeeCheckPosConstants.AUDIT_FEE_KMS_POS_DAY), (String)"yyyy-MM-dd");
        }
        if (StringUtil.isEmpty((String)endDateStr)) {
            endDateStr = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (CollectionUtil.isEmpty((Collection)(dayList = DateUtil.getBetweenDays((Date)(beginDate = DateUtil.parseDate((String)beginDateStr, (String)"yyyy-MM-dd")), (Date)(endDate = DateUtil.parseDate((String)endDateStr, (String)"yyyy-MM-dd")))))) {
            dayList.add(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        return dayList.stream().distinct().collect(Collectors.toList());
    }

    private Map<String, TpmDeductionDetailMappingVo> buildDetailMappingVoMap(List<TpmDeductionMatchingTemplateVo> templatePageRecords) {
        if (CollectionUtil.isEmpty(templatePageRecords)) {
            log.error("=====>   \u62c9\u53d6KMS\u7684POS\u6570\u636e,\u65e0\u6263\u8d39\u5339\u914d\u6a21\u7248\u4fe1\u606f  <=====");
            return Maps.newHashMap();
        }
        List applyMappingCodeList = templatePageRecords.stream().filter(k -> StringUtil.isNotEmpty((String)k.getApplyMappingCode())).map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(applyMappingCodeList)) {
            log.error("=====>   \u62c9\u53d6KMS\u7684POS\u6570\u636e,\u6263\u8d39\u5339\u914d\u6a21\u7248\u65e0\u5546\u8d85\u6263\u8d39\u9690\u5c04\u4fe1\u606f[{}]   <=====", JSON.toJSON(templatePageRecords));
            return Maps.newHashMap();
        }
        List detailMappingVoList = this.tpmDeductionDetailMappingService.findByCodes(applyMappingCodeList);
        if (CollectionUtil.isEmpty((Collection)detailMappingVoList)) {
            log.error("=====>   \u62c9\u53d6KMS\u7684POS\u6570\u636e,\u6263\u8d39\u5339\u914d\u6a21\u7248\u7f16\u7801\u914d\u7f6e\u7684\u5546\u8d85\u6263\u8d39\u9690\u5c04\u4fe1\u606f{}\u672a\u5728\u5546\u8d85\u6263\u8d39\u9690\u5c04\u5904\u627e\u5230!   <=====", applyMappingCodeList);
            return Maps.newHashMap();
        }
        return detailMappingVoList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getCode())).collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, v -> v, (n, o) -> n));
    }

    private List<SalesDataDto> buildSalesDataDto(List<String> dayList) {
        ArrayList salesDataDtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(dayList)) {
            SalesDataDto salesDataDto = new SalesDataDto();
            salesDataDto.setTenantCode(TenantUtils.getTenantCode());
            salesDataDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            salesDataDto.setOrderStatus(InvoicesStatus.S200.getDictCode());
            salesDataDto.setModifyTimeDay(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
            salesDataDtoList.add(salesDataDto);
            return salesDataDtoList;
        }
        dayList.forEach(item -> {
            SalesDataDto salesDataDto = new SalesDataDto();
            salesDataDto.setTenantCode(TenantUtils.getTenantCode());
            salesDataDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            salesDataDto.setOrderStatus(InvoicesStatus.S200.getDictCode());
            salesDataDto.setModifyTimeDay(item);
            salesDataDtoList.add(salesDataDto);
        });
        return salesDataDtoList;
    }

    private List<InvoiceExpenseSheetSpecificationDto> buildInvoiceExpenseSheetSpecificationDataDto(List<String> dayList) {
        ArrayList specificationDtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(dayList)) {
            InvoiceExpenseSheetSpecificationDto specificationDto = new InvoiceExpenseSheetSpecificationDto();
            specificationDto.setTenantCode(TenantUtils.getTenantCode());
            specificationDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            specificationDto.setOrderStatus(InvoicesStatus.S200.getDictCode());
            specificationDto.setModifyTimeDay(DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
            specificationDtoList.add(specificationDto);
            return specificationDtoList;
        }
        dayList.forEach(item -> {
            InvoiceExpenseSheetSpecificationDto specificationDto = new InvoiceExpenseSheetSpecificationDto();
            specificationDto.setTenantCode(TenantUtils.getTenantCode());
            specificationDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            specificationDto.setOrderStatus(InvoicesStatus.S200.getDictCode());
            specificationDto.setModifyTimeDay(item);
            specificationDtoList.add(specificationDto);
        });
        return specificationDtoList;
    }

    private void pullPosData(List<SalesDataDto> salesDataDtoList, TpmDeductionDetailMappingVo detailMappingVo, TpmDeductionMatchingTemplateVo templateVo, Map<String, String> productUnitConvertMap, String onlyKey, Map<String, Boolean> onlyKeyMap) {
        if (CollectionUtil.isEmpty(salesDataDtoList)) {
            return;
        }
        salesDataDtoList.forEach(salesDataDto -> {
            if (Objects.isNull(salesDataDto)) {
                log.error("=====>    \u62c9\u53d6KMS\u7684POS\u6570\u636e \u9500\u552e\u6570\u636e\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a \u5546\u8d85\u6263\u8d39\u6620\u5c04\u6a21\u677f[{}]  \u6263\u8d39\u5339\u914d\u6a21\u677f[{}]    <=====", (Object)detailMappingVo.getCode(), (Object)templateVo.getCode());
                return;
            }
            if (Objects.isNull(detailMappingVo)) {
                log.error("=====>    \u62c9\u53d6KMS\u7684POS\u6570\u636e \u9500\u552e\u6570\u636e\u53c2\u6570[{}] \u5546\u8d85\u6263\u8d39\u6620\u5c04\u53c2\u6570\u4e3a\u7a7a  \u6263\u8d39\u5339\u914d\u6a21\u677f[{}]    <=====", salesDataDto, (Object)templateVo.getCode());
                return;
            }
            if (Objects.isNull(templateVo)) {
                log.error("=====>    \u62c9\u53d6KMS\u7684POS\u6570\u636e \u9500\u552e\u6570\u636e\u53c2\u6570[{}] \u5546\u8d85\u6263\u8d39\u6620\u5c04\u6a21\u677f[{}]  \u6263\u8d39\u5339\u914d\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a    <=====", salesDataDto, (Object)detailMappingVo.getCode());
                return;
            }
            PageRequest posPageable = PageRequest.of((int)1, (int)600);
            Page posPage = null;
            salesDataDto.setCustomerRetailerCode(detailMappingVo.getResaleCommercialCode());
            salesDataDto.setSalesOrgCode(detailMappingVo.getSalesInstitutionCode());
            salesDataDto.setBusinessFormatCode(detailMappingVo.getBusinessFormatCode());
            salesDataDto.setBusinessUnitCode(detailMappingVo.getBusinessUnitCode());
            do {
                try {
                    posPage = this.invoiceSalesDataVoService.pagePosByGroupTotal((Pageable)posPageable, salesDataDto);
                    posPageable = posPageable.next();
                    if (Objects.isNull(posPage)) {
                        log.error("=====>    \u62c9\u53d6KMS\u7684POS\u6570\u636e\u53c2\u6570[{}] [{}/{}]\u9875 KMS\u8fd4\u56denull   <=====", new Object[]{JSON.toJSONString((Object)salesDataDto), posPageable.getPageNumber(), posPageable.getPageSize()});
                        return;
                    }
                    log.info("=====>    \u62c9\u53d6KMS\u7684POS\u6570\u636e\u53c2\u6570[{}] \u5546\u8d85\u6263\u8d39\u6620\u5c04\u6a21\u677f[{}]  \u6263\u8d39\u5339\u914d\u6a21\u677f[{}] [{}/{}]\u9875    <=====", new Object[]{JSON.toJSONString((Object)salesDataDto), detailMappingVo.getCode(), templateVo.getCode(), posPage.getCurrent(), posPage.getPages()});
                    List<AuditFeeCheckPos> entityList = this.buildKmsPosEntity(detailMappingVo, templateVo, posPage.getRecords(), productUnitConvertMap);
                    if (!onlyKeyMap.getOrDefault(onlyKey, false).booleanValue() && CollectionUtil.isNotEmpty(entityList)) {
                        onlyKeyMap.put(onlyKey, true);
                    }
                    this.saveOrUpdateEntityList(entityList);
                }
                catch (Exception e) {
                    log.error("=====>    \u62c9\u53d6KMS\u7684POS\u6570\u636e\u53c2\u6570[{}] [{}/{}]\u9875 \u5f02\u5e38   <=====", new Object[]{JSON.toJSONString((Object)salesDataDto), posPageable.getPageNumber(), posPageable.getPageSize()});
                    log.error("", (Throwable)e);
                }
            } while (Objects.nonNull(posPage) && posPage.hasNext());
        });
    }

    private void pullFeeData(List<InvoiceExpenseSheetSpecificationDto> specificationDtoList, TpmDeductionDetailMappingVo detailMappingVo, TpmDeductionMatchingTemplateVo templateVo, Map<String, String> productUnitMap, String onlyKey, Map<String, Boolean> onlyKeyMap) {
        if (CollectionUtil.isEmpty(specificationDtoList)) {
            return;
        }
        specificationDtoList.forEach(sheetSpecificationDto -> {
            if (Objects.isNull(sheetSpecificationDto)) {
                log.error("=====>    \u62c9\u53d6KMS\u7684\u8d39\u7528\u6570\u636e \u8d39\u7528\u6570\u636e\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a \u5546\u8d85\u6263\u8d39\u6620\u5c04\u6a21\u677f[{}]  \u6263\u8d39\u5339\u914d\u6a21\u677f[{}]    <=====", (Object)detailMappingVo.getCode(), (Object)templateVo.getCode());
                return;
            }
            if (Objects.isNull(detailMappingVo)) {
                log.error("=====>    \u62c9\u53d6KMS\u7684\u8d39\u7528\u6570\u636e \u8d39\u7528\u6570\u636e\u53c2\u6570[{}] \u5546\u8d85\u6263\u8d39\u6620\u5c04\u53c2\u6570\u4e3a\u7a7a  \u6263\u8d39\u5339\u914d\u6a21\u677f[{}]    <=====", sheetSpecificationDto, (Object)templateVo.getCode());
                return;
            }
            if (Objects.isNull(templateVo)) {
                log.error("=====>    \u62c9\u53d6KMS\u7684\u8d39\u7528\u6570\u636e \u8d39\u7528\u6570\u636e\u53c2\u6570[{}] \u5546\u8d85\u6263\u8d39\u6620\u5c04\u6a21\u677f[{}]  \u6263\u8d39\u5339\u914d\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a    <=====", sheetSpecificationDto, (Object)detailMappingVo.getCode());
                return;
            }
            PageRequest posPageable = PageRequest.of((int)1, (int)600);
            Page posPage = null;
            sheetSpecificationDto.setCustomerRetailerCode(detailMappingVo.getResaleCommercialCode());
            sheetSpecificationDto.setSalesOrgCode(detailMappingVo.getSalesInstitutionCode());
            sheetSpecificationDto.setBusinessFormatCode(detailMappingVo.getBusinessFormatCode());
            sheetSpecificationDto.setBusinessUnitCode(detailMappingVo.getBusinessUnitCode());
            if (RetailersSystemTypeEnum.VANGUARD.getCode().equals(sheetSpecificationDto.getCustomerRetailerCode()) || RetailersSystemTypeEnum.TESCO.getCode().equals(sheetSpecificationDto.getCustomerRetailerCode())) {
                sheetSpecificationDto.setUrlList(Collections.singletonList("\u4fc3\u9500\u8d39\u7528\u5355"));
            } else if (RetailersSystemTypeEnum.REN_REN_LE.getCode().equals(sheetSpecificationDto.getCustomerRetailerCode())) {
                sheetSpecificationDto.setUrlList(Collections.singletonList("\u4fc3\u9500"));
            }
            do {
                try {
                    posPage = this.invoiceExpenseSheetSpecificationVoService.pageInvoiceExpenseSheetSpecificationByGroupTotal((Pageable)posPageable, sheetSpecificationDto);
                    posPageable = posPageable.next();
                    if (Objects.isNull(posPage)) {
                        log.error("=====>    \u62c9\u53d6KMS\u7684\u8d39\u7528\u6570\u636e\u53c2\u6570[{}] [{}/{}]\u9875 KMS\u8fd4\u56denull   <=====", new Object[]{JSON.toJSONString((Object)sheetSpecificationDto), posPageable.getPageNumber(), posPageable.getPageSize()});
                        return;
                    }
                    log.info("=====>    \u62c9\u53d6KMS\u7684\u8d39\u7528\u6570\u636e\u53c2\u6570[{}] \u5546\u8d85\u6263\u8d39\u6620\u5c04\u6a21\u677f[{}]  \u6263\u8d39\u5339\u914d\u6a21\u677f[{}] [{}/{}]\u9875    <=====", new Object[]{JSON.toJSONString((Object)sheetSpecificationDto), detailMappingVo.getCode(), templateVo.getCode(), posPage.getCurrent(), posPage.getPages()});
                    List<AuditFeeCheckPos> entityList = this.buildKmsFeeEntity(detailMappingVo, templateVo, posPage.getRecords(), productUnitMap);
                    if (!onlyKeyMap.getOrDefault(onlyKey, false).booleanValue() && CollectionUtil.isNotEmpty(entityList)) {
                        onlyKeyMap.put(onlyKey, true);
                    }
                    this.saveOrUpdateEntityList(entityList);
                }
                catch (Exception e) {
                    log.error("=====>    \u62c9\u53d6KMS\u7684\u8d39\u7528\u6570\u636e\u53c2\u6570[{}] [{}/{}]\u9875 \u5f02\u5e38   <=====", new Object[]{JSON.toJSONString((Object)sheetSpecificationDto), posPageable.getPageNumber(), posPageable.getPageSize()});
                    log.error("", (Throwable)e);
                }
            } while (Objects.nonNull(posPage) && posPage.hasNext());
        });
    }

    private void saveOrUpdateEntityList(List<AuditFeeCheckPos> entityList) {
        if (CollectionUtil.isEmpty(entityList)) {
            return;
        }
        if (CollectionUtil.isEmpty(entityList = new ArrayList<AuditFeeCheckPos>(entityList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v, (n, o) -> n)).values()))) {
            return;
        }
        List<String> idList = entityList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getId())).map(UuidEntity::getId).collect(Collectors.toList());
        List<AuditFeeCheckPos> oldList = this.auditFeeCheckPosRepository.listIdsByIds(idList);
        ArrayList<AuditFeeCheckPos> saveList = new ArrayList<AuditFeeCheckPos>();
        ArrayList updateList = new ArrayList();
        if (CollectionUtil.isEmpty(oldList)) {
            saveList.addAll(entityList);
        } else {
            Map<String, AuditFeeCheckPos> idsMap = oldList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getId())).collect(Collectors.toMap(UuidEntity::getId, v -> v, (n, o) -> n));
            entityList.forEach(entity -> {
                BigDecimal productNumber = Optional.ofNullable(entity.getProductNumber()).orElse(BigDecimal.ZERO);
                BigDecimal promotionDeduction = Optional.ofNullable(entity.getPromotionDeduction()).orElse(BigDecimal.ZERO);
                entity.setOnePromotionDeduction(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(productNumber) != 0) {
                    entity.setOnePromotionDeduction(promotionDeduction.divide(productNumber, 4, 4));
                }
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                AuditFeeCheckPos oldEntity = (AuditFeeCheckPos)((Object)((Object)idsMap.get(entity.getId())));
                if (Objects.nonNull((Object)oldEntity)) {
                    if (!BooleanEnum.TRUE.getCapital().equals(oldEntity.getMatchStatus())) {
                        entity.setDiffType(this.auditFeeCheckPosMatchActivityService.oneDiffAmountGetDiffType(oldEntity.getTotalDiffFinalAmount(), oldEntity.getActivityDetailItemCode()));
                        updateList.add(entity);
                    }
                } else {
                    saveList.add((AuditFeeCheckPos)((Object)entity));
                }
            });
        }
        if (CollectionUtil.isNotEmpty(saveList)) {
            List codeList = this.generateCodeService.generateCode("POS", saveList.size());
            for (int i = 0; i < saveList.size(); ++i) {
                ((AuditFeeCheckPos)((Object)saveList.get(i))).setMatchCode((String)codeList.get(i));
                ((AuditFeeCheckPos)((Object)saveList.get(i))).setIsMatchActivity(BooleanEnum.FALSE.getCapital());
                ((AuditFeeCheckPos)((Object)saveList.get(i))).setIsMatchCost(BooleanEnum.FALSE.getCapital());
            }
            this.auditFeeCheckPosRepository.saveBatch(saveList);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            updateList.forEach(entity -> this.auditFeeCheckPosRepository.updateAmountById((AuditFeeCheckPos)((Object)entity)));
        }
    }

    private List<AuditFeeCheckPos> buildKmsPosEntity(TpmDeductionDetailMappingVo detailMappingVo, TpmDeductionMatchingTemplateVo templateVo, List<SalesDataResultVo> records, Map<String, String> productUnitConvertMap) {
        if (CollectionUtil.isEmpty(records)) {
            return Collections.emptyList();
        }
        ArrayList<AuditFeeCheckPos> entityList = new ArrayList<AuditFeeCheckPos>();
        String tenantCode = TenantUtils.getTenantCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        records.forEach(item -> {
            AuditFeeCheckPos entity = new AuditFeeCheckPos();
            entity.setTenantCode(tenantCode);
            entity.setEnableStatus(enableCode);
            entity.setDelFlag(delFlag);
            entity.setMatchTemplateCode(templateVo.getCode());
            entity.setMatchTemplateName(templateVo.getName());
            entity.setCustomerRetailerCode(detailMappingVo.getResaleCommercialCode());
            entity.setCustomerRetailerName(detailMappingVo.getResaleCommercialName());
            entity.setSalesInstitutionCode(item.getSalesOrgCode());
            entity.setSalesInstitutionName(item.getSalesOrgName());
            entity.setBusinessUnitCode(item.getBusinessUnitCode());
            entity.setBusinessFormatCode(item.getBusinessFormatCode());
            entity.setBusinessArea(item.getBusinessArea());
            entity.setProvinceCode(item.getProvinceCode());
            entity.setProvinceName(item.getProvinceName());
            String salesDateStr = item.getSalesDate();
            entity.setSalesDateStr(salesDateStr);
            try {
                entity.setSalesDate(DateUtil.parseDate((String)salesDateStr, (String)"yyyy-MM-dd"));
                entity.setYearMonthLy(DateUtil.format((Date)entity.getSalesDate(), (String)"yyyy-MM"));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            entity.setChannelCode(item.getChannelCode());
            entity.setChannelName(item.getChannelName());
            if (StringUtil.isNotEmpty((String)item.getCurCompanyUnit())) {
                entity.setUnitCode(productUnitConvertMap.getOrDefault(item.getCurCompanyUnit(), ""));
                if (StringUtil.isNotEmpty((String)entity.getUnitCode())) {
                    entity.setUnitName(item.getCurCompanyUnit());
                }
            }
            entity.setDirectCode(item.getDirectCode());
            entity.setDirectName(item.getDirectName());
            entity.setTerminalCode(item.getDeliveryPartyCode());
            entity.setTerminalName(item.getDeliveryPartyName());
            entity.setProductCode(item.getGoodsCode());
            entity.setProductName(item.getGoodsName());
            entity.setPromotionDeduction(Optional.ofNullable(item.getPromotionDeduction()).orElse(BigDecimal.ZERO));
            entity.setProductNumber(Optional.ofNullable(item.getCurCompanyUnitOrderQuantity()).orElse(BigDecimal.ZERO));
            entity.setOnePromotionDeduction(BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(entity.getProductNumber()) != 0) {
                entity.setOnePromotionDeduction(entity.getPromotionDeduction().divide(entity.getProductNumber(), 4, 4));
            }
            BigDecimal oneApplicationFee = Optional.ofNullable(entity.getOneApplicationFee()).orElse(BigDecimal.ZERO);
            BigDecimal oneDiffAmount = entity.getOnePromotionDeduction().subtract(oneApplicationFee);
            entity.setOneDiffAmount(oneDiffAmount);
            BigDecimal sharePromotionDeduction = Optional.ofNullable(entity.getSharePromotionDeduction()).orElse(BigDecimal.ZERO);
            entity.setSharePromotionDeduction(sharePromotionDeduction);
            entity.setTotalDiffAmount(oneDiffAmount.multiply(entity.getProductNumber()).add(sharePromotionDeduction));
            entity.setTotalDiffFinalAmount(entity.getTotalDiffAmount());
            entity.setMatchStatus(BooleanEnum.FALSE.getCapital());
            entity.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
            entity.setIsMatchCost(BooleanEnum.FALSE.getCapital());
            entity.setDiffType(this.auditFeeCheckPosMatchActivityService.oneDiffAmountGetDiffType(entity.getTotalDiffFinalAmount(), entity.getActivityDetailItemCode()));
            entity.setDataSource(PosDataSourceEnum.RETAILER_POS.getCode());
            if (StringUtil.isEmpty((String)entity.getDataSource()) || StringUtil.isEmpty((String)entity.getDirectCode()) || StringUtil.isEmpty((String)entity.getTerminalCode()) || StringUtil.isEmpty((String)entity.getProductCode()) || StringUtil.isEmpty((String)entity.getChannelCode()) || StringUtil.isEmpty((String)entity.getSalesDateStr())) {
                return;
            }
            String onlyKey = entity.getDataSource() + entity.getDirectCode() + entity.getTerminalCode() + entity.getProductCode() + entity.getChannelCode() + entity.getSalesDateStr();
            entity.setOnlyKey(onlyKey);
            entity.setId(DigestUtils.md5Hex((String)onlyKey));
            entityList.add(entity);
        });
        return entityList;
    }

    private List<AuditFeeCheckPos> buildKmsFeeEntity(TpmDeductionDetailMappingVo detailMappingVo, TpmDeductionMatchingTemplateVo templateVo, List<InvoiceExpenseSheetSpecificationVo> records, Map<String, String> productUnitMap) {
        if (CollectionUtil.isEmpty(records)) {
            return Collections.emptyList();
        }
        ArrayList<AuditFeeCheckPos> entityList = new ArrayList<AuditFeeCheckPos>();
        String tenantCode = TenantUtils.getTenantCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        records.forEach(item -> {
            AuditFeeCheckPos entity = new AuditFeeCheckPos();
            entity.setTenantCode(tenantCode);
            entity.setEnableStatus(enableCode);
            entity.setDelFlag(delFlag);
            entity.setMatchTemplateCode(templateVo.getCode());
            entity.setMatchTemplateName(templateVo.getName());
            entity.setCustomerRetailerCode(detailMappingVo.getResaleCommercialCode());
            entity.setCustomerRetailerName(detailMappingVo.getResaleCommercialName());
            entity.setSalesInstitutionCode(item.getSalesOrgCode());
            entity.setSalesInstitutionName(item.getSalesOrgName());
            entity.setBusinessUnitCode(item.getBusinessUnitCode());
            entity.setBusinessFormatCode(item.getBusinessFormatCode());
            entity.setBusinessArea(item.getBusinessArea());
            entity.setProvinceCode(item.getProvinceCode());
            entity.setProvinceName(item.getProvinceName());
            String orderDateStr = item.getOrderDate();
            entity.setSalesDateStr(orderDateStr);
            try {
                entity.setSalesDate(DateUtil.parseDate((String)orderDateStr, (String)"yyyy-MM-dd"));
                entity.setYearMonthLy(DateUtil.format((Date)entity.getSalesDate(), (String)"yyyy-MM"));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            if (StringUtil.isNotEmpty((String)item.getCurCompanyUnit())) {
                entity.setUnitCode(productUnitMap.getOrDefault(item.getCurCompanyUnit(), ""));
                if (StringUtil.isNotEmpty((String)entity.getUnitCode())) {
                    entity.setUnitName(item.getCurCompanyUnit());
                }
            }
            entity.setChannelCode("");
            entity.setChannelName("");
            entity.setDirectCode(item.getDirectCode());
            entity.setDirectName(item.getDirectName());
            entity.setTerminalCode(item.getDeliveryPartyCode());
            entity.setTerminalName(item.getDeliveryPartyName());
            entity.setProductCode(item.getProductCode());
            entity.setProductName(item.getProductName());
            entity.setPromotionDeduction(Optional.ofNullable(item.getAmount()).orElse(BigDecimal.ZERO));
            entity.setProductNumber(Optional.ofNullable(item.getCurCompanyUnitOrderQuantity()).orElse(BigDecimal.ZERO));
            entity.setOnePromotionDeduction(BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(entity.getProductNumber()) != 0) {
                entity.setOnePromotionDeduction(entity.getPromotionDeduction().divide(entity.getProductNumber(), 4, 4));
            }
            BigDecimal oneApplicationFee = Optional.ofNullable(entity.getOneApplicationFee()).orElse(BigDecimal.ZERO);
            BigDecimal oneDiffAmount = entity.getOnePromotionDeduction().subtract(oneApplicationFee);
            entity.setOneDiffAmount(oneDiffAmount);
            BigDecimal sharePromotionDeduction = Optional.ofNullable(entity.getSharePromotionDeduction()).orElse(BigDecimal.ZERO);
            entity.setSharePromotionDeduction(sharePromotionDeduction);
            entity.setTotalDiffAmount(oneDiffAmount.multiply(entity.getProductNumber()).add(sharePromotionDeduction));
            entity.setTotalDiffFinalAmount(entity.getTotalDiffAmount());
            entity.setMatchStatus(BooleanEnum.FALSE.getCapital());
            entity.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
            entity.setIsMatchCost(BooleanEnum.FALSE.getCapital());
            entity.setDiffType(this.auditFeeCheckPosMatchActivityService.oneDiffAmountGetDiffType(entity.getTotalDiffFinalAmount(), entity.getActivityDetailItemCode()));
            entity.setDataSource(PosDataSourceEnum.FEE_DETAIL.getCode());
            if (StringUtil.isEmpty((String)entity.getDataSource()) || StringUtil.isEmpty((String)entity.getDirectCode()) || StringUtil.isEmpty((String)entity.getTerminalCode()) || StringUtil.isEmpty((String)entity.getProductCode()) || StringUtil.isEmpty((String)entity.getSalesDateStr())) {
                return;
            }
            String onlyKey = entity.getDataSource() + entity.getDirectCode() + entity.getTerminalCode() + entity.getProductCode() + entity.getChannelCode() + entity.getSalesDateStr();
            entity.setOnlyKey(onlyKey);
            entity.setId(DigestUtils.md5Hex((String)onlyKey));
            entityList.add(entity);
        });
        return entityList;
    }
}

