/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.PosMatchActTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import liquibase.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AuditFeeCheckPosServiceImpl
implements AuditFeeCheckPosService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private AuditFeeCheckPosMatchActivityService auditFeeCheckPosMatchActivityService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(AuditFeeCheckPosDto dto) {
        this.baseValData(dto);
        if (StringUtil.isNotEmpty((String)dto.getActivityDetailItemCode())) {
            List detailPlanVoList;
            AuditFeeCheckPosVo posVo = (AuditFeeCheckPosVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                SubComActivityDetailPlanItemVo detailPlanItemVo = this.subComActivityDetailPlanItemVoService.findDetailByItemCode(dto.getActivityDetailItemCode());
                Assert.notNull((Object)detailPlanItemVo, (String)("\u6d3b\u52a8\u660e\u7ec6[" + dto.getActivityDetailItemCode() + "]\u4e0d\u5b58\u5728!"));
                this.auditFeeCheckPosMatchActivityService.sonCompanyPosMatchActUpdateVo(posVo, detailPlanItemVo);
                detailPlanVoList = this.auditFeeCheckPosMatchActivityService.sonCompanyDetailPlanList(Collections.singletonList(detailPlanItemVo));
            } else {
                ActivityDetailPlanItemVo detailPlanItemVo = this.activityDetailPlanItemSdkService.getActivityDetailPlanItemByCode(dto.getActivityDetailItemCode());
                Assert.notNull((Object)detailPlanItemVo, (String)("\u6d3b\u52a8\u660e\u7ec6[" + dto.getActivityDetailItemCode() + "]\u4e0d\u5b58\u5728!"));
                this.auditFeeCheckPosMatchActivityService.verticalPosMatchActUpdateVo(posVo, detailPlanItemVo);
                detailPlanVoList = this.auditFeeCheckPosMatchActivityService.verticalDetailPlanList(Collections.singletonList(detailPlanItemVo));
            }
            posVo.setMatchActivityType(PosMatchActTypeEnum.MANUAL.getCode());
            this.auditFeeCheckPosMatchActivityService.saveResult(Collections.singletonList(posVo), detailPlanVoList);
        } else {
            this.cancelActMatchActivity(dto);
        }
    }

    private void baseValData(AuditFeeCheckPosDto dto) {
        Assert.notNull((Object)dto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getMatchCode(), (String)"\u6263\u8d39\u5339\u914d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        BusinessUnitEnum unitEnum = BusinessUnitEnum.codeToEnum((String)dto.getBusinessUnitCode());
        Assert.notNull((Object)unitEnum, (String)("\u4e1a\u52a1\u5355\u5143\u7f16\u7801[" + dto.getBusinessUnitCode() + "]\u4e0d\u5408\u6cd5!"));
        if (StringUtil.isNotEmpty((String)dto.getFeeCheckMatchCode())) {
            dto.setIsMatchCost(BooleanEnum.TRUE.getCapital());
        } else {
            dto.setIsMatchCost(BooleanEnum.FALSE.getCapital());
        }
        dto.setActivityDetailItemCode(StringUtil.trimToEmpty((String)dto.getActivityDetailItemCode()));
        dto.setActivityDetailItemName(StringUtil.trimToEmpty((String)dto.getActivityDetailItemName()));
        dto.setActivityDetailCode(StringUtil.trimToEmpty((String)dto.getActivityDetailCode()));
        dto.setActivityDetailName(StringUtil.trimToEmpty((String)dto.getActivityDetailName()));
        dto.setCompanyCostCode(StringUtil.trimToEmpty((String)dto.getCompanyCostCode()));
        dto.setItemIndex(StringUtil.trimToEmpty((String)dto.getItemIndex()));
        dto.setMatchStatus(BooleanEnum.FALSE.getCapital());
        dto.setMatchTime(null);
        AuditFeeCheckPos entity = (AuditFeeCheckPos)((Object)this.auditFeeCheckPosRepository.getById((Serializable)((Object)dto.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        Assert.isTrue((boolean)dto.getMatchCode().equals(entity.getMatchCode()), (String)"\u6263\u8d39\u5339\u914d\u5355\u53f7\u4e0d\u80fd\u4fee\u6539!");
        if (BooleanEnum.TRUE.getCapital().equals(entity.getIsMatchCost())) {
            Assert.isTrue((boolean)entity.getActivityDetailItemCode().equals(dto.getActivityDetailItemCode()), (String)("POS\u6838\u5bf9\u5355[" + entity.getMatchCode() + "]\u5df2\u5173\u8054\u8d39\u7528\u6838\u5bf9[" + entity.getFeeCheckMatchCode() + "]\uff0c\u8bf7\u5148\u5bf9\u8d39\u7528\u6838\u5bf9\u64cd\u4f5c\u53d6\u6d88\u5339\u914d\u540e\u518d\u5904\u7406POS\u6570\u636e!"));
        }
        Assert.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(entity.getMatchStatus()), (String)("POS\u6838\u5bf9\u5355[" + entity.getMatchCode() + "]\u5df2\u786e\u8ba4,\u4e0d\u53ef\u7f16\u8f91!"));
    }

    private void cancelActMatchActivity(AuditFeeCheckPosDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        AuditFeeCheckPos entity = (AuditFeeCheckPos)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeCheckPos.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        entity.setOneApplicationFee(BigDecimal.ZERO);
        entity.setOneDiffAmount(BigDecimal.ZERO);
        entity.setSharePromotionDeduction(BigDecimal.ZERO);
        entity.setTotalDiffAmount(BigDecimal.ZERO);
        entity.setTotalDiffFinalAmount(BigDecimal.ZERO);
        entity.setDiffType(this.auditFeeCheckPosMatchActivityService.oneDiffAmountGetDiffType(entity.getTotalDiffFinalAmount(), entity.getActivityDetailItemCode()));
        entity.setMatchActivityType(null);
        this.auditFeeCheckPosRepository.updateById((Object)entity);
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto) {
        Assert.hasLength((String)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.activityDetailPlanItemSdkService.findByConditions(pageable, dto);
    }

    @Override
    public Page<SubComActivityDetailPlanItemVo> findSubComActivityDetailPlanItemPage(Pageable pageable, SubComActivityDetailPlanItemDto dto) {
        Assert.hasLength((String)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!");
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.subComActivityDetailPlanItemVoService.findByConditions(pageable, dto);
    }
}

