/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.vo.InvoiceExpenseSheetVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPosLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosHeadService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosHeadDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditDiffUseEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AuditFeeCheckPosVoServiceImpl
implements AuditFeeCheckPosVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private AuditFeeCheckPosLedgerRepository auditFeeCheckPosLedgerRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeCheckPosMatchActivityService auditFeeCheckPosMatchActivityService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required=false)
    private AuditFeeCheckPosHeadService auditFeeCheckPosHeadService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public Page<AuditFeeCheckPosVo> findByConditions(Pageable pageable, AuditFeeCheckPosDto dto) {
        return this.auditFeeCheckPosRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(List<AuditFeeCheckPosVo> auditFeeCheckPosVoList, String salesDate, int total, Integer pageNum) {
        if (CollectionUtils.isEmpty(auditFeeCheckPosVoList)) {
            return;
        }
        ArrayList existList = new ArrayList();
        Map existMap = existList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        for (AuditFeeCheckPosVo posVo : auditFeeCheckPosVoList) {
            posVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            posVo.setTenantCode(TenantUtils.getTenantCode());
        }
        Collection posEntityList = this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeCheckPosVoList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class, new String[0]);
        try {
            this.auditFeeCheckPosRepository.saveOrUpdateBatch(posEntityList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u8d39\u7528\u6838\u5bf9\u4fdd\u5b58pos\u6570\u636e\u5931\u8d25\uff01[\u65e5\u671f:" + salesDate + ",\u603b\u6761\u6570:" + total + ",\u5f53\u524d\u9875:" + pageNum + "]");
        }
    }

    public List<AuditFeeCheckPosVo> findByMatchCode(String matchCode) {
        if (StringUtils.isBlank((CharSequence)matchCode)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckPos> list = this.auditFeeCheckPosRepository.findByMatchCode(matchCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<String> findExistByPosId(List<String> posIds) {
        if (CollectionUtils.isEmpty(posIds)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckPos> list = this.auditFeeCheckPosRepository.findByPosId(posIds);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list.stream().filter(p -> BooleanEnum.TRUE.getCapital().equals(p.getIsMatchCost())).map(UuidEntity::getId).distinct().collect(Collectors.toList());
    }

    public void updateStatusByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.auditFeeCheckPosRepository.updateStatusByMatchCodes(matchCodes);
    }

    public void updateByIds(List<AuditFeeCheckPosVo> updatePosList) {
        if (CollectionUtils.isEmpty(updatePosList)) {
            return;
        }
        Collection auditFeeCheckPos = this.nebulaToolkitService.copyCollectionByWhiteList(updatePosList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeCheckPosRepository.updateBatchById(auditFeeCheckPos);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateRemark(AuditFeeCheckPosDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        String remark = dto.getRemark();
        Assert.hasLength((String)remark, (String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((remark.length() < 600 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7600!");
        List<AuditFeeCheckPosVo> checkPosList = this.getIdsAndValData(dto);
        this.auditFeeCheckPosRepository.updateRemark(checkPosList.stream().map(UuidVo::getId).collect(Collectors.toList()), remark);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelMatch(AuditFeeCheckPosDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        List<AuditFeeCheckPosVo> checkPosList = this.getIdsAndValData(dto);
        checkPosList.forEach(item -> {
            Assert.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(item.getIsMatchCost()), (String)("POS\u6838\u5bf9\u5355[" + item.getMatchCode() + "]\u5df2\u5173\u8054\u8d39\u7528\u6838\u5bf9[" + item.getFeeCheckMatchCode() + "]\uff0c\u8bf7\u5148\u5bf9\u8d39\u7528\u6838\u5bf9\u64cd\u4f5c\u53d6\u6d88\u5339\u914d\u540e\u518d\u5904\u7406POS\u6570\u636e\uff01"));
            Assert.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(item.getMatchStatus()), (String)("POS\u6838\u5bf9\u5355[" + item.getMatchCode() + "]\u5df2\u786e\u8ba4,\u4e0d\u53ef\u53d6\u6d88\u5339\u914d!"));
            Assert.isTrue((boolean)BooleanEnum.TRUE.getCapital().equals(item.getIsMatchActivity()), (String)("POS\u6838\u5bf9\u5355[" + item.getMatchCode() + "]\u672a\u5173\u8054\u4efb\u4f55\u6d3b\u52a8\uff0c\u4e0d\u53ef\u53d6\u6d88\u5339\u914d!"));
            Assert.isTrue((BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode()) || BusinessUnitEnum.SON_COMPANY.getCode().equals(item.getBusinessUnitCode()) ? 1 : 0) != 0, (String)("POS\u6838\u5bf9\u5355[" + item.getMatchCode() + "]\u4e1a\u52a1\u5355\u5143\u4e0d\u5408\u6cd5\uff0c\u4e0d\u53ef\u53d6\u6d88\u5339\u914d!"));
        });
        checkPosList.forEach(item -> {
            item.setMatchActivityType(null);
            if (BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode())) {
                this.auditFeeCheckPosMatchActivityService.verticalPosMatchActUpdateVo(item, null);
            } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(item.getBusinessUnitCode())) {
                this.auditFeeCheckPosMatchActivityService.sonCompanyPosMatchActUpdateVo(item, null);
            }
        });
        this.auditFeeCheckPosMatchActivityService.saveResult(checkPosList, null);
    }

    public List<AuditFeeCheckPosVo> findDiffCheckDataList(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List entityList = this.auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty((Collection)entityList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        Assert.isTrue((entityList.size() == ids.size() ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u6761\u76ee\u4e0d\u5bf9,\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5!");
        AtomicInteger index = new AtomicInteger(0);
        entityList.forEach(item -> {
            index.getAndIncrement();
            Assert.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(item.getMatchStatus()), (String)("\u7b2c" + index.get() + "\u884c\u5df2\u6838\u5bf9,\u4e0d\u53ef\u91cd\u590d\u6838\u5bf9!"));
            item.setBusinessUnitCode(StringUtils.trim((String)item.getBusinessUnitCode()));
            item.setBusinessFormatCode(StringUtils.trim((String)item.getBusinessFormatCode()));
            item.setBusinessArea(StringUtils.trim((String)item.getBusinessArea()));
            item.setDirectCode(StringUtils.trim((String)item.getDirectCode()));
            item.setTerminalCode(StringUtils.trim((String)item.getTerminalCode()));
            item.setProductCode(StringUtils.trim((String)item.getProductCode()));
        });
        Collection checkPosVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityList, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<AuditFeeCheckPosVo>> resultMap = checkPosVos.stream().collect(Collectors.groupingBy(v -> v.getBusinessUnitCode() + v.getBusinessFormatCode() + v.getBusinessArea() + v.getDirectCode() + v.getTerminalCode() + v.getProductCode()));
        ArrayList<AuditFeeCheckPosVo> result = new ArrayList<AuditFeeCheckPosVo>();
        ArrayList<String> matchCodeList = new ArrayList<String>();
        resultMap.forEach((key, list) -> {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            ArrayList itemIds = new ArrayList();
            ArrayList matchCodeItemList = new ArrayList();
            Optional<AuditFeeCheckPosVo> posVoOptional = list.stream().filter(k -> Objects.nonNull(k.getSalesDate())).max(Comparator.comparing(AuditFeeCheckPosVo::getSalesDate));
            AuditFeeCheckPosVo vo = (AuditFeeCheckPosVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)posVoOptional.orElse((AuditFeeCheckPosVo)list.get(0)), AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setId(key);
            vo.setRemark(null);
            AtomicReference<BigDecimal> totalDiffAmountTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> totalDiffFinalAmountTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            list.forEach(item -> {
                itemIds.add(item.getId());
                matchCodeItemList.add(item.getMatchCode());
                item.setTotalDiffAmount(Optional.ofNullable(item.getTotalDiffAmount()).orElse(BigDecimal.ZERO));
                totalDiffAmountTotal.set(((BigDecimal)totalDiffAmountTotal.get()).add(item.getTotalDiffAmount()));
                item.setTotalDiffFinalAmount(Optional.ofNullable(item.getTotalDiffFinalAmount()).orElse(BigDecimal.ZERO));
                totalDiffFinalAmountTotal.set(((BigDecimal)totalDiffFinalAmountTotal.get()).add(item.getTotalDiffFinalAmount()));
            });
            vo.setIds(itemIds);
            vo.setMatchCodes(matchCodeItemList);
            matchCodeList.addAll(matchCodeItemList);
            vo.setTotalDiffAmount(totalDiffAmountTotal.get());
            vo.setTotalDiffFinalAmount(totalDiffFinalAmountTotal.get());
            result.add(vo);
        });
        this.setDiffLedgerInfo(matchCodeList, result);
        return result;
    }

    private void setDiffLedgerInfo(List<String> matchCodeList, List<AuditFeeCheckPosVo> result) {
        List<AuditFeeCheckPosLedger> posLedgerList;
        if (CollectionUtil.isEmpty(matchCodeList) || CollectionUtil.isEmpty(result)) {
            return;
        }
        HashMap ledgerVoMap = Maps.newHashMap();
        HashMap feeDiffLedgerCodeMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(matchCodeList) && CollectionUtil.isNotEmpty(posLedgerList = this.auditFeeCheckPosLedgerRepository.findByMatchCodeList(matchCodeList))) {
            List ledgerVoList;
            feeDiffLedgerCodeMap.putAll(posLedgerList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMatchCode())).filter(k -> StringUtils.isNotEmpty((CharSequence)k.getFeeDiffLedgerCode())).collect(Collectors.toMap(AuditFeeCheckPosLedger::getMatchCode, AuditFeeCheckPosLedger::getFeeDiffLedgerCode, (n, o) -> n)));
            if (CollectionUtil.isNotEmpty((Map)feeDiffLedgerCodeMap) && CollectionUtil.isNotEmpty((Collection)(ledgerVoList = this.auditFeeDiffLedgerVoService.findDetailByCodes(new ArrayList(feeDiffLedgerCodeMap.values()))))) {
                ledgerVoMap.putAll(ledgerVoList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getFeeDiffLedgerCode())).collect(Collectors.toMap(AuditFeeDiffLedgerVo::getFeeDiffLedgerCode, v -> v, (n, o) -> n)));
            }
        }
        result.forEach(item -> {
            if (CollectionUtil.isNotEmpty((Collection)item.getMatchCodes())) {
                ArrayList diffLedgerVoList = new ArrayList();
                item.getMatchCodes().stream().filter(feeDiffLedgerCodeMap::containsKey).forEach(matchCode -> diffLedgerVoList.add(ledgerVoMap.get(feeDiffLedgerCodeMap.get(matchCode))));
                item.setLedgerVoList(diffLedgerVoList);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void tempSave(List<AuditFeeCheckPosDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u786e\u8ba4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        AtomicInteger index = new AtomicInteger(0);
        Map differenceTypeMap = this.dictToolkitService.findMapByDictTypeCode("difference_type");
        Map differentialUseMap = this.dictToolkitService.findMapByDictTypeCode("differential_use");
        ArrayList ids = new ArrayList();
        ArrayList posLedgerList = new ArrayList();
        String tenantCode = TenantUtils.getTenantCode();
        dtoList.forEach(item -> {
            index.getAndIncrement();
            Assert.notEmpty((Collection)item.getIds(), (String)("\u7b2c" + index.get() + "\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.notEmpty((Collection)item.getMatchCodes(), (String)("\u7b2c" + index.get() + "\u884c\u6263\u8d39\u5339\u914d\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!"));
            ids.addAll(item.getIds());
            if (StringUtils.isNotEmpty((CharSequence)item.getDiffType())) {
                Assert.isTrue((boolean)differenceTypeMap.containsKey(item.getDiffType()), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u7c7b\u578b[" + item.getDiffType() + "]\u4e0d\u5408\u6cd5,\u672a\u5728\u6570\u636e\u5b57\u5178[" + "difference_type" + "]\u4e2d\u914d\u7f6e!"));
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getDiffUse())) {
                Assert.isTrue((boolean)differentialUseMap.containsKey(item.getDiffUse()), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u4f7f\u7528[" + item.getDiffUse() + "]\u4e0d\u5408\u6cd5,\u672a\u5728\u6570\u636e\u5b57\u5178[" + "differential_use" + "]\u4e2d\u914d\u7f6e!"));
                if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType()) && AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(item.getDiffUse()) && CollectionUtil.isNotEmpty((Collection)item.getDiffLedgerVoList())) {
                    item.getDiffLedgerVoList().forEach(diffLedgerVo -> {
                        if (Objects.nonNull(diffLedgerVo) && StringUtils.isNotEmpty((CharSequence)diffLedgerVo.getFeeDiffLedgerCode())) {
                            item.getMatchCodes().forEach(matchCode -> {
                                AuditFeeCheckPosLedger posLedger = new AuditFeeCheckPosLedger();
                                posLedger.setMatchCode((String)matchCode);
                                posLedger.setFeeDiffLedgerCode(diffLedgerVo.getFeeDiffLedgerCode());
                                posLedger.setDeductAmount(diffLedgerVo.getDeductAmount());
                                posLedger.setTenantCode(tenantCode);
                                posLedger.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                                posLedger.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                                posLedgerList.add(posLedger);
                            });
                        }
                    });
                }
            }
        });
        List entityList = this.auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty((Collection)entityList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        Assert.isTrue((entityList.size() == ids.size() ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u6761\u76ee\u4e0d\u5bf9,\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5!");
        index.set(0);
        ArrayList<String> matchCodeList = new ArrayList<String>();
        entityList.forEach(item -> {
            index.getAndIncrement();
            matchCodeList.add(item.getMatchCode());
            Assert.isTrue((!BooleanEnum.TRUE.getCapital().equals(item.getMatchStatus()) ? 1 : 0) != 0, (String)("\u7b2c" + index.get() + "\u884c\u5df2\u6838\u5bf9,\u4e0d\u53ef\u91cd\u590d\u6838\u5bf9!"));
        });
        this.auditFeeCheckPosLedgerRepository.removeByMatchCodeList(matchCodeList);
        dtoList.forEach(item -> {
            item.setMatchStatus(BooleanEnum.FALSE.getCapital());
            this.auditFeeCheckPosRepository.updateFeeCheckPos((AuditFeeCheckPosDto)item);
        });
        if (CollectionUtil.isNotEmpty(posLedgerList)) {
            this.auditFeeCheckPosLedgerRepository.saveBatch(posLedgerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void sureMatch(List<AuditFeeCheckPosDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u786e\u8ba4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        AtomicInteger index = new AtomicInteger(0);
        this.baseValData(dtoList);
        ArrayList ids = new ArrayList();
        ArrayList<AuditFeeCheckPosLedger> posLedgerList = new ArrayList<AuditFeeCheckPosLedger>();
        ArrayList<AuditFeeDiffLedgerDto> diffLedgerDtoList = new ArrayList<AuditFeeDiffLedgerDto>();
        ArrayList<AuditFeeDiffLedgerDeductionDto> deductionDtoList = new ArrayList<AuditFeeDiffLedgerDeductionDto>();
        ArrayList<AuditFeeCheckPosHeadDto> posHeadDtoList = new ArrayList<AuditFeeCheckPosHeadDto>();
        dtoList.forEach(item -> ids.addAll(item.getIds()));
        List entityList = this.auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty((Collection)entityList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        Assert.isTrue((entityList.size() == ids.size() ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u6761\u76ee\u4e0d\u5bf9,\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5!");
        index.set(0);
        ArrayList<String> matchCodeList = new ArrayList<String>();
        entityList.forEach(item -> {
            Assert.isTrue((!BooleanEnum.TRUE.getCapital().equals(item.getMatchStatus()) ? 1 : 0) != 0, (String)("\u7b2c" + index.get() + "\u884c\u5df2\u6838\u5bf9,\u4e0d\u53ef\u91cd\u590d\u6838\u5bf9!"));
            index.getAndIncrement();
            matchCodeList.add(item.getMatchCode());
        });
        index.set(0);
        this.buildDataList(dtoList, posLedgerList, diffLedgerDtoList, deductionDtoList, posHeadDtoList);
        this.auditFeeCheckPosLedgerRepository.removeByMatchCodeList(matchCodeList);
        if (CollectionUtil.isNotEmpty(posLedgerList)) {
            this.auditFeeCheckPosLedgerRepository.saveBatch(posLedgerList);
        }
        if (CollectionUtil.isNotEmpty(posHeadDtoList)) {
            this.auditFeeCheckPosHeadService.createList(posHeadDtoList);
        }
        dtoList.forEach(item -> this.auditFeeCheckPosRepository.updateFeeCheckPos((AuditFeeCheckPosDto)item));
        if (CollectionUtil.isNotEmpty(diffLedgerDtoList)) {
            diffLedgerDtoList.forEach(diffLedgerDto -> this.auditFeeDiffLedgerVoService.create(diffLedgerDto));
        }
        if (CollectionUtil.isNotEmpty(deductionDtoList)) {
            List feeDiffLedgerCodeList = deductionDtoList.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getFeeDiffLedgerCode())).map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).distinct().collect(Collectors.toList());
            boolean lockSuccess = this.auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 3);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            try {
                if (CollectionUtil.isNotEmpty(deductionDtoList)) {
                    deductionDtoList.forEach(deductionDto -> this.auditFeeDiffLedgerVoService.useAmount(deductionDto));
                }
            }
            finally {
                this.auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            }
        }
    }

    private void buildDataList(List<AuditFeeCheckPosDto> dtoList, List<AuditFeeCheckPosLedger> posLedgerList, List<AuditFeeDiffLedgerDto> diffLedgerDtoList, List<AuditFeeDiffLedgerDeductionDto> deductionDtoList, List<AuditFeeCheckPosHeadDto> posHeadDtoList) {
        if (CollectionUtil.isEmpty(dtoList)) {
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        String tenantCode = TenantUtils.getTenantCode();
        List codeList = this.generateCodeService.generateCode("PH", dtoList.size());
        AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
        String realName = crmUserIdentity.getRealName();
        String account = crmUserIdentity.getAccount();
        Date nowDate = new Date();
        dtoList.forEach(item -> {
            item.setMatchStatus(BooleanEnum.TRUE.getCapital());
            AuditFeeCheckPosHeadDto posHeadDto = (AuditFeeCheckPosHeadDto)this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeeCheckPosHeadDto.class, HashSet.class, ArrayList.class, new String[0]);
            posHeadDto.setId(null);
            posHeadDto.setCreateAccount(account);
            posHeadDto.setCreateName(realName);
            posHeadDto.setCreateTime(nowDate);
            posHeadDto.setModifyAccount(account);
            posHeadDto.setModifyName(realName);
            posHeadDto.setModifyTime(nowDate);
            posHeadDto.setMatchHeadCode((String)codeList.get(index.getAndIncrement()));
            String[] yearMonthArray = posHeadDto.getYearMonthLy().split("-");
            posHeadDto.setYear(yearMonthArray[0]);
            posHeadDto.setMonth(yearMonthArray[1]);
            posHeadDtoList.add(posHeadDto);
            item.setMatchHeadCode(posHeadDto.getMatchHeadCode());
            if (DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode().equals(item.getDiffType()) || DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType())) {
                AuditFeeDiffLedgerDto diffLedgerDto = new AuditFeeDiffLedgerDto();
                diffLedgerDto.setAuditFeeCheckCode(posHeadDto.getMatchHeadCode());
                diffLedgerDto.setBusinessFormatCode(posHeadDto.getBusinessFormatCode());
                diffLedgerDto.setBusinessUnitCode(posHeadDto.getBusinessUnitCode());
                diffLedgerDto.setFeeYearMonth(posHeadDto.getYearMonthLy());
                diffLedgerDto.setYear(posHeadDto.getYear());
                diffLedgerDto.setMonth(posHeadDto.getMonth());
                diffLedgerDto.setDiffAmount(posHeadDto.getTotalDiffFinalAmount());
                diffLedgerDto.setBusinessAreaCode(posHeadDto.getBusinessArea());
                diffLedgerDto.setRetailerCode(posHeadDto.getCustomerRetailerCode());
                diffLedgerDto.setRetailerName(posHeadDto.getCustomerRetailerName());
                diffLedgerDto.setDeliveryPartyCode(posHeadDto.getTerminalCode());
                diffLedgerDto.setDeliveryPartyName(posHeadDto.getTerminalName());
                diffLedgerDto.setDataSource(DiffLedgerDataSourceEnum.POS_COLLATE.getCode());
                diffLedgerDtoList.add(diffLedgerDto);
            } else if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType()) && AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(item.getDiffUse())) {
                item.getDiffLedgerVoList().forEach(diffLedgerVo -> {
                    AuditFeeDiffLedgerDeductionDto deductionDto = new AuditFeeDiffLedgerDeductionDto();
                    deductionDto.setFeeDiffLedgerCode(diffLedgerVo.getFeeDiffLedgerCode());
                    deductionDto.setRecoveredAmount(diffLedgerVo.getDeductAmount());
                    deductionDto.setBusinessCode(posHeadDto.getMatchHeadCode());
                    deductionDto.setResaleCommercialCode(posHeadDto.getCustomerRetailerCode());
                    deductionDto.setResaleCommercialName(posHeadDto.getCustomerRetailerName());
                    deductionDto.setTerminalCode(posHeadDto.getTerminalCode());
                    deductionDto.setTerminalName(posHeadDto.getTerminalName());
                    deductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                    deductionDto.setOperatorAccount(account);
                    deductionDto.setOperatorName(realName);
                    deductionDto.setRecoveredTime(nowDate);
                    deductionDto.setDataSource(DiffLedgerDataSourceEnum.POS_COLLATE.getCode());
                    deductionDtoList.add(deductionDto);
                    item.getMatchCodes().forEach(matchCode -> {
                        AuditFeeCheckPosLedger posLedger = new AuditFeeCheckPosLedger();
                        posLedger.setMatchHeadCode(posHeadDto.getMatchHeadCode());
                        posLedger.setMatchCode((String)matchCode);
                        posLedger.setFeeDiffLedgerCode(diffLedgerVo.getFeeDiffLedgerCode());
                        posLedger.setDeductAmount(diffLedgerVo.getDeductAmount());
                        posLedger.setTenantCode(tenantCode);
                        posLedger.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        posLedger.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                        posLedger.setRemark(item.getRemark());
                        posLedgerList.add(posLedger);
                    });
                });
            }
        });
    }

    private void baseValData(List<AuditFeeCheckPosDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u786e\u8ba4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        AtomicInteger index = new AtomicInteger(0);
        Map differenceTypeMap = this.dictToolkitService.findMapByDictTypeCode("difference_type");
        Map differentialUseMap = this.dictToolkitService.findMapByDictTypeCode("differential_use");
        dtoList.forEach(item -> {
            index.getAndIncrement();
            Assert.notEmpty((Collection)item.getIds(), (String)("\u7b2c" + index.get() + "\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (StringUtils.isNotEmpty((CharSequence)item.getRemark())) {
                Assert.isTrue((item.getRemark().length() < 100 ? 1 : 0) != 0, (String)("\u7b2c" + index.get() + "\u884c\u5907\u6ce8\u6700\u5927\u957f\u5ea6\u4e3a100!"));
            }
            Assert.notEmpty((Collection)item.getMatchCodes(), (String)("\u7b2c" + index.get() + "\u884c\u6263\u8d39\u5339\u914d\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.notNull((Object)item.getSalesDate(), (String)("\u7b2c" + index.get() + "\u884c\u9500\u552e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.hasLength((String)item.getSalesDateStr(), (String)("\u7b2c" + index.get() + "\u884c\u9500\u552e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.hasLength((String)item.getYearMonthLy(), (String)("\u7b2c" + index.get() + "\u884c\u9500\u552e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.notNull((Object)item.getTotalDiffFinalAmount(), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u91d1\u989d[totalDiffFinalAmount]\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.hasLength((String)item.getDiffType(), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)differenceTypeMap.containsKey(item.getDiffType()), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u7c7b\u578b[" + item.getDiffType() + "]\u4e0d\u5408\u6cd5,\u672a\u5728\u6570\u636e\u5b57\u5178[" + "difference_type" + "]\u4e2d\u914d\u7f6e!"));
            if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(item.getDiffType())) {
                Assert.hasLength((String)item.getDiffUse(), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u4f7f\u7528\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)differentialUseMap.containsKey(item.getDiffUse()), (String)("\u7b2c" + index.get() + "\u884c\u5dee\u5f02\u4f7f\u7528[" + item.getDiffUse() + "]\u4e0d\u5408\u6cd5,\u672a\u5728\u6570\u636e\u5b57\u5178[" + "differential_use" + "]\u4e2d\u914d\u7f6e!"));
                if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(item.getDiffUse())) {
                    Assert.notEmpty((Collection)item.getDiffLedgerVoList(), (String)("\u7b2c" + index.get() + "\u884c,\u5dee\u5f02\u7c7b\u578b[" + (String)differenceTypeMap.get(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()) + "]\u5dee\u5f02\u4f7f\u7528[" + (String)differentialUseMap.get(AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode()) + "]\u65f6,\u5dee\u5f02\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a!"));
                    AtomicReference<BigDecimal> deductAmountAtomic = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    item.getDiffLedgerVoList().forEach(diffLedgerVo -> {
                        Assert.notNull((Object)diffLedgerVo, (String)("\u7b2c" + index.get() + "\u884c,\u5dee\u5f02\u7c7b\u578b[" + (String)differenceTypeMap.get(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()) + "]\u5dee\u5f02\u4f7f\u7528[" + (String)differentialUseMap.get(AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode()) + "]\u65f6,\u8d39\u7528\u5bf9\u8c61\u4e3a\u7a7a!"));
                        Assert.hasLength((String)diffLedgerVo.getFeeDiffLedgerCode(), (String)("\u7b2c" + index.get() + "\u884c,\u5dee\u5f02\u7c7b\u578b[" + (String)differenceTypeMap.get(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()) + "]\u5dee\u5f02\u4f7f\u7528[" + (String)differentialUseMap.get(AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode()) + "]\u65f6,\u5dee\u5f02\u8d39\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!"));
                        Assert.notNull((Object)diffLedgerVo.getDeductAmount(), (String)("\u7b2c" + index.get() + "\u884c\u5173\u8054\u7684\u5dee\u5f02\u8d39\u7528[" + diffLedgerVo.getFeeDiffLedgerCode() + "]\u62b5\u6263\u91d1\u989d[deductAmount]\u4e0d\u80fd\u4e3a\u7a7a!"));
                        Assert.isTrue((diffLedgerVo.getDeductAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)("\u7b2c" + index.get() + "\u884c\u5173\u8054\u7684\u5dee\u5f02\u8d39\u7528[" + diffLedgerVo.getFeeDiffLedgerCode() + "]\u62b5\u6263\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!"));
                        deductAmountAtomic.set(((BigDecimal)deductAmountAtomic.get()).add(diffLedgerVo.getDeductAmount()));
                    });
                    Assert.isTrue((item.getTotalDiffFinalAmount().abs().compareTo(deductAmountAtomic.get().abs()) == 0 ? 1 : 0) != 0, (String)"\u62b5\u6263\u91d1\u989d\u6c47\u603b\u7684\u7edd\u5bf9\u503c\u5fc5\u987b\u7b49\u4e8e\u5dee\u5f02\u786e\u8ba4\u91d1\u989d\u7684\u7edd\u5bf9\u503c");
                }
            }
        });
    }

    public AuditFeeCheckPosVo findByIdOrCode(String id, String matchCode) {
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)matchCode)) {
            return null;
        }
        AuditFeeCheckPos entity = this.auditFeeCheckPosRepository.findByIdOrCode(id, matchCode);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        AuditFeeCheckPosVo vo = (AuditFeeCheckPosVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (BooleanEnum.TRUE.getCapital().equals(vo.getIsMatchActivity()) && StringUtils.isNotEmpty((CharSequence)vo.getActivityDetailCode())) {
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(vo.getBusinessUnitCode())) {
                SubComActivityDetailPlanVo subComPlanVo = this.subComActivityDetailPlanVoService.findDetailByPlanCode(vo.getActivityDetailCode());
                if (Objects.nonNull(subComPlanVo)) {
                    ArrayList itemList = new ArrayList();
                    if (StringUtils.isNotEmpty((CharSequence)vo.getActivityDetailItemCode())) {
                        subComPlanVo.getItemList().forEach(item -> {
                            if (vo.getActivityDetailItemCode().equals(item.getConstituentDetailPlanItemCode())) {
                                itemList.add(item);
                            }
                        });
                    }
                    subComPlanVo.setItemList(itemList);
                    vo.setSubComPlanVo(subComPlanVo);
                }
            } else if (BusinessUnitEnum.VERTICAL.getCode().equals(vo.getBusinessUnitCode())) {
                ArrayList<String> detailPlanCodes = new ArrayList<String>();
                detailPlanCodes.add(vo.getActivityDetailCode());
                List planVoList = this.activityDetailPlanSdkService.findByCodes(detailPlanCodes);
                if (CollectionUtil.isNotEmpty((Collection)planVoList)) {
                    ActivityDetailPlanItemVo planItemVo;
                    ActivityDetailPlanVo planVo = (ActivityDetailPlanVo)planVoList.get(0);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getActivityDetailItemCode()) && Objects.nonNull(planItemVo = this.activityDetailPlanItemSdkService.getActivityDetailPlanItemByCode(vo.getActivityDetailItemCode()))) {
                        ArrayList<ActivityDetailPlanItemVo> planItemVoList = new ArrayList<ActivityDetailPlanItemVo>();
                        planItemVoList.add(planItemVo);
                        planVo.setActivityDetailPlanItemList(planItemVoList);
                    }
                    vo.setPlanVo(planVo);
                }
            }
        }
        if (BooleanEnum.TRUE.getCapital().equals(vo.getIsMatchCost()) && StringUtils.isNotEmpty((CharSequence)vo.getCompanyCostCode())) {
            InvoiceExpenseSheetVo sheetVo;
            Integer itemIndex = null;
            if (StringUtils.isNotEmpty((CharSequence)vo.getItemIndex())) {
                itemIndex = Integer.valueOf(vo.getItemIndex());
            }
            if (Objects.nonNull(sheetVo = this.invoiceExpenseSheetVoService.findByCode(vo.getCompanyCostCode(), itemIndex))) {
                if (StringUtils.isEmpty((CharSequence)vo.getItemIndex())) {
                    sheetVo.setProductList(null);
                }
                vo.setSheetVo(sheetVo);
            }
        }
        return vo;
    }

    private List<AuditFeeCheckPosVo> getIdsAndValData(AuditFeeCheckPosDto dto) {
        List ids = Optional.ofNullable(dto.getIds()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)dto.getId())) {
            ids.add(dto.getId());
        }
        Assert.notEmpty((Collection)ids, (String)"\u53c2\u6570[id/ids]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        List checkPosList = this.auditFeeCheckPosRepository.listByIds(ids);
        Assert.notEmpty((Collection)checkPosList, (String)"\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5!");
        Assert.isTrue((checkPosList.size() == ids.size() ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u6761\u76ee\u4e0d\u5bf9,\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5!");
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)checkPosList, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void matchActivity(AuditFeeCheckPosDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notEmpty((Collection)dto.getIds(), (String)"\u53c2\u8bf7\u9009\u62e9\u6570\u636e\uff01");
        List posList = this.auditFeeCheckPosRepository.listByIds(dto.getIds());
        Assert.notEmpty((Collection)posList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        List posVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)posList, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0]);
        log.info("POS\u5339\u914d\u6d3b\u52a8,POS\u6761\u6570:{}", (Object)posList.size());
        AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
        this.auditFeeCheckPosMatchActivityService.posMatchActivityAsync(dto, posVoList, abstractLoginUser);
    }
}

