/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckCostAsync;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckCostAsyncHelper;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckMatchFeeAsync;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeCheckLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditDiffUseEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeVerifyDecideSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.ConditionsEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchResultEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDiffVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.FeeAccordingEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateAllowanceService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDiffVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditFeeCheckService")
public class AuditFeeCheckVoServiceImpl
implements AuditFeeCheckVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeCheckRepository auditFeeCheckRepository;
    @Autowired(required=false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoCacheService auditFeeCheckDetailPlanVoCacheService;
    @Autowired(required=false)
    private AuditFeeCheckCostVoCacheService auditFeeCheckCostVoCacheService;
    @Autowired(required=false)
    private AuditFeeCheckDiffVoCacheService auditFeeCheckDiffVoCacheService;
    @Autowired(required=false)
    private AuditFeeCheckCostVoService auditFeeCheckCostVoService;
    @Autowired(required=false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;
    @Autowired(required=false)
    private AuditFeeCheckDiffVoService auditFeeCheckDiffVoService;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditFeeVerifyDecideService auditFeeVerifyDecideService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateService deductionMatchingTemplateService;
    @Autowired(required=false)
    private TpmDeductionDetailMappingService deductionDetailMappingService;
    @Autowired(required=false)
    private AuditFeePredictionService auditFeePredictionService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Resource(shareable=false)
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateAllowanceService tpmDeductionMatchingTemplateAllowanceService;
    @Autowired(required=false)
    private GenerateAuditFeeCheckCostAsync generateAuditFeeCheckCostAsync;
    @Autowired(required=false)
    private GenerateAuditFeeCheckMatchFeeAsync generateAuditFeeCheckMatchFeeAsync;
    @Autowired(required=false)
    private GenerateAuditFeeCheckCostAsyncHelper generateAuditFeeCheckCostAsyncHelper;
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;

    public Page<AuditFeeCheckVo> findByConditions(Pageable pageable, AuditFeeCheckDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeCheckRepository.findByConditions((Page<AuditFeeCheckVo>)page, dto);
    }

    public AuditFeeCheckVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findById(id);
        if (auditFeeCheck == null) {
            return null;
        }
        AuditFeeCheckVo auditFeeCheckVo = (AuditFeeCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeCheck, AuditFeeCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
        auditFeeCheckVo.setCacheKey(UUID.randomUUID().toString().replace("-", ""));
        return auditFeeCheckVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFeeCheckVo update(AuditFeeCheckVo auditFeeCheckVo, boolean cleanCache) {
        log.info("\u8d39\u7528\u6838\u5bf9\u4fdd\u5b58");
        long a = System.currentTimeMillis();
        Validate.notNull((Object)auditFeeCheckVo.getId(), (String)"\u4fee\u6539\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = auditFeeCheckVo.getCacheKey();
        Validate.notNull((Object)cacheKey, (String)"cacheKey\u7f3a\u5931", (Object[])new Object[0]);
        String currentId = auditFeeCheckVo.getId();
        AuditFeeCheck entity = this.auditFeeCheckRepository.findById(currentId);
        Validate.notNull((Object)((Object)entity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)entity.getIsConfirm()) ? 1 : 0) != 0, (String)"\u5df2\u786e\u8ba4\u7684\u6570\u636e\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        AuditFeeCheckVo oldVo = (AuditFeeCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
        AuditFeeCheck feeCheck = (AuditFeeCheck)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeCheckVo, AuditFeeCheck.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditFeeCheckRepository.updateById((Object)feeCheck);
        log.info("\u4e3b\u6570\u636e\u4fdd\u5b58\uff1a{}", (Object)(System.currentTimeMillis() - a));
        String matchCode = feeCheck.getMatchCode();
        this.auditFeeCheckDetailPlanRepository.updateDelFlagByMatchCodes(Lists.newArrayList((Object[])new String[]{matchCode}));
        List detailPlanCacheList = this.auditFeeCheckDetailPlanVoCacheService.findCacheList(cacheKey);
        if (CollectionUtils.isNotEmpty((Collection)detailPlanCacheList)) {
            detailPlanCacheList.forEach(detailPlanVo -> detailPlanVo.setAuditFeeCheckCode(matchCode));
            this.auditFeeCheckDetailPlanVoService.createBatch(detailPlanCacheList);
            detailPlanCacheList.clear();
        }
        log.info("\u7ec6\u6848\u4fdd\u5b58\uff1a{}", (Object)(System.currentTimeMillis() - a));
        List<String> dbCostCodes = this.auditFeeCheckCostRepository.findCompanyCostCodeByMatchCodes(Lists.newArrayList((Object[])new String[]{matchCode}));
        log.info("1234567890-cost-save-get-db\uff1a{}", (Object)(System.currentTimeMillis() - a));
        List costVos = this.auditFeeCheckCostVoCacheService.findCacheList(cacheKey);
        log.info("1234567890-cost-save-get-param\uff1a{}", (Object)(System.currentTimeMillis() - a));
        ArrayList<AuditFeeCheckCost> newCosts = new ArrayList<AuditFeeCheckCost>();
        ArrayList<String> newCostCodes = new ArrayList<String>();
        List deleteCostCodes = null;
        if (CollectionUtils.isNotEmpty((Collection)costVos)) {
            TpmDeductionMatchingTemplateVo templateVo = this.deductionMatchingTemplateService.findByCode(feeCheck.getMatchTemplateCode());
            Validate.notNull((Object)templateVo, (String)"\u6838\u5bf9\u6570\u636e\u6a21\u677f\u7f3a\u5931", (Object[])new Object[0]);
            TpmDeductionDetailMappingVo mappingVo = this.deductionDetailMappingService.findByCode(templateVo.getApplyMappingCode());
            Validate.notNull((Object)mappingVo, (String)"\u6838\u5bf9\u6570\u636e\u6a21\u677f\u6620\u5c04\u7f3a\u5931", (Object[])new Object[0]);
            log.info("1234567890-cost-save-prepare\uff1a{}", (Object)(System.currentTimeMillis() - a));
            ArrayList<String> paramCostCodes = new ArrayList<String>();
            for (AuditFeeCheckCostVo costVo : costVos) {
                paramCostCodes.add(costVo.getCompanyCostCode());
                if (costVo.getMd5UniqueKey() != null) continue;
                AuditFeeCheckCost cost = new AuditFeeCheckCost();
                BeanUtils.copyProperties((Object)costVo, (Object)((Object)cost));
                cost.setId(null);
                cost.setAuditFeeCheckCode(matchCode);
                cost.setTenantCode(TenantUtils.getTenantCode());
                cost.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                cost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                newCosts.add(cost);
                newCostCodes.add(cost.getCompanyCostCode());
                this.generateAuditFeeCheckCostAsync.generateCostSummaryUnique(cost, templateVo, mappingVo);
            }
            log.info("1234567890-cost-save-make-up-new\uff1a{}", (Object)(System.currentTimeMillis() - a));
            costVos.clear();
            deleteCostCodes = dbCostCodes.stream().filter(e -> !paramCostCodes.contains(e)).collect(Collectors.toList());
        }
        log.info("1234567890-cost-save-start\uff1a{}", (Object)(System.currentTimeMillis() - a));
        this.auditFeeCheckCostRepository.updateDelFlagByMatchCodes(deleteCostCodes, matchCode);
        log.info("1234567890-cost-save-clean\uff1a{}", (Object)(System.currentTimeMillis() - a));
        if (CollectionUtils.isNotEmpty(newCosts)) {
            this.auditFeeCheckCostRepository.saveBatch(newCosts);
            newCosts.clear();
        }
        log.info("1234567890-cost-save-over\uff1a{}", (Object)(System.currentTimeMillis() - a));
        if (!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirmDiff()) && AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(auditFeeCheckVo.getDiffUse())) {
            this.auditFeeCheckDiffVoService.updateDelFlagByMatchCodes((List)Lists.newArrayList((Object[])new String[]{matchCode}));
            List diffVoCacheList = this.auditFeeCheckDiffVoCacheService.findCacheList(cacheKey);
            if (CollectionUtils.isNotEmpty((Collection)diffVoCacheList)) {
                diffVoCacheList.forEach(diffVo -> diffVo.setAuditFeeCheckDeductCode(matchCode));
                this.auditFeeCheckDiffVoService.createBatch(diffVoCacheList);
                diffVoCacheList.clear();
                log.info("\u5dee\u5f02\u4fdd\u5b58\u5185\u5bb9\uff1a{}", (Object)diffVoCacheList);
            }
        }
        log.info("\u5dee\u5f02\u4fdd\u5b58\uff1a{}", (Object)(System.currentTimeMillis() - a));
        AuditFeeCheckLogEventDto logEventDto = new AuditFeeCheckLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeCheckVo);
        SerializableBiConsumer & Serializable onUpdate = AuditFeeCheckLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFeeCheckLogEventListener.class, (SerializableBiConsumer)onUpdate);
        log.info("event\u901a\u77e5\uff1a{}", (Object)(System.currentTimeMillis() - a));
        if (cleanCache) {
            this.auditFeeCheckDetailPlanVoCacheService.clearCache(cacheKey);
            this.auditFeeCheckCostVoCacheService.clearCache(cacheKey);
            this.auditFeeCheckDiffVoCacheService.clearCache(cacheKey);
        }
        return auditFeeCheckVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeCheckRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeCheckRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditFeeCheck> feeChecks = this.auditFeeCheckRepository.findByIds(ids);
        Validate.notEmpty(feeChecks, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List matchedMatchCodeList = feeChecks.stream().filter(e -> MatchStatusEnum.MATCHED.getCode().equals(e.getMatchStatus())).map(AuditFeeCheck::getMatchCode).filter(Objects::nonNull).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(matchedMatchCodeList), (String)(String.join((CharSequence)",", matchedMatchCodeList) + "\u5339\u914d\u72b6\u6001\u4e3a\u5df2\u5339\u914d\uff0c\u4e0d\u53ef\u5220\u9664"), (Object[])new Object[0]);
        log.info("\u8d39\u7528\u6838\u5bf9\u903b\u8f91\u5220\u9664-\u5f00\u59cb");
        for (AuditFeeCheck feeCheck : feeChecks) {
            if (StringUtils.equals((CharSequence)feeCheck.getIsConfirm(), (CharSequence)BooleanEnum.TRUE.getCapital())) {
                throw new IllegalArgumentException("\u5339\u914d\u5355[" + feeCheck.getMatchCode() + "]\u5df2\u786e\u8ba4\u4e0d\u53ef\u4ee5\u5220\u9664");
            }
            if (!StringUtils.equals((CharSequence)feeCheck.getIsConfirmDiff(), (CharSequence)BooleanEnum.TRUE.getCapital())) continue;
            throw new IllegalArgumentException("\u5339\u914d\u5355[" + feeCheck.getMatchCode() + "]\u5dee\u5f02\u8d39\u7528\u5df2\u786e\u8ba4\u4e0d\u53ef\u4ee5\u5220\u9664");
        }
        List<String> matchCodes = feeChecks.stream().map(AuditFeeCheck::getMatchCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.generateAuditFeeCheckCostAsyncHelper.deleteByMatchCodes(matchCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualMatchFee(AuditFeeMatchDto auditFeeMatchDto) {
        Validate.notNull((Object)auditFeeMatchDto, (String)"\u8bf7\u4f20\u5165\u53c2\u6570", (Object[])new Object[0]);
        List idList = auditFeeMatchDto.getIdList();
        Validate.notEmpty((Collection)idList, (String)"\u8bf7\u4f20\u5165id\u96c6\u5408", (Object[])new Object[0]);
        List<AuditFeeCheck> list = this.auditFeeCheckRepository.findByIds(idList);
        Validate.notEmpty(list, (String)"\u8bf7\u4f20\u5165\u53c2\u6570", (Object[])new Object[0]);
        ArrayList<String> matchedCodes = new ArrayList<String>();
        ArrayList<String> confirmDiffCodes = new ArrayList<String>();
        for (AuditFeeCheck feeCheck : list) {
            if (MatchStatusEnum.MATCHED.getCode().equals(feeCheck.getMatchStatus())) {
                matchedCodes.add(feeCheck.getMatchCode());
            }
            if (!BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirm()) && !BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirmDiff())) continue;
            confirmDiffCodes.add(feeCheck.getMatchCode());
        }
        Validate.isTrue((boolean)CollectionUtils.isEmpty(matchedCodes), (String)(String.join((CharSequence)",", matchedCodes) + "\u5df2\u5339\u914d\uff0c\u8bf7\u5148\u53d6\u6d88\u5339\u914d"), (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(confirmDiffCodes), (String)(String.join((CharSequence)",", confirmDiffCodes) + "\u5df2\u786e\u8ba4\u5dee\u5f02\uff0c\u65e0\u6cd5\u518d\u6b21\u5339\u914d"), (Object[])new Object[0]);
        String lockKey = this.getClass().getName() + ":" + auditFeeMatchDto.hashCode();
        try {
            Validate.isTrue((boolean)this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 10L), (String)"\u5339\u914d\u5fd9\u788c\uff0c\u8bf7\u91cd\u8bd5", (Object[])new Object[0]);
            this.matchFee(auditFeeMatchDto);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    public void matchFee(AuditFeeMatchDto auditFeeMatchDto) {
        log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u5f00\u59cb");
        HashSet usedActivityDetailPlanItemCodeSet = Sets.newHashSet();
        HashMap templateMap = Maps.newHashMap();
        HashMap mappingVoMap = Maps.newHashMap();
        HashMap salesOrgVoMap = Maps.newHashMap();
        HashSet activityFormCodes = Sets.newHashSet();
        AuditFeeCheckDto dto = new AuditFeeCheckDto();
        dto.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setMatchCode(auditFeeMatchDto.getMatchCode());
        dto.setMatchCodes(auditFeeMatchDto.getMatchCodes());
        dto.setIdList(auditFeeMatchDto.getIdList());
        dto.setIsConfirm(BooleanEnum.FALSE.getCapital());
        dto.setIsConfirmDiff(BooleanEnum.FALSE.getCapital());
        log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7b5b\u9009\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)dto));
        Page<AuditFeeCheckVo> page = new Page<AuditFeeCheckVo>((long)AuditFeeConstants.PAGE_NUM.intValue(), (long)AuditFeeConstants.PAGE_SIZE.intValue());
        page.setCurrent(0L);
        do {
            page.setCurrent(page.getCurrent() + 1L);
            page = this.auditFeeCheckRepository.findByConditions(page, dto);
            if (page == null) break;
            List feeCheckList = page.getRecords();
            if (CollectionUtils.isEmpty((Collection)feeCheckList)) continue;
            log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u9875\u7801:{} \u6279\u6b21\u6570\u91cf:{}", (Object)page.getCurrent(), (Object)feeCheckList.size());
            Set templateCodes = feeCheckList.stream().map(AuditFeeCheckVo::getMatchTemplateCode).filter(Objects::nonNull).collect(Collectors.toSet());
            TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
            templateDto.setCodeList((List)Lists.newArrayList(templateCodes));
            List templateVos = this.deductionMatchingTemplateService.findAllListByConditions(templateDto);
            templateCodes.clear();
            if (CollectionUtils.isNotEmpty((Collection)templateVos)) {
                templateVos.forEach(e -> templateMap.put(e.getCode(), e));
            }
            log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u9875\u7801:{} \u6a21\u677fmap:{}", (Object)page.getCurrent(), (Object)JSON.toJSONString((Object)templateMap));
            List mappingVos = this.deductionDetailMappingService.findByCodes((List)Lists.newArrayList((Iterable)templateMap.values().stream().map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).filter(Objects::nonNull).collect(Collectors.toSet())));
            if (CollectionUtils.isNotEmpty((Collection)mappingVos)) {
                mappingVos.forEach(e -> mappingVoMap.put(e.getCode(), e));
                mappingVos.clear();
            }
            log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u9875\u7801:{} \u6620\u5c04\u6570\u636emap:{}", (Object)page.getCurrent(), (Object)JSON.toJSONString((Object)mappingVoMap));
            List salesOrgCodeList = feeCheckList.stream().map(AuditFeeCheckVo::getSalesOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(salesOrgCodeList);
            salesOrgCodeList.clear();
            if (CollectionUtils.isNotEmpty((Collection)salesOrgVoList)) {
                salesOrgVoList.forEach(e -> salesOrgVoMap.put(e.getSalesOrgCode(), e));
                salesOrgVoList.clear();
            }
            log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u9875\u7801:{} \u9500\u552e\u7ec4\u7ec7map:{}", (Object)page.getCurrent(), (Object)JSON.toJSONString((Object)salesOrgVoMap));
            for (AuditFeeCheckVo feeCheckVo : feeCheckList) {
                ArrayList batchFeeCheckDetailPlanVoList = Lists.newArrayList();
                List<Object> auditFeePredictionVoList = new ArrayList();
                log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u5f00\u59cb\u5339\u914d\u7f16\u7801:{}", (Object)feeCheckVo.getMatchCode());
                TpmDeductionMatchingTemplateVo templateVo = (TpmDeductionMatchingTemplateVo)templateMap.get(feeCheckVo.getMatchTemplateCode());
                if (templateVo == null) {
                    feeCheckVo.setRemark("\u672a\u5339\u914d\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5339\u914d\u6a21\u677f");
                    log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u672a\u67e5\u8be2\u5230\u5339\u914d\u6a21\u677f", (Object)feeCheckVo.getMatchCode());
                    continue;
                }
                TpmDeductionMatchingTemplateAllowanceVo allowanceVo = null;
                String feeMatchingCondition = templateVo.getFeeMatchingCondition();
                List feeAllowances = templateVo.getFeeAllowances();
                log.info("\u8d39\u7528\u5355\u5339\u914d\u6d3b\u52a8-\u8d39\u7528\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e:{}", (Object)JSON.toJSONString((Object)feeMatchingCondition));
                log.info("\u8d39\u7528\u5355\u5339\u914d\u6d3b\u52a8-\u8d39\u7528\u5bb9\u5dee\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)feeAllowances));
                if (feeMatchingCondition.contains(ConditionsEnum.AREA_CODE.getCode())) {
                    for (TpmDeductionMatchingTemplateAllowanceVo feeAllowance : feeAllowances) {
                        if (StringUtils.isBlank((CharSequence)feeAllowance.getApplyBusinessAreaCode())) {
                            allowanceVo = feeAllowance;
                        } else {
                            if (!StringUtils.isNotBlank((CharSequence)feeCheckVo.getAreaCode()) || !feeAllowance.getApplyBusinessAreaCode().contains(feeCheckVo.getAreaCode())) continue;
                            allowanceVo = feeAllowance;
                        }
                        break;
                    }
                } else {
                    allowanceVo = (TpmDeductionMatchingTemplateAllowanceVo)feeAllowances.get(0);
                }
                log.info("\u8d39\u7528\u5355\u5339\u914d\u6d3b\u52a8-\u5339\u914d\u7684\u8d39\u7528\u5bb9\u5dee:{}", (Object)JSON.toJSONString((Object)allowanceVo));
                if (allowanceVo == null) {
                    feeCheckVo.setRemark("\u672a\u5339\u914d\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5bb9\u5dee\u5339\u914d\u6a21\u677f");
                    log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u672a\u67e5\u8be2\u5230\u5bb9\u5dee\u5339\u914d\u6a21\u677f", (Object)feeCheckVo.getMatchCode());
                    continue;
                }
                TpmDeductionDetailMappingVo mappingVo = (TpmDeductionDetailMappingVo)mappingVoMap.get(templateVo.getApplyMappingCode());
                if (mappingVo == null) {
                    feeCheckVo.setRemark("\u672a\u5339\u914d\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5546\u8d85\u6620\u5c04");
                    log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u672a\u67e5\u8be2\u5230\u5546\u8d85\u6620\u5c04", (Object)feeCheckVo.getMatchCode());
                    continue;
                }
                if (CollectionUtils.isNotEmpty((Collection)mappingVo.getDeductionDetailMappingRelationActivityConfigList())) {
                    Set activityFormCodeSet = mappingVo.getDeductionDetailMappingRelationActivityConfigList().stream().map(TpmDeductionDetailMappingRelationActivityConfigVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toSet());
                    activityFormCodes.addAll(activityFormCodeSet);
                }
                log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u6d3b\u52a8\u5f62\u5f0f{}", (Object)feeCheckVo.getMatchCode(), (Object)JSON.toJSONString((Object)activityFormCodes));
                String deductionMatchingTemplateType = templateVo.getDeductionMatchingTemplateType();
                if (DeductionMatchingTemplateTypeEnum.DETAIL_FEE_SETATEMENT.getCode().equals(deductionMatchingTemplateType)) {
                    log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u65e0POS", (Object)feeCheckVo.getMatchCode());
                    String businessUnitCode = feeCheckVo.getBusinessUnitCode();
                    if ((StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)businessUnitCode) || StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)businessUnitCode)) && CollectionUtils.isNotEmpty(auditFeePredictionVoList = this.findAuditFeePredictionVoList(feeCheckVo, templateVo, mappingVo, allowanceVo, activityFormCodes, salesOrgVoMap))) {
                        log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u65e0POS \u67e5\u8be2\u9884\u6d4b\u7684\u6570\u91cf\uff1a{}", (Object)feeCheckVo.getMatchCode(), (Object)auditFeePredictionVoList.size());
                        auditFeePredictionVoList = this.filterInvalidPlan(auditFeePredictionVoList, usedActivityDetailPlanItemCodeSet);
                        if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                            log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u65e0POS \u53ef\u7528\u7684\u9884\u6d4b\u6570\u91cf\uff1a{}", (Object)feeCheckVo.getMatchCode(), (Object)auditFeePredictionVoList.size());
                            List<AuditFeeCheckDetailPlanVo> thisCheckMatchedDetailPlanVos = this.detailPlanHandle(feeCheckVo, auditFeePredictionVoList);
                            batchFeeCheckDetailPlanVoList.addAll(thisCheckMatchedDetailPlanVos);
                        }
                    }
                } else if (DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(deductionMatchingTemplateType)) {
                    log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u6709POS", (Object)feeCheckVo.getMatchCode());
                    List<AuditFeeCheckPos> posMatchedList = this.generateAuditFeeCheckMatchFeeAsync.matchFeePos(feeCheckVo, templateVo, allowanceVo, this.loginUserService.getAbstractLoginUser());
                    if (CollectionUtils.isNotEmpty(posMatchedList)) {
                        log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u6709POS \u5339\u914d\u5230\u7684pos\u6570\u91cf:{}", (Object)feeCheckVo.getMatchCode(), (Object)posMatchedList.size());
                        List<String> activityDetailItemCodeList = posMatchedList.stream().map(AuditFeeCheckPos::getActivityDetailItemCode).filter(Objects::nonNull).collect(Collectors.toList());
                        auditFeePredictionVoList = this.findAuditFeePredictionVoListByPos(feeCheckVo, activityDetailItemCodeList);
                        if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                            log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u6709POS \u67e5\u8be2\u9884\u6d4b\u7684\u6570\u91cf:{}", (Object)feeCheckVo.getMatchCode(), (Object)auditFeePredictionVoList.size());
                            auditFeePredictionVoList = this.filterInvalidPlan(auditFeePredictionVoList, usedActivityDetailPlanItemCodeSet);
                            if (CollectionUtils.isNotEmpty(auditFeePredictionVoList)) {
                                log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7f16\u7801:{}\u6709POS \u53ef\u7528\u7684\u9884\u6d4b\u6570\u91cf:{}", (Object)feeCheckVo.getMatchCode(), (Object)auditFeePredictionVoList.size());
                                List<AuditFeeCheckDetailPlanVo> thisCheckMatchedDetailPlanVos = this.detailPlanHandle(feeCheckVo, auditFeePredictionVoList);
                                batchFeeCheckDetailPlanVoList.addAll(thisCheckMatchedDetailPlanVos);
                                List thisCheckMatchedDetailPlanVoCodes = thisCheckMatchedDetailPlanVos.stream().map(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
                                posMatchedList = posMatchedList.stream().filter(e -> thisCheckMatchedDetailPlanVoCodes.contains(e.getActivityDetailItemCode())).collect(Collectors.toList());
                                this.generateAuditFeeCheckMatchFeeAsync.updateRelatePos(feeCheckVo, posMatchedList);
                            }
                        }
                    }
                }
                if (MatchStatusEnum.MATCHED.getCode().equals(feeCheckVo.getMatchStatus())) {
                    feeCheckVo.setRemark("");
                }
                AuditFeeCheck feeCheck = (AuditFeeCheck)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)feeCheckVo, AuditFeeCheck.class, HashSet.class, ArrayList.class, new String[0]));
                this.auditFeeCheckRepository.updateById((Object)feeCheck);
                this.auditFeeCheckDetailPlanRepository.saveWithShare(batchFeeCheckDetailPlanVoList);
                usedActivityDetailPlanItemCodeSet.addAll(batchFeeCheckDetailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
                batchFeeCheckDetailPlanVoList.clear();
                auditFeePredictionVoList.clear();
            }
            feeCheckList.clear();
            salesOrgVoMap.clear();
            mappingVoMap.clear();
            templateMap.clear();
        } while (page.hasNext());
        log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d-\u7ed3\u675f");
    }

    public List<AuditFeePredictionVo> findAuditFeePredictionVoListByPos(AuditFeeCheckVo feeCheckVo, List<String> detailPlanItemCodeList) {
        Page<AuditFeePredictionVo> page;
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return new ArrayList<AuditFeePredictionVo>(0);
        }
        AuditFeePredictionDto queryDto = new AuditFeePredictionDto();
        queryDto.setDetailPlanItemCodes(detailPlanItemCodeList);
        log.info(feeCheckVo.getMatchCode() + "\u8d39\u7528\u6838\u5bf9\u5339\u914dpos\u6d3b\u52a8\u67e5\u8be2\u6263\u8d39\u9884\u6d4b,\u7b5b\u9009\u6761\u4ef6:{}", (Object)queryDto);
        PageRequest pageable = PageRequest.of((int)0, (int)AuditFeeConstants.PAGE_SIZE);
        ArrayList auditFeePredictionVoList = Lists.newArrayList();
        while ((page = this.auditFeePredictionService.findByConditions((Pageable)(pageable = pageable.next()), queryDto)) != null) {
            if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
                auditFeePredictionVoList.addAll(page.getRecords());
            }
            if (page.hasNext()) continue;
        }
        return auditFeePredictionVoList;
    }

    public List<AuditFeePredictionVo> findAuditFeePredictionVoList(AuditFeeCheckVo feeCheckVo, TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo, TpmDeductionMatchingTemplateAllowanceVo allowanceVo, Set<String> activityFormCodes, Map<String, SalesOrgVo> salesOrgVoMap) {
        Page<AuditFeePredictionVo> page;
        AuditFeePredictionDto queryDto = new AuditFeePredictionDto();
        queryDto.setBusinessFormatCode(feeCheckVo.getBusinessFormatCode());
        queryDto.setBusinessUnitCode(feeCheckVo.getBusinessUnitCode());
        queryDto.setSalesInstitutionCode(mappingVo.getSalesInstitutionErpCode());
        queryDto.setSystemCode(feeCheckVo.getCustomerRetailerCode());
        if (StringUtils.isNotEmpty((CharSequence)templateVo.getApplyBusinessCustomerCode())) {
            queryDto.setCustomerCode(templateVo.getApplyBusinessCustomerCode());
        } else {
            SalesOrgVo salesOrgVo = salesOrgVoMap.get(feeCheckVo.getSalesOrgCode());
            queryDto.setCustomerCode(feeCheckVo.getCustomerErpCode() + salesOrgVo.getErpCode() + "A1" + templateVo.getBusinessFormatCode());
        }
        queryDto.setBuyWay(mappingVo.getBuyWay());
        queryDto.setActivityFormCodes(new ArrayList<String>(activityFormCodes));
        if (StringUtils.isNotEmpty((CharSequence)templateVo.getFeeMatchingCondition())) {
            String[] conditions;
            block10: for (String condition : conditions = templateVo.getFeeMatchingCondition().split(",")) {
                ConditionsEnum conditionsEnum = ConditionsEnum.codeToEnum((String)condition);
                if (ConditionsEnum.EMPTY.equals((Object)conditionsEnum)) continue;
                switch (conditionsEnum) {
                    case PRODUCT_CODE: {
                        queryDto.setProductCode(feeCheckVo.getProductCode());
                        continue block10;
                    }
                    case TERMINAL_CODE: {
                        queryDto.setTerminalCode(feeCheckVo.getTerminalCode());
                        continue block10;
                    }
                    case YEAR_MONTH: {
                        if (feeCheckVo.getOrderYearMonth() == null) continue block10;
                        String timeAllowanceType = allowanceVo.getTimeAllowanceType();
                        if (timeAllowanceType == null) {
                            log.error("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u7c7b\u578b\u914d\u7f6e\u9519\u8bef;");
                            continue block10;
                        }
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(allowanceVo.getTimeAllowanceType()) && !TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue().equals(allowanceVo.getTimeAllowanceUnit())) {
                            log.error("\u9002\u7528\u8303\u56f4\u65e5\u671f\u7c7b\u578b\u5f02\u5e38");
                            continue block10;
                        }
                        Integer timeAllowanceValue = allowanceVo.getTimeAllowanceValue();
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(allowanceVo.getTimeAllowanceType()) && timeAllowanceValue == null) {
                            log.error("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u503c\u914d\u7f6e\u9519\u8bef;");
                            continue block10;
                        }
                        boolean isAddUp = BooleanEnum.TRUE.getCapital().equals(feeCheckVo.getIsAddUp());
                        Date orderDate = feeCheckVo.getOrderDate();
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                            if (!isAddUp) {
                                queryDto.setActivityEndDateStart(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, 0, true));
                            }
                            queryDto.setActivityEndDateEnd(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE_POINT.getValue().equals(timeAllowanceType)) {
                            if (!isAddUp) {
                                queryDto.setActivityEndDateStart(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, true));
                            }
                            queryDto.setActivityEndDateEnd(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                            if (!isAddUp) {
                                queryDto.setActivityEndDateStart(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                            }
                            queryDto.setActivityEndDateEnd(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, 0, false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE_POINT.getValue().equals(timeAllowanceType)) {
                            if (!isAddUp) {
                                queryDto.setActivityEndDateStart(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                            }
                            queryDto.setActivityEndDateEnd(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, -timeAllowanceValue.intValue(), false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue().equals(allowanceVo.getTimeAllowanceType())) {
                            if (!isAddUp) {
                                queryDto.setActivityEndDateStart(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                            }
                            queryDto.setActivityEndDateEnd(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth(orderDate, timeAllowanceValue, false));
                            continue block10;
                        }
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(allowanceVo.getTimeAllowanceType())) continue block10;
                        if (allowanceVo.getBeginDate() == null || allowanceVo.getEndDate() == null) {
                            log.info("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u6307\u5b9a\u533a\u95f4\u914d\u7f6e\u9519\u8bef;");
                            continue block10;
                        }
                        if (!isAddUp) {
                            queryDto.setActivityEndDateStart(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth((Date)cn.hutool.core.date.DateUtil.parseDate((CharSequence)(allowanceVo.getBeginDate() + "-01")), 0, true));
                        }
                        queryDto.setActivityEndDateEnd(this.generateAuditFeeCheckMatchFeeAsync.adjustMonth((Date)cn.hutool.core.date.DateUtil.parseDate((CharSequence)(allowanceVo.getEndDate() + "-01")), 0, false));
                        continue block10;
                    }
                    case PROVINCE: {
                        queryDto.setProvinceCode(feeCheckVo.getProvinceCode());
                        continue block10;
                    }
                    case AREA_CODE: {
                        queryDto.setRegion(feeCheckVo.getAreaCode());
                        continue block10;
                    }
                    case SCHEDULE: {
                        queryDto.setScheduleName(feeCheckVo.getSlotDateName());
                    }
                    case FEE_CODE: {
                        continue block10;
                    }
                    case CHANNEL: 
                    case ACTIVITY_FORM_DESC: {
                        queryDto.setActivityFormDesc(feeCheckVo.getActivityFormDesc());
                    }
                }
            }
        }
        queryDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
        queryDto.setNoRollbackBudgetTagFlag(Boolean.valueOf(true));
        log.info(feeCheckVo.getMatchCode() + "\u8d39\u7528\u6838\u5bf9\u5339\u914d\u6d3b\u52a8\u67e5\u8be2\u6263\u8d39\u9884\u6d4b,\u7b5b\u9009\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageRequest pageable = PageRequest.of((int)0, (int)AuditFeeConstants.PAGE_SIZE);
        ArrayList auditFeePredictionVoList = Lists.newArrayList();
        while ((page = this.auditFeePredictionService.findByConditions((Pageable)(pageable = pageable.next()), queryDto)) != null) {
            if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
                auditFeePredictionVoList.addAll(page.getRecords());
            }
            if (page.hasNext()) continue;
        }
        return auditFeePredictionVoList;
    }

    public List<AuditFeePredictionVo> filterInvalidPlan(List<AuditFeePredictionVo> auditFeePredictionVoList, Set<String> usedActivityDetailPlanItemCodeSet) {
        List<String> planItemVoCodeAllList = auditFeePredictionVoList.stream().map(AuditFeePredictionVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> usedDetailPlanItemCodes = this.auditFeeCheckDetailPlanRepository.findNoConfirmByDetailPlanItemCodeList(planItemVoCodeAllList);
        if (CollectionUtils.isNotEmpty(usedDetailPlanItemCodes)) {
            usedActivityDetailPlanItemCodeSet.addAll(usedDetailPlanItemCodes);
        }
        auditFeePredictionVoList = auditFeePredictionVoList.stream().filter(o -> !usedActivityDetailPlanItemCodeSet.contains(o.getDetailPlanItemCode())).collect(Collectors.toList());
        return auditFeePredictionVoList;
    }

    private List<AuditFeeCheckDetailPlanVo> detailPlanHandle(AuditFeeCheckVo feeCheckVo, List<AuditFeePredictionVo> auditFeePredictionVoList) {
        log.info("\u8d39\u7528\u6838\u5bf9\u5339\u914d\u6d3b\u52a8-\u5f00\u59cb\u5904\u7406\u5339\u914d\u5230\u7684\u6d3b\u52a8");
        List<AuditFeeCheckDetailPlanVo> thisCheckDetailPlanVos = new ArrayList<AuditFeeCheckDetailPlanVo>();
        for (AuditFeePredictionVo predictDetailPlanVo : auditFeePredictionVoList) {
            if (predictDetailPlanVo.getCanAuditAmount() == null) continue;
            AuditFeeCheckDetailPlan detailPlan = this.auditFeeCheckDetailPlanRepository.initOne();
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = (AuditFeeCheckDetailPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailPlan, AuditFeeCheckDetailPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
            feeCheckDetailPlanVo.setAuditFeeCheckCode(feeCheckVo.getMatchCode());
            feeCheckDetailPlanVo.setDetailPlanItemCode(predictDetailPlanVo.getDetailPlanItemCode());
            feeCheckDetailPlanVo.setDetailPlanCode(predictDetailPlanVo.getDetailPlanCode());
            feeCheckDetailPlanVo.setDetailPlanName(predictDetailPlanVo.getDetailPlanName());
            feeCheckDetailPlanVo.setActivityBeginDate(predictDetailPlanVo.getActivityBeginDate());
            feeCheckDetailPlanVo.setActivityEndDate(predictDetailPlanVo.getActivityEndDate());
            feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format((Date)predictDetailPlanVo.getActivityYearMonth(), (String)"yyyy-MM"));
            feeCheckDetailPlanVo.setSystemCode(predictDetailPlanVo.getSystemCode());
            feeCheckDetailPlanVo.setSystemName(predictDetailPlanVo.getSystemName());
            feeCheckDetailPlanVo.setRegion(predictDetailPlanVo.getRegion());
            feeCheckDetailPlanVo.setRegionName(predictDetailPlanVo.getRegion());
            feeCheckDetailPlanVo.setProvinceCode(predictDetailPlanVo.getProvinceCode());
            feeCheckDetailPlanVo.setProvinceName(predictDetailPlanVo.getProvinceName());
            feeCheckDetailPlanVo.setActivityTypeCode(predictDetailPlanVo.getActivityTypeCode());
            feeCheckDetailPlanVo.setActivityTypeName(predictDetailPlanVo.getActivityTypeName());
            feeCheckDetailPlanVo.setActivityFormCode(predictDetailPlanVo.getActivityFormCode());
            feeCheckDetailPlanVo.setActivityFormName(predictDetailPlanVo.getActivityFormName());
            feeCheckDetailPlanVo.setAuditForm(predictDetailPlanVo.getAuditForm());
            feeCheckDetailPlanVo.setBuyWay(predictDetailPlanVo.getBuyWay());
            feeCheckDetailPlanVo.setCustomerCode(predictDetailPlanVo.getCustomerCode());
            feeCheckDetailPlanVo.setCustomerName(predictDetailPlanVo.getCustomerName());
            feeCheckDetailPlanVo.setTerminalCode(predictDetailPlanVo.getTerminalCode());
            feeCheckDetailPlanVo.setTerminalName(predictDetailPlanVo.getTerminalName());
            feeCheckDetailPlanVo.setProductCode(predictDetailPlanVo.getProductCode());
            feeCheckDetailPlanVo.setProductName(predictDetailPlanVo.getProductName());
            feeCheckDetailPlanVo.setScheduleName(predictDetailPlanVo.getScheduleName());
            feeCheckDetailPlanVo.setApplyAmount(predictDetailPlanVo.getApplyAmount());
            feeCheckDetailPlanVo.setPredictionAuditAmount(predictDetailPlanVo.getPredictionAuditAmount());
            feeCheckDetailPlanVo.setAlreadyAuditAmount(predictDetailPlanVo.getAlreadyAuditAmount());
            feeCheckDetailPlanVo.setCanAuditAmount(predictDetailPlanVo.getCanAuditAmount());
            feeCheckDetailPlanVo.setSalesInstitutionCode(predictDetailPlanVo.getSalesInstitutionCode());
            feeCheckDetailPlanVo.setSalesInstitutionName(predictDetailPlanVo.getSalesInstitutionName());
            feeCheckDetailPlanVo.setRemark(predictDetailPlanVo.getRemark());
            feeCheckDetailPlanVo.setActivityFormDesc(predictDetailPlanVo.getActivityFormDesc());
            thisCheckDetailPlanVos.add(feeCheckDetailPlanVo);
        }
        thisCheckDetailPlanVos = this.detailPlanShare(feeCheckVo, thisCheckDetailPlanVos);
        return thisCheckDetailPlanVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchJob() {
        this.loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = cn.hutool.core.date.DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.lock(lockKey);
            this.matchFee(new AuditFeeMatchDto());
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    public void pullKmsData(AuditFeeMatchDto auditFeeMatchDto) {
        Validate.notNull((Object)auditFeeMatchDto, (String)"\u4f20\u5165\u6570\u636e\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)auditFeeMatchDto.getMatchTemplateCode(), (String)"\u4f20\u5165\u5339\u914d\u6a21\u677f\u7f16\u7801\u7a7a", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateDto tpmDeductionMatchingTemplateDto = new TpmDeductionMatchingTemplateDto();
        tpmDeductionMatchingTemplateDto.setCodeList((List)Lists.newArrayList((Object[])new String[]{auditFeeMatchDto.getMatchTemplateCode()}));
        List templateList = this.deductionMatchingTemplateService.findAllListByConditions(tpmDeductionMatchingTemplateDto);
        Validate.notEmpty((Collection)templateList, (String)("\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f\uff01[" + auditFeeMatchDto.getMatchTemplateCode() + "]"), (Object[])new Object[0]);
        TpmDeductionMatchingTemplateVo feeMatchTemplate = (TpmDeductionMatchingTemplateVo)templateList.get(0);
        log.info("\u62c9\u53d6\u4f7f\u7528\u7684\u6a21\u677f\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)feeMatchTemplate));
        AbstractCrmUserIdentity abstractLoginUser = this.loginUserService.getAbstractLoginUser();
        if (!DeductionMatchingTemplateTypeEnum.DETAIL_FEE_SETATEMENT.getCode().equals(feeMatchTemplate.getDeductionMatchingTemplateType()) && !DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(feeMatchTemplate.getDeductionMatchingTemplateType())) {
            log.info("\u6a21\u677f\u4e0d\u5408\u9002");
            throw new IllegalArgumentException("\u6a21\u677f\u4e0d\u5408\u9002");
        }
        this.generateAuditFeeCheckCostAsync.generateForCostOrderAsync(auditFeeMatchDto, feeMatchTemplate, abstractLoginUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullKmsDataAndMatchTask() {
        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u6267\u884c\u5f00\u59cb");
        this.loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = cn.hutool.core.date.DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.lock(lockKey);
            this.backAllToBeConfirmed();
            TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
            ArrayList templateTypeList = Lists.newArrayList((Object[])new String[]{DeductionMatchingTemplateTypeEnum.DETAIL_FEE_SETATEMENT.getCode(), DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode()});
            templateDto.setDeductionMatchingTemplateTypeList((List)templateTypeList);
            templateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            templateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List templateVoList = this.deductionMatchingTemplateService.findAllListByConditions(templateDto);
            log.info("\u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u9884\u8ba1\u6267\u884c\u6a21\u677f\u6570\u91cf:{}", (Object)templateVoList.size());
            AuditFeeMatchDto auditFeeMatchDto = new AuditFeeMatchDto();
            DateTime lastTwoMonth = cn.hutool.core.date.DateUtil.offsetMonth((Date)new DateTime(), (int)-2);
            auditFeeMatchDto.setStartTime((Date)cn.hutool.core.date.DateUtil.beginOfMonth((Date)lastTwoMonth));
            auditFeeMatchDto.setEndTime((Date)new DateTime());
            AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
            if (CollectionUtils.isNotEmpty((Collection)templateVoList)) {
                for (TpmDeductionMatchingTemplateVo templateVo : templateVoList) {
                    try {
                        this.generateAuditFeeCheckCostAsync.generateForCostOrder(auditFeeMatchDto, templateVo, loginUser);
                    }
                    catch (Exception e) {
                        log.error("\u6a21\u677f:{} \u540d\u79f0:{} \u62c9\u53d6\u8d39\u7528\u5355 \u6267\u884c\u5931\u8d25:{}", new Object[]{templateVo.getCode(), templateVo.getName(), e.getMessage()});
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u8d39\u7528\u6293\u5355\u4efb\u52a1 \u6267\u884c\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
            log.info("\u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u6267\u884c\u5b8c\u6210");
        }
        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u6293\u53d6\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5339\u914d");
        this.matchFee(new AuditFeeMatchDto());
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void backAllToBeConfirmed() {
        PageRequest pageable = PageRequest.of((int)1, (int)800);
        Page<String> page = null;
        AuditFeeCheckDto dto = new AuditFeeCheckDto();
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setIsConfirmDiff(BooleanEnum.FALSE.getCapital());
        dto.setIsConfirm(BooleanEnum.FALSE.getCapital());
        log.info("=====>    \u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u5386\u53f2\u6570\u636e\u56de\u9000 start    <=====");
        do {
            page = this.auditFeeCheckRepository.findNotConfirmedDiffPage((Pageable)pageable, dto);
            pageable = pageable.next();
            log.info("=====>    \u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u5386\u53f2\u6570\u636e\u56de\u9000 [{}/{}]    <=====", (Object)page.getCurrent(), (Object)page.getPages());
            if (CollectionUtil.isEmpty((Collection)page.getRecords())) {
                return;
            }
            this.generateAuditFeeCheckCostAsyncHelper.deleteByMatchCodes(page.getRecords());
        } while (page.hasNext() && pageable.getPageNumber() > 10000);
        log.info("=====>    \u62c9\u53d6\u8d39\u7528\u5355\u4efb\u52a1 \u5386\u53f2\u6570\u636e\u56de\u9000 end    <=====");
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirm(AuditFeeCheckVo auditFeeCheckVo) {
        log.info("\u8d39\u7528\u6838\u5bf9\u786e\u8ba4");
        Validate.notNull((Object)auditFeeCheckVo, (String)"\u63d0\u4ea4\u786e\u8ba4\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long a = System.currentTimeMillis();
        Validate.isTrue((boolean)MatchStatusEnum.MATCHED.getCode().equals(auditFeeCheckVo.getMatchStatus()), (String)"\u6570\u636e\u672a\u5339\u914d\uff0c\u4e0d\u80fd\u8fdb\u884c\u786e\u8ba4!", (Object[])new Object[0]);
        AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findById(auditFeeCheckVo.getId());
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)BooleanEnum.FALSE.getCapital(), (CharSequence)auditFeeCheck.getIsConfirm()), (String)"\u6570\u636e\u5df2\u786e\u8ba4,\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        log.info("\u4e3b\u6570\u636e\u67e5\u8be2\uff1a{}", (Object)(System.currentTimeMillis() - a));
        this.update(auditFeeCheckVo, false);
        log.info("\u6570\u636e\u4fdd\u5b58\uff1a{}", (Object)(System.currentTimeMillis() - a));
        if (!BooleanEnum.TRUE.getCapital().equals(auditFeeCheck.getIsConfirmDiff())) {
            this.confirmDiff(auditFeeCheckVo);
            BeanUtils.copyProperties((Object)auditFeeCheckVo, (Object)((Object)auditFeeCheck));
            log.info("\u786e\u8ba4\u5dee\u5f02\uff1a{}", (Object)(System.currentTimeMillis() - a));
        }
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        log.info("\u786e\u8ba4\u4eba\u7ebf\u7a0b\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)loginUser));
        auditFeeCheck.setIsConfirm(BooleanEnum.TRUE.getCapital());
        auditFeeCheck.setConfirmDate(new Date());
        auditFeeCheck.setConfirmUserAccount(loginUser.getAccount());
        auditFeeCheck.setConfirmUserName(loginUser.getRealName());
        this.auditFeeCheckRepository.updateById((Object)auditFeeCheck);
        log.info("\u786e\u8ba4\u6570\u636e\u4fdd\u5b58\uff1a{}", (Object)(System.currentTimeMillis() - a));
        ArrayList<AuditFeeVerifyDecideDto> verifyDecideDtoArrayList = new ArrayList<AuditFeeVerifyDecideDto>();
        TpmDeductionMatchingTemplateVo templateVo = this.deductionMatchingTemplateService.findByCode(auditFeeCheck.getMatchTemplateCode());
        Validate.notNull((Object)templateVo, (String)("\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f\uff01[" + auditFeeCheck.getMatchTemplateCode() + "]"), (Object[])new Object[0]);
        log.info("\u67e5\u8be2\u6a21\u677f\uff1a{}", (Object)(System.currentTimeMillis() - a));
        if (FeeAccordingEnum.FEE_INVOICE.getCode().equals(templateVo.getFeeAccording())) {
            List<AuditFeeCheckDetailPlanVo> detailPlanList = this.auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(auditFeeCheck.getMatchCode());
            Validate.notNull((Object)templateVo, (String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u6d3b\u52a8\uff01", (Object[])new Object[0]);
            for (AuditFeeCheckDetailPlanVo detailPlanVo : detailPlanList) {
                AuditFeeVerifyDecideDto verifyDecideDto = new AuditFeeVerifyDecideDto();
                verifyDecideDto.setActivityDetailItemCode(detailPlanVo.getDetailPlanItemCode());
                verifyDecideDto.setActivityDetailCode(detailPlanVo.getDetailPlanCode());
                verifyDecideDto.setActivityDetailName(detailPlanVo.getDetailPlanName());
                verifyDecideDto.setTerminalCode(detailPlanVo.getTerminalCode());
                verifyDecideDto.setTerminalName(detailPlanVo.getTerminalName());
                verifyDecideDto.setProductCode(detailPlanVo.getProductCode());
                verifyDecideDto.setProductName(detailPlanVo.getProductName());
                verifyDecideDto.setAuditFeeCheckCode(auditFeeCheck.getMatchCode());
                verifyDecideDto.setBusinessFormatCode(auditFeeCheck.getBusinessFormatCode());
                verifyDecideDto.setBusinessUnitCode(auditFeeCheck.getBusinessUnitCode());
                verifyDecideDto.setAreaCode(detailPlanVo.getRegion());
                verifyDecideDto.setCustomerRetailerCode(auditFeeCheck.getCustomerRetailerCode());
                verifyDecideDto.setCustomerRetailerName(auditFeeCheck.getCustomerRetailerName());
                verifyDecideDto.setVerifyDecideAmount(detailPlanVo.getThisAuditAmount());
                verifyDecideDto.setSalesInstitutionErpCode(detailPlanVo.getSalesInstitutionCode());
                verifyDecideDto.setSalesInstitutionName(detailPlanVo.getSalesInstitutionName());
                verifyDecideDto.setAuditWay(detailPlanVo.getAuditForm());
                verifyDecideDto.setCustomerCode(detailPlanVo.getCustomerCode());
                verifyDecideDto.setCustomerName(detailPlanVo.getCustomerName());
                verifyDecideDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
                verifyDecideDto.setSource(AuditFeeVerifyDecideSourceEnum.COST.getCode());
                verifyDecideDtoArrayList.add(verifyDecideDto);
            }
            this.auditFeeVerifyDecideService.createBatch(verifyDecideDtoArrayList);
            log.info("\u751f\u6210\u6263\u8d39\u6838\u5b9a\uff1a{}", (Object)(System.currentTimeMillis() - a));
        }
        this.generateAuditFeeCheckCostAsyncHelper.updateKMSStatus(this.auditFeeCheckCostRepository.findCompanyCostCodeByMatchCodes(Lists.newArrayList((Object[])new String[]{auditFeeCheckVo.getMatchCode()})), AuditFeeMatchStatusEnum.CONFIRM.getCode());
        String cacheKey = auditFeeCheckVo.getCacheKey();
        this.auditFeeCheckDetailPlanVoCacheService.clearCache(cacheKey);
        this.auditFeeCheckCostVoCacheService.clearCache(cacheKey);
        this.auditFeeCheckDiffVoCacheService.clearCache(cacheKey);
        log.info("\u6e05\u7406\u7f13\u5b58\uff1a{}", (Object)(System.currentTimeMillis() - a));
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirmDiff(AuditFeeCheckVo auditFeeCheckVo) {
        AuditFeeCheckDetailPlanVo detailPlanVo;
        log.info("\u8d39\u7528\u6838\u5bf9\u786e\u8ba4\u5dee\u5f02\uff1a{}", (Object)auditFeeCheckVo);
        Validate.notNull((Object)auditFeeCheckVo, (String)"\u4f20\u5165\u6838\u5bf9\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String diffType = auditFeeCheckVo.getDiffType();
        Validate.notNull((Object)diffType, (String)"\u5dee\u5f02\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(diffType)) {
            Validate.notNull((Object)auditFeeCheckVo.getDiffUse(), (String)"\u8bf7\u5148\u9009\u62e9\u5dee\u5f02\u4f7f\u7528", (Object[])new Object[0]);
        }
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirmDiff()) ? 1 : 0) != 0, (String)"\u5dee\u5f02\u5df2\u88ab\u786e\u8ba4\uff01", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirm()) ? 1 : 0) != 0, (String)"\u6838\u5bf9\u6570\u636e\u5df2\u786e\u8ba4\uff01", (Object[])new Object[0]);
        List<AuditFeeCheckDetailPlanVo> detailPlanVos = null;
        detailPlanVos = auditFeeCheckVo.getCacheKey() != null ? this.auditFeeCheckDetailPlanVoCacheService.findCacheList(auditFeeCheckVo.getCacheKey()) : this.auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(auditFeeCheckVo.getMatchCode());
        AuditFeeCheckDetailPlanVo auditFeeCheckDetailPlanVo = detailPlanVo = CollectionUtils.isNotEmpty(detailPlanVos) ? detailPlanVos.get(detailPlanVos.size() - 1) : null;
        if (DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode().equals(diffType) || DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode().equals(diffType)) {
            AuditFeeDiffLedgerDto ledgerDto = new AuditFeeDiffLedgerDto();
            ledgerDto.setAuditFeeCheckCode(auditFeeCheckVo.getMatchCode());
            ledgerDto.setFeeYearMonth(cn.hutool.core.date.DateUtil.format((Date)auditFeeCheckVo.getOrderYearMonth(), (String)"yyyy-MM"));
            if (Objects.nonNull(ledgerDto.getFeeYearMonth())) {
                String[] yearMonthArray = ledgerDto.getFeeYearMonth().split("-");
                ledgerDto.setYear(yearMonthArray[0]);
                ledgerDto.setMonth(yearMonthArray[1]);
            }
            ledgerDto.setBusinessFormatCode(auditFeeCheckVo.getBusinessFormatCode());
            ledgerDto.setBusinessUnitCode(auditFeeCheckVo.getBusinessUnitCode());
            ledgerDto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
            ledgerDto.setRetailerCode(auditFeeCheckVo.getCustomerRetailerCode());
            ledgerDto.setRetailerName(auditFeeCheckVo.getCustomerRetailerName());
            ledgerDto.setBusinessAreaCode(auditFeeCheckVo.getAreaCode());
            ledgerDto.setBusinessAreaName(auditFeeCheckVo.getAreaCode());
            ledgerDto.setSoldToPartyCode(auditFeeCheckVo.getCustomerErpCode());
            ledgerDto.setSoldToPartyName(auditFeeCheckVo.getCustomerName());
            ledgerDto.setSalesOrgCode(auditFeeCheckVo.getSalesOrgCode());
            ledgerDto.setSalesOrgName(auditFeeCheckVo.getSalesOrgName());
            ledgerDto.setDiffAmount(auditFeeCheckVo.getDiffConfirmAmount());
            ledgerDto.setRemark(auditFeeCheckVo.getRemark());
            ledgerDto.setDataSource(DiffLedgerDataSourceEnum.FEE_COLLATE.getCode());
            if (detailPlanVo != null) {
                ledgerDto.setDeliveryPartyCode(detailPlanVo.getTerminalCode());
                ledgerDto.setDeliveryPartyName(detailPlanVo.getTerminalName());
                ledgerDto.setSoldToPartyCode(detailPlanVo.getCustomerCode());
                ledgerDto.setSoldToPartyName(detailPlanVo.getCustomerName());
                ledgerDto.setActivitiesType(detailPlanVo.getActivityTypeCode());
                ledgerDto.setActivitiesTypeName(detailPlanVo.getActivityTypeName());
                ledgerDto.setActivity_form_code(detailPlanVo.getActivityFormCode());
                ledgerDto.setActivity_form_name(detailPlanVo.getActivityFormName());
            }
            this.auditFeeDiffLedgerVoService.create(ledgerDto);
        }
        if (DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode().equals(diffType)) {
            String diffUse = auditFeeCheckVo.getDiffUse();
            if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equals(diffUse)) {
                String cacheKey = auditFeeCheckVo.getCacheKey();
                List diffVoList = this.auditFeeCheckDiffVoCacheService.findCacheList(cacheKey);
                Validate.notEmpty((Collection)diffVoList, (String)"\u672a\u9009\u62e9\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\uff0c\u8bf7\u5148\u8fdb\u884c\u5dee\u5f02\u62b5\u6263", (Object[])new Object[0]);
                ArrayList<String> notEnoughDeductCodeList = new ArrayList<String>();
                BigDecimal deductAmountTotal = BigDecimal.ZERO;
                for (AuditFeeCheckDiffVo diffVo : diffVoList) {
                    String feeDiffLedgerCode = diffVo.getFeeDiffLedgerCode();
                    Validate.notNull((Object)diffVo.getBeRecoveredAmount(), (String)("\u6240\u9009\u5dee\u5f02\u6570\u636e[" + feeDiffLedgerCode + "]\u5f85\u8ffd\u56de\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                    Validate.notNull((Object)diffVo.getDeductAmount(), (String)("\u6240\u9009\u5dee\u5f02\u6570\u636e[" + feeDiffLedgerCode + "]\u672c\u6b21\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                    if (diffVo.getBeRecoveredAmount().compareTo(diffVo.getDeductAmount()) < 0) {
                        notEnoughDeductCodeList.add(feeDiffLedgerCode);
                    }
                    deductAmountTotal = deductAmountTotal.add(diffVo.getDeductAmount());
                }
                Validate.isTrue((boolean)CollectionUtils.isEmpty(notEnoughDeductCodeList), (String)("\u6240\u9009\u5dee\u5f02\u6570\u636e[" + String.join((CharSequence)",", notEnoughDeductCodeList) + "]\u4e0d\u8db3\u62b5\u6263"), (Object[])new Object[0]);
                Validate.isTrue((deductAmountTotal.compareTo(auditFeeCheckVo.getDiffConfirmAmount().abs()) == 0 ? 1 : 0) != 0, (String)"\u62b5\u6263\u91d1\u989d\u4e4b\u548c\u5fc5\u987b\u4e0e\u5dee\u5f02\u786e\u8ba4\u91d1\u989d\u7edd\u5bf9\u503c\u76f8\u7b49", (Object[])new Object[0]);
                List feeDiffLedgerCodeList = diffVoList.stream().peek(e -> e.setAuditFeeCheckDeductCode(auditFeeCheckVo.getMatchCode())).map(AuditFeeCheckDiffVo::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());
                this.auditFeeCheckDiffVoService.updateDelFlagByMatchCodes((List)Lists.newArrayList((Object[])new String[]{auditFeeCheckVo.getMatchCode()}));
                this.auditFeeCheckDiffVoService.createBatch(diffVoList);
                log.info("\u5dee\u5f02\u4fdd\u5b58\u5185\u5bb9\uff1a{}", (Object)diffVoList);
                Validate.isTrue((boolean)this.auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 1), (String)"\u6263\u51cf\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (Object[])new Object[0]);
                for (AuditFeeCheckDiffVo diffVo : diffVoList) {
                    AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
                    ledgerDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                    ledgerDto.setFeeDiffLedgerCode(diffVo.getFeeDiffLedgerCode());
                    ledgerDto.setBusinessCode(auditFeeCheckVo.getMatchCode());
                    ledgerDto.setRecoveredAmount(diffVo.getDeductAmount());
                    AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
                    ledgerDto.setOperatorAccount(loginUser.getAccount());
                    ledgerDto.setOperatorName(loginUser.getRealName());
                    ledgerDto.setRemark(auditFeeCheckVo.getRemark());
                    ledgerDto.setResaleCommercialCode(auditFeeCheckVo.getCustomerRetailerCode());
                    ledgerDto.setResaleCommercialName(auditFeeCheckVo.getCustomerRetailerName());
                    if (detailPlanVo != null) {
                        ledgerDto.setTerminalCode(detailPlanVo.getTerminalCode());
                        ledgerDto.setTerminalName(detailPlanVo.getTerminalName());
                        ledgerDto.setActivityFormCode(detailPlanVo.getActivityFormCode());
                        ledgerDto.setActivityFormName(detailPlanVo.getActivityFormName());
                        ledgerDto.setActivityTypeCode(detailPlanVo.getActivityTypeCode());
                        ledgerDto.setActivityTypeName(detailPlanVo.getActivityTypeName());
                    }
                    ledgerDto.setDataSource(DiffLedgerDataSourceEnum.FEE_COLLATE.getCode());
                    this.auditFeeDiffLedgerVoService.useAmount(ledgerDto);
                }
                this.auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            }
        }
        auditFeeCheckVo.setIsConfirmDiff(BooleanEnum.TRUE.getCapital());
        AuditFeeCheck auditFeeCheck = new AuditFeeCheck();
        BeanUtils.copyProperties((Object)auditFeeCheckVo, (Object)((Object)auditFeeCheck));
        this.auditFeeCheckRepository.updateById((Object)auditFeeCheck);
    }

    public AuditFeeCheckVo compute(AuditFeeCheckVo auditFeeCheckVo) {
        Validate.notNull((Object)auditFeeCheckVo, (String)"\u4f20\u5165\u6838\u5bf9\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)auditFeeCheckVo.getId(), (String)"\u4f20\u5165\u6838\u5bf9\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(auditFeeCheckVo.getIsConfirm()) ? 1 : 0) != 0, (String)"\u6838\u5bf9\u6570\u636e\u5df2\u786e\u8ba4\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)auditFeeCheckVo.getCacheKey(), (String)"\u6570\u636e\u7f13\u5b58\u5931\u8d25\uff01", (Object[])new Object[0]);
        List costCacheList = this.auditFeeCheckCostVoCacheService.findCacheList(auditFeeCheckVo.getCacheKey());
        BigDecimal costAmountTotal = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)costCacheList)) {
            costAmountTotal = costCacheList.stream().map(AuditFeeCheckCostVo::getDeductionAmountTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        auditFeeCheckVo.setCostDeductionAmount(costAmountTotal);
        this.detailPlanReshare(auditFeeCheckVo);
        return auditFeeCheckVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelingMatch(String id) {
        Validate.notNull((Object)id, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeCheck feeCheck = this.auditFeeCheckRepository.findById(id);
        Validate.notNull((Object)((Object)feeCheck), (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)MatchStatusEnum.MATCHED.getCode().equals(feeCheck.getMatchStatus()), (String)"\u8be5\u6570\u636e\u672a\u5339\u914d\u6210\u529f,\u4e0d\u80fd\u53d6\u6d88,\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirm()) ? 1 : 0) != 0, (String)"\u8be5\u6570\u636e\u5df2\u786e\u8ba4,\u4e0d\u80fd\u53d6\u6d88,\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(feeCheck.getIsConfirmDiff()) ? 1 : 0) != 0, (String)"\u8be5\u6570\u636e\u5df2\u786e\u8ba4\u5dee\u5f02,\u4e0d\u80fd\u53d6\u6d88,\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        feeCheck.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        feeCheck.setMatchResult("");
        feeCheck.setIsAddUp("");
        feeCheck.setRemark("");
        feeCheck.setActivityPreAuditAmount(BigDecimal.ZERO);
        feeCheck.setCostDetailDiffAmount(feeCheck.getCostDeductionAmount());
        feeCheck.setDiffConfirmAmount(feeCheck.getCostDetailDiffAmount());
        feeCheck.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
        feeCheck.setDiffUse(null);
        this.auditFeeCheckRepository.updateById((Object)feeCheck);
        this.generateAuditFeeCheckCostAsyncHelper.cancelByMatchCodes(Lists.newArrayList((Object[])new String[]{feeCheck.getMatchCode()}));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateNote(String id, String note) {
        Validate.notEmpty((CharSequence)id, (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findById(id);
        Validate.notNull((Object)((Object)auditFeeCheck), (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)note)) {
            note = "";
        }
        Validate.isTrue((note.length() <= 400 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u8d85\u957f", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(auditFeeCheck.getIsConfirm()) ? 1 : 0) != 0, (String)"\u786e\u8ba4\u540e\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u5907\u6ce8", (Object[])new Object[0]);
        auditFeeCheck.setRemark(note);
        this.auditFeeCheckRepository.updateById((Object)auditFeeCheck);
    }

    public boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u8d39\u7528\u6838\u5bf9job\u6267\u884c\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock("audit_fee_job:lock:" + yearMonthDay, TimeUnit.HOURS, 12L);
    }

    public void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u8d39\u7528\u6838\u5bf9job\u6267\u884c\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisLockService.unlock("audit_fee_job:lock:" + yearMonthDay);
    }

    public List<AuditFeeCheckVo> getPlanCheckAccountData(AuditFeeCheckDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheck> list = this.auditFeeCheckRepository.getPlanCheckAccountData(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List auditFeeCheckVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheck.class, AuditFeeCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
        auditFeeCheckVos.forEach(feeCheckVo -> {
            feeCheckVo.setCosts(this.auditFeeCheckCostVoService.findDetailByMatchCode(feeCheckVo.getMatchCode()));
            feeCheckVo.setAuditFeeCheckDetailPlans(this.auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(feeCheckVo.getMatchCode()));
            feeCheckVo.setMappingCode(this.auditFeeCheckRepository.findMappingCode(feeCheckVo.getMatchCode()));
        });
        return auditFeeCheckVos;
    }

    public List<AuditFeeCheckVo> getByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheck> feeCheckList = this.auditFeeCheckRepository.findByMatchCodes(matchCodes);
        if (CollectionUtils.isEmpty(feeCheckList)) {
            return Lists.newArrayList();
        }
        List auditFeeCheckVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(feeCheckList, AuditFeeCheck.class, AuditFeeCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
        auditFeeCheckVos.forEach(auditFeeCheckVo -> {
            auditFeeCheckVo.setCosts(this.auditFeeCheckCostVoService.findDetailByMatchCode(auditFeeCheckVo.getMatchCode()));
            auditFeeCheckVo.setAuditFeeCheckDetailPlans(this.auditFeeCheckDetailPlanRepository.findDetailPlanByMatchCode(auditFeeCheckVo.getMatchCode()));
        });
        return auditFeeCheckVos;
    }

    public void updateAuditCheckStatus(List<String> auditCheckCodes) {
        if (CollectionUtils.isEmpty(auditCheckCodes)) {
            return;
        }
        int count = this.auditFeeCheckDetailPlanRepository.getCountByAuditCode(auditCheckCodes);
        if (count == 0) {
            return;
        }
        this.auditFeeCheckDetailPlanRepository.updateStatusByAuditCodes(auditCheckCodes);
    }

    public Page<AuditFeeCheckVo> findByConditionsForEct(Pageable pageable, AuditFeeCheckSelectDto dto) {
        Page page;
        Page<AuditFeeCheckVo> result;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckSelectDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Date currentDate = new Date();
        if (StringUtils.isBlank((CharSequence)dto.getStartDate()) || StringUtils.isBlank((CharSequence)dto.getEndDate())) {
            dto.setStartDate(DateUtil.format((Date)currentDate, (String)"yyyy-MM-dd"));
            dto.setEndDate(DateUtil.format((Date)currentDate, (String)"yyyy-MM-dd"));
        }
        if (CollectionUtils.isEmpty((Collection)(result = this.auditFeeCheckRepository.findByConditionsForEct((Page<AuditFeeCheckVo>)(page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize())), dto)).getRecords())) {
            return result;
        }
        List feeList = result.getRecords();
        List matchCodes = feeList.stream().map(AuditFeeCheckVo::getMatchCode).distinct().collect(Collectors.toList());
        List costList = this.auditFeeCheckCostVoService.findDetailByMatchCodes(matchCodes);
        Map<String, List<AuditFeeCheckCostVo>> costMap = costList.stream().collect(Collectors.groupingBy(AuditFeeCheckCostVo::getAuditFeeCheckCode));
        List detailPlanList = this.auditFeeCheckDetailPlanVoService.findByMatchCodes(matchCodes);
        Map<String, List<AuditFeeCheckDetailPlanVo>> detailPlanMap = detailPlanList.stream().collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode));
        feeList.forEach(fee -> {
            String matchCode = fee.getMatchCode();
            if (costMap != null) {
                List auditFeeCheckCostVos = (List)costMap.get(matchCode);
                fee.setCosts(auditFeeCheckCostVos);
            }
            if (detailPlanMap != null) {
                List auditFeeCheckDetailPlanVos = (List)detailPlanMap.get(matchCode);
                fee.setAuditFeeCheckDetailPlans(auditFeeCheckDetailPlanVos);
            }
        });
        return result.setRecords(feeList);
    }

    public void posActivityAmountSummary(boolean update, AuditFeeCheckVo auditFeeCheckVo, String matchCode) {
        List<AuditFeeCheckDetailPlan> detailPlanList;
        Validate.notBlank((CharSequence)matchCode, (String)"\u6263\u8d39\u5339\u914d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (Objects.isNull(auditFeeCheckVo)) {
            AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findByMatchCode(matchCode);
            auditFeeCheckVo = (AuditFeeCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeCheck, AuditFeeCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        if (CollectionUtils.isEmpty(detailPlanList = this.auditFeeCheckDetailPlanRepository.findDetailByMatchCode(matchCode))) {
            return;
        }
        List<Object> posList = new ArrayList();
        if (CollectionUtils.isEmpty(posList = posList.stream().filter(p -> !StringUtils.isBlank((CharSequence)p.getActivityDetailItemCode())).collect(Collectors.toList()))) {
            return;
        }
        List costList = this.auditFeeCheckCostVoService.findDetailByMatchCode(matchCode);
        if (CollectionUtils.isEmpty((Collection)costList)) {
            return;
        }
        BigDecimal promotionDeduction = posList.stream().map(AuditFeeCheckPosVo::getPromotionDeduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal deductionAmountTax = costList.stream().map(AuditFeeCheckCostVo::getDeductionAmountTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal diffTotalAmount = deductionAmountTax.subtract(promotionDeduction);
        BigDecimal hadDiffAmount = BigDecimal.ZERO;
        for (int i = 0; i < posList.size(); ++i) {
            AuditFeeCheckPosVo pos = (AuditFeeCheckPosVo)posList.get(i);
            BigDecimal div1 = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(diffTotalAmount) != 0) {
                div1 = NumberUtil.div((Number)pos.getPromotionDeduction(), (Number)diffTotalAmount);
            }
            BigDecimal mul = BigDecimal.ZERO;
            if (i + 1 == posList.size()) {
                mul = NumberUtil.sub((Number)diffTotalAmount, (Number)hadDiffAmount);
            } else {
                mul = NumberUtil.mul((Number)div1, (Number)diffTotalAmount).setScale(2, 4);
                hadDiffAmount = hadDiffAmount.add(mul);
            }
            pos.setSharePromotionDeduction(mul);
            BigDecimal oneDiffAmount = Optional.ofNullable(pos.getOneDiffAmount()).orElse(BigDecimal.ZERO);
            BigDecimal productNumber = Optional.ofNullable(pos.getProductNumber()).orElse(BigDecimal.ZERO);
            pos.setTotalDiffAmount(oneDiffAmount.multiply(productNumber).add(mul));
        }
        Map posToActivityVoMap = posList.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
        detailPlanList.forEach(plan -> {
            AuditFeeCheckPosVo posVo = (AuditFeeCheckPosVo)posToActivityVoMap.get(plan.getDetailPlanItemCode());
            plan.setAuditFeeCheckShareAmount(posVo.getPromotionDeduction().add(posVo.getSharePromotionDeduction()));
        });
        if (!Objects.isNull(auditFeeCheckVo)) {
            auditFeeCheckVo.setCostDetailDiffAmount(diffTotalAmount);
        }
        if (update) {
            this.updatePosAuditAmount(auditFeeCheckVo, posList, detailPlanList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePosAuditAmount(AuditFeeCheckVo auditFeeCheckVo, List<AuditFeeCheckPosVo> posList, List<AuditFeeCheckDetailPlan> detailPlanList) {
        if (!Objects.isNull(auditFeeCheckVo)) {
            AuditFeeCheck auditFeeCheck = (AuditFeeCheck)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeCheckVo, AuditFeeCheck.class, HashSet.class, ArrayList.class, new String[0]));
            this.auditFeeCheckRepository.updateById((Object)auditFeeCheck);
        }
        if (!CollectionUtils.isEmpty(posList)) {
            List posEntitys = (List)this.nebulaToolkitService.copyCollectionByWhiteList(posList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeCheckPosRepository.updateBatchById(posEntitys);
        }
        if (!CollectionUtils.isEmpty(detailPlanList)) {
            this.auditFeeCheckDetailPlanRepository.updateBatchById(detailPlanList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveExpensesDeductResult(List<AuditFeeCheckVo> feeCheckVoList, List<AuditFeeCheckDetailPlanVo> feeCheckDetailPlanVoList) {
        if (!CollectionUtils.isEmpty(feeCheckVoList)) {
            Collection auditFeeChecks = this.nebulaToolkitService.copyCollectionByWhiteList(feeCheckVoList, AuditFeeCheckVo.class, AuditFeeCheck.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeCheckRepository.updateBatchById(auditFeeChecks);
        }
        if (!CollectionUtils.isEmpty(feeCheckDetailPlanVoList)) {
            Collection feeCheckDetailPlanVos = this.nebulaToolkitService.copyCollectionByWhiteList(feeCheckDetailPlanVoList, AuditFeeCheckDetailPlanVo.class, AuditFeeCheckDetailPlan.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeCheckDetailPlanRepository.updateBatchById(feeCheckDetailPlanVos);
        }
    }

    public List<String> findDetailPlanItemCodeByCost(Set<String> deductionCodeList) {
        List<String> detailPLanItemCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(deductionCodeList)) {
            List<String> matchCodeList = this.auditFeeCheckCostRepository.findMatchCodesByCostCode(Lists.newArrayList(deductionCodeList));
            List<String> confirmedMatchCodeList = this.auditFeeCheckRepository.findConfirmedByMatchCodes(matchCodeList);
            detailPLanItemCodeList = this.auditFeeCheckDetailPlanRepository.findDetailPlanItemCodeByMatchCodes(confirmedMatchCodeList);
        }
        return detailPLanItemCodeList;
    }

    public void detailPlanReshare(AuditFeeCheckVo feeCheckVo) {
        Validate.notNull((Object)feeCheckVo, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)feeCheckVo.getId(), (String)"\u5339\u914d\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = feeCheckVo.getCacheKey();
        Validate.notNull((Object)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (feeCheckVo.getIsAddUp() == null || feeCheckVo.getBusinessUnitCode() == null) {
            AuditFeeCheck auditFeeCheck = this.auditFeeCheckRepository.findById(feeCheckVo.getId());
            feeCheckVo.setIsConfirm(auditFeeCheck.getIsConfirm());
            feeCheckVo.setIsConfirmDiff(auditFeeCheck.getIsConfirmDiff());
            feeCheckVo.setIsAddUp(auditFeeCheck.getIsAddUp());
            feeCheckVo.setBusinessUnitCode(auditFeeCheck.getBusinessUnitCode());
        }
        String diffType = feeCheckVo.getDiffType();
        String diffUse = feeCheckVo.getDiffUse();
        BigDecimal diffConfirmAmount = feeCheckVo.getDiffConfirmAmount();
        List<AuditFeeCheckDetailPlanVo> detailPlanVoList = this.auditFeeCheckDetailPlanVoCacheService.findCacheList(cacheKey);
        detailPlanVoList = this.detailPlanShare(feeCheckVo, detailPlanVoList);
        feeCheckVo.setDiffType(diffType);
        feeCheckVo.setDiffUse(diffUse);
        feeCheckVo.setDiffConfirmAmount(diffConfirmAmount);
        if (CollectionUtils.isNotEmpty(detailPlanVoList)) {
            this.auditFeeCheckDetailPlanVoCacheService.addItemCache(cacheKey, detailPlanVoList);
        }
    }

    private List<AuditFeeCheckDetailPlanVo> detailPlanShare(AuditFeeCheckVo feeCheckVo, List<AuditFeeCheckDetailPlanVo> detailPlanVoList) {
        BigDecimal costDeductionAmount;
        BigDecimal needBeAuditAmount = costDeductionAmount = Optional.ofNullable(feeCheckVo.getCostDeductionAmount()).orElse(BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(detailPlanVoList)) {
            feeCheckVo.setCostDetailDiffAmount(costDeductionAmount);
            feeCheckVo.setActivityPreAuditAmount(BigDecimal.ZERO);
            feeCheckVo.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
            feeCheckVo.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
            return detailPlanVoList;
        }
        detailPlanVoList = detailPlanVoList.stream().sorted(Comparator.comparing(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode)).collect(Collectors.toList());
        for (int i = 0; i < detailPlanVoList.size(); ++i) {
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = (AuditFeeCheckDetailPlanVo)detailPlanVoList.get(i);
            Validate.notNull((Object)feeCheckDetailPlanVo.getCanAuditAmount(), (String)("\u660e\u7ec6\u7f16\u7801" + feeCheckDetailPlanVo.getDetailPlanItemCode() + "\u53ef\u6838\u9500\u91d1\u989d\u6570\u636e\u9519\u8bef"), (Object[])new Object[0]);
            BigDecimal canAuditAmount = feeCheckDetailPlanVo.getCanAuditAmount();
            BigDecimal auditFeeCheckShareAmount = BigDecimal.ZERO;
            if (needBeAuditAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal remainNeedBeAuditAmount = needBeAuditAmount.subtract(canAuditAmount);
                int i1 = remainNeedBeAuditAmount.compareTo(BigDecimal.ZERO);
                if (i1 >= 0) {
                    auditFeeCheckShareAmount = canAuditAmount;
                }
                if (i1 < 0) {
                    auditFeeCheckShareAmount = needBeAuditAmount;
                }
                auditFeeCheckShareAmount = auditFeeCheckShareAmount.setScale(2, RoundingMode.HALF_UP);
                feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(auditFeeCheckShareAmount);
                if (i + 1 == detailPlanVoList.size() && remainNeedBeAuditAmount.compareTo(BigDecimal.ZERO) > 0) {
                    feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(remainNeedBeAuditAmount.add(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount()));
                    remainNeedBeAuditAmount = BigDecimal.ZERO;
                }
                needBeAuditAmount = remainNeedBeAuditAmount;
            } else {
                feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(BigDecimal.ZERO);
            }
            BigDecimal toBeSupplementedAmount = Optional.ofNullable(feeCheckDetailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).add(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount()).subtract(Optional.ofNullable(feeCheckDetailPlanVo.getApplyAmount()).orElse(BigDecimal.ZERO));
            if (toBeSupplementedAmount.compareTo(BigDecimal.ZERO) > 0) {
                feeCheckDetailPlanVo.setToBeSupplementedAmount(toBeSupplementedAmount);
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(feeCheckVo.getBusinessUnitCode())) {
                BigDecimal subtract = Optional.ofNullable(feeCheckDetailPlanVo.getApplyAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(feeCheckDetailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO));
                feeCheckDetailPlanVo.setThisAuditAmount(subtract.compareTo(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount()) < 0 ? subtract : feeCheckDetailPlanVo.getAuditFeeCheckShareAmount());
            } else {
                feeCheckDetailPlanVo.setThisAuditAmount(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount());
            }
            if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)feeCheckVo.getIsAddUp()) && needBeAuditAmount.compareTo(BigDecimal.ZERO) <= 0) break;
        }
        detailPlanVoList = detailPlanVoList.stream().filter(e -> e.getAuditFeeCheckShareAmount() != null).collect(Collectors.toList());
        BigDecimal canAuditAmountTotal = detailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getCanAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u672c\u6b21\u5339\u914d\u5230\u7684\u6d3b\u52a8\u7684\u603b\u53ef\u7ed3\u6848\u91d1\u989d-\u7d2f\u8ba1:{}", (Object)canAuditAmountTotal);
        feeCheckVo.setActivityPreAuditAmount(canAuditAmountTotal);
        feeCheckVo.setCostDetailDiffAmount(costDeductionAmount.subtract(feeCheckVo.getActivityPreAuditAmount()));
        int diffAmount = costDeductionAmount.compareTo(feeCheckVo.getActivityPreAuditAmount());
        feeCheckVo.setMatchResult(diffAmount == 0 ? MatchResultEnum.NO_DIFFERENCE.getCode() : MatchResultEnum.HAVE_DIFFERENCE.getCode());
        if (!BooleanEnum.TRUE.getCapital().equals(feeCheckVo.getIsConfirmDiff())) {
            if (diffAmount == 0) {
                feeCheckVo.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
            }
            if (diffAmount > 0) {
                feeCheckVo.setDiffType(DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode());
            }
            if (diffAmount < 0) {
                feeCheckVo.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
            }
            feeCheckVo.setDiffConfirmAmount(feeCheckVo.getCostDetailDiffAmount());
        }
        feeCheckVo.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
        return detailPlanVoList;
    }
}

