/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeVerifyDecide;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeVerifyDecideRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeVerifyDecideSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.IsPushEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CustomerSupplierTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.event.AuditEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeVerifyDecideServiceImpl
implements AuditFeeVerifyDecideService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeVerifyDecideServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeVerifyDecideRepository auditFeeVerifyDecideRepository;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;
    @Autowired(required=false)
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private AuditEventListener auditEventListener;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<AuditFeeVerifyDecideVo> findByConditions(Pageable pageable, AuditFeeVerifyDecideDto dto) {
        List productVoList;
        Page page;
        Page<AuditFeeVerifyDecideVo> result;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeVerifyDecideDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if ("9999".equals(dto.getAreaCode())) {
            dto.setAreaCode(null);
        }
        if (CollectionUtils.isEmpty((Collection)(result = this.auditFeeVerifyDecideRepository.findByConditions((Page<AuditFeeVerifyDecideVo>)(page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize())), dto)).getRecords())) {
            return result;
        }
        List productCodes = result.getRecords().stream().map(AuditFeeVerifyDecideVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        HashMap<String, ProductVo> productVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(productCodes) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes(productCodes)))) {
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        Map<String, List<AuditFeeVerifyDecideVo>> recordsMap = result.getRecords().stream().collect(Collectors.groupingBy(AuditFeeVerifyDecideVo::getSource));
        for (String key : recordsMap.keySet()) {
            Map<String, AuditFeeVerifyDecideVo> decideVoMap;
            List<AuditFeeVerifyDecideVo> valueList = recordsMap.get(key);
            if (CollectionUtils.isEmpty(valueList)) continue;
            List<String> activityItemCodes = valueList.stream().map(AuditFeeVerifyDecideVo::getActivityDetailItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (AuditFeeVerifyDecideSourceEnum.COST.getCode().equals(key)) {
                decideVoMap = valueList.stream().collect(Collectors.toMap(a -> a.getActivityDetailItemCode() + a.getAuditFeeCheckCode(), Function.identity(), (v1, v2) -> v2));
                List<AuditFeeCheckDetailPlanVo> costActivityItemList = this.auditFeeCheckDetailPlanRepository.findActivityAndShareByActivityItemCodes(activityItemCodes);
                Map<String, AuditFeeCheckDetailPlanVo> costActivityItemMap = costActivityItemList.stream().collect(Collectors.toMap(a -> a.getDetailPlanItemCode() + a.getAuditFeeCheckCode(), Function.identity(), (v1, v2) -> v2));
                this.buildDataByCost(decideVoMap, costActivityItemMap, productVoMap);
            }
            if (!AuditFeeVerifyDecideSourceEnum.STATEMENT.getCode().equals(key)) continue;
            decideVoMap = valueList.stream().filter(f -> AuditFeeVerifyDecideSourceEnum.STATEMENT.getCode().equals(f.getSource())).collect(Collectors.toMap(a -> a.getActivityDetailItemCode() + a.getAuditFeeCheckCode(), Function.identity(), (v1, v2) -> v2));
            List<AuditFeeSettlementCheckDetailPlanVo> statementActivityItemList = this.auditFeeSettlementCheckDetailPlanRepository.findActivityAndShareByActivityItemCodes(activityItemCodes);
            Map<String, AuditFeeSettlementCheckDetailPlanVo> statementActivityItemMap = statementActivityItemList.stream().collect(Collectors.toMap(a -> a.getDetailPlanItemCode() + a.getCode(), Function.identity(), (v1, v2) -> v2));
            this.buildDataByStatement(decideVoMap, statementActivityItemMap, productVoMap);
        }
        return result;
    }

    private void buildDataByStatement(Map<String, AuditFeeVerifyDecideVo> decideVoMap, Map<String, AuditFeeSettlementCheckDetailPlanVo> statementActivityItemMap, Map<String, ProductVo> productVoMap) {
        if (CollectionUtils.isEmpty(decideVoMap) || CollectionUtils.isEmpty(statementActivityItemMap)) {
            return;
        }
        statementActivityItemMap.forEach((k, v) -> {
            ProductVo productVo;
            if (Objects.isNull(v)) {
                return;
            }
            AuditFeeVerifyDecideVo auditFeeVerifyDecideVo = (AuditFeeVerifyDecideVo)decideVoMap.get(k);
            if (Objects.isNull(auditFeeVerifyDecideVo)) {
                return;
            }
            auditFeeVerifyDecideVo.setFeeAmount(v.getApplyAmount());
            auditFeeVerifyDecideVo.setActivityPreAuditAmount(v.getPredictionAuditAmount());
            auditFeeVerifyDecideVo.setAlreadyAuditAmount(v.getAlreadyAuditAmount());
            if (!CollectionUtils.isEmpty((Map)productVoMap) && !Objects.isNull(productVo = (ProductVo)productVoMap.get(v.getProductCode()))) {
                auditFeeVerifyDecideVo.setProductBrandCode(productVo.getProductBrandCode());
                auditFeeVerifyDecideVo.setProductBrandName(productVo.getProductBrandName());
                auditFeeVerifyDecideVo.setProductCategoryCode(productVo.getProductCategoryCode());
                auditFeeVerifyDecideVo.setProductCategoryName(productVo.getProductCategoryName());
                auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelCode());
                auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelName());
            }
        });
    }

    private void buildDataByCost(Map<String, AuditFeeVerifyDecideVo> decideVoMap, Map<String, AuditFeeCheckDetailPlanVo> costActivityItemMap, Map<String, ProductVo> productVoMap) {
        if (CollectionUtils.isEmpty(decideVoMap) || CollectionUtils.isEmpty(costActivityItemMap)) {
            return;
        }
        costActivityItemMap.forEach((k, v) -> {
            ProductVo productVo;
            if (Objects.isNull(v)) {
                return;
            }
            AuditFeeVerifyDecideVo auditFeeVerifyDecideVo = (AuditFeeVerifyDecideVo)decideVoMap.get(k);
            if (Objects.isNull(auditFeeVerifyDecideVo)) {
                return;
            }
            auditFeeVerifyDecideVo.setFeeAmount(v.getApplyAmount());
            auditFeeVerifyDecideVo.setActivityPreAuditAmount(v.getPredictionAuditAmount());
            auditFeeVerifyDecideVo.setAlreadyAuditAmount(v.getAlreadyAuditAmount());
            if (!CollectionUtils.isEmpty((Map)productVoMap) && !Objects.isNull(productVo = (ProductVo)productVoMap.get(v.getProductCode()))) {
                auditFeeVerifyDecideVo.setProductBrandCode(productVo.getProductBrandCode());
                auditFeeVerifyDecideVo.setProductBrandName(productVo.getProductBrandName());
                auditFeeVerifyDecideVo.setProductCategoryCode(productVo.getProductCategoryCode());
                auditFeeVerifyDecideVo.setProductCategoryName(productVo.getProductCategoryName());
                auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelCode());
                auditFeeVerifyDecideVo.setProductItemCode(productVo.getProductLevelName());
            }
        });
    }

    public void createBatch(List<AuditFeeVerifyDecideDto> decideList) {
        if (CollectionUtils.isEmpty(decideList)) {
            return;
        }
        Collection list = this.nebulaToolkitService.copyCollectionByBlankList(decideList, AuditFeeVerifyDecideDto.class, AuditFeeVerifyDecide.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(e -> {
            Validate.notBlank((CharSequence)e.getSource(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getActivityDetailItemCode(), (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            e.setId(UUID.randomUUID().toString().replace("-", ""));
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setIsPush(IsPushEnum.WAIT.getCode());
        });
        this.auditFeeVerifyDecideRepository.saveBatch(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateWholeAudit(AuditFeeVerifyDecideDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getIdList(), (String)"\u8bf7\u9009\u62e9\u8981\u7f16\u8f91\u7684\u53c2\u6570\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWholeAudit(), (String)"\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!YesOrNoEnum.YES.getCode().equals(dto.getWholeAudit()) && !YesOrNoEnum.NO.getCode().equals(dto.getWholeAudit())) {
            throw new IllegalArgumentException("\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u503c\u9519\u8bef");
        }
        List verifyDecideList = this.auditFeeVerifyDecideRepository.listByIds(dto.getIdList());
        Validate.notEmpty((Collection)verifyDecideList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.auditFeeVerifyDecideRepository.updateWholeAudit(dto.getIdList(), dto.getWholeAudit());
    }

    public Page<AuditFeeVerifyDecideVo> pushAuditQuery(Pageable pageable, AuditFeeVerifyDecideDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesInstitutionErpCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesInstitutionName(), (String)"\u9500\u552e\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuditWay(), (String)"\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAreaCode(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setIsPushNot(IsPushEnum.SUCCESS.getCode());
        return this.findByConditions(pageable, dto);
    }

    public void pushAudit(AuditFeeVerifyDecideDto dto) {
        this.pushAuditValidation(dto);
        boolean nationwide = false;
        if ("9999".equals(dto.getAreaCode())) {
            nationwide = true;
            dto.setAreaCode(null);
        }
        List<AuditFeeVerifyDecideVo> willPushDataList = this.findWillPushAuditData(dto);
        Validate.notEmpty(willPushDataList, (String)"\u9700\u8981\u4e0b\u63a8\u6838\u9500\u5355\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Map<String, List<AuditFeeVerifyDecideVo>> willPushDataMap = willPushDataList.stream().collect(Collectors.groupingBy(AuditFeeVerifyDecideVo::getActivityDetailItemCode));
        Validate.notEmpty(willPushDataMap.keySet(), (String)"\u9009\u62e9\u7684\u6263\u8d39\u6838\u5b9a\u4e2d\u7684\u6d3b\u52a8\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List activityDetailPlanItemList = this.activityDetailPlanItemSdkService.findByItemCodes(new ArrayList<String>(willPushDataMap.keySet()));
        Validate.notEmpty((Collection)activityDetailPlanItemList, (String)"\u672a\u627e\u5230\u6d3b\u52a8\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.isTrue((willPushDataMap.keySet().size() == activityDetailPlanItemList.size() ? 1 : 0) != 0, (String)("\u6570\u636e\u4e0d\u5339\u914d\uff01\u9009\u62e9\u7684\u6263\u8d39\u6838\u5b9a\u4e2d\u7684\u6d3b\u52a8\u7f16\u7801\uff08\u5171:" + willPushDataMap.keySet().size() + "\u6761\uff0c\u627e\u5230\u7684\u6d3b\u52a8\u8be6\u60c5\uff08\u5171:" + activityDetailPlanItemList.size() + "\u6761\u3002"), (Object[])new Object[0]);
        log.info("\u4e0b\u63a8\u6838\u9500\u5355,\u5f00\u59cb\u7ec4\u88c5\u6570\u636e");
        AutoAuditDto auditDto = new AutoAuditDto();
        HashMap<String, List<String>> auditFeeCheckCodeMap = new HashMap<String, List<String>>();
        ArrayList<AuditCustomerDetailDto> auditCustomerDetailList = new ArrayList<AuditCustomerDetailDto>(activityDetailPlanItemList.size() + 10);
        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            auditDto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
        } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            auditDto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
        }
        auditDto.setRegionCode(nationwide ? "9999" : dto.getAreaCode());
        auditDto.setAuditName(dto.getAuditName());
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        auditDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        auditDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        auditDto.setIsCollection(Boolean.TRUE);
        auditDto.setSaveType("");
        auditDto.setCompanyCode(dto.getSalesInstitutionErpCode());
        auditDto.setCompanyName(dto.getSalesInstitutionName());
        auditDto.setWhetherSpeciallyApproved(YesOrNoEnum.NO.getCode());
        auditDto.setWhetherPay(BooleanEnum.FALSE.getCapital());
        auditDto.setRemark(dto.getRemark());
        BigDecimal thisEndCaseTaxTotalAmount = BigDecimal.ZERO;
        BigDecimal discountTaxTotalAmount = BigDecimal.ZERO;
        BigDecimal discountTotalAmount = BigDecimal.ZERO;
        BigDecimal auditTaxTotalAmount = BigDecimal.ZERO;
        BigDecimal auditTotalAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemVo detailPlanItemVo : activityDetailPlanItemList) {
            AuditCustomerDetailDto customerDetailDto = this.buildAuditCustomerDetail(loginUser, detailPlanItemVo);
            List<AuditFeeVerifyDecideVo> auditFeeVerifyDecideVos = willPushDataMap.get(detailPlanItemVo.getDetailPlanItemCode());
            if (!CollectionUtils.isEmpty(auditFeeVerifyDecideVos)) {
                BigDecimal thisAuditAmount;
                List auditFeeCheckCodes = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
                auditFeeCheckCodeMap.put(detailPlanItemVo.getDetailPlanItemCode(), auditFeeCheckCodes);
                BigDecimal verifyDecideAmount = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getVerifyDecideAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                customerDetailDto.setThisAuditAmount(verifyDecideAmount);
                thisEndCaseTaxTotalAmount = thisEndCaseTaxTotalAmount.add(verifyDecideAmount);
                String wholeAuditYes = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getWholeAudit).filter(e -> Objects.nonNull(e) && BooleanEnum.TRUE.getCapital().equals(e)).findFirst().orElse("");
                if (StringUtils.isBlank((CharSequence)wholeAuditYes)) {
                    String wholeAuditNo = auditFeeVerifyDecideVos.stream().map(AuditFeeVerifyDecideVo::getWholeAudit).filter(e -> Objects.nonNull(e) && BooleanEnum.FALSE.getCapital().equals(e)).findFirst().orElse("");
                    if (StringUtils.isBlank((CharSequence)wholeAuditNo)) {
                        customerDetailDto.setWholeAudit(BooleanEnum.TRUE.getCapital());
                    } else {
                        customerDetailDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
                    }
                } else {
                    customerDetailDto.setWholeAudit(BooleanEnum.TRUE.getCapital());
                }
                customerDetailDto.setIsDeductionFeePool(BooleanEnum.FALSE.getCapital());
                if (EndCaseFormEnum.DISCOUNT.getCode().equals(customerDetailDto.getEndCaseForm())) {
                    customerDetailDto.setDiscountTaxRate("0");
                    thisAuditAmount = Optional.ofNullable(customerDetailDto.getThisAuditAmount()).orElse(BigDecimal.ZERO);
                    customerDetailDto.setDiscountTaxAmount(thisAuditAmount);
                    customerDetailDto.setDiscountAmount(thisAuditAmount);
                    discountTaxTotalAmount = discountTaxTotalAmount.add(thisAuditAmount);
                    discountTotalAmount = discountTotalAmount.add(thisAuditAmount);
                }
                if (EndCaseFormEnum.REIMBURSE.getCode().equals(customerDetailDto.getEndCaseForm())) {
                    customerDetailDto.setReimburseTaxRate("0");
                    thisAuditAmount = Optional.ofNullable(customerDetailDto.getThisAuditAmount()).orElse(BigDecimal.ZERO);
                    customerDetailDto.setReimburseTaxAmount(thisAuditAmount);
                    customerDetailDto.setReimburseAmount(thisAuditAmount);
                    auditTaxTotalAmount = auditTaxTotalAmount.add(thisAuditAmount);
                    auditTotalAmount = auditTotalAmount.add(thisAuditAmount);
                }
            }
            auditCustomerDetailList.add(customerDetailDto);
        }
        auditDto.setThisEndCaseTaxTotalAmount(thisEndCaseTaxTotalAmount);
        auditDto.setDiscountTaxTotalAmount(discountTaxTotalAmount);
        auditDto.setDiscountTotalAmount(discountTotalAmount);
        auditDto.setAuditTaxTotalAmount(auditTaxTotalAmount);
        auditDto.setAuditTotalAmount(auditTotalAmount);
        auditDto.setCacheKey(UUID.randomUUID().toString().replace("-", ""));
        auditDto.setAuditCustomerDetailList(auditCustomerDetailList);
        AuditDto resultDto = null;
        try {
            log.info("\u4e0b\u63a8\u6838\u9500\u5355,\u5f00\u59cb\u63a8\u9001");
            log.info("\u4e0b\u63a8\u6838\u9500\u5355,auditDto:{}", (Object)JSONObject.toJSONString((Object)auditDto));
            resultDto = this.auditEventListener.autoAudit(auditDto);
            if (Objects.isNull(resultDto) || !StringUtils.isNotBlank((CharSequence)resultDto.getAuditCode())) {
                throw new RuntimeException("\u4e0b\u63a8\u6838\u9500\u5355,\u63a8\u9001\u5931\u8d25!");
            }
            log.info("\u4e0b\u63a8\u6838\u9500\u5355,\u63a8\u9001\u6210\u529f,\u66f4\u65b0\u63a8\u9001\u7ed3\u679c");
            this.updatePushAuditResult(resultDto, auditFeeCheckCodeMap, IsPushEnum.SUCCESS.getCode());
        }
        catch (Exception e2) {
            log.info("\u4e0b\u63a8\u6838\u9500\u5355,\u63a8\u9001\u5931\u8d25,\u66f4\u65b0\u63a8\u9001\u7ed3\u679c");
            e2.printStackTrace();
            this.updatePushAuditResult(resultDto, auditFeeCheckCodeMap, IsPushEnum.FAIL.getCode());
            throw e2;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePushAuditResult(AuditDto resultDto, HashMap<String, List<String>> auditFeeCheckCodeMap, String status) {
        if (Objects.isNull(resultDto) || CollectionUtils.isEmpty((Collection)resultDto.getAuditCustomerDetailList())) {
            log.info("\u4e0b\u63a8\u6838\u9500\u5355,\u4e3a\u7a7a,\u65e0\u9700\u66f4\u65b0\u63a8\u9001\u7ed3\u679c");
            return;
        }
        if (CollectionUtils.isEmpty(auditFeeCheckCodeMap)) {
            log.info("\u4e0b\u63a8\u6838\u9500\u5355,\u66f4\u65b0\u72b6\u6001\u65f6,\u6838\u5bf9\u5355\u53f7\u4e3a\u7a7a\uff01");
            return;
        }
        for (AuditCustomerDetailDto customerDetailDto : resultDto.getAuditCustomerDetailList()) {
            List<String> auditFeeCheckCodes = auditFeeCheckCodeMap.get(customerDetailDto.getActivityDetailCode());
            customerDetailDto.setAuditFeeCheckCodes(auditFeeCheckCodes);
        }
        this.auditFeeVerifyDecideRepository.updatePushAuditResult(resultDto.getAuditCustomerDetailList(), resultDto.getAuditCode(), status);
    }

    private List<AuditFeeVerifyDecideVo> findWillPushAuditData(AuditFeeVerifyDecideDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<AuditFeeVerifyDecideVo> list = this.auditFeeVerifyDecideRepository.findWillPushAuditData(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public void pushAuditValidation(AuditFeeVerifyDecideDto decideDto) {
        Validate.notNull((Object)decideDto, (String)"\u63a8\u9001\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getAreaCode(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getAuditName(), (String)"\u6838\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getSalesInstitutionErpCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)decideDto.getAuditWay(), (String)"\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private AuditCustomerDetailDto buildAuditCustomerDetail(AbstractCrmUserIdentity loginUser, ActivityDetailPlanItemVo itemVo) {
        if (Objects.isNull(itemVo)) {
            return null;
        }
        AuditCustomerDetailDto dto = new AuditCustomerDetailDto();
        dto.setRegion(itemVo.getRegion());
        dto.setActivityDetailCode(itemVo.getDetailPlanItemCode());
        dto.setActivityCode(itemVo.getDetailPlanCode());
        dto.setActivityName(itemVo.getDetailPlanName());
        dto.setActivityFormCode(itemVo.getActivityFormCode());
        dto.setActivityFormName(itemVo.getActivityFormName());
        dto.setActivityTypeCode(itemVo.getActivityTypeCode());
        dto.setActivityTypeName(itemVo.getActivityTypeName());
        dto.setActivityBeginTime(itemVo.getActivityBeginDate());
        dto.setActivityEndTime(itemVo.getActivityEndDate());
        dto.setSystemCode(itemVo.getSystemCode());
        dto.setSystemName(itemVo.getSystemName());
        dto.setCustomerCode(itemVo.getCustomerCode());
        dto.setCustomerErpCode(itemVo.getCustomerErpCode());
        dto.setCustomerName(itemVo.getCustomerName());
        dto.setDistributionChannelCode(itemVo.getDistributionChannelCode());
        dto.setDistributionChannelName(itemVo.getDistributionChannelName());
        dto.setSalesInstitutionErpCode(itemVo.getSalesInstitutionErpCode());
        dto.setSalesOrgName(itemVo.getActivityOrgName());
        dto.setSalesOrgCode(itemVo.getActivityOrgCode());
        dto.setStoreCode(itemVo.getTerminalCode());
        dto.setStoreName(itemVo.getTerminalName());
        dto.setApplyAmount(itemVo.getFeeAmount());
        dto.setAuditAmount(itemVo.getAuditAmount());
        dto.setCustomerSupplierType(CustomerSupplierTypeEnum.CUSTOMER.getValue());
        dto.setAuditConditionCode(itemVo.getWriteOffMethod());
        dto.setEndCaseCustomerCode(itemVo.getCustomerCode());
        dto.setEndCaseCustomerName(itemVo.getCustomerName());
        dto.setEndCaseForm(itemVo.getAuditForm());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTaxQuota(BigDecimal.ZERO);
        dto.setAlreadyAuditAmount(itemVo.getAlreadyAuditAmount());
        dto.setCreateTime(new Date());
        if (!Objects.isNull(loginUser)) {
            dto.setCreateName(loginUser.getUsername());
            dto.setCreateAccount(loginUser.getAccount());
        }
        return dto;
    }

    public void updateStatusByAudit(List<String> auditCodeList, List<String> auditDetailCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList) && CollectionUtils.isEmpty(auditDetailCodeList)) {
            return;
        }
        this.auditFeeVerifyDecideRepository.updateStatusByAudit(auditCodeList, auditDetailCodeList, TenantUtils.getTenantCode());
    }
}

