/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.PosMatchActTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosMatchActivityService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.AuditFeeCheckActivityAmountSummaryVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AuditFeeCheckPosMatchActivityServiceImpl
implements AuditFeeCheckPosMatchActivityService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosMatchActivityServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Async(value="auditFeeMatchThread")
    public void posMatchActivityAsync(AuditFeeCheckPosDto dto, List<AuditFeeCheckPosVo> posList, AbstractCrmUserIdentity abstractLoginUser) {
        this.loginUserService.refreshAuthentication((Object)abstractLoginUser);
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosDto());
        this.posMatchActivity(dto, posList);
    }

    public void posMatchActivity(AuditFeeCheckPosDto dto, List<AuditFeeCheckPosVo> posList) {
        List matchCodePostList;
        List<AuditFeeCheckPos> list;
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosDto());
        log.info("=====>    POS\u5339\u914d\u6d3b\u52a8 \u7ec4\u88c5\u6570\u636e start    <=====");
        ArrayList<AuditFeeCheckPosVo> posVoList = new ArrayList<AuditFeeCheckPosVo>();
        if (CollectionUtil.isNotEmpty(posList)) {
            posVoList.addAll(posList);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getMatchCode()) && CollectionUtil.isNotEmpty(list = this.auditFeeCheckPosRepository.findByMatchCode(dto.getMatchCode())) && CollectionUtil.isNotEmpty((Collection)(matchCodePostList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeCheckPos.class, AuditFeeCheckPosVo.class, HashSet.class, ArrayList.class, new String[0])))) {
            posVoList.addAll(matchCodePostList);
        }
        if (CollectionUtil.isEmpty(posVoList)) {
            return;
        }
        List posVos = posVoList.stream().filter(pos -> StringUtils.isBlank((CharSequence)pos.getActivityDetailItemCode()) || !BooleanEnum.TRUE.getCapital().equals(pos.getIsMatchActivity()) || StringUtils.isNotEmpty((CharSequence)pos.getTerminalCode())).collect(Collectors.toList());
        log.info("=====>    POS\u5339\u914d\u6d3b\u52a8 \u7ec4\u88c5\u6570\u636e[{}]\u6761 end    <=====", (Object)posVos.size());
        if (CollectionUtils.isEmpty(posVos)) {
            return;
        }
        log.info("=====>    \u5782\u76f4POS\u5339\u914d\u6d3b\u52a8 start    <=====");
        this.verticalPosMatchActivity(posVoList);
        log.info("=====>    \u5782\u76f4POS\u5339\u914d\u6d3b\u52a8 end    <=====");
        log.info("=====>    \u5206\u5b50POS\u5339\u914d\u6d3b\u52a8 start   <=====");
        this.sonCompanyPosMatchActivity(posVoList);
        log.info("=====>    \u5206\u5b50POS\u5339\u914d\u6d3b\u52a8 end   <=====");
    }

    private void verticalPosMatchActivity(List<AuditFeeCheckPosVo> posVoList) {
        if (CollectionUtil.isEmpty(posVoList)) {
            return;
        }
        List resultVoList = posVoList.stream().filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode())).filter(k -> StringUtils.isNotEmpty((CharSequence)k.getTerminalCode())).filter(k -> StringUtils.isNotEmpty((CharSequence)k.getProductCode())).filter(k -> Objects.nonNull(k.getSalesDate())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(resultVoList)) {
            return;
        }
        Map<String, List<AuditFeeCheckPosVo>> listMap = resultVoList.stream().collect(Collectors.groupingBy(AuditFeeCheckPosVo::getTerminalCode));
        listMap.forEach((terminalCode, list) -> {
            AuditFeeCheckPosVo posHeadVo = (AuditFeeCheckPosVo)list.get(0);
            List productList = list.stream().map(AuditFeeCheckPosVo::getProductCode).distinct().collect(Collectors.toList());
            Page planItemVoPage = null;
            List planItemVoList = null;
            ActivityDetailPlanItemDto czQueryDto = new ActivityDetailPlanItemDto();
            czQueryDto.setBusinessFormatCode(posHeadVo.getBusinessFormatCode());
            czQueryDto.setBusinessUnitCode(posHeadVo.getBusinessUnitCode());
            czQueryDto.setTerminalCode(terminalCode);
            czQueryDto.setIncludeProductCodeList(productList);
            czQueryDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            czQueryDto.setIsTimeAsc(BooleanEnum.TRUE.getCapital());
            czQueryDto.setWriteOffMethod(WriteOffMethodEnum.AFTER_THE_EVENT.getCode());
            PageRequest pageable = PageRequest.of((int)1, (int)AuditFeeConstants.PAGE_SIZE);
            do {
                AuditFeeCheckPosVo notMatchPos;
                planItemVoPage = this.activityDetailPlanItemSdkService.findByConditions((Pageable)pageable, czQueryDto);
                log.info("=====>    POS\u5339\u914d\u5782\u76f4\u6d3b\u52a8[{}/{}]    <====", (Object)planItemVoPage.getCurrent(), (Object)planItemVoPage.getPages());
                if (CollectionUtil.isEmpty((Collection)planItemVoPage.getRecords())) {
                    return;
                }
                pageable = pageable.next();
                planItemVoList = planItemVoPage.getRecords();
                ArrayList<AuditFeeCheckPosVo> updatePosList = new ArrayList<AuditFeeCheckPosVo>();
                ArrayList<ActivityDetailPlanItemVo> updateDetailPlanList = new ArrayList<ActivityDetailPlanItemVo>();
                for (AuditFeeCheckPosVo posVo : list) {
                    log.info("=====>    POS\u5339\u914d\u6d3b\u52a8[{}]    <====", (Object)posVo.getMatchCode());
                    if (StringUtils.isNotEmpty((CharSequence)posVo.getActivityDetailCode()) || StringUtils.isNotEmpty((CharSequence)posVo.getActivityDetailItemCode()) || BooleanEnum.TRUE.getCapital().equals(posVo.getIsMatchActivity()) || StringUtils.isBlank((CharSequence)posVo.getTerminalCode()) || StringUtils.isBlank((CharSequence)posVo.getProductCode()) || StringUtils.isBlank((CharSequence)posVo.getChannelName()) || Objects.isNull(posVo.getSalesDate())) continue;
                    ActivityDetailPlanItemVo planItemVo = this.verticalPosMatchAct(posVo, planItemVoList);
                    if (Objects.isNull(planItemVo)) {
                        log.info("\u5782\u76f4POS\u672a\u5339\u914d\u5230\u6d3b\u52a8POS\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)posVo));
                        log.info("\u5782\u76f4POS\u672a\u5339\u914d\u5230\u6d3b\u52a8\u6d3b\u52a8\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)planItemVoList));
                        continue;
                    }
                    this.verticalPosMatchActUpdateVo(posVo, planItemVo);
                    posVo.setMatchActivityType(PosMatchActTypeEnum.AUTO.getCode());
                    updatePosList.add(posVo);
                    planItemVo.setMatchCode(posVo.getMatchCode());
                    updateDetailPlanList.add(planItemVo);
                }
                if (CollectionUtil.isNotEmpty(updateDetailPlanList)) {
                    List<AuditFeeCheckDetailPlanVo> detailPlanVoList = this.verticalDetailPlanList(updateDetailPlanList);
                    updateDetailPlanList.stream().filter(ActivityDetailPlanItemBase::isSingleBatch).forEach(item -> this.activityDetailPlanItemSdkService.useProductNumber(item));
                    this.saveResult(updatePosList, detailPlanVoList);
                }
                if (!Objects.isNull(notMatchPos = (AuditFeeCheckPosVo)resultVoList.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getActivityDetailItemCode())).findAny().orElse(null))) continue;
                return;
            } while (planItemVoPage.hasNext());
        });
    }

    public void verticalPosMatchActUpdateVo(AuditFeeCheckPosVo posVo, ActivityDetailPlanItemVo planItemVo) {
        if (Objects.isNull(posVo)) {
            return;
        }
        planItemVo = Optional.ofNullable(planItemVo).orElse(new ActivityDetailPlanItemVo());
        posVo.setActivityDetailCode(planItemVo.getDetailPlanCode());
        posVo.setActivityDetailName(planItemVo.getDetailPlanName());
        posVo.setActivityDetailItemCode(planItemVo.getDetailPlanItemCode());
        posVo.setActivityDetailItemName(planItemVo.getDetailPlanName());
        BigDecimal productNumber = Optional.ofNullable(posVo.getProductNumber()).orElse(BigDecimal.ZERO);
        planItemVo.setPeriodPromotionalNumberUse(Integer.valueOf(productNumber.intValue()));
        BigDecimal promotionDeduction = Optional.ofNullable(posVo.getPromotionDeduction()).orElse(BigDecimal.ZERO);
        BigDecimal onePromotionDeduction = Optional.ofNullable(posVo.getOnePromotionDeduction()).orElse(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(productNumber) != 0 && BigDecimal.ZERO.compareTo(onePromotionDeduction) == 0) {
            onePromotionDeduction = promotionDeduction.divide(productNumber, 4, 4);
            posVo.setOnePromotionDeduction(onePromotionDeduction);
        }
        BigDecimal oneApplicationFee = Optional.ofNullable(planItemVo.getSingleApplicationFee()).orElse(BigDecimal.ZERO);
        posVo.setOneApplicationFee(oneApplicationFee);
        BigDecimal oneDiffAmount = onePromotionDeduction.subtract(oneApplicationFee);
        posVo.setOneDiffAmount(oneDiffAmount);
        BigDecimal sharePromotionDeduction = Optional.ofNullable(posVo.getSharePromotionDeduction()).orElse(BigDecimal.ZERO);
        posVo.setSharePromotionDeduction(sharePromotionDeduction);
        posVo.setTotalDiffAmount(oneDiffAmount.multiply(productNumber).add(sharePromotionDeduction));
        posVo.setTotalDiffFinalAmount(posVo.getTotalDiffAmount());
        posVo.setDiffType(this.oneDiffAmountGetDiffType(posVo.getTotalDiffFinalAmount(), posVo.getActivityDetailItemCode()));
        if (StringUtils.isEmpty((CharSequence)posVo.getActivityDetailItemCode())) {
            posVo.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        } else {
            posVo.setIsMatchActivity(BooleanEnum.TRUE.getCapital());
        }
    }

    public String oneDiffAmountGetDiffType(BigDecimal amount, String activityDetailItemCode) {
        if (Objects.isNull(amount) || BigDecimal.ZERO.compareTo(amount) == 0) {
            return DiffTypeEnum.NO_DIFF.getCode();
        }
        if (StringUtil.isNotEmpty((CharSequence)activityDetailItemCode)) {
            if (BigDecimal.ZERO.compareTo(amount) < 0) {
                return DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode();
            }
            if (BigDecimal.ZERO.compareTo(amount) > 0) {
                return DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode();
            }
        } else {
            if (BigDecimal.ZERO.compareTo(amount) < 0) {
                return DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode();
            }
            if (BigDecimal.ZERO.compareTo(amount) > 0) {
                return DiffTypeEnum.LESS_DEDUCTION_NO_DEDUCTION.getCode();
            }
        }
        return "-1";
    }

    private ActivityDetailPlanItemVo verticalPosMatchAct(AuditFeeCheckPosVo posVo, List<ActivityDetailPlanItemVo> planItemVoList) {
        if (CollectionUtil.isEmpty(planItemVoList) || Objects.isNull(posVo)) {
            return null;
        }
        ActivityDetailPlanItemVo detailPlanItemVo = null;
        List<Object> planItemVoNewList = planItemVoList.stream().filter(k -> !"\u5168\u6e20\u9053".equals(k.getRetailerChannel())).filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getIsClose())).filter(k -> Objects.nonNull(k.getSingleApplicationFee())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getChannelName().equals(item.getRetailerChannel()) && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0 && posVo.getSalesDate().compareTo(item.getActivityEndDate()) <= 0).collect(Collectors.toList());
        detailPlanItemVo = this.getDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        planItemVoNewList = planItemVoList.stream().filter(k -> !"\u5168\u6e20\u9053".equals(k.getRetailerChannel())).filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsClose())).filter(k -> Objects.nonNull(k.getCloseDate())).filter(k -> Objects.nonNull(k.getSingleApplicationFee())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getChannelName().equals(item.getRetailerChannel()) && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0 && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0).collect(Collectors.toList());
        detailPlanItemVo = this.getDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        planItemVoNewList = planItemVoList.stream().filter(k -> "\u5168\u6e20\u9053".equals(k.getRetailerChannel())).filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getIsClose())).filter(k -> Objects.nonNull(k.getSingleApplicationFee())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0 && posVo.getSalesDate().compareTo(item.getActivityEndDate()) <= 0).collect(Collectors.toList());
        detailPlanItemVo = this.getDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        planItemVoNewList = planItemVoList.stream().filter(k -> "\u5168\u6e20\u9053".equals(k.getRetailerChannel())).filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsClose())).filter(k -> Objects.nonNull(k.getCloseDate())).filter(k -> Objects.nonNull(k.getSingleApplicationFee())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getSalesDate().compareTo(item.getActivityBeginDate()) >= 0 && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0).collect(Collectors.toList());
        return this.getDetailPlanVo(planItemVoNewList);
    }

    private ActivityDetailPlanItemVo getDetailPlanVo(List<ActivityDetailPlanItemVo> planItemVoNewList) {
        if (CollectionUtil.isEmpty(planItemVoNewList)) {
            return null;
        }
        planItemVoNewList.sort(Comparator.comparing(ActivityDetailPlanItemBase::getSingleApplicationFee).reversed());
        ActivityDetailPlanItemVo detailPlanItemVo = null;
        if (planItemVoNewList.size() > 1) {
            for (ActivityDetailPlanItemVo itemVo : planItemVoNewList) {
                if (!Objects.isNull(itemVo.getPeriodPromotionalNumberUse()) && (!Objects.nonNull(itemVo.getPeriodPromotionalNumber()) || itemVo.getPeriodPromotionalNumber().compareTo(itemVo.getPeriodPromotionalNumberUse()) <= 0)) continue;
                itemVo.setSingleBatch(true);
                detailPlanItemVo = itemVo;
                break;
            }
            if (Objects.isNull(detailPlanItemVo)) {
                detailPlanItemVo = planItemVoNewList.get(planItemVoNewList.size() - 1);
            }
        } else {
            detailPlanItemVo = planItemVoNewList.get(0);
        }
        return detailPlanItemVo;
    }

    public List<AuditFeeCheckDetailPlanVo> verticalDetailPlanList(List<ActivityDetailPlanItemVo> detailPlanItemVoList) {
        ArrayList<AuditFeeCheckDetailPlanVo> result = new ArrayList<AuditFeeCheckDetailPlanVo>();
        if (CollectionUtil.isEmpty(detailPlanItemVoList)) {
            return result;
        }
        AuditFeeCheckActivityAmountSummaryVo summaryVo = this.detailPlanItemAmountSummaryForVertical(detailPlanItemVoList);
        List detailedForecastVoList = summaryVo.getDetailedForecastVoList();
        List detailPlanCodeList = detailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(detailPlanCodeList)) {
            return result;
        }
        List detailPlanVoList = this.activityDetailPlanSdkService.findByCodes(detailPlanCodeList);
        BigDecimal activityPreAuditAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemVo detailPlanVo : detailPlanItemVoList) {
            Optional<DetailedForecastVo> detailedForecastVo = detailedForecastVoList.stream().filter(o -> detailPlanVo.getDetailPlanItemCode().equals(o.getActivityDetailItemCode())).findAny();
            Optional<ActivityDetailPlanVo> planVo = detailPlanVoList.stream().filter(o -> detailPlanVo.getDetailPlanCode().equals(o.getDetailPlanCode())).findAny();
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = new AuditFeeCheckDetailPlanVo();
            feeCheckDetailPlanVo.setAuditFeeCheckCode(detailPlanVo.getMatchCode());
            feeCheckDetailPlanVo.setPosId(detailPlanVo.getPosId());
            feeCheckDetailPlanVo.setDetailPlanItemCode(detailPlanVo.getDetailPlanItemCode());
            feeCheckDetailPlanVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
            feeCheckDetailPlanVo.setActivityBeginDate(detailPlanVo.getActivityBeginDate());
            feeCheckDetailPlanVo.setActivityEndDate(detailPlanVo.getActivityEndDate());
            feeCheckDetailPlanVo.setActivityTypeCode(detailPlanVo.getActivityTypeCode());
            feeCheckDetailPlanVo.setActivityTypeName(detailPlanVo.getActivityTypeName());
            feeCheckDetailPlanVo.setActivityFormCode(detailPlanVo.getActivityFormCode());
            feeCheckDetailPlanVo.setActivityFormName(detailPlanVo.getActivityFormName());
            feeCheckDetailPlanVo.setTerminalCode(detailPlanVo.getTerminalCode());
            feeCheckDetailPlanVo.setTerminalName(detailPlanVo.getTerminalName());
            feeCheckDetailPlanVo.setProductCode(detailPlanVo.getProductCode());
            feeCheckDetailPlanVo.setProductName(detailPlanVo.getProductName());
            feeCheckDetailPlanVo.setSystemCode(detailPlanVo.getSystemCode());
            feeCheckDetailPlanVo.setSystemName(detailPlanVo.getSystemName());
            feeCheckDetailPlanVo.setRegion(detailPlanVo.getRegion());
            feeCheckDetailPlanVo.setWriteOffMethod(detailPlanVo.getWriteOffMethod());
            feeCheckDetailPlanVo.setAuditForm(detailPlanVo.getAuditForm());
            feeCheckDetailPlanVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
            feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format((Date)detailPlanVo.getFeeYearMonth(), (String)"yyyy-MM"));
            feeCheckDetailPlanVo.setRemark(detailPlanVo.getRemark());
            feeCheckDetailPlanVo.setIsPos(BooleanEnum.TRUE.getCapital());
            detailPlanVo.setPeriodPromotionalNumber(Optional.ofNullable(detailPlanVo.getPeriodPromotionalNumber()).orElse(0));
            feeCheckDetailPlanVo.setApplyAmount(detailPlanVo.getTotalFeeAmount());
            detailedForecastVo.ifPresent(o -> feeCheckDetailPlanVo.setPredictionAuditAmount(o.getEstimatedWriteOffAmount()));
            planVo.ifPresent(o -> feeCheckDetailPlanVo.setDetailPlanName(o.getDetailPlanName()));
            BigDecimal alreadyAuditAmount = Optional.ofNullable(detailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
            feeCheckDetailPlanVo.setAlreadyAuditAmount(alreadyAuditAmount);
            BigDecimal preAuditAmount = Optional.ofNullable(feeCheckDetailPlanVo.getPredictionAuditAmount()).orElse(BigDecimal.ZERO);
            feeCheckDetailPlanVo.setCanAuditAmount(preAuditAmount.subtract(alreadyAuditAmount));
            activityPreAuditAmount = activityPreAuditAmount.add(feeCheckDetailPlanVo.getCanAuditAmount());
            feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(feeCheckDetailPlanVo.getAuditFeeCheckShareAmount());
            result.add(feeCheckDetailPlanVo);
        }
        return result;
    }

    private void sonCompanyPosMatchActivity(List<AuditFeeCheckPosVo> posVoList) {
        if (CollectionUtil.isEmpty(posVoList)) {
            return;
        }
        List resultVoList = posVoList.stream().filter(k -> BusinessUnitEnum.SON_COMPANY.getCode().equals(k.getBusinessUnitCode())).filter(k -> StringUtils.isNotEmpty((CharSequence)k.getTerminalCode())).filter(k -> StringUtils.isNotEmpty((CharSequence)k.getProductCode())).filter(k -> Objects.nonNull(k.getSalesDate())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(resultVoList)) {
            return;
        }
        Map<String, List<AuditFeeCheckPosVo>> listMap = resultVoList.stream().collect(Collectors.groupingBy(AuditFeeCheckPosVo::getTerminalCode));
        SubComActivityDetailPlanItemDto fzQueryDto = new SubComActivityDetailPlanItemDto();
        listMap.forEach((terminalCode, list) -> {
            List productList = list.stream().map(AuditFeeCheckPosVo::getProductCode).distinct().collect(Collectors.toList());
            AuditFeeCheckPosVo posHeadVo = (AuditFeeCheckPosVo)list.get(0);
            Page planItemVoPage = null;
            List fzPlanItemVoList = null;
            fzQueryDto.setBusinessFormatCode(posHeadVo.getBusinessFormatCode());
            fzQueryDto.setBusinessUnitCode(posHeadVo.getBusinessUnitCode());
            fzQueryDto.setTerminalCode(terminalCode);
            fzQueryDto.setProductCodeList(productList);
            fzQueryDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            PageRequest pageable = PageRequest.of((int)1, (int)AuditFeeConstants.PAGE_SIZE);
            do {
                AuditFeeCheckPosVo notMatchPos;
                if (Objects.isNull(planItemVoPage = this.subComActivityDetailPlanItemVoService.findByConditions((Pageable)pageable, fzQueryDto)) || CollectionUtil.isEmpty((Collection)planItemVoPage.getRecords())) {
                    return;
                }
                pageable = pageable.next();
                fzPlanItemVoList = planItemVoPage.getRecords();
                ArrayList<AuditFeeCheckPosVo> updatePosList = new ArrayList<AuditFeeCheckPosVo>();
                ArrayList<SubComActivityDetailPlanItemVo> updateDetailPlanList = new ArrayList<SubComActivityDetailPlanItemVo>();
                for (AuditFeeCheckPosVo posVo : list) {
                    if (StringUtils.isNotEmpty((CharSequence)posVo.getActivityDetailItemCode()) || BooleanEnum.TRUE.getCapital().equals(posVo.getIsMatchActivity()) || StringUtils.isBlank((CharSequence)posVo.getTerminalCode()) || StringUtils.isBlank((CharSequence)posVo.getProductCode()) || Objects.isNull(posVo.getSalesDate())) continue;
                    SubComActivityDetailPlanItemVo activityVo = this.sonCompanyPosMatchAct(posVo, fzPlanItemVoList);
                    if (Objects.isNull(activityVo)) {
                        log.info("\u5206\u5b50POS\u672a\u5339\u914d\u5230\u6d3b\u52a8POS\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)posVo));
                        log.info("\u5206\u5b50POS\u672a\u5339\u914d\u5230\u6d3b\u52a8\u6d3b\u52a8\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)fzPlanItemVoList));
                        continue;
                    }
                    this.sonCompanyPosMatchActUpdateVo(posVo, activityVo);
                    posVo.setMatchActivityType(PosMatchActTypeEnum.AUTO.getCode());
                    updatePosList.add(posVo);
                    activityVo.setMatchCode(posVo.getMatchCode());
                    updateDetailPlanList.add(activityVo);
                }
                if (CollectionUtil.isNotEmpty(updateDetailPlanList)) {
                    List<AuditFeeCheckDetailPlanVo> detailPlanVoList = this.sonCompanyDetailPlanList(updateDetailPlanList);
                    updateDetailPlanList.stream().filter(SubComActivityDetailPlanItemVo::isSingleBatch).forEach(item -> this.subComActivityDetailPlanItemVoService.useProductNumber(item));
                    this.saveResult(updatePosList, detailPlanVoList);
                }
                if (!Objects.isNull(notMatchPos = (AuditFeeCheckPosVo)list.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getActivityDetailItemCode()) || BooleanEnum.FALSE.getCapital().equals(p.getIsMatchActivity())).findAny().orElse(null))) continue;
                return;
            } while (planItemVoPage.hasNext());
        });
    }

    public void sonCompanyPosMatchActUpdateVo(AuditFeeCheckPosVo posVo, SubComActivityDetailPlanItemVo planItemVo) {
        if (Objects.isNull(posVo)) {
            return;
        }
        planItemVo = Optional.ofNullable(planItemVo).orElse(new SubComActivityDetailPlanItemVo());
        posVo.setActivityDetailCode(planItemVo.getConstituentDetailPlanCode());
        posVo.setActivityDetailName(planItemVo.getConstituentDetailPlanName());
        posVo.setActivityDetailItemCode(planItemVo.getConstituentDetailPlanItemCode());
        posVo.setActivityDetailItemName(planItemVo.getConstituentDetailPlanName());
        BigDecimal productNumber = Optional.ofNullable(posVo.getProductNumber()).orElse(BigDecimal.ZERO);
        planItemVo.setPromoteSalesUse(productNumber);
        BigDecimal promotionDeduction = Optional.ofNullable(posVo.getPromotionDeduction()).orElse(BigDecimal.ZERO);
        BigDecimal onePromotionDeduction = Optional.ofNullable(posVo.getOnePromotionDeduction()).orElse(BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(productNumber) != 0 && BigDecimal.ZERO.compareTo(onePromotionDeduction) == 0) {
            onePromotionDeduction = promotionDeduction.divide(productNumber, 4, 4);
            posVo.setOnePromotionDeduction(onePromotionDeduction);
        }
        BigDecimal oneApplicationFee = Optional.ofNullable(planItemVo.getSingleEstimatedCost()).orElse(BigDecimal.ZERO);
        posVo.setOneApplicationFee(oneApplicationFee);
        BigDecimal oneDiffAmount = onePromotionDeduction.subtract(oneApplicationFee);
        posVo.setOneDiffAmount(oneDiffAmount);
        BigDecimal sharePromotionDeduction = Optional.ofNullable(posVo.getSharePromotionDeduction()).orElse(BigDecimal.ZERO);
        posVo.setSharePromotionDeduction(sharePromotionDeduction);
        posVo.setTotalDiffAmount(oneDiffAmount.multiply(productNumber).add(sharePromotionDeduction));
        posVo.setTotalDiffFinalAmount(posVo.getTotalDiffAmount());
        posVo.setDiffType(this.oneDiffAmountGetDiffType(posVo.getTotalDiffFinalAmount(), posVo.getActivityDetailItemCode()));
        if (StringUtils.isEmpty((CharSequence)posVo.getActivityDetailItemCode())) {
            posVo.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        } else {
            posVo.setIsMatchActivity(BooleanEnum.TRUE.getCapital());
        }
    }

    private SubComActivityDetailPlanItemVo sonCompanyPosMatchAct(AuditFeeCheckPosVo posVo, List<SubComActivityDetailPlanItemVo> fzPlanItemVoList) {
        if (CollectionUtil.isEmpty(fzPlanItemVoList) || Objects.isNull(posVo)) {
            return null;
        }
        SubComActivityDetailPlanItemVo detailPlanItemVo = null;
        List<Object> planItemVoNewList = fzPlanItemVoList.stream().filter(k -> !"\u5168\u6e20\u9053".equals(k.getDistributionChannelName())).filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getCloseTag())).filter(k -> Objects.nonNull(k.getSingleEstimatedCost())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getChannelName().equals(item.getDistributionChannelName()) && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0 && posVo.getSalesDate().compareTo(item.getActivityEndTime()) <= 0).collect(Collectors.toList());
        detailPlanItemVo = this.getSubComDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        planItemVoNewList = fzPlanItemVoList.stream().filter(k -> !"\u5168\u6e20\u9053".equals(k.getDistributionChannelName())).filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getCloseTag())).filter(k -> Objects.nonNull(k.getCloseDate())).filter(k -> Objects.nonNull(k.getSingleEstimatedCost())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getChannelName().equals(item.getDistributionChannelName()) && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0 && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0).collect(Collectors.toList());
        detailPlanItemVo = this.getSubComDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        planItemVoNewList = fzPlanItemVoList.stream().filter(k -> "\u5168\u6e20\u9053".equals(k.getDistributionChannelName())).filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getCloseTag())).filter(k -> Objects.nonNull(k.getSingleEstimatedCost())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0 && posVo.getSalesDate().compareTo(item.getActivityEndTime()) <= 0).collect(Collectors.toList());
        detailPlanItemVo = this.getSubComDetailPlanVo(planItemVoNewList);
        if (Objects.nonNull(detailPlanItemVo)) {
            return detailPlanItemVo;
        }
        planItemVoNewList = fzPlanItemVoList.stream().filter(k -> "\u5168\u6e20\u9053".equals(k.getDistributionChannelName())).filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getCloseTag())).filter(k -> Objects.nonNull(k.getCloseDate())).filter(k -> Objects.nonNull(k.getSingleEstimatedCost())).filter(item -> posVo.getTerminalCode().equals(item.getTerminalCode()) && posVo.getProductCode().equals(item.getProductCode()) && posVo.getSalesDate().compareTo(item.getActivityBeginTime()) >= 0 && posVo.getSalesDate().compareTo(item.getCloseDate()) <= 0).collect(Collectors.toList());
        return this.getSubComDetailPlanVo(planItemVoNewList);
    }

    private SubComActivityDetailPlanItemVo getSubComDetailPlanVo(List<SubComActivityDetailPlanItemVo> planItemVoNewList) {
        if (CollectionUtil.isEmpty(planItemVoNewList)) {
            return null;
        }
        planItemVoNewList.sort(Comparator.comparing(SubComActivityDetailPlanItemVo::getSingleEstimatedCost).reversed());
        SubComActivityDetailPlanItemVo detailPlanItemVo = null;
        if (planItemVoNewList.size() > 1) {
            for (SubComActivityDetailPlanItemVo itemVo : planItemVoNewList) {
                if (!Objects.isNull(itemVo.getPromoteSalesUse()) && (!Objects.nonNull(itemVo.getPromoteSales()) || itemVo.getPromoteSales().compareTo(itemVo.getPromoteSalesUse()) <= 0)) continue;
                itemVo.setSingleBatch(true);
                detailPlanItemVo = itemVo;
                break;
            }
            if (Objects.isNull(detailPlanItemVo)) {
                detailPlanItemVo = planItemVoNewList.get(planItemVoNewList.size() - 1);
            }
        } else {
            detailPlanItemVo = planItemVoNewList.get(0);
        }
        return detailPlanItemVo;
    }

    public List<AuditFeeCheckDetailPlanVo> sonCompanyDetailPlanList(List<SubComActivityDetailPlanItemVo> detailPlanItemVoList) {
        ArrayList<AuditFeeCheckDetailPlanVo> result = new ArrayList<AuditFeeCheckDetailPlanVo>();
        if (CollectionUtil.isEmpty(detailPlanItemVoList)) {
            return result;
        }
        log.info("pos\u5339\u914d\u6d3b\u52a820");
        AuditFeeCheckActivityAmountSummaryVo summaryVo = this.fzDetailPlanItemAmountSummaryForVertical(detailPlanItemVoList);
        List detailedForecastVoList = summaryVo.getDetailedForecastVoList();
        for (SubComActivityDetailPlanItemVo fzDetailPlanVo : detailPlanItemVoList) {
            Optional<DetailedForecastVo> detailedForecastVo = detailedForecastVoList.stream().filter(o -> fzDetailPlanVo.getConstituentDetailPlanItemCode().equals(o.getActivityDetailItemCode())).findAny();
            AuditFeeCheckDetailPlanVo feeCheckDetailPlanVo = new AuditFeeCheckDetailPlanVo();
            feeCheckDetailPlanVo.setDetailPlanItemCode(fzDetailPlanVo.getConstituentDetailPlanItemCode());
            feeCheckDetailPlanVo.setDetailPlanCode(fzDetailPlanVo.getConstituentDetailPlanCode());
            feeCheckDetailPlanVo.setDetailPlanName(fzDetailPlanVo.getConstituentDetailPlanName());
            feeCheckDetailPlanVo.setActivityYearMonth(DateUtil.format((Date)fzDetailPlanVo.getFeeYearMonth(), (String)"yyyy-MM"));
            feeCheckDetailPlanVo.setActivityBeginDate(fzDetailPlanVo.getActivityBeginTime());
            feeCheckDetailPlanVo.setActivityEndDate(fzDetailPlanVo.getActivityEndTime());
            feeCheckDetailPlanVo.setActivityTypeCode(fzDetailPlanVo.getActivityType());
            feeCheckDetailPlanVo.setActivityTypeName(fzDetailPlanVo.getActivityTypeName());
            feeCheckDetailPlanVo.setActivityFormCode(fzDetailPlanVo.getActivityFormCode());
            feeCheckDetailPlanVo.setActivityFormName(fzDetailPlanVo.getActivityFormName());
            feeCheckDetailPlanVo.setTerminalCode(fzDetailPlanVo.getTerminalCode());
            feeCheckDetailPlanVo.setTerminalName(fzDetailPlanVo.getTerminalName());
            feeCheckDetailPlanVo.setProductCode(fzDetailPlanVo.getProductCode());
            feeCheckDetailPlanVo.setProductName(fzDetailPlanVo.getProductName());
            feeCheckDetailPlanVo.setSystemCode(fzDetailPlanVo.getResaleCommercialCode());
            feeCheckDetailPlanVo.setSystemName(fzDetailPlanVo.getResaleCommercialName());
            feeCheckDetailPlanVo.setWriteOffMethod(fzDetailPlanVo.getAuditType());
            feeCheckDetailPlanVo.setAuditForm(fzDetailPlanVo.getAuditForm());
            feeCheckDetailPlanVo.setApplyAmount(fzDetailPlanVo.getTotalCost());
            feeCheckDetailPlanVo.setIsPos(BooleanEnum.TRUE.getCapital());
            detailedForecastVo.ifPresent(o -> {
                feeCheckDetailPlanVo.setPredictionAuditAmount(o.getEstimatedWriteOffAmount());
                feeCheckDetailPlanVo.setAuditFeeCheckShareAmount(o.getEstimatedWriteOffAmount());
            });
            detailedForecastVo.ifPresent(o -> feeCheckDetailPlanVo.setPredictionAuditAmount(o.getEstimatedWriteOffAmount()));
            feeCheckDetailPlanVo.setApplyAmount(fzDetailPlanVo.getTotalCost());
            feeCheckDetailPlanVo.setDetailPlanName(fzDetailPlanVo.getConstituentDetailPlanName());
            BigDecimal alreadyAuditAmount = Optional.ofNullable(fzDetailPlanVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
            feeCheckDetailPlanVo.setAlreadyAuditAmount(alreadyAuditAmount);
            BigDecimal preAuditAmount = Optional.ofNullable(feeCheckDetailPlanVo.getPredictionAuditAmount()).orElse(BigDecimal.ZERO);
            feeCheckDetailPlanVo.setCanAuditAmount(preAuditAmount.subtract(alreadyAuditAmount));
            feeCheckDetailPlanVo.setPredictionAuditAmount(feeCheckDetailPlanVo.getPredictionAuditAmount());
            result.add(feeCheckDetailPlanVo);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveResult(List<AuditFeeCheckPosVo> updatePosList, List<AuditFeeCheckDetailPlanVo> detailPlanVos) {
        if (CollectionUtil.isNotEmpty(updatePosList)) {
            log.info("POS\u5339\u914d\u6d3b\u52a824");
            Collection auditFeeCheckPos = this.nebulaToolkitService.copyCollectionByWhiteList(updatePosList, AuditFeeCheckPosVo.class, AuditFeeCheckPos.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeCheckPosRepository.updateBatchById(auditFeeCheckPos);
        }
        if (CollectionUtil.isNotEmpty(detailPlanVos)) {
            log.info("POS\u5339\u914d\u6d3b\u52a823");
            this.auditFeeCheckDetailPlanVoService.createBatch(detailPlanVos);
        }
    }

    private AuditFeeCheckActivityAmountSummaryVo detailPlanItemAmountSummaryForVertical(List<ActivityDetailPlanItemVo> detailPlanItemList) {
        AuditFeeCheckActivityAmountSummaryVo result = new AuditFeeCheckActivityAmountSummaryVo();
        result.setTotalEstimateWriteOffAmount(BigDecimal.ZERO);
        result.setTotalFeeAmount(BigDecimal.ZERO);
        result.setDetailedForecastVoList(Collections.emptyList());
        if (CollectionUtil.isEmpty(detailPlanItemList)) {
            return result;
        }
        result.setTotalFeeAmount(detailPlanItemList.stream().filter(k -> Objects.nonNull(k.getTotalFeeAmount())).map(ActivityDetailPlanItemBase::getTotalFeeAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        Set detailPlanItemCodeSet = detailPlanItemList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getDetailPlanItemCode())).map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(detailPlanItemCodeSet)) {
            return result;
        }
        List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodeSet);
        if (CollectionUtil.isEmpty((Collection)detailedForecastVoList)) {
            return result;
        }
        result.setTotalEstimateWriteOffAmount(detailedForecastVoList.stream().filter(k -> Objects.nonNull(k.getEstimatedWriteOffAmount())).map(DetailedForecastVo::getEstimatedWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        result.setDetailedForecastVoList(detailedForecastVoList);
        return result;
    }

    private AuditFeeCheckActivityAmountSummaryVo fzDetailPlanItemAmountSummaryForVertical(List<SubComActivityDetailPlanItemVo> detailPlanItemList) {
        AuditFeeCheckActivityAmountSummaryVo result = new AuditFeeCheckActivityAmountSummaryVo();
        result.setTotalEstimateWriteOffAmount(BigDecimal.ZERO);
        result.setTotalFeeAmount(BigDecimal.ZERO);
        result.setDetailedForecastVoList(Collections.emptyList());
        if (CollectionUtil.isEmpty(detailPlanItemList)) {
            return result;
        }
        result.setTotalFeeAmount(detailPlanItemList.stream().filter(k -> Objects.nonNull(k.getTotalCost())).map(SubComActivityDetailPlanItemVo::getTotalCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        Set detailPlanItemCodeSet = detailPlanItemList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getConstituentDetailPlanItemCode())).map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(detailPlanItemCodeSet)) {
            return result;
        }
        List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodeSet);
        if (CollectionUtil.isEmpty((Collection)detailedForecastVoList)) {
            return result;
        }
        result.setTotalEstimateWriteOffAmount(detailedForecastVoList.stream().filter(k -> Objects.nonNull(k.getEstimatedWriteOffAmount())).map(DetailedForecastVo::getEstimatedWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        result.setDetailedForecastVoList(detailedForecastVoList);
        return result;
    }
}

