/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import com.biz.crm.kms.business.audit.fee.sdk.vo.AuditFeeRespVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.GenerateAuditFeeCheckCostAsyncHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateConditionEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingCustomerVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingTextVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.MD5Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenerateAuditFeeCheckCostAsync {
    private static final Logger log = LoggerFactory.getLogger(GenerateAuditFeeCheckCostAsync.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmDeductionDetailMappingService deductionDetailMappingService;
    @Autowired(required=false)
    private AuditFeeCostService auditFeeCostService;
    @Autowired(required=false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;
    @Autowired(required=false)
    private GenerateAuditFeeCheckCostAsyncHelper generateAuditFeeCheckCostAsyncHelper;

    @Transactional(rollbackFor={Exception.class})
    public void generateForCostOrder(AuditFeeMatchDto auditFeeMatchDto, TpmDeductionMatchingTemplateVo feeMatchTemplate, AbstractCrmUserIdentity abstractLoginUser) {
        this.generateForCostOrderAsync(auditFeeMatchDto, feeMatchTemplate, abstractLoginUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="auditFeeThread")
    public void generateForCostOrderAsync(AuditFeeMatchDto auditFeeMatchDto, TpmDeductionMatchingTemplateVo feeMatchTemplate, AbstractCrmUserIdentity abstractLoginUser) {
        this.loginUserService.refreshAuthentication((Object)abstractLoginUser);
        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6838\u5bf9\u4e3b\u6570\u636e:{}", (Object)JSON.toJSONString((Object)auditFeeMatchDto));
        ArrayList<AuditFeeRespVo> respVoList = new ArrayList<AuditFeeRespVo>();
        HashSet<String> costUniqueKeySet = new HashSet<String>();
        String redisLockKey = "audit_fee_pull_kms:lock:" + feeMatchTemplate.getCode() + ":" + feeMatchTemplate.getName();
        boolean hasLock = false;
        try {
            List customerErpCodeList;
            hasLock = this.redisLockService.tryLock(redisLockKey, TimeUnit.MINUTES, 15L);
            if (!hasLock) {
                throw new RuntimeException("\u6b63\u5728\u4f7f\u7528\u6a21\u677f\u3010" + redisLockKey + "\u3011\u62c9\u53d6\u6570\u636e\uff0c\u8bf7\u7b49\u5f85");
            }
            List feeAllowances = feeMatchTemplate.getFeeAllowances();
            if (CollectionUtils.isEmpty((Collection)feeAllowances)) {
                log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f\u5bb9\u5dee\u4e2a\u6570\u4e3a0\u4e0d\u62c9\u53d6\u6570\u636e");
                return;
            }
            AtomicInteger totalTasks = new AtomicInteger(0);
            AtomicInteger currentTasks = new AtomicInteger(0);
            Map feeAllowanceMap = feeAllowances.stream().collect(Collectors.toMap(e -> e.getDataSource() + "_" + e.getApplyBusinessAreaCode(), Function.identity(), (a, b) -> a));
            log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f\u53bb\u91cd\u5bb9\u5dee:{}\u4e2a\u6570:{}", (Object)JSON.toJSONString(feeAllowanceMap.keySet()), (Object)feeAllowanceMap.size());
            AuditFeeReqDto auditFeeReqDto = new AuditFeeReqDto();
            auditFeeReqDto.setCostIsMatch(AuditFeeMatchStatusEnum.WITH.getCode());
            auditFeeReqDto.setWithoutTime(true);
            auditFeeReqDto.setDeliveryPartyCode(auditFeeMatchDto.getTerminalCode());
            auditFeeReqDto.setOrderDateBegin(DateUtil.formatDate((Date)auditFeeMatchDto.getStartTime()));
            auditFeeReqDto.setOrderDateEnd(DateUtil.formatDate((Date)auditFeeMatchDto.getEndTime()));
            auditFeeReqDto.setBusinessUnitCode(feeMatchTemplate.getBusinessUnitCode());
            auditFeeReqDto.setBusinessFormatCode(feeMatchTemplate.getBusinessFormatCode());
            if (StringUtils.isEmpty((CharSequence)feeMatchTemplate.getApplyMappingCode())) {
                throw new IllegalArgumentException("\u6a21\u677f[" + feeMatchTemplate.getName() + "]\u5546\u8d85\u6620\u5c04\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            List mappingVoList = this.deductionDetailMappingService.findByCodes((List)Lists.newArrayList((Object[])new String[]{feeMatchTemplate.getApplyMappingCode()}));
            if (CollectionUtils.isEmpty((Collection)mappingVoList)) {
                throw new IllegalArgumentException("\u6a21\u677f[" + feeMatchTemplate.getName() + "]\u5546\u8d85\u6620\u5c04\u6570\u636e\u4e0d\u5b58\u5728");
            }
            TpmDeductionDetailMappingVo mappingVo = (TpmDeductionDetailMappingVo)mappingVoList.get(0);
            auditFeeReqDto.setCustomerRetailerCode(mappingVo.getResaleCommercialCode());
            if (StringUtils.isNotBlank((CharSequence)mappingVo.getSalesInstitutionCode())) {
                auditFeeReqDto.setSalesOrgCode(mappingVo.getSalesInstitutionCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)mappingVo.getDeductionDetailMappingTextList())) {
                auditFeeReqDto.setDeductionNameList(mappingVo.getDeductionDetailMappingTextList().stream().map(TpmDeductionDetailMappingTextVo::getText).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)mappingVo.getCustomerList()) && CollectionUtils.isNotEmpty(customerErpCodeList = mappingVo.getCustomerList().stream().map(TpmDeductionDetailMappingCustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                auditFeeReqDto.setSoldToPartyCodeList(customerErpCodeList);
            }
            String templateInfoStr = feeMatchTemplate.getName() + feeMatchTemplate.getCode();
            String mappingStr = feeMatchTemplate.getApplyMappingName() + feeMatchTemplate.getApplyMappingCode();
            for (TpmDeductionMatchingTemplateAllowanceVo allowanceVo : feeAllowanceMap.values()) {
                String dataSource = allowanceVo.getDataSource();
                auditFeeReqDto.setDataSource(dataSource);
                String applyBusinessAreaCode = allowanceVo.getApplyBusinessAreaCode();
                String[] areaArray = null;
                areaArray = StringUtils.isBlank((CharSequence)applyBusinessAreaCode) ? new String[]{null} : applyBusinessAreaCode.split(",");
                log.info("\u62c9\u53d6\u8d39\u7528\u5355-\u5f53\u524d\u5bb9\u5dee:{}", (Object)JSON.toJSONString((Object)allowanceVo));
                log.info("\u62c9\u53d6\u8d39\u7528\u5355-\u533a\u57df\u6570\u7ec4:{}", (Object)JSON.toJSONString((Object)areaArray));
                for (String areaCode : areaArray) {
                    auditFeeReqDto.setBusinessArea(areaCode);
                    log.info("\u62c9\u53d6\u8d39\u7528\u5355\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)auditFeeReqDto));
                    Pageable pageable = Pageable.ofSize((int)1);
                    Page costPages = this.auditFeeCostService.findByConditions(pageable, auditFeeReqDto);
                    int total = (int)costPages.getTotal();
                    log.info("\u4f7f\u7528\u6a21\u677f:{},\u6620\u5c04:{},\u5bb9\u5dee\u6570\u636e\u6765\u6e90{},\u8d39\u7528\u5355\u603b\u6761\u6570:{}", new Object[]{templateInfoStr, mappingStr, dataSource, total});
                    if (total <= 0) continue;
                    int pageSize = 400;
                    int pageNum = total / pageSize + 1;
                    totalTasks.addAndGet(pageNum);
                    for (int c = 1; c <= pageNum; ++c) {
                        PageRequest currentPage = PageRequest.of((int)c, (int)pageSize);
                        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6570\u636e\u6e90{} \u5f00\u59cb\u7b2c:{}\u9875", new Object[]{templateInfoStr, dataSource, c});
                        long kmsPageTimeUsed = this.getKMSPage(templateInfoStr, mappingStr, currentTasks, (Pageable)currentPage, auditFeeReqDto, respVoList);
                        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6570\u636e\u6e90{} \u5df2\u5b8c\u6210\u7b2c:{}\u9875 \u8017\u65f6{}", new Object[]{templateInfoStr, dataSource, c, kmsPageTimeUsed});
                        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6620\u5c04{}\u6570\u636e\u6e90{} \u7b2c{}\u9875\u540e\u5b58\u50a8{}\u6761", new Object[]{templateInfoStr, mappingStr, dataSource, c, respVoList.size()});
                        List<AuditFeeCheckCost> costList = this.convertToAuditFeeCheckCost(respVoList, allowanceVo, feeMatchTemplate, mappingVo);
                        respVoList.clear();
                        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6620\u5c04{}\u6570\u636e\u6e90{} \u7b2c{}\u9875\u540e\u552f\u4e00\u8ba1\u7b97\u5b8c\u6210", new Object[]{templateInfoStr, mappingStr, dataSource, c});
                        this.auditFeeCheckCostRepository.saveBatch(costList);
                        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6620\u5c04{}\u6570\u636e\u6e90{} \u7b2c{}\u9875\u540e\u5b58\u50a8\u5b8c\u6210", new Object[]{templateInfoStr, mappingStr, dataSource, c});
                        costUniqueKeySet.addAll(costList.stream().map(AuditFeeCheckCost::getMd5UniqueKey).filter(Objects::nonNull).collect(Collectors.toSet()));
                        costList.clear();
                        log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6620\u5c04{}\u6570\u636e\u6e90{} \u7b2c{}\u9875\u540e\u672c\u6279\u5904\u7406\u5b8c\u6210,\u552f\u4e00\u952e[{}]", new Object[]{templateInfoStr, mappingStr, dataSource, c, String.join((CharSequence)",", costUniqueKeySet)});
                    }
                }
                log.info("\u62c9\u53d6\u8d39\u7528\u5355\u6a21\u677f{}\u6620\u5c04{}\u6570\u636e\u6e90{}\u6570\u636e\u8f6c\u5b58\u5b8c\u6210", new Object[]{templateInfoStr, mappingStr, dataSource});
            }
            log.info("\u8d39\u5355\u83b7\u53d6\u5b8c\u6210,\u8d39\u5355\u603b\u4efb\u52a1\u6570:{},\u5df2\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6570:{}", (Object)totalTasks, (Object)currentTasks);
            List<AuditFeeCheck> newFeeCheckList = this.generateAuditFeeCheckCostAsyncHelper.doSummary(costUniqueKeySet, feeMatchTemplate, auditFeeReqDto, mappingVo);
            log.info("\u62c9\u53d6\u8d39\u7528\u5355 \u6a21\u677f{} \u751f\u6210\u6838\u5bf9\u603b\u6761\u6570:{}", (Object)templateInfoStr, (Object)JSON.toJSONString(newFeeCheckList));
        }
        catch (Exception e2) {
            log.error("\u8d39\u7528\u6838\u5bf9\u83b7\u53d6\u8d39\u7528\u5355\u6570\u636e\u5931\u8d25\uff01");
            log.error("", (Throwable)e2);
        }
        finally {
            if (hasLock) {
                log.info("\u62c9\u53d6\u6a21\u677f{}\u8d39\u7528\u5355\u5df2\u89e3\u9501", (Object)feeMatchTemplate.getName());
                this.redisLockService.unlock(redisLockKey);
            }
        }
    }

    private long getKMSPage(String template, String dataSource, AtomicInteger currentTasks, Pageable currentPage, AuditFeeReqDto auditFeeReqDto, List<AuditFeeRespVo> respVoList) {
        long timeUsed = 0L;
        try {
            long before = System.currentTimeMillis();
            Page costPages = this.auditFeeCostService.findByConditions(currentPage, auditFeeReqDto);
            timeUsed = System.currentTimeMillis() - before;
            List records = costPages.getRecords();
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                List amounts = records.stream().map(AuditFeeRespVo::getAmount).collect(Collectors.toList());
                log.info("\u83b7\u53d6\u8d39\u7528\u6570\u636e\u91d1\u989d:{}", (Object)JSON.toJSONString(amounts));
                records = records.stream().filter(e -> e.getAmount() != null && !BigDecimal.ZERO.equals(e.getAmount())).collect(Collectors.toList());
                respVoList.addAll(records);
                currentTasks.getAndIncrement();
            }
        }
        catch (Exception e2) {
            log.info("\u8d39\u7528\u6838\u5bf9\u83b7\u53d6\u8d39\u7528\u5355\u6570\u636e\u5931\u8d25!,[\u5f53\u524d\u6a21\u677f:{},\u6570\u636e\u6e90:{},\u5f53\u524d\u9875:{}, \u9519\u8bef{}]", new Object[]{template, dataSource, currentPage.getPageNumber(), e2.getMessage()});
            throw e2;
        }
        return timeUsed;
    }

    private List<AuditFeeCheckCost> convertToAuditFeeCheckCost(List<AuditFeeRespVo> respVoList, TpmDeductionMatchingTemplateAllowanceVo allowanceVo, TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo) {
        if (CollectionUtils.isEmpty(respVoList)) {
            return new ArrayList<AuditFeeCheckCost>(0);
        }
        ArrayList<AuditFeeCheckCost> costList = new ArrayList<AuditFeeCheckCost>();
        for (AuditFeeRespVo respVo : respVoList) {
            AuditFeeCheckCost cost = this.auditFeeCheckCostRepository.initOne();
            costList.add(cost);
            cost.setAuditFeeCheckCode("");
            cost.setBusinessFormatCode(respVo.getBusinessFormatCode());
            cost.setBusinessUnitCode(respVo.getBusinessUnitCode());
            cost.setBusinessArea(respVo.getBusinessArea());
            cost.setCustomerRetailerCode(respVo.getCustomerRetailerCode());
            cost.setCustomerRetailerName(respVo.getCustomerRetailerName());
            cost.setProvinceCode(respVo.getProvinceCode());
            cost.setProvinceName(respVo.getProvinceName());
            cost.setSoldToPartyCode(respVo.getSoldToPartyCode());
            cost.setSoldToPartyName(respVo.getSoldToPartyName());
            cost.setDeliveryPartyCode(respVo.getDeliveryPartyCode());
            cost.setDeliveryPartyName(respVo.getDeliveryPartyName());
            cost.setProductCode(respVo.getProductCode());
            cost.setProductName(respVo.getProductName());
            cost.setSlotDateName(respVo.getSlotDateName());
            cost.setActualYearMonth(DateUtil.format((Date)respVo.getCreateTime(), (String)"yyyy-MM"));
            cost.setOrderDate(respVo.getOrderDate());
            if (StringUtils.isNotBlank((CharSequence)respVo.getOrderDate())) {
                cost.setOrderYearMonth(DateUtil.format((Date)DateUtil.parseDate((CharSequence)respVo.getOrderDate()), (String)"yyyy-MM"));
            }
            cost.setAuditWay(respVo.getAuditWay());
            cost.setCashingType(respVo.getCashingType());
            cost.setDeductionAmountTax(respVo.getAmount());
            cost.setSalesOrgCode(respVo.getSalesOrgCode());
            cost.setSalesOrgName(respVo.getSalesOrgName());
            cost.setRemark(respVo.getRemark());
            cost.setDataSource(respVo.getDataSource());
            cost.setCompanyCostCode(respVo.getTpmDeductionCode());
            cost.setDeductionCode(respVo.getDeductionCode());
            cost.setDeductionName(respVo.getDeductionName());
            cost.setAllowanceKey(allowanceVo.getDeductionUniqueKey());
            cost.setActivityFormDesc(respVo.getActivityFormDesc());
            this.generateCostSummaryUnique(cost, templateVo, mappingVo);
        }
        return costList;
    }

    public void generateCostSummaryUnique(AuditFeeCheckCost cost, TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo) {
        List deductionDetailMappingTextCodeList;
        List customerCodeList;
        StringBuilder keyBuilder = new StringBuilder();
        String separator = "_";
        keyBuilder.append(cost.getBusinessUnitCode());
        keyBuilder.append(separator).append(cost.getBusinessFormatCode());
        List<String> dimensionList = Arrays.asList(templateVo.getFeeMatchingCondition().split(","));
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.PRODUCT_CODE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getProductCode()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.TERMINAL_CODE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getDeliveryPartyCode()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getOrderYearMonth()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.FEE_CODE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getCompanyCostCode()).split("-")[0]);
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.FEE_ITEM_CODE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getCompanyCostCode()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.PROVINCE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getProvinceCode()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.AREA_CODE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getBusinessArea()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.SCHEDULE.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getSlotDateName()));
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.CHANNEL.getCode())) {
            // empty if block
        }
        if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.ACTIVITY_FORM_DESC.getCode())) {
            keyBuilder.append(separator).append(this.ifNull(cost.getActivityFormDesc()));
        }
        keyBuilder.append(separator).append(this.ifNull(cost.getDataSource()));
        keyBuilder.append(separator).append(this.ifNull(mappingVo.getSalesInstitutionErpCode()));
        keyBuilder.append(separator).append(this.ifNull(cost.getCustomerRetailerCode()));
        if (CollectionUtils.isNotEmpty((Collection)mappingVo.getCustomerList()) && CollectionUtils.isNotEmpty(customerCodeList = mappingVo.getCustomerList().stream().sorted(Comparator.comparing(TpmDeductionDetailMappingCustomerVo::getCustomerCode)).map(TpmDeductionDetailMappingCustomerVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList()))) {
            String customerCodeListStr = String.join((CharSequence)separator, customerCodeList);
            keyBuilder.append(separator).append(this.ifNull(customerCodeListStr));
        }
        if (CollectionUtils.isNotEmpty((Collection)mappingVo.getDeductionDetailMappingTextList()) && CollectionUtils.isNotEmpty(deductionDetailMappingTextCodeList = mappingVo.getDeductionDetailMappingTextList().stream().sorted(Comparator.comparing(TpmDeductionDetailMappingTextVo::getCode)).map(TpmDeductionDetailMappingTextVo::getCode).filter(Objects::nonNull).collect(Collectors.toList()))) {
            String deductionDetailMappingTextCodeListStr = String.join((CharSequence)separator, deductionDetailMappingTextCodeList);
            keyBuilder.append(separator).append(this.ifNull(deductionDetailMappingTextCodeListStr));
        }
        cost.setMd5UniqueKey(MD5Util.computeMD5((String)keyBuilder.toString()));
    }

    private String ifNull(String s) {
        return s == null ? "" : s;
    }
}

