/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDiffRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.KMSFeeUpdateAsync;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateConditionEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenerateAuditFeeCheckCostAsyncHelper {
    private static final Logger log = LoggerFactory.getLogger(GenerateAuditFeeCheckCostAsyncHelper.class);
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private AuditFeeCheckRepository auditFeeCheckRepository;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanRepository auditFeeCheckDetailPlanRepository;
    @Autowired(required=false)
    private AuditFeeCheckDiffRepository auditFeeCheckDiffRepository;
    @Autowired(required=false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private KMSFeeUpdateAsync kmsFeeUpdateAsync;

    @Transactional(rollbackFor={Exception.class})
    public List<AuditFeeCheck> doSummary(Set<String> costUniqueKeySet, TpmDeductionMatchingTemplateVo feeMatchTemplate, AuditFeeReqDto auditFeeReqDto, TpmDeductionDetailMappingVo mappingVo) {
        if (CollectionUtils.isEmpty(costUniqueKeySet)) {
            return new ArrayList<AuditFeeCheck>(0);
        }
        log.info("\u6a21\u677f\u7f16\u53f7{}\u62c9\u53d6\u8d39\u7528\u5355\u5f00\u59cb\u6c47\u603b\u6570\u636e", (Object)feeMatchTemplate.getCode());
        this.removeUnconfirmedAuditFeeCheck(feeMatchTemplate);
        this.auditFeeCheckCostRepository.deleteUsedCosts(Lists.newArrayList(costUniqueKeySet));
        List<String> dimensionList = Arrays.asList(feeMatchTemplate.getFeeMatchingCondition().split(","));
        ArrayList<AuditFeeCheck> feeCheckList = new ArrayList<AuditFeeCheck>();
        for (String uniqueKey : costUniqueKeySet) {
            int diffAmount;
            AuditFeeCheckCost costOne = this.auditFeeCheckCostRepository.findOneByMd5UniqueKey(uniqueKey);
            AuditFeeCheckCost sumOne = this.auditFeeCheckCostRepository.findSumAmountByMd5UniqueKey(uniqueKey);
            if (costOne == null || sumOne == null) continue;
            BigDecimal deductionAmountTax = sumOne.getDeductionAmountTax();
            log.info("\u6a21\u677f\u7f16\u53f7{}\u6c47\u603b\u6570\u636eMD5Key{} \u5bf9\u5e94\u7684\u6570\u636e\u5b58\u5728", (Object)feeMatchTemplate.getCode(), (Object)uniqueKey);
            AuditFeeCheck feeCheck = this.auditFeeCheckRepository.initOne();
            feeCheck.setBusinessFormatCode(costOne.getBusinessFormatCode());
            feeCheck.setBusinessUnitCode(costOne.getBusinessUnitCode());
            if (dimensionList.contains(DeductionMatchingTemplateConditionEnum.AREA_CODE.getCode())) {
                feeCheck.setAreaCode(costOne.getBusinessArea());
            }
            if (null != costOne.getActualYearMonth()) {
                feeCheck.setActualYearMonth(costOne.getActualYearMonth());
            }
            if (null != costOne.getOrderYearMonth()) {
                feeCheck.setOrderYearMonthStr(costOne.getOrderYearMonth());
            }
            if (null != costOne.getOrderYearMonth()) {
                feeCheck.setOrderYearMonth((Date)DateUtil.parse((CharSequence)costOne.getOrderYearMonth(), (String)"yyyy-MM"));
            }
            if (null != costOne.getOrderDate()) {
                feeCheck.setOrderDate((Date)DateUtil.parse((CharSequence)costOne.getOrderDate(), (String)"yyyy-MM-dd"));
            }
            feeCheck.setCustomerRetailerCode(costOne.getCustomerRetailerCode());
            feeCheck.setCustomerRetailerName(costOne.getCustomerRetailerName());
            feeCheck.setTerminalCode(costOne.getDeliveryPartyCode());
            feeCheck.setTerminalName(costOne.getDeliveryPartyName());
            feeCheck.setCustomerErpCode(costOne.getSoldToPartyCode());
            feeCheck.setCustomerName(costOne.getSoldToPartyName());
            feeCheck.setProvinceCode(costOne.getProvinceCode());
            feeCheck.setProvinceName(costOne.getProvinceName());
            feeCheck.setProductCode(costOne.getProductCode());
            feeCheck.setProductName(costOne.getProductName());
            feeCheck.setMd5UniqueKey(costOne.getMd5UniqueKey());
            feeCheck.setAllowanceKey(costOne.getAllowanceKey());
            feeCheck.setMatchTemplateCode(feeMatchTemplate.getCode());
            feeCheck.setMatchTemplateName(feeMatchTemplate.getName());
            feeCheck.setMatchTemplateType(feeMatchTemplate.getDeductionMatchingTemplateType());
            feeCheck.setSalesOrgCode(costOne.getSalesOrgCode());
            feeCheck.setSalesOrgName(costOne.getSalesOrgName());
            feeCheck.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
            feeCheck.setIsConfirm(BooleanEnum.FALSE.getCapital());
            feeCheck.setIsConfirmDiff(BooleanEnum.FALSE.getCapital());
            feeCheck.setMatchCode((String)this.generateCodeService.generateCode("KF", 1).get(0));
            feeCheck.setCostDeductionAmount(deductionAmountTax);
            feeCheck.setCostDetailDiffAmount(feeCheck.getCostDeductionAmount());
            feeCheck.setDiffConfirmAmount(feeCheck.getCostDetailDiffAmount());
            feeCheck.setIsAddUp(feeMatchTemplate.getIsAddUpMapping());
            feeCheck.setDataSource(costOne.getDataSource());
            feeCheck.setActivityFormDesc(costOne.getActivityFormDesc());
            if (mappingVo != null && CollectionUtils.isNotEmpty((Collection)mappingVo.getDeductionDetailMappingRelationActivityConfigList())) {
                TpmDeductionDetailMappingRelationActivityConfigVo activityConfigVo = (TpmDeductionDetailMappingRelationActivityConfigVo)mappingVo.getDeductionDetailMappingRelationActivityConfigList().get(0);
                feeCheck.setActivityTypeCode(activityConfigVo.getActivityTypeCode());
                feeCheck.setActivityTypeName(activityConfigVo.getActivityTypeName());
            }
            if ((diffAmount = feeCheck.getDiffConfirmAmount().compareTo(BigDecimal.ZERO)) == 0) {
                feeCheck.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
            }
            if (diffAmount > 0) {
                feeCheck.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
            }
            if (diffAmount < 0) {
                feeCheck.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
            }
            log.info("\u6a21\u677f\u7f16\u53f7{}\u6c47\u603b\u6570\u636eMD5Key{} \u5bf9\u5e94\u7684\u6570\u636e{}", new Object[]{feeMatchTemplate.getCode(), uniqueKey, JSON.toJSONString((Object)((Object)feeCheck))});
            this.auditFeeCheckCostRepository.updateMatchedByMd5UniqueKey(uniqueKey, feeCheck.getMatchCode());
            feeCheckList.add(feeCheck);
        }
        this.auditFeeCheckRepository.saveBatch(feeCheckList);
        log.info("\u6a21\u677f\u7f16\u53f7{}\u62c9\u53d6\u8d39\u7528\u5355\u6c47\u603b\u6570\u636e\u5b8c\u6210\u6c47\u603b\u53ca\u5199\u5165", (Object)feeMatchTemplate.getCode());
        return feeCheckList;
    }

    private void removeUnconfirmedAuditFeeCheck(TpmDeductionMatchingTemplateVo template) {
        if (template == null) {
            return;
        }
        List<AuditFeeCheck> feeChecks = this.auditFeeCheckRepository.findNotConfirmedDiff(template.getCode());
        if (CollectionUtils.isNotEmpty(feeChecks)) {
            List<String> matchCodes = feeChecks.stream().map(AuditFeeCheck::getMatchCode).distinct().collect(Collectors.toList());
            this.deleteByMatchCodes(matchCodes);
        }
        log.info("\u6a21\u677f\u7f16\u53f7{}\u62c9\u53d6\u8d39\u7528\u5355\u5df2\u6e05\u7406\u672a\u786e\u8ba4\u6570\u636e", (Object)template.getCode());
    }

    public void updateKMSStatus(List<String> tpmDeductionCodeList, String costIsMatch) {
        if (CollectionUtils.isEmpty(tpmDeductionCodeList)) {
            return;
        }
        if (!AuditFeeMatchStatusEnum.CONFIRM.getCode().equals(costIsMatch)) {
            return;
        }
        AuditFeeReqDto reqDto = new AuditFeeReqDto();
        reqDto.setTpmDeductionCodeList(tpmDeductionCodeList);
        reqDto.setCostIsMatch(costIsMatch);
        AuditFeeCheckCost cost = this.auditFeeCheckCostRepository.findByCompanyCode(tpmDeductionCodeList.get(0));
        reqDto.setDataSource(cost.getDataSource());
        log.info("\u8d39\u7528\u6838\u5bf9-\u66f4\u65b0KMS\u8d39\u7528\u5355\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.kmsFeeUpdateAsync.updateKMSStatusAsync(reqDto);
    }

    @Transactional
    public void deleteByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        matchCodes = matchCodes.stream().distinct().collect(Collectors.toList());
        this.auditFeeCheckRepository.updateDelFlagByMatchCodes(matchCodes);
        this.auditFeeCheckCostRepository.updateDelFlagByMatchCodes(matchCodes);
        this.auditFeeCheckDetailPlanRepository.updateDelFlagByMatchCodes(matchCodes);
        this.auditFeeCheckDiffRepository.updateDelFlagByMatchCodes(matchCodes);
        this.cancelRelatePos(matchCodes);
    }

    @Transactional
    public void cancelByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        this.auditFeeCheckDetailPlanRepository.updateDelFlagByMatchCodes(matchCodes);
        this.auditFeeCheckDiffRepository.updateDelFlagByMatchCodes(matchCodes);
        this.cancelRelatePos(matchCodes);
    }

    private void cancelRelatePos(List<String> matchCodes) {
        List<AuditFeeCheckPos> posList = this.auditFeeCheckPosRepository.findByFeeCheckMatchCodes(matchCodes);
        if (CollectionUtils.isNotEmpty(posList)) {
            ArrayList<String> posIdList = new ArrayList<String>(posList.size());
            for (AuditFeeCheckPos pos : posList) {
                pos.setIsMatchCost(BooleanEnum.FALSE.getCapital());
                pos.setSharePromotionDeduction(BigDecimal.ZERO);
                pos.setFeeCheckMatchCode(null);
                posIdList.add(pos.getId());
            }
            this.auditFeeCheckPosRepository.updateBatchById(posList);
            this.auditFeeCheckPosRepository.computeTotalDiffAmount(posIdList);
        }
    }
}

