/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckCostRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckPosRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.ConditionsEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenerateAuditFeeCheckMatchFeeAsync {
    private static final Logger log = LoggerFactory.getLogger(GenerateAuditFeeCheckMatchFeeAsync.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private AuditFeeCheckPosRepository auditFeeCheckPosRepository;
    @Autowired(required=false)
    private AuditFeeCheckCostRepository auditFeeCheckCostRepository;

    @Transactional(rollbackFor={Exception.class})
    public List<AuditFeeCheckPos> matchFeePos(AuditFeeCheckVo feeCheckVo, TpmDeductionMatchingTemplateVo templateVo, TpmDeductionMatchingTemplateAllowanceVo allowanceVo, AbstractCrmUserIdentity abstractLoginUser) {
        Page<AuditFeeCheckPosVo> posPage;
        log.info("\u8d39\u5355\u5339POS \u6838\u5bf9\u6570\u636e:{} \u6a21\u677f\uff1a{} \u5bb9\u5dee\uff1a{}", new Object[]{feeCheckVo, templateVo, allowanceVo});
        this.loginUserService.refreshAuthentication((Object)abstractLoginUser);
        log.info("\u8d39\u5355\u5339pos2");
        String failReasonStr = "";
        BigDecimal costDeductionAmount = feeCheckVo.getCostDeductionAmount();
        if (costDeductionAmount == null) {
            failReasonStr = failReasonStr.concat("\u805a\u5408\u6570\u636e\u8d39\u7528\u542b\u7a0e\u91d1\u989d\u7a7a;");
        }
        if (Objects.isNull(templateVo) || StringUtils.isBlank((CharSequence)templateVo.getFeeMatchingCondition())) {
            failReasonStr = failReasonStr.concat("\u6a21\u677f\u6216\u6a21\u677f\u5339\u914d\u6761\u4ef6\u7a7a;");
        }
        if (!DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(templateVo.getDeductionMatchingTemplateType())) {
            failReasonStr = failReasonStr.concat("\u6a21\u677f\u7c7b\u578b\u975epos;");
        }
        log.info("\u8d39\u5355\u5339pos3");
        if (Objects.isNull(allowanceVo)) {
            failReasonStr = failReasonStr.concat("\u6a21\u677f\u5bb9\u5dee\u7a7a;");
        }
        AuditFeeCheckPosDto posQueryDto = new AuditFeeCheckPosDto();
        posQueryDto.setBusinessFormatCode(feeCheckVo.getBusinessFormatCode());
        posQueryDto.setBusinessUnitCode(feeCheckVo.getBusinessUnitCode());
        posQueryDto.setSalesInstitutionCode(feeCheckVo.getSalesOrgCode());
        posQueryDto.setCustomerRetailerCode(feeCheckVo.getCustomerRetailerCode());
        posQueryDto.setIsMatchCost(BooleanEnum.FALSE.getCapital());
        posQueryDto.setIsMatchActivity(BooleanEnum.TRUE.getCapital());
        posQueryDto.setTenantCode(TenantUtils.getTenantCode());
        String[] conditions = templateVo.getFeeMatchingCondition().split(",");
        StringBuilder falseReason = new StringBuilder();
        block7: for (String condition : conditions) {
            ConditionsEnum conditionsEnum = ConditionsEnum.codeToEnum((String)condition);
            if (ConditionsEnum.EMPTY.equals((Object)conditionsEnum)) continue;
            switch (conditionsEnum) {
                case PRODUCT_CODE: {
                    if (!StringUtils.isBlank((CharSequence)feeCheckVo.getProductCode())) {
                        posQueryDto.setProductCode(feeCheckVo.getProductCode());
                        continue block7;
                    }
                    falseReason.append("\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a;");
                    continue block7;
                }
                case TERMINAL_CODE: {
                    if (!StringUtils.isBlank((CharSequence)feeCheckVo.getTerminalCode())) {
                        posQueryDto.setTerminalCode(feeCheckVo.getTerminalCode());
                        continue block7;
                    }
                    falseReason.append("\u9001\u8fbe\u65b9\u7f16\u7801/\u95e8\u5e97\u7f16\u7801;");
                    continue block7;
                }
                case YEAR_MONTH: {
                    if (feeCheckVo.getOrderYearMonth() == null) {
                        falseReason.append("\u5355\u636e\u65e5\u671f\u4e3a\u7a7a;");
                        continue block7;
                    }
                    if (!TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue().equals(allowanceVo.getTimeAllowanceUnit())) {
                        falseReason.append("\u65f6\u95f4\u5bb9\u5dee\u5355\u4f4d\u9519\u8bef;");
                        continue block7;
                    }
                    String timeAllowanceType = allowanceVo.getTimeAllowanceType();
                    Integer timeAllowanceValue = allowanceVo.getTimeAllowanceValue();
                    if (timeAllowanceType == null || timeAllowanceValue == null) {
                        falseReason.append("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u914d\u7f6e\u9519\u8bef;");
                        continue block7;
                    }
                    Date orderDate = feeCheckVo.getOrderDate();
                    if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE.getValue().equals(timeAllowanceType)) {
                        posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, 0, true));
                        posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                        continue block7;
                    }
                    if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE_POINT.getValue().equals(timeAllowanceType)) {
                        posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, timeAllowanceValue, true));
                        posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                        continue block7;
                    }
                    if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE.getValue().equals(timeAllowanceType)) {
                        posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                        posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, 0, false));
                        continue block7;
                    }
                    if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE_POINT.getValue().equals(timeAllowanceType)) {
                        posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                        posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), false));
                        continue block7;
                    }
                    if (TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue().equals(timeAllowanceType)) {
                        posQueryDto.setSalesDateBegin(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                        posQueryDto.setSalesDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                        continue block7;
                    }
                    falseReason.append("\u65f6\u95f4\u5bb9\u5dee\u7c7b\u578b\u9519\u8bef;");
                    continue block7;
                }
                case PROVINCE: {
                    if (!StringUtils.isBlank((CharSequence)feeCheckVo.getProvinceCode())) {
                        posQueryDto.setProvinceCode(feeCheckVo.getProvinceCode());
                        continue block7;
                    }
                    falseReason.append("\u7701\u7f16\u7801\u4e3a\u7a7a;");
                    continue block7;
                }
                case AREA_CODE: {
                    if (!StringUtils.isBlank((CharSequence)feeCheckVo.getAreaCode())) {
                        posQueryDto.setBusinessArea(feeCheckVo.getAreaCode());
                        continue block7;
                    }
                    falseReason.append("\u533a\u57df\u7f16\u7801\u4e3a\u7a7a;");
                    continue block7;
                }
            }
        }
        String paramLackWithConditionStr = falseReason.toString();
        if (paramLackWithConditionStr.length() > 0) {
            failReasonStr = failReasonStr.concat(paramLackWithConditionStr);
        }
        log.info("\u8d39\u5355\u5339pos4");
        PageRequest pageRequest = PageRequest.of((int)0, (int)1000);
        ArrayList posRecords = new ArrayList();
        while ((posPage = this.auditFeeCheckPosRepository.findByConditions((Pageable)(pageRequest = pageRequest.next()), posQueryDto)) != null) {
            posRecords.addAll(posPage.getRecords());
            if (posPage.hasNext()) continue;
        }
        log.info("\u67e5\u8be2\u5230pos\u6570\u91cf\uff1a{}", (Object)posRecords.size());
        BigDecimal posAmountTotal = BigDecimal.ZERO;
        ArrayList<AuditFeeCheckPos> validPosRecords = new ArrayList<AuditFeeCheckPos>();
        if (CollectionUtils.isEmpty(posRecords)) {
            failReasonStr = failReasonStr.concat("\u6839\u636e\u6a21\u677f\u89c4\u5219\u672a\u67e5\u627e\u5230\u5bf9\u5e94pos;");
        } else {
            for (AuditFeeCheckPosVo posVo : posRecords) {
                if (posVo.getPromotionDeduction() == null || posVo.getActivityDetailItemCode() == null) continue;
                posAmountTotal = posAmountTotal.add(posVo.getPromotionDeduction());
                AuditFeeCheckPos pos = new AuditFeeCheckPos();
                BeanUtils.copyProperties((Object)posVo, (Object)((Object)pos));
                validPosRecords.add(pos);
            }
            if (BigDecimal.ZERO.equals(posAmountTotal)) {
                failReasonStr = failReasonStr.concat("pos\u6570\u636e\u91d1\u989d\u548c\u4e3a0\u65e0\u6cd5\u5206\u644a;");
            }
        }
        log.info("\u8fc7\u6ee4\u540e\u6709\u91d1\u989d\u6709\u7ec6\u6848\u7684pos\u6570\u91cf\uff1a{}", (Object)validPosRecords.size());
        if (StringUtils.isNotBlank((CharSequence)failReasonStr)) {
            this.auditFeeCheckCostRepository.updatePosRemarkByMatchCodeList(Lists.newArrayList((Object[])new String[]{feeCheckVo.getMatchCode()}), failReasonStr);
            return new ArrayList<AuditFeeCheckPos>(0);
        }
        return validPosRecords;
    }

    public void updateRelatePos(AuditFeeCheckVo feeCheckVo, List<AuditFeeCheckPos> posMatchedAndUsedList) {
        if (CollectionUtils.isEmpty(posMatchedAndUsedList)) {
            return;
        }
        BigDecimal posAmountTotal = posMatchedAndUsedList.stream().map(AuditFeeCheckPos::getPromotionDeduction).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal feePosDifference = feeCheckVo.getCostDeductionAmount().subtract(posAmountTotal);
        BigDecimal rate = posAmountTotal.compareTo(BigDecimal.ZERO) != 0 ? feePosDifference.divide(posAmountTotal, 6, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        BigDecimal shareTotal = BigDecimal.ZERO;
        for (AuditFeeCheckPos pos : posMatchedAndUsedList) {
            BigDecimal shareByRate = pos.getPromotionDeduction().multiply(rate).setScale(2, RoundingMode.HALF_UP);
            shareTotal = shareTotal.add(shareByRate);
            pos.setSharePromotionDeduction(shareByRate);
            pos.setIsMatchCost(BooleanEnum.TRUE.getCapital());
            pos.setFeeCheckMatchCode(feeCheckVo.getMatchCode());
        }
        BigDecimal accuracyDifference = feePosDifference.subtract(shareTotal);
        if (accuracyDifference.compareTo(BigDecimal.ZERO) != 0) {
            AuditFeeCheckPos lastPos = posMatchedAndUsedList.get(posMatchedAndUsedList.size() - 1);
            lastPos.setSharePromotionDeduction(lastPos.getSharePromotionDeduction().add(accuracyDifference).setScale(2, RoundingMode.HALF_UP));
        }
        this.auditFeeCheckPosRepository.updateBatchById(posMatchedAndUsedList);
        this.auditFeeCheckPosRepository.computeTotalDiffAmount(posMatchedAndUsedList.stream().map(UuidEntity::getId).filter(Objects::nonNull).collect(Collectors.toList()));
        this.auditFeeCheckCostRepository.cleanPosMatchRemarkByMatchCodes(Lists.newArrayList((Object[])new String[]{feeCheckVo.getMatchCode()}));
    }

    public String adjustMonth(Date date, Integer span, boolean begin) {
        DateTime adjustedDate = DateUtil.offsetMonth((Date)date, (int)span);
        DateTime headOrTail = begin ? DateUtil.beginOfDay((Date)DateUtil.beginOfMonth((Date)adjustedDate)) : DateUtil.endOfDay((Date)DateUtil.endOfMonth((Date)adjustedDate));
        return DateUtil.format((Date)headOrTail, (String)"yyyy-MM-dd HH:mm:ss");
    }
}

