/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedgerItem;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeDetailRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerItemRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AuditFeeDiffDisposeDetailPageCacheHelper
extends MnPageCacheHelper<AuditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetailDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeDiffDisposeDetailRepository auditFeeDiffDisposeDetailRepository;
    @Autowired(required=false)
    private AuditFeeDiffDisposeLedgerItemRepository auditFeeDiffDisposeLedgerItemRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "audit_fee:diff_dispose_cache:";
    }

    public Class<AuditFeeDiffDisposeDetailDto> getDtoClass() {
        return AuditFeeDiffDisposeDetailDto.class;
    }

    public Class<AuditFeeDiffDisposeDetailVo> getVoClass() {
        return AuditFeeDiffDisposeDetailVo.class;
    }

    public List<AuditFeeDiffDisposeDetailDto> findDtoListFromRepository(AuditFeeDiffDisposeDetailDto dto, String cacheKey) {
        if (!StringUtils.hasText((String)dto.getFeeDiffDisposeCode())) {
            return Lists.newArrayList();
        }
        Assert.hasText((String)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        String[] split = cacheKey.split(":");
        String templateCode = split[1];
        Assert.hasText((String)templateCode, (String)"\u6a21\u7248\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setTemplateConfigCode(templateCode);
        List<AuditFeeDiffDisposeDetail> entities = this.auditFeeDiffDisposeDetailRepository.findByFeeDiffDisposeCode(dto);
        List detailDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, AuditFeeDiffDisposeDetail.class, AuditFeeDiffDisposeDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<AuditFeeDiffDisposeLedgerItem> ledgerItems = this.auditFeeDiffDisposeLedgerItemRepository.findByFeeDiffDisposeCode(dto);
        List ledgerItemDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(ledgerItems, AuditFeeDiffDisposeLedgerItem.class, AuditFeeDiffDisposeLedgerItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Map<String, List<AuditFeeDiffDisposeLedgerItemDto>> ledgerMap = ledgerItemDtos.stream().collect(Collectors.groupingBy(AuditFeeDiffDisposeLedgerItemDto::getDetailPlanItemCode));
        detailDtos.forEach(o -> o.setLedgerItems((List)ledgerMap.get(o.getDetailPlanItemCode())));
        if (!CollectionUtils.isEmpty((Collection)detailDtos)) {
            String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
            String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
            Map ratioDtoMap = detailDtos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getId, Function.identity()));
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), ratioDtoMap.keySet().toArray());
            this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, ratioDtoMap);
            this.redisService.expire(redisCacheDataKey, this.getExpireTime());
        }
        return detailDtos;
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<AuditFeeDiffDisposeDetailDto> newItem(String cacheKey, List<AuditFeeDiffDisposeDetailDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List<AuditFeeDiffDisposeDetailDto> newList = itemList.stream().filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        if (newList.size() == 0) {
            AuditFeeDiffDisposeDetailDto detailDto = new AuditFeeDiffDisposeDetailDto();
            detailDto.setId(UuidCrmUtil.general());
            detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailDto.setTenantCode(TenantUtils.getTenantCode());
            newList.add(detailDto);
        }
        return newList;
    }

    public void updateItem(String cacheKey, List<AuditFeeDiffDisposeDetailDto> itemList) {
    }

    public List<AuditFeeDiffDisposeDetailDto> copyItem(String cacheKey, List<AuditFeeDiffDisposeDetailDto> itemList) {
        List newList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditFeeDiffDisposeDetailDto.class, AuditFeeDiffDisposeDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditFeeDiffDisposeDetailDto newItem : newList) {
            newItem.setId(UuidCrmUtil.general());
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        return newList;
    }

    public Object getDtoKey(AuditFeeDiffDisposeDetailDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(AuditFeeDiffDisposeDetailDto dto) {
        return dto.getChecked();
    }

    public void importSave(String cacheKey, AuditFeeDiffDisposeDetailDto dto) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        dto.setId(UuidCrmUtil.general());
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        if (!idList.contains(dto.getId())) {
            Object[] newIdArr = new Object[]{dto.getId()};
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        HashMap ratioDtoMap = Maps.newHashMap();
        ratioDtoMap.put(dto.getId(), dto);
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, (Map)ratioDtoMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}

