/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeDetailRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.log.AuditFeeDiffDisposeDetailLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeDetailEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffDisposeDetailLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="auditFeeDiffDisposeDetailVoService")
public class AuditFeeDiffDisposeDetailVoServiceImpl
extends MnPageCacheServiceImpl<AuditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetailDto>
implements AuditFeeDiffDisposeDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeDetailVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffDisposeDetailRepository auditFeeDiffDisposeDetailRepository;
    @Autowired(required=false)
    private List<AuditFeeDiffDisposeDetailEventListener> eventListeners;
    @Autowired(required=false)
    private MnPageCacheHelper<AuditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetailDto> helper;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeBudgetVoService;

    public Page<AuditFeeDiffDisposeDetailVo> findByConditions(Pageable pageable, AuditFeeDiffDisposeDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffDisposeDetailDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffDisposeDetailRepository.findByConditions((Page<AuditFeeDiffDisposeDetailVo>)page, dto);
    }

    public AuditFeeDiffDisposeDetailVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeDiffDisposeDetail auditFeeDiffDisposeDetail = this.auditFeeDiffDisposeDetailRepository.findById(id);
        if (auditFeeDiffDisposeDetail == null) {
            return null;
        }
        return (AuditFeeDiffDisposeDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffDisposeDetail, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public AuditFeeDiffDisposeDetailVo create(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        this.createValidation(auditFeeDiffDisposeDetailVo);
        auditFeeDiffDisposeDetailVo.setTenantCode(TenantUtils.getTenantCode());
        auditFeeDiffDisposeDetailVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditFeeDiffDisposeDetailVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        AuditFeeDiffDisposeDetail auditFeeDiffDisposeDetail = (AuditFeeDiffDisposeDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffDisposeDetailVo, AuditFeeDiffDisposeDetail.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditFeeDiffDisposeDetailRepository.saveOrUpdate((Object)auditFeeDiffDisposeDetail);
        auditFeeDiffDisposeDetailVo.setId(auditFeeDiffDisposeDetail.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditFeeDiffDisposeDetailEventListener auditFeeDiffDisposeDetailEventListener : this.eventListeners) {
                auditFeeDiffDisposeDetailEventListener.onCreate(auditFeeDiffDisposeDetailVo);
            }
        }
        AuditFeeDiffDisposeDetailLogEventDto logEventDto = new AuditFeeDiffDisposeDetailLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffDisposeDetailVo);
        SerializableBiConsumer & Serializable onCreate = AuditFeeDiffDisposeDetailLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFeeDiffDisposeDetailLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditFeeDiffDisposeDetailVo;
    }

    @Transactional
    public AuditFeeDiffDisposeDetailVo update(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        this.updateValidation(auditFeeDiffDisposeDetailVo);
        String currentId = auditFeeDiffDisposeDetailVo.getId();
        AuditFeeDiffDisposeDetail current = this.auditFeeDiffDisposeDetailRepository.findById(currentId);
        current = (AuditFeeDiffDisposeDetail)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditFeeDiffDisposeDetailVo oldVo = (AuditFeeDiffDisposeDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeDiffDisposeDetailRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditFeeDiffDisposeDetailEventListener auditFeeDiffDisposeDetailEventListener : this.eventListeners) {
                auditFeeDiffDisposeDetailEventListener.onUpdate(oldVo, auditFeeDiffDisposeDetailVo);
            }
        }
        AuditFeeDiffDisposeDetailLogEventDto logEventDto = new AuditFeeDiffDisposeDetailLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffDisposeDetailVo);
        SerializableBiConsumer & Serializable onUpdate = AuditFeeDiffDisposeDetailLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFeeDiffDisposeDetailLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditFeeDiffDisposeDetailVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeDetailRepository.updateDelFlagByIds(ids);
    }

    public List<AuditFeeDiffDisposeDetailVo> findDetailByDiffDisposeCode(String feeDiffDisposeCode) {
        if (StringUtils.isEmpty((CharSequence)feeDiffDisposeCode)) {
            return Lists.newArrayList();
        }
        List<AuditFeeDiffDisposeDetail> auditFeeDiffDisposeDetails = this.auditFeeDiffDisposeDetailRepository.findDetailByDiffDisposeCode(feeDiffDisposeCode);
        if (CollectionUtils.isEmpty(auditFeeDiffDisposeDetails)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffDisposeDetails, AuditFeeDiffDisposeDetail.class, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<AuditFeeDiffDisposeLedgerVo> findBudgetByCacheKey(String cacheKey) {
        List diffDisDtoList = this.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty((Collection)diffDisDtoList)) {
            return Lists.newArrayList();
        }
        ArrayList ledgerItemDtoList = new ArrayList(diffDisDtoList.size() * 2);
        diffDisDtoList.forEach(disDto -> {
            if (!CollectionUtils.isEmpty((Collection)disDto.getLedgerItems())) {
                ledgerItemDtoList.addAll(disDto.getLedgerItems());
            }
        });
        Map<String, List<AuditFeeDiffDisposeLedgerItemDto>> ledgerItemDtoMap = ledgerItemDtoList.stream().collect(Collectors.groupingBy(k -> k.getFeeDiffLedgerCode() + k.getFeeYearMonth()));
        ArrayList<AuditFeeDiffDisposeLedgerVo> ledgerVoList = new ArrayList<AuditFeeDiffDisposeLedgerVo>(ledgerItemDtoMap.keySet().size());
        ledgerItemDtoMap.forEach((k, v) -> {
            if (!CollectionUtils.isEmpty((Collection)v)) {
                AuditFeeDiffDisposeLedgerVo ledgerVo = new AuditFeeDiffDisposeLedgerVo();
                ledgerVo.setFeeDiffLedgerCode(((AuditFeeDiffDisposeLedgerItemDto)v.get(0)).getFeeDiffLedgerCode());
                ledgerVo.setFeeYearMonth(((AuditFeeDiffDisposeLedgerItemDto)v.get(0)).getFeeYearMonth());
                BigDecimal thisUseAmount = v.stream().map(AuditFeeDiffDisposeLedgerItemDto::getThisUseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                ledgerVo.setThisUseAmount(thisUseAmount);
                BigDecimal beRecoveredAmount = v.stream().map(AuditFeeDiffDisposeLedgerItemDto::getBeRecoveredAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                ledgerVo.setBeRecoveredAmount(beRecoveredAmount);
                ledgerVoList.add(ledgerVo);
            }
        });
        return ledgerVoList;
    }

    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        Validate.notNull((Object)feeDiffDisposeCode, (String)"\u5dee\u5f02\u8d39\u7528\u5904\u7406\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeDetailRepository.deleteByDiffDisposeCode(feeDiffDisposeCode);
    }

    private String getRedisCacheKey(String cacheKey) {
        return "audit_fee:diff_ledger_cache:" + cacheKey;
    }

    private void createValidation(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        this.validation(auditFeeDiffDisposeDetailVo);
    }

    private void updateValidation(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
        this.validation(auditFeeDiffDisposeDetailVo);
    }

    private void validation(AuditFeeDiffDisposeDetailVo auditFeeDiffDisposeDetailVo) {
    }

    public void saveBatch(String feeDiffDisposeCode, List<AuditFeeDiffDisposeDetailDto> detailDtos) {
        Assert.notEmpty(detailDtos, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        this.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
        List details = (List)this.nebulaToolkitService.copyCollectionByBlankList(detailDtos, AuditFeeDiffDisposeDetailDto.class, AuditFeeDiffDisposeDetail.class, HashSet.class, ArrayList.class, new String[0]);
        details.forEach(o -> {
            o.setFeeDiffDisposeCode(feeDiffDisposeCode);
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.auditFeeDiffDisposeDetailRepository.saveOrUpdateBatch(details);
    }
}

