/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedgerItem;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerItemRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerItemVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="auditFeeDiffDisposeLedgerItemVoService")
public class AuditFeeDiffDisposeLedgerItemVoServiceImpl
implements AuditFeeDiffDisposeLedgerItemVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeLedgerItemVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffDisposeLedgerItemRepository auditFeeDiffDisposeLedgerItemRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        Validate.notBlank((CharSequence)feeDiffDisposeCode, (String)"feeDiffDisposeCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeLedgerItemRepository.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
    }

    public void saveBatch(String feeDiffDisposeCode, List<AuditFeeDiffDisposeDetailDto> details) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        this.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
        ArrayList ledgerItemList = new ArrayList();
        for (AuditFeeDiffDisposeDetailDto detail : details) {
            if (CollectionUtils.isEmpty((Collection)detail.getLedgerItems())) continue;
            detail.getLedgerItems().forEach(ledger -> {
                ledger.setId(null);
                ledger.setDetailPlanItemCode(detail.getDetailPlanItemCode());
                ledger.setFeeDiffDisposeCode(feeDiffDisposeCode);
                ledger.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                ledger.setTenantCode(TenantUtils.getTenantCode());
                ledger.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                AuditFeeDiffDisposeLedgerItem ledgerItem = (AuditFeeDiffDisposeLedgerItem)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(ledger, AuditFeeDiffDisposeLedgerItem.class, HashSet.class, ArrayList.class, new String[0])));
                ledgerItemList.add(ledgerItem);
            });
        }
        this.auditFeeDiffDisposeLedgerItemRepository.saveBatch(ledgerItemList);
    }

    public void updateDelFlagByFeeDiffDisposeCode(List<String> feeDifDisposeCodes) {
        if (CollectionUtils.isEmpty(feeDifDisposeCodes)) {
            return;
        }
        this.auditFeeDiffDisposeLedgerItemRepository.updateDelFlagByFeeDiffDisposeCodes(feeDifDisposeCodes);
    }
}

