/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.log.AuditFeeDiffDisposeLedgerLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeLedgerEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffDisposeLedgerLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="auditFeeDiffDisposeLedgerVoService")
public class AuditFeeDiffDisposeLedgerVoServiceImpl
implements AuditFeeDiffDisposeLedgerVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeLedgerVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffDisposeLedgerRepository auditFeeDiffDisposeLedgerRepository;
    @Autowired(required=false)
    private List<AuditFeeDiffDisposeLedgerEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    public Page<AuditFeeDiffDisposeLedgerVo> findByConditions(Pageable pageable, AuditFeeDiffDisposeLedgerDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffDisposeLedgerDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffDisposeLedgerRepository.findByConditions((Page<AuditFeeDiffDisposeLedgerVo>)page, dto);
    }

    public AuditFeeDiffDisposeLedgerVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeDiffDisposeLedger auditFeeDiffDisposeBudget = this.auditFeeDiffDisposeLedgerRepository.findById(id);
        if (auditFeeDiffDisposeBudget == null) {
            return null;
        }
        return (AuditFeeDiffDisposeLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffDisposeBudget, AuditFeeDiffDisposeLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public AuditFeeDiffDisposeLedgerVo create(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        this.createValidation(auditFeeDiffDisposeBudgetVo);
        auditFeeDiffDisposeBudgetVo.setTenantCode(TenantUtils.getTenantCode());
        auditFeeDiffDisposeBudgetVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditFeeDiffDisposeBudgetVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        AuditFeeDiffDisposeLedger auditFeeDiffDisposeBudget = (AuditFeeDiffDisposeLedger)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffDisposeBudgetVo, AuditFeeDiffDisposeLedger.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditFeeDiffDisposeLedgerRepository.saveOrUpdate((Object)auditFeeDiffDisposeBudget);
        auditFeeDiffDisposeBudgetVo.setId(auditFeeDiffDisposeBudget.getId());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditFeeDiffDisposeLedgerEventListener auditFeeDiffDisposeBudgetEventListener : this.eventListeners) {
                auditFeeDiffDisposeBudgetEventListener.onCreate(auditFeeDiffDisposeBudgetVo);
            }
        }
        AuditFeeDiffDisposeLedgerLogEventDto logEventDto = new AuditFeeDiffDisposeLedgerLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffDisposeBudgetVo);
        SerializableBiConsumer & Serializable onCreate = AuditFeeDiffDisposeLedgerLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFeeDiffDisposeLedgerLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditFeeDiffDisposeBudgetVo;
    }

    @Transactional
    public AuditFeeDiffDisposeLedgerVo update(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        this.updateValidation(auditFeeDiffDisposeBudgetVo);
        String currentId = auditFeeDiffDisposeBudgetVo.getId();
        AuditFeeDiffDisposeLedger current = this.auditFeeDiffDisposeLedgerRepository.findById(currentId);
        current = (AuditFeeDiffDisposeLedger)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditFeeDiffDisposeLedgerVo oldVo = (AuditFeeDiffDisposeLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditFeeDiffDisposeLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeDiffDisposeLedgerRepository.saveOrUpdate((Object)current);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditFeeDiffDisposeLedgerEventListener auditFeeDiffDisposeBudgetEventListener : this.eventListeners) {
                auditFeeDiffDisposeBudgetEventListener.onUpdate(oldVo, auditFeeDiffDisposeBudgetVo);
            }
        }
        AuditFeeDiffDisposeLedgerLogEventDto logEventDto = new AuditFeeDiffDisposeLedgerLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffDisposeBudgetVo);
        SerializableBiConsumer & Serializable onUpdate = AuditFeeDiffDisposeLedgerLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFeeDiffDisposeLedgerLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditFeeDiffDisposeBudgetVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeLedgerRepository.updateDelFlagByIds(ids);
    }

    public List<AuditFeeDiffDisposeLedgerVo> getBudgetsByFeeDetails(List<AuditFeeDiffDisposeDetailVo> details) {
        List auditFeeDiffLedgerVos = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details)) {
            Set ledgerCodes = details.stream().map(x -> x.getFeeDiffLedgerCode()).filter(Objects::nonNull).collect(Collectors.toSet());
            auditFeeDiffLedgerVos = this.auditFeeDiffLedgerVoService.findDetailByCodes((List)Lists.newArrayList(ledgerCodes));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(auditFeeDiffLedgerVos)) {
            Map<String, BigDecimal> amountMap = details.stream().collect(Collectors.toMap(AuditFeeDiffDisposeDetailVo::getFeeDiffLedgerCode, ActivityDetailPlanItemBase::getFeeAmount));
            ArrayList<AuditFeeDiffDisposeLedgerVo> auditFeeDiffDisposeBudgetVos = new ArrayList<AuditFeeDiffDisposeLedgerVo>(auditFeeDiffLedgerVos.size());
            auditFeeDiffLedgerVos.forEach(auditFeeDiffLedgerVo -> {
                AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo = new AuditFeeDiffDisposeLedgerVo();
                auditFeeDiffDisposeBudgetVo.setFeeDiffLedgerCode(auditFeeDiffLedgerVo.getFeeDiffLedgerCode());
                auditFeeDiffDisposeBudgetVo.setFeeYearMonth(auditFeeDiffLedgerVo.getFeeYearMonth());
                auditFeeDiffDisposeBudgetVo.setThisUseAmount((BigDecimal)amountMap.get(auditFeeDiffLedgerVo.getFeeDiffLedgerCode()));
                auditFeeDiffDisposeBudgetVos.add(auditFeeDiffDisposeBudgetVo);
            });
            return auditFeeDiffDisposeBudgetVos;
        }
        return Lists.newArrayList();
    }

    public List<AuditFeeDiffDisposeLedgerVo> findDetailByDiffDisposeCode(String feeDiffDisposeCode) {
        if (StringUtils.isEmpty((CharSequence)feeDiffDisposeCode)) {
            return Lists.newArrayList();
        }
        List<AuditFeeDiffDisposeLedger> auditFeeDiffDisposeBudgets = this.auditFeeDiffDisposeLedgerRepository.findDetailByDiffDisposeCode(feeDiffDisposeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(auditFeeDiffDisposeBudgets)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffDisposeBudgets, AuditFeeDiffDisposeLedger.class, AuditFeeDiffDisposeLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void deleteByAuditFeeDiffDisposeCode(String feeDiffDisposeCode) {
        Validate.notBlank((CharSequence)feeDiffDisposeCode, (String)"feeDiffDisposeCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeLedgerRepository.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
    }

    private void createValidation(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        this.validation(auditFeeDiffDisposeBudgetVo);
    }

    private void updateValidation(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
        this.validation(auditFeeDiffDisposeBudgetVo);
    }

    private void validation(AuditFeeDiffDisposeLedgerVo auditFeeDiffDisposeBudgetVo) {
    }

    public void saveBatch(String feeDiffDisposeCode, List<AuditFeeDiffDisposeLedgerDto> budgets) {
        if (CollectionUtils.isEmpty(budgets)) {
            return;
        }
        this.deleteByAuditFeeDiffDisposeCode(feeDiffDisposeCode);
        budgets.forEach(o -> {
            o.setFeeDiffDisposeCode(feeDiffDisposeCode);
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            o.setTenantCode(TenantUtils.getTenantCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        List diffDisposeBudgets = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgets, AuditFeeDiffDisposeLedgerDto.class, AuditFeeDiffDisposeLedger.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeDiffDisposeLedgerRepository.saveBatch(diffDisposeBudgets);
    }

    public void updateDelFlagByFeeDiffDisposeCode(List<String> feeDifDisposeCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(feeDifDisposeCodes)) {
            return;
        }
        this.auditFeeDiffDisposeLedgerRepository.updateDelFlagByFeeDiffDisposeCodes(feeDifDisposeCodes);
    }
}

