/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDispose;
import com.biz.crm.tpm.business.audit.fee.local.entity.dispose.AuditFeeDiffDisposeDetail;
import com.biz.crm.tpm.business.audit.fee.local.helper.AuditFeeDiffDisposeHelper;
import com.biz.crm.tpm.business.audit.fee.local.helper.AuditFeeDiffLedgerHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.dispose.AuditFeeDiffDisposeRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffDisposeDetailService;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffLedgerService;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.dispose.AuditFeeDiffDisposeDetailPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditCheckEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeCorrelationDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeProcessDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.WhereFromEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerItemVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="auditFeeDiffDisposeVoService")
public class AuditFeeDiffDisposeVoServiceImpl
implements AuditFeeDiffDisposeVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffDisposeRepository auditFeeDiffDisposeRepository;
    @Autowired
    private AuditFeeDiffDisposeDetailPageCacheHelper auditFeeDiffDisposeDetailPageCacheHelper;
    @Autowired(required=false)
    private List<AuditFeeDiffDisposeEventListener> eventListeners;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private AuditFeeDiffDisposeDetailVoService auditFeeDiffDisposeDetailVoService;
    @Autowired(required=false)
    private AuditFeeDiffDisposeDetailService auditFeeDiffDisposeDetailService;
    @Autowired
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeBudgetVoService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Resource
    private AuditFeeDiffDisposeHelper auditFeeDiffDisposeHelper;
    @Resource
    private AuditFeeDiffDisposeLedgerItemVoService auditFeeDiffDisposeLedgerItemVoService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerHelper auditFeeDiffLedgerHelper;
    @Autowired(required=false)
    private AuditFeeDiffLedgerService auditFeeDiffLedgerService;
    @Autowired(required=false)
    private AuditFeeDiffDisposeLedgerVoService auditFeeDiffDisposeLedgerVoService;

    public Page<AuditFeeDiffDisposeVo> findByConditions(Pageable pageable, AuditFeeDiffDisposeDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffDisposeDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffDisposeRepository.findByConditions((Page<AuditFeeDiffDisposeVo>)page, dto);
    }

    public AuditFeeDiffDisposeVo findDetailById(String id) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeDiffDispose auditFeeDiffDispose = this.auditFeeDiffDisposeRepository.findById(id);
        if (auditFeeDiffDispose == null) {
            return null;
        }
        AuditFeeDiffDisposeVo auditFeeDiffDisposeVo = (AuditFeeDiffDisposeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffDispose, AuditFeeDiffDisposeVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fullDetail(auditFeeDiffDisposeVo);
        return auditFeeDiffDisposeVo;
    }

    private void fullDetail(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        auditFeeDiffDisposeVo.setLedgers(this.auditFeeDiffDisposeBudgetVoService.findDetailByDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode()));
        List detailVos = this.auditFeeDiffDisposeDetailVoService.findDetailByDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
        Map<String, String> templateMap = detailVos.stream().filter(x -> x.getTemplateConfigCode() != null).collect(Collectors.toMap(ActivityDetailPlanItemBase::getTemplateConfigCode, AuditFeeDiffDisposeDetailVo::getTemplateConfigName));
        if (MapUtil.isNotEmpty(templateMap)) {
            ArrayList templateVos = new ArrayList(templateMap.size());
            templateMap.forEach((k, v) -> {
                AuditFeeDiffDisposeTemplateVo auditFeeDiffDisposeTemplateVo = new AuditFeeDiffDisposeTemplateVo();
                auditFeeDiffDisposeTemplateVo.setTemplateConfigCode(k);
                auditFeeDiffDisposeTemplateVo.setTemplateConfigName(v);
                templateVos.add(auditFeeDiffDisposeTemplateVo);
            });
            auditFeeDiffDisposeVo.setTemplates(templateVos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditFeeDiffDisposeVo create(String cacheKey, AuditFeeDiffDisposeDto dto) {
        this.auditFeeDiffDisposeHelper.verifyEmpty(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        dto.setWhereFrom(WhereFromEnum.MANUAL.getCode());
        dto.setFeeDiffDisposeCode(this.auditFeeDiffDisposeHelper.generateCode());
        dto.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeHelper.buildDetails(cacheKey, dto);
        Validate.notEmpty((Collection)dto.getDetails(), (String)"\u7ec6\u6848\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList feeDiffLedgerCodes = Lists.newArrayList();
        dto.getDetails().forEach(detail -> {
            String feeDiffLedgerCode = detail.getFeeDiffLedgerCode();
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)feeDiffLedgerCode)) {
                feeDiffLedgerCodes.addAll(Arrays.asList(feeDiffLedgerCode.split(",")));
            }
        });
        boolean lock = true;
        try {
            lock = this.auditFeeDiffLedgerHelper.batchTryLock(feeDiffLedgerCodes, TimeUnit.SECONDS, 30);
            if (lock) {
                this.saveOrUpdate(dto);
                if (!Objects.isNull(dto.getProcessBusiness())) {
                    this.submitBatchProcessAfterCreate(dto, dto.getProcessBusiness());
                }
            }
        }
        finally {
            if (lock) {
                this.auditFeeDiffLedgerHelper.batchUnLock(feeDiffLedgerCodes);
            }
        }
        return null;
    }

    private void submitBatchProcessAfterCreate(AuditFeeDiffDisposeDto dto, ProcessBusinessDto processBusiness) {
        Validate.notNull((Object)processBusiness, (String)"\u5ba1\u6279\u6d41\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto, (String)"\u4e0d\u5b58\u5728\u7684\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(dto.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(dto.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(dto.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u63d0\u4ea4,\u8ffd\u56de,\u9a73\u56de\u72b6\u6001\u7684\u53ef\u4ee5\u63d0\u4ea4\u5ba1\u6279\uff01", (Object[])new Object[0]);
        String uuid = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(uuid);
        processBusiness.setBusinessCode("AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE");
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        dto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        dto.setProcessNo(processBusinessVo.getProcessNo());
        this.auditFeeDiffDisposeRepository.updateProcessStatusByCode(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(AuditFeeDiffDisposeDto dto) {
        dto.setWhereFrom(WhereFromEnum.MANUAL.getCode());
        AuditFeeDiffDispose auditFeeDiffDispose = (AuditFeeDiffDispose)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffDispose.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditFeeDiffDisposeRepository.save((Object)auditFeeDiffDispose);
        this.auditFeeDiffDisposeDetailVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getDetails());
        this.auditFeeDiffDisposeLedgerItemVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getDetails());
        this.auditFeeDiffDisposeBudgetVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getLedgers());
        this.auditFeeDiffLedgerService.handle(dto.getFeeDiffDisposeCode(), dto.getLedgerItems());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public AuditFeeDiffDisposeVo update(String cacheKey, AuditFeeDiffDisposeDto dto) {
        Assert.hasText((String)dto.getId(), (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        AuditFeeDiffDispose oldEntity = this.auditFeeDiffDisposeRepository.findById(dto.getId());
        this.auditFeeDiffDisposeHelper.verifyEmpty(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        dto.setFeeDiffDisposeCode(oldEntity.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeHelper.buildDetails(cacheKey, dto);
        ArrayList feeDiffLedgerCodes = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)dto.getDetails())) {
            this.saveOrUpdate(dto);
        } else {
            dto.getDetails().forEach(detail -> {
                String feeDiffLedgerCode = detail.getFeeDiffLedgerCode();
                if (StringUtils.hasText((String)feeDiffLedgerCode)) {
                    feeDiffLedgerCodes.addAll(Arrays.asList(feeDiffLedgerCode.split(",")));
                }
            });
            boolean lock = true;
            try {
                lock = this.auditFeeDiffLedgerHelper.batchTryLock(feeDiffLedgerCodes, TimeUnit.SECONDS, 30);
                if (lock) {
                    this.saveOrUpdate(dto);
                }
            }
            finally {
                if (lock) {
                    this.auditFeeDiffLedgerHelper.batchUnLock(feeDiffLedgerCodes);
                }
            }
        }
        return null;
    }

    private void saveOtherInfo(String cacheKey, AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        List disposeDetails = new ArrayList();
        if (StrUtil.isNotEmpty((CharSequence)cacheKey)) {
            List detailVoServiceCacheList = this.auditFeeDiffDisposeDetailVoService.findCacheList(cacheKey);
            disposeDetails = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailVoServiceCacheList, AuditFeeDiffDisposeDetailDto.class, AuditFeeDiffDisposeDetailVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.auditFeeDiffDisposeDetailVoService.clearCache(cacheKey);
        } else {
            disposeDetails = auditFeeDiffDisposeVo.getDetails();
        }
        if (CollectionUtils.isNotEmpty(disposeDetails)) {
            for (AuditFeeDiffDisposeDetailVo disposeDetailVo : disposeDetails) {
                disposeDetailVo.setFeeDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
                this.auditFeeDiffDisposeDetailVoService.create(disposeDetailVo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)auditFeeDiffDisposeVo.getLedgers())) {
            auditFeeDiffDisposeVo.getLedgers().forEach(auditFeeDiffDisposeBudgetVo -> {
                auditFeeDiffDisposeBudgetVo.setFeeDiffDisposeCode(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
                this.auditFeeDiffDisposeBudgetVoService.create(auditFeeDiffDisposeBudgetVo);
            });
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffDisposeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditFeeDiffDispose> diffDis = this.auditFeeDiffDisposeRepository.findByIds(ids);
        Validate.notEmpty(diffDis, (String)"\u8981\u5220\u9664\u662f\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        diffDis.forEach(diff -> {
            if (ProcessStatusEnum.PASS.getDictCode().equals(diff.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(diff.getProcessStatus())) {
                throw new IllegalArgumentException(diff.getFeeDiffDisposeName() + diff.getFeeDiffDisposeCode() + "\u5df2\u5ba1\u6279\u6216\u5ba1\u6279\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
            }
        });
        List<String> feeDifDisposeCodes = diffDis.stream().map(AuditFeeDiffDispose::getFeeDiffDisposeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.auditFeeDiffDisposeDetailService.updateDelFlagByFeeDiffDisposeCode(feeDifDisposeCodes);
        this.auditFeeDiffDisposeLedgerItemVoService.updateDelFlagByFeeDiffDisposeCode(feeDifDisposeCodes);
        this.auditFeeDiffDisposeLedgerVoService.updateDelFlagByFeeDiffDisposeCode(feeDifDisposeCodes);
        this.auditFeeDiffDisposeRepository.updateDelFlagByIds(ids);
        List matchCodes = diffDis.stream().map(AuditFeeDiffDispose::getMatchCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        AuditCheckEventDto eventDto = new AuditCheckEventDto();
        eventDto.setMatchCodes(matchCodes);
        SerializableBiConsumer & Serializable diffDisposeDeleted = AuditFeeCheckEventListener::diffDisposeDeleted;
        this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, AuditFeeCheckEventListener.class, (SerializableBiConsumer)diffDisposeDeleted);
    }

    public AuditFeeDiffDisposeVo findDetailByDisposeCode(String businessNo) {
        Validate.notNull((Object)businessNo, (String)"businessNo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeDiffDispose auditFeeDiffDispose = this.auditFeeDiffDisposeRepository.findDetailByDisposeCode(businessNo);
        if (Objects.isNull((Object)auditFeeDiffDispose)) {
            return null;
        }
        AuditFeeDiffDisposeVo auditFeeDiffDisposeVo = (AuditFeeDiffDisposeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffDispose, AuditFeeDiffDisposeVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fullDetail(auditFeeDiffDisposeVo);
        return auditFeeDiffDisposeVo;
    }

    public void submitBatchProcess(AuditFeeDiffDisposeProcessDto auditFeeDiffDisposeProcessDto) {
        if (Objects.isNull(auditFeeDiffDisposeProcessDto)) {
            return;
        }
        Validate.notNull((Object)auditFeeDiffDisposeProcessDto.getProcessBusiness(), (String)"\u5ba1\u6279\u6d41\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditFeeDiffDispose> auditFeeDiffDisposes = this.auditFeeDiffDisposeRepository.findByIds(auditFeeDiffDisposeProcessDto.getIds());
        Validate.notEmpty(auditFeeDiffDisposes, (String)"\u4e0d\u5b58\u5728\u7684\u5b9e\u4f8b\u5bf9\u8c61", (Object[])new Object[0]);
        auditFeeDiffDisposes.forEach(auditFeeDiffDispose -> Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(auditFeeDiffDispose.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(auditFeeDiffDispose.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(auditFeeDiffDispose.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u63d0\u4ea4,\u8ffd\u56de,\u9a73\u56de\u72b6\u6001\u7684\u53ef\u4ee5\u63d0\u4ea4\u5ba1\u6279\uff01", (Object[])new Object[0]));
        ProcessBusinessDto processBusiness = auditFeeDiffDisposeProcessDto.getProcessBusiness();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        processBusiness.setBusinessNo(uuid);
        processBusiness.setBusinessNoList(auditFeeDiffDisposes.stream().map(AuditFeeDiffDispose::getFeeDiffDisposeCode).filter(Objects::nonNull).collect(Collectors.toList()));
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)auditFeeDiffDisposeProcessDto));
        processBusiness.setBusinessCode("AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        auditFeeDiffDisposes.forEach(auditFeeDiffDispose -> {
            auditFeeDiffDispose.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            auditFeeDiffDispose.setProcessNo(processBusinessVo.getProcessNo());
        });
        this.auditFeeDiffDisposeRepository.updateBatchById(auditFeeDiffDisposes);
    }

    @Transactional(rollbackFor={Exception.class})
    public void correlation(AuditFeeDiffDisposeCorrelationDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getId(), (String)"\u5dee\u5f02\u8d39\u7528\u5904\u7406\u4e3b\u5efaid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getLedgerItems(), (String)"\u5dee\u5f02\u8d39\u7528\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeDiffDispose dispose = this.auditFeeDiffDisposeRepository.findById(dto.getId());
        Assert.notNull((Object)((Object)dispose), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        Assert.isTrue((boolean)WhereFromEnum.AUTOMATIC.getCode().equals(dispose.getWhereFrom()), (String)"\u975e\u81ea\u52a8\u751f\u6210\u6570\u636e");
        List<AuditFeeDiffDisposeDetail> disposeDetails = this.auditFeeDiffDisposeDetailService.findByFeeDiffDisposeCode(dispose.getFeeDiffDisposeCode());
        Assert.notEmpty(disposeDetails, (String)"\u6ca1\u6709\u660e\u7ec6\u4fe1\u606f");
        AuditFeeDiffDisposeDetail auditFeeDiffDisposeDetail = disposeDetails.get(0);
        AtomicReference<BigDecimal> thisUseAmountAtomic = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        ArrayList feeDiffLedgerCodes = Lists.newArrayList();
        dto.getLedgerItems().forEach(o -> {
            o.setDetailPlanItemCode(auditFeeDiffDisposeDetail.getDetailPlanItemCode());
            o.setFeeDiffDisposeCode(dispose.getFeeDiffDisposeCode());
            o.setThisUseAmount(o.getBeRecoveredAmount());
            thisUseAmountAtomic.set(((BigDecimal)thisUseAmountAtomic.get()).add(o.getThisUseAmount()));
            feeDiffLedgerCodes.add(o.getFeeDiffLedgerCode());
        });
        auditFeeDiffDisposeDetail.setThisUseAmount(thisUseAmountAtomic.get());
        auditFeeDiffDisposeDetail.setFeeDiffLedgerCode(String.join((CharSequence)",", feeDiffLedgerCodes));
        dispose.setDisposeFeeAmount(thisUseAmountAtomic.get());
        this.auditFeeDiffDisposeRepository.updateById((Object)dispose);
        this.auditFeeDiffDisposeDetailService.batchUpdateById(Lists.newArrayList((Object[])new AuditFeeDiffDisposeDetail[]{auditFeeDiffDisposeDetail}));
    }

    private void commitProcess(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        if (auditFeeDiffDisposeVo.getProcessBusiness() == null) {
            return;
        }
        ProcessBusinessDto processBusiness = auditFeeDiffDisposeVo.getProcessBusiness();
        processBusiness.setBusinessNo(auditFeeDiffDisposeVo.getFeeDiffDisposeCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)auditFeeDiffDisposeVo));
        processBusiness.setBusinessCode("AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE");
        this.processBusinessService.processStart(processBusiness);
        auditFeeDiffDisposeVo.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
    }

    private void createValidation(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
    }

    private void updateValidation(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
        this.validation(auditFeeDiffDisposeVo);
    }

    private void validation(AuditFeeDiffDisposeVo auditFeeDiffDisposeVo) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoCreate(AuditFeeDiffDisposeDto dto) {
        this.auditFeeDiffDisposeHelper.verifyEmpty(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        AuditFeeDiffDispose auditFeeDiffDispose = (AuditFeeDiffDispose)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffDispose.class, HashSet.class, ArrayList.class, new String[0]));
        auditFeeDiffDispose.setWhereFrom(WhereFromEnum.AUTOMATIC.getCode());
        dto.setFeeDiffDisposeCode(this.auditFeeDiffDisposeHelper.generateCode());
        auditFeeDiffDispose.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeRepository.save((Object)auditFeeDiffDispose);
        this.auditFeeDiffDisposeHelper.buildDetails(null, dto);
        this.auditFeeDiffDisposeDetailVoService.saveBatch(dto.getFeeDiffDisposeCode(), dto.getDetails());
    }

    public void importSave(AuditFeeDiffDisposeDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        AuditFeeDiffDispose auditFeeDiffDispose = (AuditFeeDiffDispose)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffDispose.class, HashSet.class, ArrayList.class, new String[0]));
        auditFeeDiffDispose.setWhereFrom(WhereFromEnum.MANUAL.getCode());
        dto.setFeeDiffDisposeCode(this.auditFeeDiffDisposeHelper.generateCode());
        auditFeeDiffDispose.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
        this.auditFeeDiffDisposeRepository.save((Object)auditFeeDiffDispose);
    }
}

