/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditFeeDiffLedgerLockServiceImpl
implements AuditFeeDiffLedgerLockService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffLedgerLockServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public boolean lock(String code, TimeUnit timeUnit, int time) {
        Validate.notBlank((CharSequence)code, (String)"\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u52a0\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        return this.lock(Collections.singletonList(code), timeUnit, time);
    }

    public boolean lock(List<String> codeList, TimeUnit timeUnit, int time) {
        Validate.notEmpty(codeList, (String)"\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u52a0\u9501\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (Objects.isNull((Object)timeUnit)) {
            timeUnit = TimeUnit.MINUTES;
        }
        if (time < 1) {
            time = 3;
        }
        return this.redisLockService.batchLock("audit_fee_check_diff_ledger:use:", codeList, timeUnit, time);
    }

    public void unlock(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        this.unlock(Collections.singletonList(code));
    }

    public void unlock(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        this.redisLockService.batchUnLock("audit_fee_check_diff_ledger:use:", codeList);
    }
}

