/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerPlan;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeDiffLedgerPlanCacheHelper
extends MnPageCacheHelper<AuditFeeDiffLedgerPlanVo, AuditFeeDiffLedgerPlanDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerPlanRepository auditFeeDiffLedgerPlanRepository;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "audit_fee:diff_ledger_plan_cache:";
    }

    public Class<AuditFeeDiffLedgerPlanDto> getDtoClass() {
        return AuditFeeDiffLedgerPlanDto.class;
    }

    public Class<AuditFeeDiffLedgerPlanVo> getVoClass() {
        return AuditFeeDiffLedgerPlanVo.class;
    }

    public List<AuditFeeDiffLedgerPlanDto> findDtoListFromRepository(AuditFeeDiffLedgerPlanDto dto, String cacheKey) {
        Assert.hasText((String)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getFeeDiffLedgerCode(), (String)"\u5dee\u5f02\u8d39\u7528\u53f0\u5e10\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<AuditFeeDiffLedgerPlan> entities = this.auditFeeDiffLedgerPlanRepository.findByFeeDiffLedgerCode(dto);
        List detailDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, AuditFeeDiffLedgerPlan.class, AuditFeeDiffLedgerPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)detailDtos)) {
            String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
            String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
            Map ratioDtoMap = detailDtos.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), ratioDtoMap.keySet().toArray());
            this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, ratioDtoMap);
            this.redisService.expire(redisCacheDataKey, this.getExpireTime());
        }
        return detailDtos;
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<AuditFeeDiffLedgerPlanDto> newItem(String cacheKey, List<AuditFeeDiffLedgerPlanDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List<AuditFeeDiffLedgerPlanDto> newList = itemList.stream().filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        if (newList.size() == 0) {
            AuditFeeDiffLedgerPlanDto detailDto = new AuditFeeDiffLedgerPlanDto();
            detailDto.setId(UuidCrmUtil.general());
            detailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailDto.setTenantCode(TenantUtils.getTenantCode());
            newList.add(detailDto);
        }
        return newList;
    }

    public void updateItem(String cacheKey, List<AuditFeeDiffLedgerPlanDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.forEach(item -> {
            if (!Objects.isNull(item.getPlanRecoveredAmount()) && BigDecimal.ZERO.compareTo(item.getPlanRecoveredAmount()) > 0) {
                throw new IllegalArgumentException("\u8ba1\u5212\u8ffd\u56de\u91d1\u989d\u5fc5\u987b \u2265 0 \uff01");
            }
        });
    }

    public List<AuditFeeDiffLedgerPlanDto> copyItem(String cacheKey, List<AuditFeeDiffLedgerPlanDto> itemList) {
        List newList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditFeeDiffLedgerPlanDto.class, AuditFeeDiffLedgerPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditFeeDiffLedgerPlanDto newItem : newList) {
            newItem.setId(UuidCrmUtil.general());
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        return newList;
    }

    public Object getDtoKey(AuditFeeDiffLedgerPlanDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(AuditFeeDiffLedgerPlanDto dto) {
        return dto.getChecked();
    }

    public void importSave(String cacheKey, AuditFeeDiffLedgerPlanDto dto) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        dto.setId(UuidCrmUtil.general());
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        if (!idList.contains(dto.getId())) {
            Object[] newIdArr = new Object[]{dto.getId()};
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        HashMap ratioDtoMap = Maps.newHashMap();
        ratioDtoMap.put(dto.getId(), dto);
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, (Map)ratioDtoMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}

