/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerPlan;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeDiffLedgerPlanLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.ledger.AuditFeeDiffLedgerPlanEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.event.log.AuditFeeDiffLedgerPlanLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="auditFeeDiffLedgerPlanService")
public class AuditFeeDiffLedgerPlanVoServiceImpl
extends MnPageCacheServiceImpl<AuditFeeDiffLedgerPlanVo, AuditFeeDiffLedgerPlanDto>
implements AuditFeeDiffLedgerPlanVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffLedgerPlanVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffLedgerPlanRepository auditFeeDiffLedgerPlanRepository;
    @Autowired(required=false)
    private List<AuditFeeDiffLedgerPlanEventListener> eventListeners;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<AuditFeeDiffLedgerPlanVo> findByConditions(Pageable pageable, AuditFeeDiffLedgerPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffLedgerPlanDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffLedgerPlanRepository.findByConditions((Page<AuditFeeDiffLedgerPlanVo>)page, dto);
    }

    public AuditFeeDiffLedgerPlanVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeDiffLedgerPlan auditFeeDiffLedgerPlan = this.auditFeeDiffLedgerPlanRepository.findById(id);
        if (auditFeeDiffLedgerPlan == null) {
            return null;
        }
        return (AuditFeeDiffLedgerPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffLedgerPlan, AuditFeeDiffLedgerPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFeeDiffLedgerPlanVo create(AuditFeeDiffLedgerPlanDto dto) {
        Assert.hasText((String)dto.getFeeDiffLedgerCode(), (String)"\u5dee\u5f02\u8d39\u7528\u53f0\u5e10\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a");
        List planDtos = this.findCacheList(dto.getCacheKey());
        Assert.notEmpty((Collection)planDtos, (String)"\u4e3a\u67e5\u8be2\u5230\u7f13\u5b58\u4fe1\u606f");
        this.auditFeeDiffLedgerPlanRepository.deleteByFeeDiffLedgerCode(dto.getFeeDiffLedgerCode());
        List ledgerPlans = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planDtos, AuditFeeDiffLedgerPlanDto.class, AuditFeeDiffLedgerPlan.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        int i = 1;
        for (AuditFeeDiffLedgerPlan o : ledgerPlans) {
            o.setFeeDiffLedgerCode(dto.getFeeDiffLedgerCode());
            o.setSerialNumber(i);
            ++i;
        }
        this.auditFeeDiffLedgerPlanRepository.saveOrUpdateBatch(ledgerPlans);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFeeDiffLedgerPlanVo update(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        this.updateValidation(auditFeeDiffLedgerPlanVo);
        String currentId = auditFeeDiffLedgerPlanVo.getId();
        AuditFeeDiffLedgerPlan current = this.auditFeeDiffLedgerPlanRepository.findById(currentId);
        current = (AuditFeeDiffLedgerPlan)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditFeeDiffLedgerPlanVo oldVo = (AuditFeeDiffLedgerPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditFeeDiffLedgerPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeDiffLedgerPlanRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditFeeDiffLedgerPlanEventListener auditFeeDiffLedgerPlanEventListener : this.eventListeners) {
                auditFeeDiffLedgerPlanEventListener.onUpdate(oldVo, auditFeeDiffLedgerPlanVo);
            }
        }
        AuditFeeDiffLedgerPlanLogEventDto logEventDto = new AuditFeeDiffLedgerPlanLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffLedgerPlanVo);
        SerializableBiConsumer & Serializable onUpdate = AuditFeeDiffLedgerPlanLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFeeDiffLedgerPlanLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditFeeDiffLedgerPlanVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffLedgerPlanRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffLedgerPlanRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffLedgerPlanRepository.updateDelFlagByIds(ids);
    }

    public List<AuditFeeDiffLedgerPlanVo> findDetailByLedgerId(String feeDiffLedgerId) {
        if (StringUtils.isEmpty((CharSequence)feeDiffLedgerId)) {
            return Lists.newArrayList();
        }
        List<AuditFeeDiffLedgerPlan> auditFeeDiffLedgerPlans = this.auditFeeDiffLedgerPlanRepository.findDetailByLedgerId(feeDiffLedgerId);
        if (CollectionUtils.isEmpty(auditFeeDiffLedgerPlans)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffLedgerPlans, AuditFeeDiffLedgerPlan.class, AuditFeeDiffLedgerPlanVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    private void createValidation(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        this.validation(auditFeeDiffLedgerPlanVo);
    }

    private void updateValidation(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
        this.validation(auditFeeDiffLedgerPlanVo);
    }

    private void validation(AuditFeeDiffLedgerPlanVo auditFeeDiffLedgerPlanVo) {
    }

    public void createByCacheKey(String cacheKey) {
    }
}

