/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedger;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerDeduction;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerDeductionRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeDiffLedgerService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="auditFeeDiffLedgerService")
public class AuditFeeDiffLedgerServiceImpl
implements AuditFeeDiffLedgerService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffLedgerServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffLedgerRepository auditFeeDiffLedgerRepository;
    @Autowired
    private AuditFeeDiffLedgerDeductionRepository auditFeeDiffLedgerDeductionRepository;

    @Override
    public void handle(String feeDiffDisposeCode, List<AuditFeeDiffDisposeLedgerItemDto> ledgerItems) {
        if (CollectionUtils.isEmpty(ledgerItems)) {
            return;
        }
        HashMap ledgerAmountMap = Maps.newHashMap();
        HashSet detailPlanItemCodeSet = Sets.newHashSet();
        ArrayList thisDeductionList = Lists.newArrayList();
        ledgerItems.forEach(ledgerItemDto -> {
            String feeDiffLedgerCode = ledgerItemDto.getFeeDiffLedgerCode();
            BigDecimal ledgerAmount = Optional.ofNullable(ledgerAmountMap.get(feeDiffLedgerCode)).orElse(BigDecimal.ZERO);
            BigDecimal thisUseAmount = ledgerItemDto.getThisUseAmount();
            ledgerAmountMap.put(feeDiffLedgerCode, ledgerAmount.add(thisUseAmount));
            detailPlanItemCodeSet.add(ledgerItemDto.getDetailPlanItemCode());
            this.buildThisDeductionList(thisDeductionList, (AuditFeeDiffDisposeLedgerItemDto)ledgerItemDto);
        });
        List<AuditFeeDiffLedgerDeduction> histDeductionEntities = this.auditFeeDiffLedgerDeductionRepository.findByFeeDiffDisposeCodeAndDetailPlanItemCodes(feeDiffDisposeCode, Lists.newArrayList((Iterable)detailPlanItemCodeSet));
        Map<String, BigDecimal> histDeductionAmountMap = histDeductionEntities.stream().collect(Collectors.groupingBy(AuditFeeDiffLedgerDeduction::getFeeDiffLedgerDisposeCode, Collectors.reducing(BigDecimal.ZERO, AuditFeeDiffLedgerDeduction::getRecoveredAmount, BigDecimal::add)));
        List<AuditFeeDiffLedger> ledgerEntities = this.auditFeeDiffLedgerRepository.findDetailByCodes(Lists.newArrayList(ledgerAmountMap.keySet()));
        ledgerEntities.forEach(entity -> {
            BigDecimal histAmount = Optional.ofNullable(histDeductionAmountMap.get(entity.getFeeDiffLedgerCode())).orElse(BigDecimal.ZERO);
            BigDecimal thisAmount = Optional.ofNullable(ledgerAmountMap.get(entity.getFeeDiffLedgerCode())).orElse(BigDecimal.ZERO);
            entity.setRecoveredAmount(entity.getRecoveredAmount().subtract(histAmount).add(thisAmount));
            entity.setBeRecoveredAmount(entity.getDiffAmount().subtract(entity.getRecoveredAmount()));
            Assert.isTrue((entity.getBeRecoveredAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)("\u53f0\u5e10[" + entity.getFeeDiffLedgerCode() + "]\u8d39\u7528\u8d85\u989d\u4f7f\u7528"));
        });
        this.auditFeeDiffLedgerDeductionRepository.deleteByFeeDiffDisposeCode(feeDiffDisposeCode);
        this.auditFeeDiffLedgerDeductionRepository.saveBatch(thisDeductionList);
        this.auditFeeDiffLedgerRepository.updateBatchById(ledgerEntities);
    }

    private void buildThisDeductionList(List<AuditFeeDiffLedgerDeduction> thisDeductionList, AuditFeeDiffDisposeLedgerItemDto ledgerItemDto) {
        AuditFeeDiffLedgerDeduction deduction = new AuditFeeDiffLedgerDeduction();
        deduction.setFeeDiffLedgerDisposeCode(ledgerItemDto.getFeeDiffDisposeCode());
        deduction.setBusinessCode(ledgerItemDto.getDetailPlanItemCode());
        deduction.setRecoveredAmount(ledgerItemDto.getThisUseAmount());
        deduction.setRecoveredTime(ledgerItemDto.getRecoveredTime());
        deduction.setTenantCode(TenantUtils.getTenantCode());
        deduction.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        deduction.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        thisDeductionList.add(deduction);
    }
}

