/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedger;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerDeduction;
import com.biz.crm.tpm.business.audit.fee.local.helper.AuditFeeDiffLedgerHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerDeductionRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerConfirmDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.event.ledger.AuditFeeDiffLedgerEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditFeeDiffLedgerVoService")
public class AuditFeeDiffLedgerVoServiceImpl
implements AuditFeeDiffLedgerVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffLedgerVoServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeDiffLedgerRepository auditFeeDiffLedgerRepository;
    @Autowired(required=false)
    private List<AuditFeeDiffLedgerEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Resource
    private AuditFeeDiffLedgerHelper auditFeeDiffLedgerHelper;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerDeductionRepository auditFeeDiffLedgerDeductionRepository;

    public Page<AuditFeeDiffLedgerVo> findByConditions(Pageable pageable, AuditFeeDiffLedgerDto dto) {
        return this.auditFeeDiffLedgerRepository.findByConditions(pageable, dto);
    }

    public Page<AuditFeeDiffLedgerVo> selectByConditions(Pageable pageable, AuditFeeDiffLedgerDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffLedgerDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffLedgerRepository.selectByConditions((Page<AuditFeeDiffLedgerVo>)page, dto);
    }

    public AuditFeeDiffLedgerVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeDiffLedger auditFeeDiffLedger = this.auditFeeDiffLedgerRepository.findById(id);
        if (auditFeeDiffLedger == null) {
            return null;
        }
        return (AuditFeeDiffLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffLedger, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFeeDiffLedgerVo create(AuditFeeDiffLedgerDto dto) {
        this.auditFeeDiffLedgerHelper.verifyEmpty(dto);
        dto.setFeeDiffLedgerCode((String)this.generateCodeService.generateCode("AFDL", 1).get(0));
        dto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setRecoveredAmount(BigDecimal.ZERO);
        dto.setBeRecoveredAmount(BigDecimal.ZERO);
        dto.setFollowUpPerson(this.loginUserService.getLoginAccountName());
        AuditFeeDiffLedger auditFeeDiffLedger = (AuditFeeDiffLedger)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffLedger.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditFeeDiffLedgerRepository.saveOrUpdate((Object)auditFeeDiffLedger);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFeeDiffLedgerVo update(AuditFeeDiffLedgerDto dto) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeDiffLedgerRepository.updateDelFlagByIds(ids);
    }

    public void confirm(AuditFeeDiffLedgerConfirmDto dto) {
        Validate.notNull((Object)dto.getId(), (String)"\u4e3b\u952eid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getConfirmDiffAmount(), (String)"\u786e\u8ba4\u5dee\u5f02\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        AuditFeeDiffLedger ledger = (AuditFeeDiffLedger)((Object)this.auditFeeDiffLedgerRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)ledger), (String)"\u5bf9\u8c61\u5b9e\u4f8b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((!AuditStateEnum.CONFIRMED.getCode().equals(ledger.getStatus()) ? 1 : 0) != 0, (String)"\u6570\u636e\u5df2\u786e\u8ba4\u8fc7\uff01", (Object[])new Object[0]);
        ledger.setStatus(AuditStateEnum.CONFIRMED.getCode());
        ledger.setConfirmDiffAmount(dto.getConfirmDiffAmount());
        ledger.setBeRecoveredAmount(dto.getConfirmDiffAmount());
        ledger.setRecoveredAmount(BigDecimal.ZERO);
        this.auditFeeDiffLedgerRepository.updateById((Object)ledger);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            ArrayList list = Lists.newArrayList();
            AuditFeeDiffLedgerVo auditFeeDiffLedgerVo = (AuditFeeDiffLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)ledger, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
            list.add(auditFeeDiffLedgerVo);
            for (AuditFeeDiffLedgerEventListener auditFeeDiffLedgerEventListener : this.eventListeners) {
                auditFeeDiffLedgerEventListener.onConfirm((Collection)list);
            }
        }
    }

    public List<AuditFeeDiffLedgerVo> findDetailByCodes(List<String> ledgerCodes) {
        if (CollectionUtils.isEmpty(ledgerCodes)) {
            return Collections.emptyList();
        }
        List<AuditFeeDiffLedger> auditFeeDiffLedgers = this.auditFeeDiffLedgerRepository.findDetailByCodes(ledgerCodes);
        if (CollectionUtils.isEmpty(auditFeeDiffLedgers)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffLedgers, AuditFeeDiffLedger.class, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public void rollBackAmount(Map<String, BigDecimal> ledgerAmountMap) {
        if (MapUtil.isEmpty(ledgerAmountMap)) {
            return;
        }
        ledgerAmountMap.forEach((k, v) -> {
            AuditFeeDiffLedgerVo auditFeeDiffLedgerVo = this.findDetailByCode((String)k);
            if (Objects.nonNull(auditFeeDiffLedgerVo)) {
                auditFeeDiffLedgerVo.setDiffAmount(NumberUtil.add((Number)auditFeeDiffLedgerVo.getDiffAmount(), (Number)v));
            }
        });
    }

    public AuditFeeDiffLedgerVo findDetailByCode(String k) {
        Validate.notNull((Object)k, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeDiffLedger auditFeeDiffLedger = this.auditFeeDiffLedgerRepository.findDetailByCode(k);
        if (auditFeeDiffLedger == null) {
            return null;
        }
        return (AuditFeeDiffLedgerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFeeDiffLedger, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void useAmount(AuditFeeDiffLedgerDeductionDto dto) {
        log.info("\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u64cd\u4f5c\u6263\u51cf\u660e\u7ec6");
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeDiffLedgerCode(), (String)"\u5dee\u5f02\u8d39\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        AuditFeeDiffLedgerOperationTypeEnum operationTypeEnum = AuditFeeDiffLedgerOperationTypeEnum.codeToEnum((String)dto.getOperationType());
        Validate.notNull((Object)operationTypeEnum, (String)"\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRecoveredAmount(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (dto.getRecoveredAmount().compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        if (!this.redisLockService.isLock("audit_fee_check_diff_ledger:use:" + dto.getFeeDiffLedgerCode())) {
            throw new RuntimeException("\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u3010" + dto.getFeeDiffLedgerCode() + "\u3011\u64cd\u4f5c\u91d1\u989d\u65f6\uff0c\u672a\u52a0\u9501\uff01");
        }
        AuditFeeDiffLedger diffLedger = this.auditFeeDiffLedgerRepository.findDetailByCode(dto.getFeeDiffLedgerCode());
        Validate.notNull((Object)((Object)diffLedger), (String)("\u672a\u627e\u5230\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u3010" + dto.getFeeDiffLedgerCode() + "\u3011"), (Object[])new Object[0]);
        Validate.isTrue((boolean)AuditStateEnum.CONFIRMED.getCode().equals(diffLedger.getStatus()), (String)("\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u3010" + dto.getFeeDiffLedgerCode() + "\u3011,\u72b6\u6001\u4e3a'\u672a\u786e\u8ba4',\u4e0d\u53ef\u7528\uff01"), (Object[])new Object[0]);
        BigDecimal beRecoveredAmount = Optional.ofNullable(diffLedger.getBeRecoveredAmount()).orElse(BigDecimal.ZERO);
        BigDecimal recoveredAmount = Optional.ofNullable(diffLedger.getRecoveredAmount()).orElse(BigDecimal.ZERO);
        if (AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode().equals(dto.getOperationType()) || AuditFeeDiffLedgerOperationTypeEnum.RECOVER_AMOUNT.getCode().equals(dto.getOperationType())) {
            Validate.isTrue((diffLedger.getBeRecoveredAmount().compareTo(dto.getRecoveredAmount()) >= 0 ? 1 : 0) != 0, (String)"\u62b5\u6263\u6216\u8ffd\u56de\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53f0\u8d26\u7684\u5f85\u8ffd\u56de\u91d1\u989d\uff01", (Object[])new Object[0]);
        }
        AuditFeeDiffLedgerDeduction deduction = (AuditFeeDiffLedgerDeduction)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeDiffLedgerDeduction.class, HashSet.class, ArrayList.class, new String[0]));
        deduction.setOperationType(dto.getOperationType());
        deduction.setFeeDiffLedgerCode(diffLedger.getFeeDiffLedgerCode());
        deduction.setRecoveredAmount(dto.getRecoveredAmount());
        deduction.setRecoveredTime(new Date());
        deduction.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        deduction.setTenantCode(TenantUtils.getTenantCode());
        if (AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode().equals(dto.getOperationType()) || AuditFeeDiffLedgerOperationTypeEnum.RECOVER_AMOUNT.getCode().equals(dto.getOperationType())) {
            diffLedger.setBeRecoveredAmount(beRecoveredAmount.subtract(dto.getRecoveredAmount()));
            diffLedger.setRecoveredAmount(recoveredAmount.add(dto.getRecoveredAmount()));
        }
        if (AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode().equals(dto.getOperationType())) {
            diffLedger.setBeRecoveredAmount(beRecoveredAmount.add(dto.getRecoveredAmount()));
            diffLedger.setRecoveredAmount(recoveredAmount.subtract(dto.getRecoveredAmount()));
        }
        this.auditFeeDiffLedgerDeductionRepository.save((Object)deduction);
        this.auditFeeDiffLedgerRepository.updateById((Object)diffLedger);
    }
}

