/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.track;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class AuditFeeDiffTrackDetailPageCacheHelper
extends MnPageCacheHelper<AuditFeeDiffTrackDetailVo, AuditFeeDiffTrackDetailDto> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffTrackDetailPageCacheHelper.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private AuditFeeDiffTrackDetailRepository auditFeeDiffTrackDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ChannelMsgService channelMsgService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Value(value="${spring.application.name:}")
    private String applicationName;

    public String getCacheKeyPrefix() {
        return "audit_fee_diff_detail:item_cache:";
    }

    public Class<AuditFeeDiffTrackDetailDto> getDtoClass() {
        return AuditFeeDiffTrackDetailDto.class;
    }

    public Class<AuditFeeDiffTrackDetailVo> getVoClass() {
        return AuditFeeDiffTrackDetailVo.class;
    }

    public List<AuditFeeDiffTrackDetailDto> findDtoListFromRepository(AuditFeeDiffTrackDetailDto dto, String cacheKey) {
        String[] split = cacheKey.split(":");
        String planCode = split[0];
        String templateCode = split[2];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List<AuditFeeDiffTrackDetailVo> detailVoList = this.auditFeeDiffTrackDetailRepository.findByPlanCodeList(Lists.newArrayList((Object[])new String[]{planCode}));
        List allDtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(detailVoList, AuditFeeDiffTrackDetailVo.class, AuditFeeDiffTrackDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        allDtoList.sort(Comparator.comparing(AuditFeeDiffTrackDetailDto::getPlanCode));
        ObjectConvertStringUtil.fillObjectListStrProperties((List)allDtoList, AuditFeeDiffTrackDetailDto.class);
        allDtoList.forEach(e -> {
            e.setActivityTypeCode(e.getActivityTypeCode());
            e.setDetailCode(e.getDetailCode());
        });
        Map<String, List<AuditFeeDiffTrackDetailDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailDto::getTemplateConfigCode));
        for (Map.Entry<String, List<AuditFeeDiffTrackDetailDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, entry.getKey());
            Map newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), entry.getValue().stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public void fillVoListProperties(List<AuditFeeDiffTrackDetailVo> records) {
        super.fillVoListProperties(records);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<AuditFeeDiffTrackDetailDto> newItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[2];
        AuditFeeDiffTrackDetailDto newItem = new AuditFeeDiffTrackDetailDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList((Object[])new AuditFeeDiffTrackDetailDto[]{newItem});
    }

    public void importNewItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        String[] split = cacheKey.split(":");
        String planCode = split[0];
        String templateCode = split[2];
        for (AuditFeeDiffTrackDetailDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanCode(null);
            newItem.setTemplateConfigCode(templateCode);
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public List<AuditFeeDiffTrackDetailDto> copyItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditFeeDiffTrackDetailDto.class, AuditFeeDiffTrackDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditFeeDiffTrackDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setPlanCode(null);
            newItem.setDetailCode(null);
            if (CollectionUtils.isEmpty((Collection)newItem.getAuditFeeDiffTrackDetailLedgerList())) continue;
            for (AuditFeeDiffTrackDetailLedgerDto detailLedgerDto : newItem.getAuditFeeDiffTrackDetailLedgerList()) {
                detailLedgerDto.setId(UUID.randomUUID().toString().replace("-", ""));
                detailLedgerDto.setPlanCode(null);
                detailLedgerDto.setDetailCode(null);
            }
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        String[] split = cacheKey.split(":");
        String lockKey = "activity_plan:lock:save:" + split[0];
        if (this.redisLockService.isLock(lockKey)) {
            throw new RuntimeException("\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
    }

    public List<AuditFeeDiffTrackDetailVo> dtoListToVoList(List<AuditFeeDiffTrackDetailDto> itemDtoList) {
        return super.dtoListToVoList(itemDtoList);
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[2];
        return redisCacheInitKey.replace(templateCode, "");
    }

    public Object getDtoKey(AuditFeeDiffTrackDetailDto AuditFeeDiffTrackDetailDto2) {
        return AuditFeeDiffTrackDetailDto2.getId();
    }

    public String getCheckedStatus(AuditFeeDiffTrackDetailDto auditFeeDiffTrackDetailDto) {
        return auditFeeDiffTrackDetailDto.getChecked();
    }

    public void sendMsg(String remark) {
        this.sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }

    public void sendMsg(String remark, String execStatus) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("remark", (Object)remark);
        String time = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        jsonObject.put("time", (Object)time);
        jsonObject.put("applicationName", (Object)this.applicationName);
        jsonObject.put("execStatus", (Object)execStatus);
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)jsonObject, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String modelCode = "activity_plan_save";
        log.info(" activity_plan model send msg2: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, this.applicationName, modelCode});
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, modelCode, loginUser.getAccount(), jsonBytes);
    }
}

