/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.track;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrack;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.third.DiffTrackPushCowManager;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationVoService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.Validate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AuditFeeDiffTrackDetailVoServiceImpl
extends MnPageCacheServiceImpl<AuditFeeDiffTrackDetailVo, AuditFeeDiffTrackDetailDto>
implements AuditFeeDiffTrackDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffTrackDetailVoServiceImpl.class);
    @Autowired
    private AuditFeeDiffTrackDetailRepository auditFeeDiffTrackDetailRepository;
    @Autowired
    private AuditFeeDiffTrackRepository auditFeeDiffTrackRepository;
    @Autowired
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailLedgerRepository auditFeeDiffTrackDetailLedgerRepository;
    @Autowired(required=false)
    private AuditFeeValidationVoService auditFeeValidationVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DiffTrackPushCowManager diffTrackPushCowManager;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Page<AuditFeeDiffTrackDetailVo> findCachePageList(Pageable pageable, AuditFeeDiffTrackDetailDto dto, String cacheKey) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheIdKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheIdKey);
            page.setTotal(total.longValue());
            List idList = this.redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (CollectionUtils.isNotEmpty((Collection)idList)) {
                List dataList;
                List dtoList = dataList = this.redisTemplate.opsForHash().multiGet((Object)redisCacheDataKey, (Collection)idList);
                List voList = this.helper.dtoListToVoList(dtoList);
                page.setRecords(voList);
            }
        } else if (!this.redisService.hasKey(redisCacheInitKey).booleanValue()) {
            this.redisService.set(redisCacheInitKey, (Object)BooleanEnum.TRUE, this.helper.getExpireTime());
            List dtoList = this.helper.findDtoListFromRepository((Object)dto, cacheKey);
            if (!CollectionUtils.isEmpty((Collection)dtoList)) {
                if (this.helper.initToCacheFromRepository()) {
                    this.helper.putCache(cacheKey, dtoList);
                }
                page.setTotal((long)dtoList.size());
                long start = page.offset();
                if (page.getTotal() > start) {
                    long end = page.offset() + page.getSize();
                    if (page.getTotal() < end) {
                        end = page.getTotal();
                    }
                    List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                    List voList = this.helper.dtoListToVoList(recordDtoList);
                    page.setRecords(voList);
                }
            }
        }
        this.helper.fillVoListProperties(page.getRecords());
        return page;
    }

    public Page<AuditFeeDiffTrackDetailVo> findByConditions(Pageable pageable, AuditFeeDiffTrackDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        if ((dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffTrackDetailDto())).getIsClose() == null) {
            dto.setIsClose(BooleanEnum.FALSE.getCapital());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffTrackDetailRepository.findByConditions((Page<AuditFeeDiffTrackDetailVo>)page, dto);
    }

    public AuditFeeDiffTrackDetailVo findDetailById(String id) {
        AuditFeeDiffTrackDetail byId = this.auditFeeDiffTrackDetailRepository.findById(id);
        if (byId == null) {
            return null;
        }
        AuditFeeDiffTrackDetailVo vo = new AuditFeeDiffTrackDetailVo();
        BeanUtils.copyProperties((Object)((Object)byId), (Object)vo);
        return vo;
    }

    public List<AuditFeeDiffTrackDetailVo> findDetailByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return new ArrayList<AuditFeeDiffTrackDetailVo>();
        }
        return this.auditFeeDiffTrackDetailRepository.findByPlanCodeList(planCodeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<AuditFeeDiffTrackDetailDto> detailDtoList) {
        if (CollectionUtils.isEmpty(detailDtoList)) {
            return;
        }
        this.auditFeeDiffTrackDetailRepository.createBatch(detailDtoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeBatchByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return;
        }
        this.auditFeeDiffTrackDetailRepository.removeBatchByPlanCodeList(planCodeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void useMonthBudgetByPlanCodeList(List<String> planCodeList, String operateId) {
        List<AuditFeeDiffTrackDetailVo> detailVoList = this.auditFeeDiffTrackDetailRepository.findByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(detailVoList)) {
            return;
        }
        ArrayList diffList = new ArrayList();
        for (AuditFeeDiffTrackDetailVo vo : detailVoList) {
            if (!CollectionUtils.isNotEmpty((Collection)vo.getAuditFeeDiffTrackDetailLedgerList())) continue;
            diffList.addAll(vo.getAuditFeeDiffTrackDetailLedgerList());
        }
        if (CollectionUtils.isEmpty(diffList)) {
            return;
        }
        AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
        Map detailVoMap = detailVoList.stream().collect(Collectors.toMap(AuditFeeDiffTrackDetailVo::getDetailCode, Function.identity(), (v1, v2) -> v1));
        ArrayList<AuditFeeDiffLedgerDeductionDto> ledgerDeductionDtoList = new ArrayList<AuditFeeDiffLedgerDeductionDto>();
        for (AuditFeeDiffTrackDetailLedgerVo diff : diffList) {
            AuditFeeDiffTrackDetailVo detailVo = (AuditFeeDiffTrackDetailVo)detailVoMap.get(diff.getDetailCode());
            AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
            Validate.isTrue((boolean)Objects.nonNull(diff.getUsedAmount()), (String)"\u5dee\u5f02\u8d39\u7528\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            ledgerDto.setBusinessCode(diff.getDetailCode());
            ledgerDto.setActivityFormCode(detailVo.getActivityFormCode());
            ledgerDto.setActivityFormName(detailVo.getActivityFormName());
            ledgerDto.setActivityTypeCode(detailVo.getActivityTypeCode());
            ledgerDto.setActivityTypeName(detailVo.getActivityTypeName());
            ledgerDto.setResaleCommercialCode(detailVo.getSystemCode());
            ledgerDto.setResaleCommercialName(detailVo.getSystemName());
            ledgerDto.setTerminalCode(detailVo.getTerminalCode());
            ledgerDto.setTerminalName(detailVo.getTerminalName());
            ledgerDto.setOperatorName(crmUserIdentity.getRealName());
            ledgerDto.setOperatorAccount(crmUserIdentity.getAccount());
            ledgerDto.setFeeDiffLedgerCode(diff.getFeeDiffLedgerCode());
            ledgerDto.setRecoveredAmount(diff.getUsedAmount());
            ledgerDto.setFeeDiffLedgerDisposeCode(diff.getPlanCode());
            ledgerDeductionDtoList.add(ledgerDto);
        }
        List codeList = ledgerDeductionDtoList.stream().map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());
        boolean lock = this.auditFeeDiffLedgerLockService.lock(codeList, TimeUnit.MINUTES, 1);
        Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u5dee\u5f02\u8d39\u7528\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        String key = String.format("audit_fee_diff_track_operate:%s", operateId);
        this.redisService.set(key, codeList);
        for (AuditFeeDiffLedgerDeductionDto ledgerDeductionDto : ledgerDeductionDtoList) {
            ledgerDeductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
            ledgerDeductionDto.setDataSource(DiffLedgerDataSourceEnum.DIFF_TRACK.getCode());
            this.auditFeeDiffLedgerVoService.useAmount(ledgerDeductionDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void returnMonthBudgetByPlanCodeList(List<String> planCodeList, String operateId) {
        List<AuditFeeDiffTrackDetailVo> detailVoList = this.auditFeeDiffTrackDetailRepository.findByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(detailVoList)) {
            return;
        }
        ArrayList diffList = new ArrayList();
        for (AuditFeeDiffTrackDetailVo vo : detailVoList) {
            if (!CollectionUtils.isNotEmpty((Collection)vo.getAuditFeeDiffTrackDetailLedgerList())) continue;
            diffList.addAll(vo.getAuditFeeDiffTrackDetailLedgerList());
        }
        if (CollectionUtils.isEmpty(diffList)) {
            return;
        }
        AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
        Map detailVoMap = detailVoList.stream().collect(Collectors.toMap(AuditFeeDiffTrackDetailVo::getDetailCode, Function.identity(), (v1, v2) -> v1));
        ArrayList<AuditFeeDiffLedgerDeductionDto> ledgerDeductionDtoList = new ArrayList<AuditFeeDiffLedgerDeductionDto>();
        for (AuditFeeDiffTrackDetailLedgerVo diff : diffList) {
            AuditFeeDiffTrackDetailVo detailVo = (AuditFeeDiffTrackDetailVo)detailVoMap.get(diff.getDetailCode());
            AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
            Validate.isTrue((boolean)Objects.nonNull(diff.getUsedAmount()), (String)"\u5dee\u5f02\u8d39\u7528\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            ledgerDto.setBusinessCode(diff.getDetailCode());
            ledgerDto.setActivityFormCode(detailVo.getActivityFormCode());
            ledgerDto.setActivityFormName(detailVo.getActivityFormName());
            ledgerDto.setActivityTypeCode(detailVo.getActivityTypeCode());
            ledgerDto.setActivityTypeName(detailVo.getActivityTypeName());
            ledgerDto.setResaleCommercialCode(detailVo.getSystemCode());
            ledgerDto.setResaleCommercialName(detailVo.getSystemName());
            ledgerDto.setTerminalCode(detailVo.getTerminalCode());
            ledgerDto.setTerminalName(detailVo.getTerminalName());
            ledgerDto.setOperatorName(crmUserIdentity.getRealName());
            ledgerDto.setFeeDiffLedgerCode(diff.getFeeDiffLedgerCode());
            ledgerDto.setFeeDiffLedgerDisposeCode(diff.getPlanCode());
            ledgerDto.setOperatorAccount(crmUserIdentity.getAccount());
            ledgerDto.setRecoveredAmount(diff.getUsedAmount());
            ledgerDeductionDtoList.add(ledgerDto);
        }
        List codeList = ledgerDeductionDtoList.stream().map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());
        boolean lock = this.auditFeeDiffLedgerLockService.lock(codeList, TimeUnit.MINUTES, 1);
        Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u5dee\u5f02\u8d39\u7528\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        String key = String.format("audit_fee_diff_track_operate:%s", operateId);
        this.redisService.set(key, codeList);
        for (AuditFeeDiffLedgerDeductionDto ledgerDeductionDto : ledgerDeductionDtoList) {
            ledgerDeductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
            ledgerDeductionDto.setDataSource(DiffLedgerDataSourceEnum.DIFF_TRACK.getCode());
            this.auditFeeDiffLedgerVoService.useAmount(ledgerDeductionDto);
        }
    }

    public List<String> findTemplateCodeByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return new ArrayList<String>(0);
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{AuditFeeDiffTrackDetail::getTemplateConfigCode});
        query.eq(AuditFeeDiffTrackDetail::getPlanCode, (Object)planCode);
        query.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        query.groupBy(AuditFeeDiffTrackDetail::getTemplateConfigCode);
        List list = this.auditFeeDiffTrackDetailRepository.list((Wrapper)query);
        ArrayList<String> templateCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            templateCodeList.addAll(list.stream().map(AuditFeeDiffTrackDetail::getTemplateConfigCode).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return templateCodeList;
    }

    public Page<AuditFeeDiffTrackDetailVo> auditFindByConditions(Pageable pageable, AuditFeeDiffTrackDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffTrackDetailDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if ("9999".equals(dto.getRegion())) {
            dto.setRegion(null);
        }
        return this.auditFeeDiffTrackDetailRepository.auditFindByConditions((Page<AuditFeeDiffTrackDetailVo>)page, dto);
    }

    public List<AuditFeeDiffTrackDetailLedgerVo> findLedgerByDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<AuditFeeDiffTrackDetailLedger> list = this.auditFeeDiffTrackDetailLedgerRepository.findByDetailCodeList(detailCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeDiffTrackDetailLedger.class, AuditFeeDiffTrackDetailLedgerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditFeeDiffTrackDetailVo> findByDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.auditFeeDiffTrackDetailRepository.findByDetailCodes(detailCodes);
    }

    public void updateDetailPlanCowManagerState(List<String> successCodes, InterfacePushStateEnum cowManagerState) {
        if (CollectionUtils.isEmpty(successCodes) || cowManagerState == null) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(AuditFeeDiffTrackDetail::getCowManagerState, (Object)cowManagerState.getCode());
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        updateWrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        updateWrapper.in(AuditFeeDiffTrackDetail::getDetailCode, successCodes);
        this.auditFeeDiffTrackDetailRepository.update((Wrapper)updateWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAlreadyAuditAmountByValidationPass(List<AuditFeeDiffTrackDetailDto> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        this.auditFeeDiffTrackDetailRepository.updateAlreadyAuditAmountByValidationPass(updateList);
    }

    public List<String> findEndCastFormByDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        List<String> list = this.auditFeeDiffTrackDetailRepository.findEndCastFormByDetailCodes(detailCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void closeBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u52fe\u9009\u6570\u636e\u8fdb\u884c\u5173\u95ed");
        Collections.sort(ids);
        String redisLockKey = "audit_fee_diff_detail_batch_close:lock:" + String.join((CharSequence)"", ids).hashCode();
        boolean hasLock = false;
        try {
            hasLock = this.redisLockService.tryLock(redisLockKey, TimeUnit.MINUTES, 3L);
            if (!hasLock) {
                throw new RuntimeException("\u6b63\u5728\u5173\u95ed\u5dee\u5f02\u8ffd\u8e2a\u660e\u7ec6\uff0c\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c");
            }
            List<AuditFeeDiffTrackDetail> entities = this.auditFeeDiffTrackDetailRepository.findByIds(ids);
            Assert.notEmpty(entities, (String)"\u52fe\u9009\u6570\u636e\u4e0d\u5b58\u5728");
            AuditFeeDiffTrack diffTrack = this.auditFeeDiffTrackRepository.findByPlanCode(entities.get(0).getPlanCode());
            Assert.notNull((Object)((Object)diffTrack), (String)"\u660e\u7ec6\u5bf9\u5e94\u7684\u8ffd\u8e2a\u6570\u636e\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)ProcessStatusEnum.PASS.getDictCode().equals(diffTrack.getProcessStatus()), (String)"\u660e\u7ec6\u5bf9\u5e94\u7684\u8ffd\u8e2a\u6570\u636e\u5ba1\u6279\u72b6\u6001\u4e0d\u662f\u901a\u8fc7");
            List wholeAuditDetailCodeList = entities.stream().filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getWholeAudit())).map(AuditFeeDiffTrackDetail::getDetailCode).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtils.isEmpty(wholeAuditDetailCodeList), (String)("\u8ffd\u8e2a\u660e\u7ec6" + String.join((CharSequence)",", wholeAuditDetailCodeList) + "\u5df2\u5b8c\u5168\u7ed3\u6848\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\uff01"));
            List<String> detailCodeList = entities.stream().map(AuditFeeDiffTrackDetail::getDetailCode).filter(Objects::nonNull).collect(Collectors.toList());
            List notPassDetailCodeList = this.auditFeeValidationVoService.findProcessStatusNotPass(detailCodeList);
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)notPassDetailCodeList), (String)("\u8ffd\u8e2a\u660e\u7ec6" + String.join((CharSequence)",", notPassDetailCodeList) + "\u5728\u7ed3\u6848\u6838\u9500\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\uff01"));
            List closedCodeList = entities.stream().filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getIsClose())).map(AuditFeeDiffTrackDetail::getDetailCode).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtils.isEmpty(closedCodeList), (String)(String.join((CharSequence)",", closedCodeList) + "\u6570\u636e\u5df2\u88ab\u5173\u95ed"));
            List<AuditFeeDiffTrackDetailLedger> diffList = this.auditFeeDiffTrackDetailLedgerRepository.findByDetailCodeList(detailCodeList);
            Map<String, List<AuditFeeDiffTrackDetailLedger>> detailCodeDiffMap = diffList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedger::getDetailCode));
            ArrayList<AuditFeeDiffLedgerDeductionDto> returnList = new ArrayList<AuditFeeDiffLedgerDeductionDto>();
            block5: for (AuditFeeDiffTrackDetail auditFeeDiffTrackDetail : entities) {
                auditFeeDiffTrackDetail.setIsClose(BooleanEnum.TRUE.getCapital());
                BigDecimal alreadyAuditAmount = Optional.ofNullable(auditFeeDiffTrackDetail.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
                BigDecimal feeAmount = Optional.ofNullable(auditFeeDiffTrackDetail.getFeeAmount()).orElse(BigDecimal.ZERO);
                BigDecimal remain = feeAmount.subtract(alreadyAuditAmount);
                log.info("\u8ffd\u8e2a\u660e\u7ec6:{},\u5f85\u56de\u9000\u91d1\u989d:{}", (Object)auditFeeDiffTrackDetail.getDetailCode(), (Object)remain);
                List<AuditFeeDiffTrackDetailLedger> ledgers = detailCodeDiffMap.get(auditFeeDiffTrackDetail.getDetailCode());
                ledgers = ledgers.stream().sorted(Comparator.comparing(AuditFeeDiffTrackDetailLedger::getFeeDiffLedgerCode, Comparator.reverseOrder())).collect(Collectors.toList());
                for (AuditFeeDiffTrackDetailLedger ledger : ledgers) {
                    if (remain.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                    BigDecimal recoveredAmount = remain.min(ledger.getUsedAmount());
                    log.info("\u8ffd\u8e2a\u660e\u7ec6:{},\u53f0\u8d26\u7f16\u7801:{},\u64cd\u4f5c\u91d1\u989d:{}", new Object[]{auditFeeDiffTrackDetail.getDetailCode(), ledger.getFeeDiffLedgerCode(), recoveredAmount});
                    remain = remain.subtract(ledger.getUsedAmount());
                    AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
                    ledgerDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
                    ledgerDto.setFeeDiffLedgerCode(ledger.getFeeDiffLedgerCode());
                    ledgerDto.setFeeDiffLedgerDisposeCode(auditFeeDiffTrackDetail.getPlanCode());
                    ledgerDto.setBusinessCode(auditFeeDiffTrackDetail.getDetailCode());
                    ledgerDto.setRecoveredAmount(recoveredAmount);
                    AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
                    ledgerDto.setOperatorAccount(loginUser.getAccount());
                    ledgerDto.setOperatorName(loginUser.getRealName());
                    ledgerDto.setRemark(auditFeeDiffTrackDetail.getRemark());
                    ledgerDto.setResaleCommercialCode(auditFeeDiffTrackDetail.getSystemCode());
                    ledgerDto.setResaleCommercialName(auditFeeDiffTrackDetail.getSystemName());
                    ledgerDto.setTerminalCode(auditFeeDiffTrackDetail.getTerminalCode());
                    ledgerDto.setTerminalName(auditFeeDiffTrackDetail.getTerminalName());
                    ledgerDto.setActivityFormCode(auditFeeDiffTrackDetail.getActivityFormCode());
                    ledgerDto.setActivityFormName(auditFeeDiffTrackDetail.getActivityFormName());
                    ledgerDto.setActivityTypeCode(auditFeeDiffTrackDetail.getActivityTypeCode());
                    ledgerDto.setActivityTypeName(auditFeeDiffTrackDetail.getActivityTypeName());
                    ledgerDto.setDataSource(DiffLedgerDataSourceEnum.DIFF_TRACK.getCode());
                    returnList.add(ledgerDto);
                }
            }
            List feeDiffLedgerCodeList = returnList.stream().map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).collect(Collectors.toList());
            Assert.isTrue((boolean)this.auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 1), (String)"\u5173\u95ed\u65f6\u56de\u9000\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            for (AuditFeeDiffLedgerDeductionDto dto : returnList) {
                this.auditFeeDiffLedgerVoService.useAmount(dto);
            }
            this.auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            this.auditFeeDiffTrackDetailRepository.updateBatchById(entities);
            List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, AuditFeeDiffTrackDetail.class, AuditFeeDiffTrackDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.diffTrackPushCowManager.closeItemPush(list);
        }
        catch (Exception e2) {
            log.info("\u5dee\u5f02\u8ffd\u8e2a\u660e\u7ec6\u6279\u91cf\u5173\u95ed\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
            throw e2;
        }
        finally {
            if (hasLock) {
                log.info("\u5dee\u5f02\u8ffd\u8e2a\u660e\u7ec6\u6279\u91cf\u5173\u95ed\u5df2\u89e3\u9501");
                this.redisLockService.unlock(redisLockKey);
            }
        }
    }
}

