/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.internal.track;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrack;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.track.AuditFeeDiffTrackDetailPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.service.third.DiffTrackPushCowManager;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackApproveSubmitDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackForecastDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffTrackDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackSummaryVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AuditFeeDiffTrackVoServiceImpl
implements AuditFeeDiffTrackVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffTrackVoServiceImpl.class);
    @Autowired
    private AuditFeeDiffTrackRepository auditFeeDiffTrackRepository;
    @Autowired
    private AuditFeeDiffTrackDetailRepository auditFeeDiffTrackDetailRepository;
    @Autowired
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailPageCacheHelper helper;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private DiffTrackPushCowManager diffTrackPushCowManager;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;

    public Page<AuditFeeDiffTrackVo> findByConditions(Pageable pageable, AuditFeeDiffTrackDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffTrackDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditFeeDiffTrackRepository.findByConditions((Page<AuditFeeDiffTrackVo>)page, dto);
    }

    public AuditFeeDiffTrackVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFeeDiffTrack entity = this.auditFeeDiffTrackRepository.findById(id);
        if (entity == null) {
            return null;
        }
        AuditFeeDiffTrackVo vo = (AuditFeeDiffTrackVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeDiffTrackVo.class, HashSet.class, ArrayList.class, new String[0]);
        List templateCodeList = this.auditFeeDiffTrackDetailVoService.findTemplateCodeByPlanCode(vo.getPlanCode());
        vo.setTemplateCodeList(templateCodeList);
        return vo;
    }

    public AuditFeeDiffTrackVo findDetailByProcessNo(String processNo) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return null;
        }
        AuditFeeDiffTrack entity = this.auditFeeDiffTrackRepository.findByProcessNo(processNo);
        if (entity == null) {
            return null;
        }
        AuditFeeDiffTrackVo vo = (AuditFeeDiffTrackVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeDiffTrackVo.class, HashSet.class, ArrayList.class, new String[0]);
        List templateCodeList = this.auditFeeDiffTrackDetailVoService.findTemplateCodeByPlanCode(vo.getPlanCode());
        vo.setTemplateCodeList(templateCodeList);
        return vo;
    }

    public void pushCowManagerManual() {
        List<AuditFeeDiffTrackDetailVo> detailVos = this.auditFeeDiffTrackDetailRepository.pushCowManagerManual();
        if (CollectionUtils.isEmpty(detailVos)) {
            return;
        }
        this.diffTrackPushCowManager.passItemPush(detailVos);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(AuditFeeDiffTrackDto dto) {
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u65b0\u589e{}", (Object)dto);
        this.createValidate(dto);
        AuditFeeDiffTrack auditFeeDiffTrack = new AuditFeeDiffTrack();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)auditFeeDiffTrack));
        this.auditFeeDiffTrackRepository.initInfo(auditFeeDiffTrack);
        auditFeeDiffTrack.setPlanCode((String)this.generateCodeService.generateCode("DH", 1).get(0));
        auditFeeDiffTrack.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        auditFeeDiffTrack.setIsClose(BooleanEnum.FALSE.getCapital());
        auditFeeDiffTrack.setDatasource(AuditFeeDiffTrackDataSourceEnum.MANUAL.getCode());
        auditFeeDiffTrack.setWholeAudit(BooleanEnum.FALSE.getSure());
        this.auditFeeDiffTrackRepository.save((Object)auditFeeDiffTrack);
        String cacheKey = dto.getCacheKey();
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            this.auditFeeDiffTrackDetailVoService.removeBatchByPlanCodeList((List)Lists.newArrayList((Object[])new String[]{auditFeeDiffTrack.getPlanCode()}));
            List detailDtoList = this.auditFeeDiffTrackDetailVoService.findCacheList(dto.getCacheKey());
            this.createDetail(auditFeeDiffTrack, detailDtoList);
            log.info("\u8ffd\u8e2a\u660e\u7ec6\u6570\u636e,{}", (Object)detailDtoList.size());
            this.auditFeeDiffTrackDetailVoService.clearCache(dto.getCacheKey());
            this.auditFeeDiffTrackDetailVoService.clearCache(cacheKey);
        }
    }

    private void createValidate(AuditFeeDiffTrackDto dto) {
        Validate.notNull((Object)dto.getPlanName(), (String)"\u5dee\u5f02\u8d39\u7528\u5904\u7406\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getPlanName().length() < 255 ? 1 : 0) != 0, (String)"\u5dee\u5f02\u8d39\u7528\u5904\u7406\u540d\u79f0\u8d85\u957f", (Object[])new Object[0]);
        List<AuditFeeDiffTrackSummaryVo> summaryVos = this.collectDiffAmount(dto);
        List notEnoughList = summaryVos.stream().filter(e -> e.getBeRecoveredAmountTotal().compareTo(e.getUsedAmountTotal()) < 0).map(AuditFeeDiffTrackSummaryVo::getFeeDiffLedgerCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(notEnoughList), (String)(String.join((CharSequence)",", notEnoughList) + "\u91d1\u989d\u4e0d\u8db3"), (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void edit(AuditFeeDiffTrackDto dto) {
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u7f16\u8f91{}", (Object)dto);
        this.updateValidate(dto);
        AuditFeeDiffTrack auditFeeDiffTrack = new AuditFeeDiffTrack();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)auditFeeDiffTrack));
        if (StringUtil.isEmpty((CharSequence)auditFeeDiffTrack.getWholeAudit())) {
            auditFeeDiffTrack.setWholeAudit(BooleanEnum.FALSE.getSure());
        }
        this.auditFeeDiffTrackRepository.updateById((Object)auditFeeDiffTrack);
        if (StringUtils.isNotBlank((CharSequence)dto.getCacheKey())) {
            this.auditFeeDiffTrackDetailVoService.removeBatchByPlanCodeList((List)Lists.newArrayList((Object[])new String[]{auditFeeDiffTrack.getPlanCode()}));
            List detailDtoList = this.auditFeeDiffTrackDetailVoService.findCacheList(dto.getCacheKey());
            this.createDetail(auditFeeDiffTrack, detailDtoList);
            log.info("\u8ffd\u8e2a\u660e\u7ec6\u6570\u636e,{}", (Object)detailDtoList.size());
            this.auditFeeDiffTrackDetailVoService.clearCache(dto.getCacheKey());
        }
    }

    private void updateValidate(AuditFeeDiffTrackDto dto) {
        Validate.notNull((Object)dto.getPlanName(), (String)"\u5dee\u5f02\u8d39\u7528\u5904\u7406\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getPlanName().length() < 255 ? 1 : 0) != 0, (String)"\u5dee\u5f02\u8d39\u7528\u5904\u7406\u540d\u79f0\u8d85\u957f", (Object[])new Object[0]);
        List<AuditFeeDiffTrackSummaryVo> summaryVos = this.collectDiffAmount(dto);
        List notEnoughList = summaryVos.stream().filter(e -> e.getBeRecoveredAmountTotal().compareTo(e.getUsedAmountTotal()) < 0).map(AuditFeeDiffTrackSummaryVo::getFeeDiffLedgerCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(notEnoughList), (String)(String.join((CharSequence)",", notEnoughList) + "\u91d1\u989d\u4e0d\u8db3"), (Object[])new Object[0]);
    }

    private void createDetail(AuditFeeDiffTrack auditFeeDiffTrack, List<AuditFeeDiffTrackDetailDto> detailDtoList) {
        if (CollectionUtils.isEmpty(detailDtoList)) {
            return;
        }
        HashSet templateConfigCodeSet = Sets.newHashSet();
        HashSet terminalCodes = Sets.newHashSet();
        for (AuditFeeDiffTrackDetailDto detail : detailDtoList) {
            Validate.isTrue((boolean)detail.getActivityBeginDateStr().substring(0, 7).equals(detail.getActivityEndDateStr().substring(0, 7)), (String)"\u6d3b\u52a8\u5f00\u59cb/\u7ed3\u675f\u4e0d\u5141\u8bb8\u8de8\u6708\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)detail.getTemplateConfigCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            templateConfigCodeSet.add(detail.getTemplateConfigCode());
            if (detail.getTerminalCode() != null) {
                terminalCodes.add(detail.getTerminalCode());
            }
            if (!StringUtil.isEmpty((CharSequence)detail.getWholeAudit())) continue;
            detail.setWholeAudit(BooleanEnum.FALSE.getSure());
        }
        List templateList = this.activitiesTemplateSdkService.findByCodeList((List)Lists.newArrayList((Iterable)templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("\u6d3b\u52a8\u660e\u7ec6\u6a21\u677f\u6570\u636e\u6709\u8bef\uff01");
        }
        String firstChannel = "firstChannelName";
        String secondChannel = "secondChannelCode";
        Map dictTypeCodeMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"firstChannelName", "secondChannelCode"}));
        HashMap firstChannelMap = CollectionUtils.isEmpty((Collection)((Collection)dictTypeCodeMap.get("firstChannelName"))) ? new HashMap(0) : ((List)dictTypeCodeMap.get("firstChannelName")).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        HashMap secondChannelMap = CollectionUtils.isEmpty((Collection)((Collection)dictTypeCodeMap.get("secondChannelCode"))) ? new HashMap(0) : ((List)dictTypeCodeMap.get("secondChannelCode")).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        HashMap terminalMap = new HashMap();
        List terminalList = this.terminalVoService.findBaseByTerminalCodes((List)Lists.newArrayList((Iterable)terminalCodes));
        if (CollectionUtils.isNotEmpty((Collection)terminalList)) {
            terminalMap.putAll(terminalList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }
        Map templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<AuditFeeDiffTrackDetailDto>> groupBy = detailDtoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailDto::getTemplateConfigCode));
        AtomicReference<BigDecimal> feeAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> useAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        groupBy.forEach((k, v) -> {
            ActivitiesTemplateConfigVo templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(k);
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            ObjectConvertStringUtil.convertObjectListStrProperties((List)v, AuditFeeDiffTrackDetailDto.class, null, (boolean)true, templateDetailTitleMap);
            v.forEach(e -> {
                TerminalVo terminalVo;
                e.setPlanCode(auditFeeDiffTrack.getPlanCode());
                BigDecimal theFeeAmount = StringUtils.isBlank((CharSequence)e.getFeeAmountStr()) ? BigDecimal.ZERO : new BigDecimal(e.getFeeAmountStr());
                feeAmount.set(((BigDecimal)feeAmount.get()).add(theFeeAmount));
                if (CollectionUtils.isNotEmpty((Collection)e.getAuditFeeDiffTrackDetailLedgerList())) {
                    useAmount.set(((BigDecimal)useAmount.get()).add(e.getAuditFeeDiffTrackDetailLedgerList().stream().filter(diff -> Objects.nonNull(diff.getUsedAmount())).map(AuditFeeDiffTrackDetailLedgerDto::getUsedAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
                if (StringUtils.isNotEmpty((CharSequence)e.getFirstChannelCode())) {
                    e.setFirstChannelName((String)firstChannelMap.get(e.getFirstChannelCode()));
                }
                if (StringUtils.isNotEmpty((CharSequence)e.getSecondChannelCode())) {
                    e.setSecondChannelName((String)secondChannelMap.get(e.getSecondChannelCode()));
                }
                if (StringUtils.isNotEmpty((CharSequence)e.getTerminalCode()) && (terminalVo = (TerminalVo)terminalMap.get(e.getTerminalCode())) != null) {
                    e.setCustomerCode(terminalVo.getSellerCode());
                    e.setCustomerName(terminalVo.getSellerName());
                }
            });
            log.info("\u63d2\u5165\u660e\u7ec6\u6570\u636e,{}", (Object)JSON.toJSONString((Object)v));
            this.auditFeeDiffTrackDetailVoService.createBatch(v);
        });
        Validate.isTrue((feeAmount.get().compareTo(useAmount.get()) == 0 ? 1 : 0) != 0, (String)"\u5173\u8054\u9884\u7b97\u91d1\u989d\u9700\u7b49\u4e8e\u6211\u65b9\u627f\u62c5\u91d1\u989d\u4e4b\u548c", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditFeeDiffTrack> auditFeeDiffTrackList = this.auditFeeDiffTrackRepository.findByIds(ids);
        Validate.notEmpty(auditFeeDiffTrackList, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List notPrepareList = auditFeeDiffTrackList.stream().map(AuditFeeDiffTrack::getProcessStatus).filter(e -> !ProcessStatusEnum.PREPARE.getDictCode().equals(e)).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(notPrepareList), (String)"\u5ba1\u6838\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\uff0c\u53ea\u6709\u5f85\u5ba1\u6838\u72b6\u6001\u624d\u80fd\u5220\u9664", (Object[])new Object[0]);
        log.info("\u5dee\u5f02\u8ffd\u8e2a\u903b\u8f91\u5220\u9664-\u5f00\u59cb");
        auditFeeDiffTrackList = auditFeeDiffTrackList.stream().peek(e -> e.setDelFlag(DelFlagStatusEnum.DELETE.getCode())).collect(Collectors.toList());
        this.auditFeeDiffTrackRepository.updateBatchById(auditFeeDiffTrackList);
        List planCodeList = auditFeeDiffTrackList.stream().map(AuditFeeDiffTrack::getPlanCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(planCodeList)) {
            this.auditFeeDiffTrackDetailVoService.removeBatchByPlanCodeList(planCodeList);
        }
    }

    public List<CommonSelectVo> findActivitiesTemplateConfigSelectList(ActivitiesTemplateConfigDto configDto, CommonSelectDto dto) {
        Validate.notBlank((CharSequence)configDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)configDto.getBusinessUnitCode())) {
            configDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        }
        configDto.setType(ActivitiesTemplateConfigTypeEnum.DIFF_FEE_DISPOSE.getCode());
        return this.activitiesTemplateSdkService.findActivitiesTemplateConfigSelectList(dto, configDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(List<String> ids, AuditFeeDiffTrackApproveSubmitDto dto) {
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u6d41\u7a0b\u63d0\u4ea4id{} \u5bf9\u8c61{}", ids, (Object)dto);
        List auditFeeDiffTracks = this.auditFeeDiffTrackRepository.listByIds(ids);
        for (AuditFeeDiffTrack auditFeeDiffTrack : auditFeeDiffTracks) {
            if (Boolean.TRUE.equals(auditFeeDiffTrack.getTempSave())) {
                throw new RuntimeException("\u8ffd\u8e2a\u7f16\u7801[" + auditFeeDiffTrack.getPlanCode() + "]\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
            }
            if (ProcessStatusEnum.PREPARE.getDictCode().equals(auditFeeDiffTrack.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(auditFeeDiffTrack.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(auditFeeDiffTrack.getProcessStatus())) continue;
            throw new RuntimeException("\u8ffd\u8e2a\u7f16\u7801[" + auditFeeDiffTrack.getPlanCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        List<String> planCodeList = auditFeeDiffTracks.stream().map(AuditFeeDiffTrack::getPlanCode).collect(Collectors.toList());
        this.auditFeeDiffTrackDetailVoService.useMonthBudgetByPlanCodeList(planCodeList, dto.getOperateId());
        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        processBusinessDto.setBusinessNoList(planCodeList);
        processBusinessDto.setBusinessCode("audit_fee_diff_track");
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusinessDto.setBusinessNo(businessNo);
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusinessDto);
        this.auditFeeDiffTrackRepository.updateProcessStatusAndProcessNo(planCodeList, ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo());
    }

    @Transactional(rollbackFor={Exception.class})
    public void processPass(ProcessStatusDto dto) {
        this.auditFeeDiffTrackRepository.updateProcessStatus(dto.getBusinessNoList(), dto.getProcessStatus());
    }

    @Transactional(rollbackFor={Exception.class})
    public void processRejectAndRecover(ProcessStatusDto dto, String operateId) {
        this.auditFeeDiffTrackDetailVoService.returnMonthBudgetByPlanCodeList(dto.getBusinessNoList(), operateId);
        this.auditFeeDiffTrackRepository.updateProcessStatus(dto.getBusinessNoList(), dto.getProcessStatus());
    }

    @Transactional(rollbackFor={Exception.class})
    public void close(List<String> ids, String operateId) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<AuditFeeDiffTrack> entities = this.auditFeeDiffTrackRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        List notPassEntityPlanNameList = entities.stream().filter(e -> ProcessStatusEnum.PASS.getDictCode().equals(e.getProcessStatus())).map(AuditFeeDiffTrack::getPlanName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(notPassEntityPlanNameList), (String)("\u5dee\u5f02\u8d39\u7528\u5904\u7406\u540d\u79f0[" + String.join((CharSequence)",", notPassEntityPlanNameList) + "]\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u65e0\u6cd5\u5173\u95ed"));
        List wholeAuditedPlanNameList = entities.stream().filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getWholeAudit())).map(AuditFeeDiffTrack::getPlanName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(notPassEntityPlanNameList), (String)("\u5dee\u5f02\u8d39\u7528\u5904\u7406\u540d\u79f0[" + String.join((CharSequence)",", wholeAuditedPlanNameList) + "]\u5df2\u5b8c\u5168\u7ed3\u6848\uff0c\u65e0\u6cd5\u5173\u95ed"));
        entities = entities.stream().peek(e -> e.setIsClose(BooleanEnum.TRUE.getCapital())).collect(Collectors.toList());
        this.auditFeeDiffTrackRepository.saveOrUpdateBatch(entities);
        List<String> planCodeList = entities.stream().map(AuditFeeDiffTrack::getPlanCode).distinct().collect(Collectors.toList());
        this.auditFeeDiffTrackDetailVoService.returnMonthBudgetByPlanCodeList(planCodeList, operateId);
        this.diffTrackPushCowManager.closePush(planCodeList);
    }

    public List<AuditFeeDiffTrackForecastDto> buildAuditFeeDiffTrackPlanParams(List<String> businessNoList) {
        ArrayList<AuditFeeDiffTrackForecastDto> list = new ArrayList<AuditFeeDiffTrackForecastDto>();
        if (!CollectionUtils.isEmpty(businessNoList)) {
            List entityList = ((LambdaQueryChainWrapper)this.auditFeeDiffTrackRepository.lambdaQuery().in(AuditFeeDiffTrack::getPlanCode, businessNoList)).list();
            List detailList = this.auditFeeDiffTrackDetailVoService.findDetailByPlanCodeList(businessNoList);
            Map<String, List<AuditFeeDiffTrackDetailVo>> trackPlanDetailsMap = detailList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailVo::getPlanCode));
            ArrayList diffTrackDetailLedgerVoList = new ArrayList();
            for (AuditFeeDiffTrackDetailVo detailVo : detailList) {
                diffTrackDetailLedgerVoList.addAll(detailVo.getAuditFeeDiffTrackDetailLedgerList());
            }
            Map<Object, Object> ledgerMap = new HashMap();
            if (CollectionUtils.isNotEmpty(diffTrackDetailLedgerVoList)) {
                ledgerMap = diffTrackDetailLedgerVoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getDetailCode));
            }
            for (AuditFeeDiffTrack entity : entityList) {
                String businessUnitCode = entity.getBusinessUnitCode();
                String businessFormatCode = entity.getBusinessFormatCode();
                AuditFeeDiffTrackForecastDto trackForecastDto = (AuditFeeDiffTrackForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeDiffTrackForecastDto.class, HashSet.class, ArrayList.class, new String[0]);
                List<AuditFeeDiffTrackDetailVo> detailItemList = trackPlanDetailsMap.get(entity.getPlanCode());
                if (CollectionUtils.isNotEmpty(detailItemList)) {
                    List detailItemDtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(detailItemList, AuditFeeDiffTrackDetailVo.class, AuditFeeDiffTrackDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    for (AuditFeeDiffTrackDetailDto detailItemDto : detailItemDtoList) {
                        detailItemDto.setBusinessUnitCode(businessUnitCode);
                        detailItemDto.setBusinessFormatCode(businessFormatCode);
                        List ledgerVoList = (List)ledgerMap.get(detailItemDto.getDetailCode());
                        if (!CollectionUtils.isNotEmpty((Collection)ledgerVoList)) continue;
                        Collection activityPlanBudgetDtos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)ledgerVoList, AuditFeeDiffTrackDetailLedgerVo.class, AuditFeeDiffTrackDetailLedgerDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        detailItemDto.setAuditFeeDiffTrackDetailLedgerList((List)activityPlanBudgetDtos);
                    }
                    trackForecastDto.setItemList(detailItemDtoList);
                }
                list.add(trackForecastDto);
            }
        }
        return list;
    }

    public List<AuditFeeDiffTrackSummaryVo> collectDiffAmount(AuditFeeDiffTrackDto dto) {
        log.info("\u6c47\u603b\u5dee\u5f02\u8d39\u7528\u4fe1\u606f{}", (Object)dto);
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCacheKey(), (String)"\u6570\u636e\u7f13\u5b58KEY\u7a7a", (Object[])new Object[0]);
        ArrayList cacheDiffList = new ArrayList();
        List detailDtoList = this.auditFeeDiffTrackDetailVoService.findCacheList(dto.getCacheKey());
        if (CollectionUtils.isNotEmpty((Collection)detailDtoList)) {
            detailDtoList.forEach(e -> {
                if (CollectionUtils.isNotEmpty((Collection)e.getAuditFeeDiffTrackDetailLedgerList())) {
                    cacheDiffList.addAll(e.getAuditFeeDiffTrackDetailLedgerList());
                }
            });
        }
        if (CollectionUtils.isEmpty(cacheDiffList)) {
            return new ArrayList<AuditFeeDiffTrackSummaryVo>(0);
        }
        Collection diffVoList = this.nebulaToolkitService.copyCollectionByBlankList(cacheDiffList, AuditFeeDiffTrackDetailLedgerDto.class, AuditFeeDiffTrackDetailLedgerVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Map<String, List<AuditFeeDiffTrackDetailLedgerVo>> diffCodeMap = diffVoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getFeeDiffLedgerCode));
        ArrayList<AuditFeeDiffTrackSummaryVo> diffTrackSummaryVos = new ArrayList<AuditFeeDiffTrackSummaryVo>(diffCodeMap.size());
        diffCodeMap.forEach((k, v) -> {
            AuditFeeDiffTrackSummaryVo trackSummaryVo = new AuditFeeDiffTrackSummaryVo();
            trackSummaryVo.setFeeDiffLedgerCode(k);
            AuditFeeDiffTrackDetailLedgerVo detailLedgerVo = (AuditFeeDiffTrackDetailLedgerVo)v.get(0);
            trackSummaryVo.setYearMonth(detailLedgerVo.getFeeYearMonth());
            BigDecimal usedAmountTotal = BigDecimal.ZERO;
            for (AuditFeeDiffTrackDetailLedgerVo ledgerVo : v) {
                usedAmountTotal = usedAmountTotal.add(Optional.ofNullable(ledgerVo.getUsedAmount()).orElse(BigDecimal.ZERO));
            }
            trackSummaryVo.setBeRecoveredAmountTotal(detailLedgerVo.getBeRecoveredAmount());
            trackSummaryVo.setUsedAmountTotal(usedAmountTotal);
            diffTrackSummaryVos.add(trackSummaryVo);
        });
        return diffTrackSummaryVos;
    }

    public BigDecimal collectFeeAmount(AuditFeeDiffTrackDto dto) {
        log.info("\u7533\u8bf7\u91d1\u989d\u6c47\u603b\u53c2\u6570{}", (Object)dto);
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCacheKey(), (String)"\u6570\u636e\u7f13\u5b58KEY\u7a7a", (Object[])new Object[0]);
        List detailDtoList = this.auditFeeDiffTrackDetailVoService.findCacheList(dto.getCacheKey());
        BigDecimal feeAmountTotal = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)detailDtoList)) {
            for (AuditFeeDiffTrackDetailDto trackDetailDto : detailDtoList) {
                String feeAmount = trackDetailDto.getFeeAmountStr();
                feeAmountTotal = feeAmountTotal.add(StringUtils.isBlank((CharSequence)feeAmount) ? BigDecimal.ZERO : new BigDecimal(feeAmount));
            }
        }
        return feeAmountTotal;
    }
}

