/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.observer;

import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeDiffDisposeCallbackServiceImpl
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeCallbackServiceImpl.class);
    @Autowired
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;
    @Autowired(required=false)
    private List<AuditFeeDiffDisposeEventListener> eventListeners;

    public String getBusinessCode() {
        return "AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String processStatus = dto.getProcessStatus();
        if (CollectionUtils.isNotEmpty(this.eventListeners)) {
            this.eventListeners.forEach(eventListeners -> eventListeners.onUpdateProcessStatus(processStatus, dto.getProcessNo()));
        }
    }
}

