/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.perdiction.internal;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePredictionFormula;
import com.biz.crm.tpm.business.audit.fee.local.repository.prediction.AuditFeePredictionFormulaRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.prediction.AuditFeePredictionRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateRulesVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeePredictionServiceImpl
implements AuditFeePredictionService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeePredictionServiceImpl.class);
    @Autowired
    private VariableService variableService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private DetailedForecastService detailedForecastService;
    @Autowired
    private AuditFeePredictionRepository auditFeePredictionRepository;
    @Autowired
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;
    @Autowired
    private AuditFeePredictionFormulaRepository auditFeePredictionFormulaRepository;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<AuditFeePredictionDto> dtos) {
        log.info("\u6279\u91cf\u521b\u5efa\u6263\u8d39\u9884\u6d4b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(dtos));
        this.validateCreate(dtos);
        List entityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dtos, AuditFeePredictionDto.class, AuditFeePrediction.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeePredictionRepository.saveBatch(entityList);
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList predictionFormulaList = Lists.newArrayList();
        ArrayList updateEntityList = Lists.newArrayList();
        entityList.forEach(entity -> {
            TpmDeductionDetailMappingDto mappingDto = new TpmDeductionDetailMappingDto();
            mappingDto.setBusinessFormatCode(entity.getBusinessFormatCode());
            mappingDto.setBusinessUnitCode(entity.getBusinessUnitCode());
            mappingDto.setSalesInstitutionErpCode(entity.getSalesInstitutionCode());
            mappingDto.setResaleCommercialCode(entity.getSystemCode());
            mappingDto.setFirstChannelCode(entity.getFirstChannelCode());
            mappingDto.setSecondChannelCode(entity.getSecondChannelCode());
            if (StringUtils.isNotEmpty((CharSequence)entity.getCustomerCode())) {
                ArrayList customerCodes = Lists.newArrayList();
                customerCodes.add(entity.getCustomerCode());
                mappingDto.setCustomerCodeList((List)customerCodes);
            }
            mappingDto.setBuyWay(entity.getBuyWay());
            mappingDto.setActivityFormCode(entity.getActivityFormCode());
            mappingDto.setTenantCode(tenantCode);
            List mappingVos = this.tpmDeductionDetailMappingService.findByDto(mappingDto);
            log.info("\u6279\u91cf\u521b\u5efa\u6263\u8d39\u9884\u6d4b\u6620\u5c04\uff1a{}", (Object)JSONObject.toJSONString((Object)mappingVos));
            if (!CollectionUtils.isEmpty((Collection)mappingVos) && mappingVos.size() == 1) {
                TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
                templateDto.setBusinessFormatCode(entity.getBusinessFormatCode());
                templateDto.setBusinessUnitCode(entity.getBusinessUnitCode());
                templateDto.setApplyMappingCode(((TpmDeductionDetailMappingVo)mappingVos.get(0)).getCode());
                templateDto.setTenantCode(tenantCode);
                List templateVoList = this.tpmDeductionMatchingTemplateService.findByDto(templateDto);
                log.info("\u6279\u91cf\u521b\u5efa\u6263\u8d39\u9884\u6d4b\u6a21\u677f\uff1a{}", (Object)JSONObject.toJSONString((Object)templateVoList));
                if (!CollectionUtils.isEmpty((Collection)templateVoList) && templateVoList.size() == 1) {
                    TpmDeductionMatchingTemplateVo templateVo = (TpmDeductionMatchingTemplateVo)templateVoList.get(0);
                    entity.setMatchTemplateCode(templateVo.getCode());
                    List templateRulesVoList = templateVo.getRulesList();
                    if (!CollectionUtils.isEmpty((Collection)templateRulesVoList)) {
                        templateRulesVoList.forEach(rule -> {
                            AuditFeePredictionFormula predictionFormula = (AuditFeePredictionFormula)((Object)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(rule, AuditFeePredictionFormula.class, HashSet.class, ArrayList.class, new String[0]))));
                            predictionFormula.setId(null);
                            predictionFormula.setDetailPlanItemCode(entity.getDetailPlanItemCode());
                            predictionFormulaList.add(predictionFormula);
                        });
                        try {
                            this.templateRuleComputation((AuditFeePrediction)((Object)entity), templateRulesVoList);
                            updateEntityList.add(entity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.info("\u6279\u91cf\u521b\u5efa\u6263\u8d39\u9884\u6d4b\u6a21\u677f,\u516c\u5f0f\u8ba1\u7b97\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        }
                    }
                }
            }
        });
        if (!CollectionUtils.isEmpty((Collection)updateEntityList)) {
            this.auditFeePredictionRepository.updateBatchById(updateEntityList);
        }
        if (!CollectionUtils.isEmpty((Collection)predictionFormulaList)) {
            this.auditFeePredictionFormulaRepository.saveBatch(predictionFormulaList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoUpdateByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List list = this.auditFeePredictionRepository.listByIds(ids);
        Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u6263\u8d39\u9884\u6d4b\u4fe1\u606f", (Object[])new Object[0]);
        this.syncUpdateData(list);
        this.auditFeePredictionRepository.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.auditFeePredictionRepository.removeByIds(ids);
    }

    private void syncUpdateData(List<AuditFeePrediction> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set activityDetailItemCodes = list.stream().map(AuditFeePrediction::getDetailPlanItemCode).collect(Collectors.toSet());
        List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(activityDetailItemCodes);
        log.info("\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)detailedForecastVoList));
        HashMap detailedForecastVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
            detailedForecastVoMap.putAll(detailedForecastVoList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), (a, b) -> a)));
        }
        List matchTemplateCodes = list.stream().map(AuditFeePrediction::getMatchTemplateCode).collect(Collectors.toList());
        List templateVoList = this.tpmDeductionMatchingTemplateService.findByCodes(matchTemplateCodes);
        log.info("\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)templateVoList));
        HashMap templateVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)templateVoList)) {
            templateVoMap.putAll(templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode, Function.identity(), (a, b) -> a)));
        }
        ArrayList totalFormulaList = Lists.newArrayList();
        ArrayList needUpdateFormula = Lists.newArrayList();
        list.forEach(entity -> {
            TpmDeductionMatchingTemplateVo templateVo;
            List templateRulesVoList;
            if (templateVoMap.containsKey(entity.getMatchTemplateCode()) && !CollectionUtils.isEmpty((Collection)(templateRulesVoList = (templateVo = (TpmDeductionMatchingTemplateVo)templateVoMap.get(entity.getMatchTemplateCode())).getRulesList()))) {
                List<AuditFeePredictionFormula> formulaList = this.templateRuleComputation((AuditFeePrediction)((Object)entity), templateRulesVoList);
                totalFormulaList.addAll(formulaList);
                needUpdateFormula.add(entity.getDetailPlanItemCode());
            }
            if (detailedForecastVoMap.containsKey(entity.getDetailPlanItemCode())) {
                DetailedForecastVo detailedForecastVo = (DetailedForecastVo)detailedForecastVoMap.get(entity.getDetailPlanItemCode());
                entity.setPredictionAccountsAmount(detailedForecastVo.getEstimatedWriteOffAmount());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)needUpdateFormula)) {
            this.auditFeePredictionFormulaRepository.removeByDetailItemCodes(needUpdateFormula);
        }
        if (!CollectionUtils.isEmpty((Collection)totalFormulaList)) {
            this.auditFeePredictionFormulaRepository.saveBatch(totalFormulaList);
        }
    }

    @Override
    public void autoJobUpdate() {
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findAll(BooleanEnum.TRUE.getCapital());
        if (!CollectionUtils.isEmpty(list)) {
            this.syncUpdateData(list);
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }

    @Override
    public List<AuditFeePredictionVo> findByActivityDetailPlanItemCodes(List<String> activityDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(activityDetailPlanItemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeePrediction.class, AuditFeePredictionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public Page<AuditFeePredictionVo> findByConditions(Pageable pageable, AuditFeePredictionDto dto) {
        return this.auditFeePredictionRepository.findByConditions(pageable, dto);
    }

    @Override
    @Async
    public void autoJobAsync(AuditFeePredictionDto dto, UserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        this.autoJobSync(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoJobSync(AuditFeePredictionDto dto) {
        boolean hasLock = false;
        String redisLockKey = "audit_fee_prediction_generate:lock:";
        try {
            hasLock = this.redisLockService.tryLock(redisLockKey, TimeUnit.MINUTES, 5L);
            if (!hasLock) {
                throw new RuntimeException("\u6b63\u5728\u540c\u6b65\u6263\u8d39\u9884\u6d4b\u6570\u636e");
            }
            log.info("\u6263\u8d39\u9884\u6d4b-\u81ea\u52a8\u540c\u6b65\u6570\u636e-\u5f00\u59cb");
            Date now = new Date();
            Date beforeWeek = this.getDate(now, -7);
            ActivityDetailPlanDto detailPlanDto = new ActivityDetailPlanDto();
            if (dto.getActivityBeginDate() != null) {
                detailPlanDto.setActivityBeginDate((Date)DateUtil.beginOfDay((Date)dto.getActivityBeginDate()));
            } else {
                detailPlanDto.setActivityBeginDate(beforeWeek);
            }
            if (dto.getActivityEndDate() != null) {
                detailPlanDto.setActivityEndDate((Date)DateUtil.endOfDay((Date)dto.getActivityEndDate()));
            } else {
                detailPlanDto.setActivityEndDate(now);
            }
            detailPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page detailPlanItemCodePage = null;
            List detailPlanItemCodes = null;
            PageRequest pageable = PageRequest.of((int)0, (int)2000);
            while ((detailPlanItemCodePage = this.activityDetailPlanSdkService.findByDtoForPrediction((Pageable)(pageable = pageable.next()), detailPlanDto)) != null && !CollectionUtils.isEmpty((Collection)detailPlanItemCodePage.getRecords())) {
                detailPlanItemCodes = detailPlanItemCodePage.getRecords();
                log.info("\u9875\u7801\uff1a{}\uff0c\u5782\u76f4\u6d3b\u52a8\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)pageable.getPageNumber(), (Object)JSONObject.toJSONString((Object)detailPlanItemCodes));
                List<String> existItemCodes = this.auditFeePredictionRepository.findExistItemCode(detailPlanItemCodes);
                List notExistItemCodes = detailPlanItemCodes.stream().filter(e -> !existItemCodes.contains(e)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(notExistItemCodes)) {
                    List itemVos = this.activityDetailPlanItemSdkService.findDetailAndExtendByItemCodes(notExistItemCodes);
                    List<AuditFeePredictionDto> dtos = this.verticalDetailPlanConvertToPrediction(itemVos);
                    this.auditFeePredictionFormulaRepository.removeByDetailItemCodes(dtos.stream().map(AuditFeePredictionDto::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
                    this.createBatch(dtos);
                    notExistItemCodes.clear();
                }
                detailPlanItemCodes.clear();
                if (detailPlanItemCodePage.hasNext()) continue;
            }
            SubComActivityDetailPlanDto subComDetailPlanDto = new SubComActivityDetailPlanDto();
            if (dto.getActivityBeginDate() != null) {
                subComDetailPlanDto.setActivityBeginTime((Date)DateUtil.beginOfDay((Date)dto.getActivityBeginDate()));
            } else {
                subComDetailPlanDto.setActivityBeginTime(beforeWeek);
            }
            if (dto.getActivityEndDate() != null) {
                subComDetailPlanDto.setActivityEndTime((Date)DateUtil.endOfDay((Date)dto.getActivityEndDate()));
            } else {
                subComDetailPlanDto.setActivityEndTime(now);
            }
            subComDetailPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page subDetailPlanItemCodePage = null;
            List subDetailPlanItemCodes = null;
            PageRequest subPageable = PageRequest.of((int)0, (int)2000);
            while ((subDetailPlanItemCodePage = this.subComActivityDetailPlanVoService.findByDtoForPrediction((Pageable)(subPageable = subPageable.next()), subComDetailPlanDto)) != null && !CollectionUtils.isEmpty((Collection)subDetailPlanItemCodePage.getRecords())) {
                subDetailPlanItemCodes = subDetailPlanItemCodePage.getRecords();
                log.info("\u9875\u7801\uff1a{}\uff0c\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)subPageable.getPageNumber(), (Object)JSONObject.toJSONString((Object)subDetailPlanItemCodes));
                List<String> existItemCodes = this.auditFeePredictionRepository.findExistItemCode(subDetailPlanItemCodes);
                List notExistItemCodes = subDetailPlanItemCodes.stream().filter(e -> !existItemCodes.contains(e)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(notExistItemCodes)) {
                    List subItemVos = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(notExistItemCodes);
                    List<AuditFeePredictionDto> dtos = this.subDetailPlanConvertToPrediction(subItemVos);
                    this.auditFeePredictionFormulaRepository.removeByDetailItemCodes(dtos.stream().map(AuditFeePredictionDto::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
                    this.createBatch(dtos);
                    notExistItemCodes.clear();
                }
                subDetailPlanItemCodes.clear();
                if (subDetailPlanItemCodePage.hasNext()) continue;
            }
            log.info("\u6263\u8d39\u9884\u6d4b-\u81ea\u52a8\u540c\u6b65\u6570\u636e-\u7ed3\u675f");
        }
        catch (Exception e2) {
            log.info("\u6263\u8d39\u9884\u6d4b-\u81ea\u52a8\u540c\u6b65\u6570\u636e-\u9519\u8bef:{}", (Object)e2.getMessage());
            e2.printStackTrace();
        }
        finally {
            if (hasLock) {
                log.info("\u540c\u6b65\u6263\u8d39\u9884\u6d4b\u6570\u636e\u5df2\u89e3\u9501");
                this.redisLockService.unlock(redisLockKey);
            }
        }
    }

    private Date getDate(Date date, int day) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    private List<AuditFeePredictionDto> verticalDetailPlanConvertToPrediction(List<ActivityDetailPlanItemVo> itemList) {
        ArrayList predictionDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(itemList)) {
            return predictionDtoList;
        }
        HashSet<String> terminalCodes = new HashSet<String>();
        HashSet<String> salesInstitutionCodes = new HashSet<String>();
        for (ActivityDetailPlanItemVo itemVo : itemList) {
            if (itemVo.getTerminalCode() != null) {
                terminalCodes.add(itemVo.getTerminalCode());
            }
            if (itemVo.getSalesInstitutionErpCode() == null) continue;
            salesInstitutionCodes.add(itemVo.getSalesInstitutionErpCode());
        }
        List terminalVos = this.terminalVoService.findByTerminalCodes((List)Lists.newArrayList(terminalCodes));
        HashMap terminalVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)terminalVos)) {
            terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost((List)Lists.newArrayList(salesInstitutionCodes));
        HashMap salesOrgVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)salesOrgVoList)) {
            salesOrgVoMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getErpCode, Function.identity(), (v1, v2) -> v2)));
        }
        itemList.forEach(item -> {
            AuditFeePredictionDto dto = (AuditFeePredictionDto)this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeePredictionDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setId(null);
            dto.setCreateTime(null);
            dto.setModifyTime(null);
            dto.setCreateAccount(null);
            dto.setCreateName(null);
            dto.setModifyAccount(null);
            dto.setModifyName(null);
            if (terminalVoMap.containsKey(item.getTerminalCode())) {
                dto.setProvinceCode(((TerminalVo)terminalVoMap.get(item.getTerminalCode())).getProvinceCode());
                dto.setProvinceName(((TerminalVo)terminalVoMap.get(item.getTerminalCode())).getProvinceName());
            }
            dto.setActivityFormDesc(item.getRemark());
            dto.setCustomerErpCode(item.getCustomerErpCode());
            dto.setCustomerCode(item.getCustomerCode());
            dto.setApplyAmount(item.getFeeAmount());
            if (item.getSalesInstitutionErpCode() == null && item.getSalesInstitutionCode() != null) {
                dto.setSalesInstitutionCode(item.getSalesInstitutionCode().substring(4));
                dto.setSalesInstitutionName(item.getSalesInstitutionName());
            } else {
                dto.setSalesInstitutionCode(item.getSalesInstitutionErpCode());
                SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(item.getSalesInstitutionErpCode());
                if (salesOrgVo != null) {
                    dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
            }
            dto.setActivityYearMonth(item.getActivityBeginDate());
            dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
            predictionDtoList.add(dto);
        });
        return predictionDtoList;
    }

    private List<AuditFeePredictionDto> subDetailPlanConvertToPrediction(List<SubComActivityDetailPlanItemVo> itemList) {
        ArrayList predictionDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(itemList)) {
            return predictionDtoList;
        }
        ArrayList<String> salesInstitutionCodes = new ArrayList<String>();
        for (SubComActivityDetailPlanItemVo itemVo : itemList) {
            if (itemVo.getSalesInstitutionCode() == null) continue;
            salesInstitutionCodes.add(itemVo.getSalesInstitutionCode());
        }
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost((List)Lists.newArrayList(salesInstitutionCodes));
        HashMap salesOrgVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)salesOrgVoList)) {
            salesOrgVoMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2)));
        }
        itemList.forEach(item -> {
            AuditFeePredictionDto dto = (AuditFeePredictionDto)this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeePredictionDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setId(null);
            dto.setCreateTime(null);
            dto.setModifyTime(null);
            dto.setCreateAccount(null);
            dto.setCreateName(null);
            dto.setModifyAccount(null);
            dto.setModifyName(null);
            dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
            dto.setActivityYearMonth(item.getFeeYearMonth());
            dto.setSystemCode(item.getResaleCommercialCode());
            dto.setSystemName(item.getResaleCommercialName());
            dto.setActivityBeginDate(item.getActivityBeginTime());
            dto.setActivityEndDate(item.getActivityEndTime());
            dto.setOrderBeginDate(item.getOrderStartDate());
            dto.setDetailPlanItemCode(item.getConstituentDetailPlanItemCode());
            dto.setDetailPlanCode(item.getConstituentDetailPlanCode());
            dto.setDetailPlanName(item.getConstituentDetailPlanName());
            dto.setApplyAmount(item.getTotalCost());
            dto.setCustomerCode(item.getCustomerCode());
            SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(item.getSalesInstitutionErpCode());
            if (salesOrgVo != null) {
                dto.setSalesInstitutionCode(salesOrgVo.getErpCode());
                dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            }
            predictionDtoList.add(dto);
        });
        return predictionDtoList;
    }

    private List<AuditFeePredictionFormula> templateRuleComputation(AuditFeePrediction entity, List<TpmDeductionMatchingTemplateRulesVo> templateRulesVoList) {
        ArrayList feePredictionFormulaList = Lists.newArrayList();
        List<CalculateVo> calculateVoList = this.variableInfo(entity, templateRulesVoList, feePredictionFormulaList);
        log.info("\u6263\u8d39\u9884\u6d4b\u8ba1\u7b97\u516c\u5f0f\u8fd4\u56de\uff1a{}", calculateVoList);
        Validate.notEmpty(calculateVoList, (String)"\u516c\u5f0f\u8ba1\u7b97\u9519\u8bef", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(calculateVoList)) {
            AtomicReference<BigDecimal> totalPredictionAuditAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            calculateVoList.forEach(dto -> totalPredictionAuditAmount.getAndSet(dto.getFormulaValue()));
            entity.setPredictionAuditAmount(totalPredictionAuditAmount.get());
            entity.setCanAuditAmount(totalPredictionAuditAmount.get().subtract(Optional.ofNullable(entity.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)));
        }
        return feePredictionFormulaList;
    }

    private List<CalculateVo> variableInfo(AuditFeePrediction entity, List<TpmDeductionMatchingTemplateRulesVo> templateRulesVoList, List<AuditFeePredictionFormula> feePredictionFormulaList) {
        ArrayList calculateDtoList = Lists.newArrayList();
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setCode(entity.getDetailPlanItemCode());
        calculateDto.setName(entity.getDetailPlanName());
        calculateDto.setBusinessFormatCode(entity.getBusinessFormatCode());
        calculateDto.setBusinessUnitCode(entity.getBusinessUnitCode());
        calculateDto.setDeliveryPartyCode(entity.getTerminalCode());
        calculateDto.setProductCode(entity.getProductCode());
        calculateDto.setActivityTypeCode(entity.getActivityTypeCode());
        calculateDto.setActivityFormCode(entity.getActivityFormCode());
        calculateDto.setStartTimeOrDate(entity.getActivityBeginDate());
        if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)entity.getIsClose())) {
            calculateDto.setEndTimeOrDate(entity.getCloseDate());
        } else {
            calculateDto.setEndTimeOrDate(entity.getActivityEndDate());
        }
        calculateDto.setActivityDetailItemCode(entity.getDetailPlanItemCode());
        ArrayList productCodes = Lists.newArrayList();
        productCodes.add(entity.getProductCode());
        calculateDto.setProductList((List)productCodes);
        ArrayList terminalCodes = Lists.newArrayList();
        terminalCodes.add(entity.getTerminalCode());
        calculateDto.setStoreList((List)terminalCodes);
        ArrayList formulaInfoDtoList = new ArrayList();
        templateRulesVoList.forEach(rule -> {
            FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
            formulaInfoDto.setFormula(rule.getFormulaCode());
            formulaInfoDto.setFormulaCode(rule.getFormulaCode());
            formulaInfoDto.setFormulaName(rule.getFormulaName());
            formulaInfoDtoList.add(formulaInfoDto);
            AuditFeePredictionFormula predictionFormula = (AuditFeePredictionFormula)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(rule, AuditFeePredictionFormula.class, HashSet.class, ArrayList.class, new String[0])));
            predictionFormula.setId(null);
            predictionFormula.setDetailPlanItemCode(entity.getDetailPlanItemCode());
            feePredictionFormulaList.add(predictionFormula);
            this.buildDto(calculateDto, rule.getFormulaCode(), entity);
        });
        calculateDto.setFormulaInfoDtoList(formulaInfoDtoList);
        calculateDtoList.add(calculateDto);
        log.info("\u6263\u8d39\u9884\u6d4b\u8ba1\u7b97\u516c\u5f0f\u8f93\u5165\uff1a{}", (Object)JSONObject.toJSONString((Object)calculateDtoList));
        return this.variableService.orCalculateConditionAndExpression((List)calculateDtoList);
    }

    private void buildDto(CalculateDto dto, String formulaCode, AuditFeePrediction entity) {
        if (formulaCode == null) {
            return;
        }
        if (formulaCode.contains("AUDITFEEP0001")) {
            dto.setActivityDetailItemCode(entity.getDetailPlanItemCode());
            dto.setActivityDetailItemCodeList((List)Lists.newArrayList((Object[])new String[]{entity.getDetailPlanItemCode()}));
        }
        if (formulaCode.contains("AUDITFEEP0002") || formulaCode.contains("AUDITFEEP0003") || formulaCode.contains("AUDITFEEP0004") || formulaCode.contains("AUDITFEEP0005")) {
            dto.setProductList((List)Lists.newArrayList((Object[])new String[]{entity.getProductCode()}));
            dto.setStoreList((List)Lists.newArrayList((Object[])new String[]{entity.getTerminalCode()}));
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP0006") || formulaCode.contains("AUDITFEEP0007")) {
            dto.setProductCode(entity.getProductCode());
            dto.setDeliveryPartyCode(entity.getTerminalCode());
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP0008") || formulaCode.contains("AUDITFEEP0009")) {
            dto.setStoreList((List)Lists.newArrayList((Object[])new String[]{entity.getTerminalCode()}));
            dto.setProductList((List)Lists.newArrayList((Object[])new String[]{entity.getProductCode()}));
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP00010") || formulaCode.contains("AUDITFEEP0011")) {
            dto.setStoreList((List)Lists.newArrayList((Object[])new String[]{entity.getTerminalCode()}));
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP0012")) {
            dto.setProductCode(entity.getProductCode());
            dto.setExcludeProductCodeList((List)Lists.newArrayList((Object[])new String[]{entity.getProductCode()}));
        }
        if (formulaCode.contains("AUDITFEEP0013") || formulaCode.contains("AUDITFEEP0014")) {
            dto.setDataSource(entity.getDataSource());
        }
        if (formulaCode.contains("AUDITFEEP0015")) {
            // empty if block
        }
        if (formulaCode.contains("AUDITFEEP0016")) {
            dto.setActivityDetailItemCode(entity.getDetailPlanItemCode());
        }
        if (formulaCode.contains("AUDITFEEP0017")) {
            dto.setBusinessFormatCode(entity.getBusinessFormatCode());
            dto.setBusinessUnitCode(entity.getBusinessUnitCode());
            dto.setRetailBusinessmanCode(entity.getSystemCode());
            dto.setDeliveryPartyCode(entity.getTerminalCode());
            dto.setProductCode(entity.getProductCode());
            dto.setYearMonthLy(DateUtil.format((Date)entity.getActivityYearMonth(), (String)"yyyy-MM"));
        }
    }

    private void validateCreate(List<AuditFeePredictionDto> dtos) {
        Validate.notEmpty(dtos, (String)"\u521b\u5efa\u65f6\uff0c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dtos.forEach(dto -> {
            Validate.notEmpty((CharSequence)dto.getDetailPlanCode(), (String)"\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)dto.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getActivityBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getActivityEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }
}

