/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.perdiction.internal;

import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.repository.prediction.AuditFeePredictionRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.prediction.AuditFeePredictionVoService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeePredictionVoServiceImpl
implements AuditFeePredictionVoService {
    @Autowired
    private AuditFeePredictionRepository auditFeePredictionRepository;

    @Transactional(rollbackFor={Exception.class})
    public void updateRollbackBudgetTag(List<AuditFeePredictionDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        List<String> detailPlanItemCodes = dtos.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getDetailPlanItemCode())).filter(a -> StringUtils.isNotEmpty((CharSequence)a.getRollbackBudgetTag())).map(AuditFeePredictionDto::getDetailPlanItemCode).collect(Collectors.toList());
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(list)) {
            Map dtoMap = dtos.stream().collect(Collectors.toMap(AuditFeePredictionDto::getDetailPlanItemCode, Function.identity(), (a, b) -> a));
            list.forEach(e -> {
                if (dtoMap.containsKey(e.getDetailPlanItemCode())) {
                    AuditFeePredictionDto dto = (AuditFeePredictionDto)dtoMap.get(e.getDetailPlanItemCode());
                    e.setRollbackBudgetTag(dto.getRollbackBudgetTag());
                }
            });
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }

    public void updateWholeAudit(List<AuditFeePredictionDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        List<String> detailPlanItemCodes = dtos.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getDetailPlanItemCode())).filter(a -> StringUtils.isNotEmpty((CharSequence)a.getWholeAudit())).filter(a -> Objects.nonNull(a.getAlreadyAuditAmount())).map(AuditFeePredictionDto::getDetailPlanItemCode).collect(Collectors.toList());
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(list)) {
            Map dtoMap = dtos.stream().collect(Collectors.toMap(AuditFeePredictionDto::getDetailPlanItemCode, Function.identity(), (a, b) -> a));
            list.forEach(e -> {
                if (dtoMap.containsKey(e.getDetailPlanItemCode())) {
                    AuditFeePredictionDto dto = (AuditFeePredictionDto)dtoMap.get(e.getDetailPlanItemCode());
                    e.setWholeAudit(dto.getWholeAudit());
                    e.setAlreadyAuditAmount(dto.getAlreadyAuditAmount());
                    e.setCanAuditAmount(Optional.ofNullable(e.getPredictionAuditAmount()).orElse(BigDecimal.ZERO).subtract(e.getAlreadyAuditAmount()));
                }
            });
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }

    public void updateCloseDate(List<AuditFeePredictionDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        List<String> detailPlanItemCodes = dtos.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getDetailPlanItemCode())).filter(a -> StringUtils.isNotEmpty((CharSequence)a.getIsClose())).filter(a -> Objects.nonNull(a.getCloseDate())).map(AuditFeePredictionDto::getDetailPlanItemCode).collect(Collectors.toList());
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(list)) {
            Map dtoMap = dtos.stream().collect(Collectors.toMap(AuditFeePredictionDto::getDetailPlanItemCode, Function.identity(), (a, b) -> a));
            list.forEach(e -> {
                if (dtoMap.containsKey(e.getDetailPlanItemCode())) {
                    AuditFeePredictionDto dto = (AuditFeePredictionDto)dtoMap.get(e.getDetailPlanItemCode());
                    e.setIsClose(dto.getIsClose());
                    e.setCloseDate(dto.getCloseDate());
                }
            });
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }
}

