/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckFeeRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckFeeService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditFeeSettlementCheckFeeServiceImpl
extends MnPageCacheServiceImpl<AuditFeeSettlementCheckFeeVo, AuditFeeSettlementCheckFeeDto>
implements AuditFeeSettlementCheckFeeService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeSettlementCheckFeeServiceImpl.class);
    @Autowired
    private RedisService redisService;
    @Autowired
    private AuditFeeSettlementCheckFeeRepository auditFeeSettlementCheckFeeRepository;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;

    @Override
    public Page<AuditFeeSettlementCheckFeeVo> findByConditions(Pageable pageable, AuditFeeSettlementCheckFeeDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeeSettlementCheckFeeDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditFeeSettlementCheckFeeRepository.findByConditions((Page<AuditFeeSettlementCheckFeeVo>)page, dto);
    }

    @Override
    public AuditFeeSettlementCheckFeeVo findById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        AuditFeeSettlementCheckFee entity = (AuditFeeSettlementCheckFee)((Object)this.auditFeeSettlementCheckFeeRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u8d39\u7528\u5355\u4fe1\u606f", (Object[])new Object[0]);
        AuditFeeSettlementCheckFeeVo vo = this.findInfoFromKms(entity.getFeeDetailCode());
        Validate.notNull((Object)vo, (String)"\u672a\u4ecekms\u627e\u5230\u8d39\u7528\u5355\u4fe1\u606f", (Object[])new Object[0]);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        List list = this.auditFeeSettlementCheckFeeRepository.listByIds(ids);
        Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u8d39\u7528\u5355\u4fe1\u606f", (Object[])new Object[0]);
        this.auditFeeSettlementCheckFeeRepository.removeByIds(ids);
        String code = ((AuditFeeSettlementCheckFee)((Object)list.get(0))).getCode();
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodeAndFeeDetailCode(code, null);
    }

    private AuditFeeSettlementCheckFeeVo findInfoFromKms(String settlementDetailCode) {
        return new AuditFeeSettlementCheckFeeVo();
    }

    @Override
    public Integer getTotal(String cacheKey) {
        return this.redisService.lSize(this.helper.getRedisCacheIdKey(cacheKey)).intValue();
    }
}

