/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.service.statement.AuditFeeStatementService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheck;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckSettlement;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDiffRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckFeeRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckSettlementRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.KMSFeeUpdateAsync;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDetailPlanService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDiffService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckFeeService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckSettlementService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFindFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditDiffUseEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeVerifyDecideSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.ConditionsEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchResultEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.SubmitStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.FeeAccordingEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingCustomerVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingTextVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditFeeSettlementCheckServiceImpl
extends MnPageCacheServiceImpl<AuditFeeSettlementCheckVo, AuditFeeSettlementCheckDto>
implements AuditFeeSettlementCheckService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeSettlementCheckServiceImpl.class);
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditFeeStatementService auditFeeStatementService;
    @Autowired
    private AuditFeePredictionService auditFeePredictionService;
    @Autowired
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired
    private AuditFeeSettlementCheckRepository auditFeeSettlementCheckRepository;
    @Autowired
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;
    @Autowired
    private AuditFeeSettlementCheckFeeRepository auditFeeSettlementCheckFeeRepository;
    @Autowired
    private AuditFeeSettlementCheckDiffRepository auditFeeSettlementCheckDiffRepository;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;
    @Autowired
    private AuditFeeSettlementCheckSettlementRepository auditFeeSettlementCheckSettlementRepository;
    @Autowired
    private AuditFeeSettlementCheckSettlementService auditFeeSettlementCheckSettlementService;
    @Autowired
    private AuditFeeSettlementCheckFeeService auditFeeSettlementCheckFeeService;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanService auditFeeSettlementCheckDetailPlanService;
    @Autowired
    private AuditFeeSettlementCheckDiffService auditFeeSettlementCheckDiffService;
    @Autowired
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired
    private AuditFeeCheckVoService auditFeeCheckVoService;
    @Autowired(required=false)
    private KMSFeeUpdateAsync kmsFeeUpdateAsync;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired
    private AuditFeeVerifyDecideService auditFeeVerifyDecideService;
    @Autowired
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    @Override
    public void autoJobUpdate() {
        TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
        templateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        templateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List templateVoList = this.tpmDeductionMatchingTemplateService.findAllListByConditions(templateDto);
        log.info("\u7ed3\u7b97\u6838\u5bf9\u6a21\u677f\uff1a{}", (Object)JSONObject.toJSONString((Object)templateVoList));
        if (!CollectionUtils.isEmpty((Collection)templateVoList)) {
            List mappingCodes = templateVoList.stream().map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).collect(Collectors.toList());
            List mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(mappingCodes);
            log.info("\u7ed3\u7b97\u6838\u5bf9\u6620\u5c04\uff1a{}", (Object)JSONObject.toJSONString((Object)mappingVoList));
            Map mappingVoMap = mappingVoList.stream().collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, Function.identity(), (a, b) -> a));
            this.removeAllExtConfirm(null);
            templateVoList.forEach(templateVo -> {
                if (mappingVoMap.containsKey(templateVo.getApplyMappingCode())) {
                    TpmDeductionDetailMappingVo mappingVo = (TpmDeductionDetailMappingVo)mappingVoMap.get(templateVo.getApplyMappingCode());
                    this.generateSettlement((TpmDeductionMatchingTemplateVo)templateVo, mappingVo, null);
                }
            });
        }
    }

    private void removeAllExtConfirm(String templateCode) {
        List<String> codes = this.auditFeeSettlementCheckRepository.findAllExtConfirm(templateCode);
        if (!CollectionUtils.isEmpty(codes)) {
            this.auditFeeSettlementCheckRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckSettlementRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatchForSettlementAndFee(List<AuditFeeSettlementCheckVo> headerList) {
        if (CollectionUtils.isEmpty(headerList)) {
            return;
        }
        List<String> keyList = headerList.stream().map(AuditFeeSettlementCheckVo::getMd5UniqueKey).filter(Objects::nonNull).collect(Collectors.toList());
        List<AuditFeeSettlementCheck> existEntityList = this.auditFeeSettlementCheckRepository.findNotConfirmedByKeyList(keyList);
        HashMap existEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(existEntityList)) {
            existEntityMap.putAll(existEntityList.stream().collect(Collectors.toMap(AuditFeeSettlementCheck::getMd5UniqueKey, Function.identity(), (a, b) -> a)));
        }
        List templateCodes = headerList.stream().map(AuditFeeSettlementCheckVo::getMatchTemplateCode).distinct().collect(Collectors.toList());
        List templateVoList = this.tpmDeductionMatchingTemplateService.findByCodes(templateCodes);
        HashMap templateVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)templateVoList)) {
            templateVoMap.putAll(templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode, Function.identity(), (a, b) -> a)));
        }
        ArrayList checkList = Lists.newArrayList();
        ArrayList allSettlementList = Lists.newArrayList();
        List codes = this.generateCodeService.generateCode("AFSC", headerList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        AtomicReference<Integer> index = new AtomicReference<Integer>(0);
        for (AuditFeeSettlementCheckVo header : headerList) {
            List settlementList = header.getSettlementList();
            if (!CollectionUtils.isEmpty((Collection)settlementList)) {
                List<String> settlementCodeList = settlementList.stream().map(AuditFeeSettlementCheckSettlementVo::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<String> existSettlementDetailCodeList = this.auditFeeSettlementCheckSettlementRepository.findSettlementDetailCodeBySettlementDetailCodes(settlementCodeList);
                settlementList = settlementList.stream().filter(e -> !existSettlementDetailCodeList.contains(e.getSettlementDetailCode())).collect(Collectors.toList());
            }
            log.info("1234567890-saveBatchForSettlementAndFee-filter:{}", (Object)header.getMd5UniqueKey());
            if (CollectionUtils.isEmpty((Collection)settlementList)) continue;
            AuditFeeSettlementCheck entity = (AuditFeeSettlementCheck)((Object)existEntityMap.get(header.getMd5UniqueKey()));
            if (entity == null) {
                List mappingVoList;
                TpmDeductionDetailMappingVo mappingVo;
                entity = (AuditFeeSettlementCheck)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)header, AuditFeeSettlementCheck.class, HashSet.class, ArrayList.class, new String[0]));
                entity.setId(null);
                entity.setCode((String)codes.get(index.get()));
                entity.setIsConfirm(YesOrNoEnum.NO.getCode());
                entity.setIsShare(YesOrNoEnum.NO.getCode());
                entity.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
                entity.setDiffStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setSettlementAmount(BigDecimal.ZERO);
                TpmDeductionMatchingTemplateVo templateVo = (TpmDeductionMatchingTemplateVo)templateVoMap.get(entity.getMatchTemplateCode());
                if (Objects.nonNull(templateVo)) {
                    entity.setMatchTemplateType(templateVo.getDeductionMatchingTemplateType());
                }
                if ((mappingVo = (TpmDeductionDetailMappingVo)(mappingVoList = this.tpmDeductionDetailMappingService.findByCodes((List)Lists.newArrayList((Object[])new String[]{templateVo.getApplyMappingCode()}))).get(0)) != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)mappingVo.getDeductionDetailMappingRelationActivityConfigList())) {
                    TpmDeductionDetailMappingRelationActivityConfigVo activityConfigVo = (TpmDeductionDetailMappingRelationActivityConfigVo)mappingVo.getDeductionDetailMappingRelationActivityConfigList().get(0);
                    entity.setActivityTypeCode(activityConfigVo.getActivityTypeCode());
                    entity.setActivityTypeName(activityConfigVo.getActivityTypeName());
                }
            }
            checkList.add(entity);
            BigDecimal settlementAmountTotal = BigDecimal.ZERO;
            List settlements = (List)this.nebulaToolkitService.copyCollectionByBlankList(settlementList, AuditFeeSettlementCheckSettlementVo.class, AuditFeeSettlementCheckSettlement.class, HashSet.class, ArrayList.class, new String[0]);
            for (AuditFeeSettlementCheckSettlement settlement : settlements) {
                settlement.setId(null);
                settlement.setCode(entity.getCode());
                settlement.setTenantCode(entity.getTenantCode());
                settlementAmountTotal = settlementAmountTotal.add(settlement.getAmount());
            }
            entity.setSettlementAmount(entity.getSettlementAmount().add(settlementAmountTotal).setScale(2, RoundingMode.HALF_UP));
            allSettlementList.addAll(settlements);
            index.set(index.get() + 1);
        }
        if (!CollectionUtils.isEmpty((Collection)allSettlementList)) {
            this.auditFeeSettlementCheckSettlementRepository.saveBatch(allSettlementList);
        }
        if (!CollectionUtils.isEmpty((Collection)checkList)) {
            checkList.forEach(e -> {
                e.setSettlementFeeDiff(e.getSettlementAmount().subtract(e.getFeeAmount()));
                e.setSettlementDetailPlanDiff(e.getSettlementAmount().subtract(e.getDetailPlanAmount()));
                BigDecimal diffConfirmAmount = e.getSettlementAmount().subtract(e.getFeeAmount());
                e.setDiffConfirmAmount(diffConfirmAmount);
                if (e.getMatchActivity().booleanValue()) {
                    e.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
                    if (diffConfirmAmount.compareTo(BigDecimal.ZERO) != 0) {
                        e.setMatchResult(MatchResultEnum.HAVE_DIFFERENCE.getCode());
                    } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0) {
                        e.setMatchResult(MatchResultEnum.NO_DIFFERENCE.getCode());
                    }
                }
                if (diffConfirmAmount.compareTo(BigDecimal.ZERO) > 0) {
                    if (e.getMatchActivity().booleanValue()) {
                        e.setDiffType(DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode());
                    } else {
                        e.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
                    }
                } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) < 0) {
                    e.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
                } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0) {
                    e.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
                }
            });
            this.auditFeeSettlementCheckRepository.saveOrUpdateBatch(checkList);
            List<String> settlementCheckCodeIds = checkList.stream().map(UuidEntity::getId).collect(Collectors.toList());
            log.info("\u518d\u5339\u914d\u7ed3\u7b97\u6838\u5bf9\u7684\u8d39\u7528\u5355\uff0c\u4f7f\u7528ID\uff1a{}", settlementCheckCodeIds);
            this.handleChangeMatch(settlementCheckCodeIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveBatchForFee(List<AuditFeeSettlementCheckVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> keyList = list.stream().map(AuditFeeSettlementCheckVo::getMd5UniqueKey).filter(Objects::nonNull).collect(Collectors.toList());
        log.info("\u7ed3\u7b97\u62c9\u53d6\u5230\u7684\u8d39\u7528key\uff1a{}", keyList);
        List<AuditFeeSettlementCheck> entityList = this.auditFeeSettlementCheckRepository.findNotConfirmedByKeyList(keyList);
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        List templateCodes = entityList.stream().map(AuditFeeSettlementCheck::getMatchTemplateCode).distinct().collect(Collectors.toList());
        List templateVoList = this.tpmDeductionMatchingTemplateService.findByCodes(templateCodes);
        HashMap templateVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)templateVoList)) {
            templateVoMap.putAll(templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode, Function.identity(), (a, b) -> a)));
        }
        Map voMap = list.stream().collect(Collectors.toMap(AuditFeeSettlementCheckVo::getMd5UniqueKey, Function.identity(), (a, b) -> a));
        list.clear();
        for (AuditFeeSettlementCheck entity : entityList) {
            if (!voMap.containsKey(entity.getMd5UniqueKey())) continue;
            AuditFeeSettlementCheckVo vo = (AuditFeeSettlementCheckVo)voMap.get(entity.getMd5UniqueKey());
            try {
                boolean lock = this.redisLockService.tryLock(this.getClass().getName() + ":" + entity.getCode(), TimeUnit.MINUTES, 1L, 2L);
                if (!lock) {
                    throw new Exception("\u52a0\u9501\u5931\u8d25");
                }
                List feeList = vo.getFeeList();
                if (!CollectionUtils.isEmpty((Collection)feeList)) {
                    List<String> feeDetailCodes = feeList.stream().map(AuditFeeSettlementCheckFeeVo::getFeeDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List<String> existFeeDetailCodes = this.auditFeeSettlementCheckFeeRepository.findFeeDetailCodeByFeeDetailCodes(feeDetailCodes);
                    feeList = feeList.stream().filter(f -> !existFeeDetailCodes.contains(f.getFeeDetailCode())).collect(Collectors.toList());
                }
                if (CollectionUtils.isEmpty((Collection)feeList)) continue;
                HashSet feeCodes = Sets.newHashSet();
                if (entity.getFeeAmount() == null) {
                    entity.setFeeAmount(BigDecimal.ZERO);
                }
                List fees = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)feeList, AuditFeeSettlementCheckFeeVo.class, AuditFeeSettlementCheckFee.class, HashSet.class, ArrayList.class, new String[0]);
                fees.forEach(s -> {
                    s.setId(null);
                    s.setCode(entity.getCode());
                    s.setTenantCode(TenantUtils.getTenantCode());
                    feeCodes.add(s.getFeeDetailCode());
                    entity.setFeeAmount(entity.getFeeAmount().add(s.getAmount()).setScale(2, RoundingMode.HALF_UP));
                });
                entity.setSettlementFeeDiff(entity.getSettlementAmount().subtract(entity.getFeeAmount()).setScale(2, RoundingMode.HALF_UP));
                this.auditFeeSettlementCheckFeeRepository.saveBatch(fees);
                fees.clear();
                ArrayList codes = Lists.newArrayList((Object[])new String[]{entity.getCode()});
                Set<String> relateFeeCodes = this.auditFeeSettlementCheckFeeRepository.findFeeDetailCodeByCodes(codes);
                relateFeeCodes.addAll(feeCodes);
                this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
                List<AuditFeeSettlementCheckDetailPlan> detailPlans = this.matchDetailPlan(relateFeeCodes, entity, (TpmDeductionMatchingTemplateVo)templateVoMap.get(entity.getMatchTemplateCode()));
                this.auditFeeSettlementCheckDetailPlanRepository.saveWithShare(detailPlans);
                entity.setSettlementDetailPlanDiff(entity.getSettlementAmount().subtract(entity.getDetailPlanAmount()).setScale(2, RoundingMode.HALF_UP));
                detailPlans.clear();
                BigDecimal diffConfirmAmount = entity.getSettlementFeeDiff();
                if (AuditStateEnum.CONFIRMED.getCode().equals(entity.getDiffStatus())) {
                    diffConfirmAmount = entity.getDiffConfirmAmount();
                } else {
                    entity.setDiffConfirmAmount(diffConfirmAmount);
                }
                if (entity.getMatchActivity().booleanValue()) {
                    entity.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
                    entity.setMatchResult(diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0 ? MatchResultEnum.NO_DIFFERENCE.getCode() : MatchResultEnum.HAVE_DIFFERENCE.getCode());
                }
                if (diffConfirmAmount.compareTo(BigDecimal.ZERO) > 0) {
                    entity.setDiffType(entity.getMatchActivity() != false ? DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode() : DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
                    continue;
                }
                if (diffConfirmAmount.compareTo(BigDecimal.ZERO) < 0) {
                    entity.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
                    continue;
                }
                if (diffConfirmAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                entity.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
            }
            catch (Exception e) {
                log.info("\u7ed3\u7b97\u5355\u53f7\uff1a{}\u8d39\u7528\u5355\u63a8\u9001\u4fdd\u5b58\u62a5\u9519\uff1a{}", (Object)entity.getCode(), (Object)e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.redisLockService.unlock(this.getClass().getName() + ":" + entity.getCode());
            }
        }
        this.auditFeeSettlementCheckRepository.updateBatchById(entityList);
    }

    @Override
    public AuditFeeSettlementCheckVo findById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeSettlementCheck entity = (AuditFeeSettlementCheck)((Object)this.auditFeeSettlementCheckRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5355\u636e\u4fe1\u606f", (Object[])new Object[0]);
        AuditFeeSettlementCheckVo vo = (AuditFeeSettlementCheckVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, AuditFeeSettlementCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        vo.setCacheKey(uuid);
        vo.setCacheKeySettlement("CACHE_PREFIX_SETTLEMENT:");
        vo.setCacheKeyFee("CACHE_PREFIX_FEE:");
        vo.setCacheKeyDetailPlan("CACHE_PREFIX_DETAIL_PLAN:");
        vo.setCacheKeyDiff("SETTLEMENT_CHECK_DIFF:");
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void matchAgain(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        AuditFeeSettlementCheck entity = (AuditFeeSettlementCheck)((Object)this.auditFeeSettlementCheckRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((!YesOrNoEnum.YES.getCode().equals(entity.getIsConfirm()) && !AuditStateEnum.CONFIRMED.getCode().equals(entity.getDiffStatus()) ? 1 : 0) != 0, (String)"\u5df2\u786e\u8ba4\u7684\u6570\u636e\u4e0d\u80fd\u91cd\u65b0\u5339\u914d", (Object[])new Object[0]);
        ArrayList codes = Lists.newArrayList((Object[])new String[]{entity.getCode()});
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        TpmDeductionMatchingTemplateVo templateVo = this.tpmDeductionMatchingTemplateService.findByCode(entity.getMatchTemplateCode());
        Validate.notNull((Object)templateVo, (String)"\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        List mappingVoList = this.tpmDeductionDetailMappingService.findByCodes((List)Lists.newArrayList((Object[])new String[]{templateVo.getApplyMappingCode()}));
        Validate.notEmpty((Collection)mappingVoList, (String)"\u672a\u627e\u5230\u6620\u5c04\u4fe1\u606f", (Object[])new Object[0]);
        TpmDeductionDetailMappingVo mappingVo = (TpmDeductionDetailMappingVo)mappingVoList.get(0);
        Validate.notNull((Object)mappingVo, (String)"\u672a\u627e\u5230\u6620\u5c04\u4fe1\u606f", (Object[])new Object[0]);
        AuditFeeSettlementCheckSettlement settlement = this.auditFeeSettlementCheckSettlementRepository.findFirstByCode(entity.getCode());
        if (Objects.nonNull((Object)settlement)) {
            this.matchFee(templateVo, mappingVo, entity, settlement);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(AuditFeeSettlementCheckDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeSettlementCheck entity = (AuditFeeSettlementCheck)((Object)this.auditFeeSettlementCheckRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)YesOrNoEnum.NO.getCode().equals(entity.getIsConfirm()), (String)"\u5df2\u786e\u8ba4\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u786e\u8ba4\u6216\u4fdd\u5b58", (Object[])new Object[0]);
        if (SubmitStatusEnum.CONFIRM.getCode().equals(dto.getStatus())) {
            Validate.isTrue((boolean)MatchStatusEnum.MATCHED.getCode().equals(dto.getMatchStatus()), (String)"\u5f85\u5339\u914d\u7684\u5355\u636e\u4e0d\u80fd\u786e\u8ba4", (Object[])new Object[0]);
        }
        List settlementDtoList = this.auditFeeSettlementCheckSettlementService.findCacheList(dto.getCacheKey());
        List feeDtoList = this.auditFeeSettlementCheckFeeService.findCacheList(dto.getCacheKey());
        List detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(dto.getCacheKey());
        List diffDtoList = this.auditFeeSettlementCheckDiffService.findCacheList(dto.getCacheKey());
        log.info("\u7f13\u5b58\uff0c\u7ed3\u7b97\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)settlementDtoList));
        log.info("\u7f13\u5b58\uff0c\u8d39\u7528\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)feeDtoList));
        log.info("\u7f13\u5b58\uff0c\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)detailPlanDtoList));
        log.info("\u7f13\u5b58\uff0c\u5dee\u5f02\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)diffDtoList));
        dto.setSettlementList(settlementDtoList);
        dto.setFeeList(feeDtoList);
        dto.setDetailPlanList(detailPlanDtoList);
        dto.setDiffList(diffDtoList);
        if (SubmitStatusEnum.CONFIRM.getCode().equals(dto.getStatus())) {
            Validate.isTrue((boolean)MatchStatusEnum.MATCHED.getCode().equals(entity.getMatchStatus()), (String)"\u5f85\u5339\u914d\u7684\u5355\u636e\u4e0d\u80fd\u786e\u8ba4", (Object[])new Object[0]);
            if (AuditStateEnum.WAIT_CONFIRM.getCode().equals(entity.getDiffStatus())) {
                entity.setDiffConfirmAmount(dto.getDiffConfirmAmount());
                entity.setDiffUse(dto.getDiffUse());
                entity.setRemark(dto.getRemark());
                this.diffSave(dto);
            }
            AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
            entity.setConfirmUserAccount(loginUser.getAccount());
            entity.setConfirmUserName(loginUser.getRealName());
            entity.setConfirmTime(new Date());
            this.createAuditFeeVerifyDecide(entity, detailPlanDtoList);
        }
        ArrayList codes = Lists.newArrayList((Object[])new String[]{entity.getCode()});
        this.auditFeeSettlementCheckSettlementRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
        this.updateSaveRelation(dto);
        entity.setSettlementAmount(dto.getSettlementAmount());
        entity.setFeeAmount(dto.getFeeAmount());
        entity.setDetailPlanAmount(dto.getDetailPlanAmount());
        entity.setSettlementFeeDiff(dto.getSettlementFeeDiff());
        entity.setSettlementDetailPlanDiff(dto.getSettlementDetailPlanDiff());
        entity.setDiffConfirmAmount(dto.getDiffConfirmAmount());
        entity.setDiffType(dto.getDiffType());
        entity.setDiffUse(dto.getDiffUse());
        entity.setDiffStatus(dto.getDiffStatus());
        entity.setMatchStatus(dto.getMatchStatus());
        entity.setMatchResult(dto.getMatchResult());
        entity.setMatchActivity(dto.getMatchActivity());
        this.auditFeeSettlementCheckRepository.updateById((Object)entity);
    }

    private void createAuditFeeVerifyDecide(AuditFeeSettlementCheck entity, List<AuditFeeSettlementCheckDetailPlanDto> detailPlanDtoList) {
        ArrayList decideList = Lists.newArrayList();
        detailPlanDtoList.forEach(e -> {
            AuditFeeVerifyDecideDto verifyDecideDto = new AuditFeeVerifyDecideDto();
            verifyDecideDto.setActivityDetailItemCode(e.getDetailPlanItemCode());
            verifyDecideDto.setActivityDetailCode(e.getDetailPlanCode());
            verifyDecideDto.setActivityDetailName(e.getDetailPlanName());
            verifyDecideDto.setTerminalCode(e.getTerminalCode());
            verifyDecideDto.setTerminalName(e.getTerminalName());
            verifyDecideDto.setProductCode(e.getProductCode());
            verifyDecideDto.setProductName(e.getProductName());
            verifyDecideDto.setAuditFeeCheckCode(e.getCode());
            verifyDecideDto.setBusinessFormatCode(entity.getBusinessFormatCode());
            verifyDecideDto.setBusinessUnitCode(entity.getBusinessUnitCode());
            verifyDecideDto.setAreaCode(e.getRegion());
            verifyDecideDto.setCustomerRetailerCode(e.getSystemCode());
            verifyDecideDto.setCustomerRetailerName(e.getSystemName());
            verifyDecideDto.setVerifyDecideAmount(e.getThisAuditAmount());
            verifyDecideDto.setSalesInstitutionErpCode(e.getSalesInstitutionCode());
            verifyDecideDto.setSalesInstitutionName(e.getSalesInstitutionName());
            verifyDecideDto.setAuditWay(e.getAuditForm());
            verifyDecideDto.setCustomerCode(e.getCustomerCode());
            verifyDecideDto.setCustomerName(e.getCustomerName());
            verifyDecideDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
            verifyDecideDto.setSource(AuditFeeVerifyDecideSourceEnum.STATEMENT.getCode());
            decideList.add(verifyDecideDto);
        });
        this.auditFeeVerifyDecideService.createBatch((List)decideList);
    }

    private void updateSaveRelation(AuditFeeSettlementCheckDto dto) {
        String matchOrConfirm;
        ArrayList settlementList = Lists.newArrayList();
        ArrayList feeList = Lists.newArrayList();
        ArrayList detailPlanList = Lists.newArrayList();
        ArrayList diffList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)dto.getSettlementList())) {
            List settlements = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getSettlementList(), AuditFeeSettlementCheckSettlementDto.class, AuditFeeSettlementCheckSettlement.class, HashSet.class, ArrayList.class, new String[0]);
            settlements.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            settlementList.addAll(settlements);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getFeeList())) {
            List fees = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getFeeList(), AuditFeeSettlementCheckFeeDto.class, AuditFeeSettlementCheckFee.class, HashSet.class, ArrayList.class, new String[0]);
            fees.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            feeList.addAll(fees);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getDetailPlanList())) {
            List detailPlans = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getDetailPlanList(), AuditFeeSettlementCheckDetailPlanDto.class, AuditFeeSettlementCheckDetailPlan.class, HashSet.class, ArrayList.class, new String[0]);
            detailPlans.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            detailPlanList.addAll(detailPlans);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getDiffList())) {
            List diffs = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getDiffList(), AuditFeeSettlementCheckDiffDto.class, AuditFeeSettlementCheckDiff.class, HashSet.class, ArrayList.class, new String[0]);
            diffs.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            diffList.addAll(diffs);
        }
        String string = matchOrConfirm = SubmitStatusEnum.CONFIRM.getCode().equals(dto.getStatus()) ? AuditFeeMatchStatusEnum.CONFIRM.getCode() : AuditFeeMatchStatusEnum.MATCH.getCode();
        if (!CollectionUtils.isEmpty((Collection)settlementList)) {
            this.auditFeeSettlementCheckSettlementRepository.saveBatch(settlementList);
            this.updateKMSStatus(settlementList.stream().map(AuditFeeSettlementCheckSettlement::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()), matchOrConfirm, null);
        }
        if (!CollectionUtils.isEmpty((Collection)feeList)) {
            this.auditFeeSettlementCheckFeeRepository.saveBatch(feeList);
            this.updateKMSStatus(feeList.stream().map(AuditFeeSettlementCheckFee::getFeeDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()), null, matchOrConfirm);
        }
        if (!CollectionUtils.isEmpty((Collection)detailPlanList)) {
            this.auditFeeSettlementCheckDetailPlanRepository.saveWithShare(detailPlanList);
        }
        if (!CollectionUtils.isEmpty((Collection)diffList)) {
            this.auditFeeSettlementCheckDiffRepository.saveWithShare(diffList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelMatch(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        AuditFeeSettlementCheck entity = (AuditFeeSettlementCheck)((Object)this.auditFeeSettlementCheckRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((!YesOrNoEnum.YES.getCode().equals(entity.getIsConfirm()) ? 1 : 0) != 0, (String)"\u5df2\u786e\u8ba4\u7684\u6570\u636e\u4e0d\u80fd\u53d6\u6d88\u5339\u914d", (Object[])new Object[0]);
        Validate.isTrue((!AuditStateEnum.CONFIRMED.getCode().equals(entity.getDiffStatus()) ? 1 : 0) != 0, (String)"\u5df2\u786e\u8ba4\u5dee\u5f02\u7684\u6570\u636e\u4e0d\u80fd\u53d6\u6d88\u5339\u914d", (Object[])new Object[0]);
        ArrayList codes = Lists.newArrayList((Object[])new String[]{entity.getCode()});
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
        entity.setMatchResult("");
        entity.setMatchActivity(Boolean.FALSE);
        entity.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        entity.setFeeAmount(BigDecimal.ZERO);
        entity.setDetailPlanAmount(BigDecimal.ZERO);
        entity.setSettlementFeeDiff(entity.getSettlementAmount());
        entity.setSettlementDetailPlanDiff(entity.getSettlementAmount());
        entity.setDiffConfirmAmount(entity.getSettlementFeeDiff());
        int i = entity.getDiffConfirmAmount().compareTo(BigDecimal.ZERO);
        if (i > 0) {
            entity.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
        } else if (i < 0) {
            entity.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
        } else {
            entity.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
        }
        entity.setDiffUse(null);
        this.auditFeeSettlementCheckRepository.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleChangeMatch(List<String> ids) {
        log.info("\u624b\u5de5\u8c03\u6574\u5339\u914d\u7ed3\u679c\uff1a{}", (Object)String.join((CharSequence)",", ids));
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u5355\u636e", (Object[])new Object[0]);
        List entityList = this.auditFeeSettlementCheckRepository.listByIds(ids);
        Validate.notEmpty((Collection)entityList, (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u5355\u4fe1\u606f", (Object[])new Object[0]);
        entityList.forEach(e -> {
            Validate.isTrue((!YesOrNoEnum.YES.getCode().equals(e.getIsConfirm()) && !AuditStateEnum.CONFIRMED.getCode().equals(e.getDiffStatus()) ? 1 : 0) != 0, (String)(e.getCode() + "\u5df2\u786e\u8ba4\u6216\u5dee\u5f02\u786e\u8ba4\u4e0d\u80fd\u624b\u5de5\u5339\u914d"), (Object[])new Object[0]);
            e.setFeeAmount(BigDecimal.ZERO);
            e.setSettlementFeeDiff(e.getSettlementAmount());
            e.setDetailPlanAmount(BigDecimal.ZERO);
            e.setSettlementDetailPlanDiff(e.getSettlementAmount());
        });
        List templateCodes = entityList.stream().map(AuditFeeSettlementCheck::getMatchTemplateCode).collect(Collectors.toList());
        TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
        templateDto.setCodeList((List)Lists.newArrayList(templateCodes));
        List templateVoList = this.tpmDeductionMatchingTemplateService.findAllListByConditions(templateDto);
        Validate.notEmpty((Collection)templateVoList, (String)"\u672a\u627e\u5230\u5173\u8054\u6a21\u677f", (Object[])new Object[0]);
        Map templateVoMap = templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode, Function.identity(), (a, b) -> a));
        List mappingCodes = templateVoList.stream().map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).collect(Collectors.toList());
        List mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(mappingCodes);
        Validate.notEmpty((Collection)mappingVoList, (String)"\u672a\u627e\u5230\u5173\u8054\u6620\u5c04", (Object[])new Object[0]);
        Map mappingVoMap = mappingVoList.stream().collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, Function.identity(), (a, b) -> a));
        List<String> codes = entityList.stream().map(AuditFeeSettlementCheck::getCode).filter(Objects::nonNull).collect(Collectors.toList());
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckRepository.updateBatchById(entityList);
        entityList.forEach(entity -> {
            log.info("\u5f00\u59cb\u5339\u914d\u7ed3\u7b97\u6838\u5bf9\uff1a{}", (Object)entity.getCode());
            TpmDeductionMatchingTemplateVo templateVo = (TpmDeductionMatchingTemplateVo)templateVoMap.get(entity.getMatchTemplateCode());
            if (Objects.nonNull(templateVo)) {
                log.info("\u6a21\u677f\uff1a{}", (Object)templateVo);
                TpmDeductionDetailMappingVo mappingVo = (TpmDeductionDetailMappingVo)mappingVoMap.get(templateVo.getApplyMappingCode());
                if (Objects.nonNull(mappingVo)) {
                    log.info("\u6620\u5c04\uff1a{}", (Object)mappingVo);
                    AuditFeeSettlementCheckSettlement settlement = this.auditFeeSettlementCheckSettlementRepository.findFirstByCode(entity.getCode());
                    if (Objects.nonNull((Object)settlement)) {
                        log.info("\u9996\u6761\u7ed3\u7b97\u5355\uff1a{}", (Object)settlement);
                        this.matchFee(templateVo, mappingVo, (AuditFeeSettlementCheck)((Object)entity), settlement);
                    }
                }
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void diffSave(AuditFeeSettlementCheckDto dto) {
        log.info("\u7ed3\u7b97\u6838\u5bf9\u786e\u8ba4\u5dee\u5f02\uff1a{}", (Object)dto);
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCacheKey(), (String)"CacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDiffConfirmAmount(), (String)"\u5dee\u5f02\u786e\u8ba4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditFeeSettlementCheck entity = (AuditFeeSettlementCheck)((Object)this.auditFeeSettlementCheckRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u4fe1\u606f", (Object[])new Object[0]);
        String cacheKey = dto.getCacheKey();
        entity.setDiffUse(dto.getDiffUse());
        entity.setDiffType(dto.getDiffType());
        entity.setRemark(dto.getRemark());
        entity.setDiffStatus(AuditStateEnum.CONFIRMED.getCode());
        entity.setDiffConfirmAmount(dto.getDiffConfirmAmount());
        AuditFeeSettlementCheckDetailPlanDto detailPlanDto = null;
        List detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(cacheKey);
        if (!CollectionUtils.isEmpty((Collection)detailPlanDtoList)) {
            detailPlanDto = detailPlanDtoList.stream().max(Comparator.comparing(AuditFeeSettlementCheckDetailPlanDto::getDetailPlanItemCode)).orElse(null);
        }
        log.info("\u6700\u540e\u4e00\u4e2a\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(detailPlanDto));
        if (StringUtils.equalsAny((CharSequence)entity.getDiffType(), (CharSequence[])new CharSequence[]{DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode(), DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode()})) {
            List settlementDtoYearMonthList;
            String yearMonth = null;
            List settlementDtoList = this.auditFeeSettlementCheckSettlementService.findCacheList(cacheKey);
            if (!CollectionUtils.isEmpty((Collection)settlementDtoList) && !CollectionUtils.isEmpty(settlementDtoYearMonthList = settlementDtoList.stream().sorted(Comparator.comparing(AuditFeeSettlementCheckSettlementDto::getOrderYearMonth)).map(AuditFeeSettlementCheckSettlementDto::getOrderYearMonth).filter(Objects::nonNull).collect(Collectors.toList())) && settlementDtoYearMonthList.size() > 1 && ((String)settlementDtoYearMonthList.get(0)).equals(settlementDtoYearMonthList.get(settlementDtoYearMonthList.size() - 1))) {
                yearMonth = (String)settlementDtoYearMonthList.get(0);
            }
            if (yearMonth == null) {
                yearMonth = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            }
            log.info("\u751f\u6210\u53f0\u8d26");
            AuditFeeDiffLedgerDto ledgerDto = new AuditFeeDiffLedgerDto();
            ledgerDto.setAuditFeeCheckCode(entity.getCode());
            ledgerDto.setFeeYearMonth(yearMonth);
            if (Objects.nonNull(ledgerDto.getFeeYearMonth())) {
                String[] yearMonthArray = ledgerDto.getFeeYearMonth().split("-");
                ledgerDto.setYear(yearMonthArray[0]);
                ledgerDto.setMonth(yearMonthArray[1]);
            }
            ledgerDto.setBusinessFormatCode(entity.getBusinessFormatCode());
            ledgerDto.setBusinessUnitCode(entity.getBusinessUnitCode());
            ledgerDto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
            ledgerDto.setRetailerCode(entity.getSystemCode());
            ledgerDto.setRetailerName(entity.getSystemName());
            ledgerDto.setBusinessAreaCode(entity.getRegion());
            ledgerDto.setBusinessAreaName(entity.getRegion());
            ledgerDto.setSoldToPartyCode(entity.getCustomerCode());
            ledgerDto.setSoldToPartyName(entity.getCustomerName());
            ledgerDto.setSalesOrgCode(entity.getSalesOrgCode());
            ledgerDto.setSalesOrgName(entity.getSalesOrgName());
            ledgerDto.setDiffAmount(entity.getDiffConfirmAmount());
            ledgerDto.setRemark(entity.getRemark());
            ledgerDto.setDataSource(DiffLedgerDataSourceEnum.FEE_COLLATE.getCode());
            if (detailPlanDto != null) {
                ledgerDto.setDeliveryPartyCode(detailPlanDto.getTerminalCode());
                ledgerDto.setDeliveryPartyName(detailPlanDto.getTerminalName());
                ledgerDto.setActivitiesType(detailPlanDto.getActivityTypeCode());
                ledgerDto.setActivitiesTypeName(detailPlanDto.getActivityTypeName());
                ledgerDto.setActivity_form_code(detailPlanDto.getActivityFormCode());
                ledgerDto.setActivity_form_name(detailPlanDto.getActivityFormName());
            }
            this.auditFeeDiffLedgerVoService.create(ledgerDto);
        } else if (StringUtils.equalsAny((CharSequence)entity.getDiffType(), (CharSequence[])new CharSequence[]{DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode()})) {
            Validate.notNull((Object)entity.getDiffUse(), (String)"\u8bf7\u9009\u62e9\u5dee\u5f02\u4f7f\u7528", (Object[])new Object[0]);
            if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equalsIgnoreCase(entity.getDiffUse())) {
                log.info("\u6263\u51cf\u53f0\u8d26");
                List diffCatchDtoList = this.auditFeeSettlementCheckDiffService.findCacheList(cacheKey);
                Validate.notEmpty((Collection)diffCatchDtoList, (String)"\u5dee\u5f02\u4f7f\u7528\u4e3a\u3010\u62b5\u6263\u5dee\u5f02\u3011\u65f6\uff0c\u5fc5\u987b\u9009\u62e9\u5dee\u5f02\u8d39\u7528", (Object[])new Object[0]);
                ArrayList<String> notEnoughDeductCodeList = new ArrayList<String>();
                BigDecimal totalDeductionAmount = BigDecimal.ZERO;
                for (AuditFeeSettlementCheckDiffDto diffVo : diffCatchDtoList) {
                    String feeDiffLedgerCode = diffVo.getFeeDiffLedgerCode();
                    Validate.notNull((Object)diffVo.getBeRecoveredAmount(), (String)("\u6240\u9009\u5dee\u5f02\u6570\u636e[" + feeDiffLedgerCode + "]\u5f85\u8ffd\u56de\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                    Validate.notNull((Object)diffVo.getDeductAmount(), (String)("\u6240\u9009\u5dee\u5f02\u6570\u636e[" + feeDiffLedgerCode + "]\u672c\u6b21\u62b5\u6263\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                    if (diffVo.getBeRecoveredAmount().compareTo(diffVo.getDeductAmount()) < 0) {
                        notEnoughDeductCodeList.add(feeDiffLedgerCode);
                    }
                    totalDeductionAmount = totalDeductionAmount.add(diffVo.getDeductAmount());
                }
                Validate.isTrue((boolean)CollectionUtils.isEmpty(notEnoughDeductCodeList), (String)("\u6240\u9009\u5dee\u5f02\u6570\u636e[" + String.join((CharSequence)",", notEnoughDeductCodeList) + "]\u4e0d\u8db3\u62b5\u6263"), (Object[])new Object[0]);
                log.info("\u5dee\u5f02\u786e\u8ba4\u91d1\u989d-\u62b5\u6263\u91d1\u989d,{}-{}", (Object)entity.getDiffConfirmAmount().abs(), (Object)totalDeductionAmount);
                Validate.isTrue((totalDeductionAmount.compareTo(entity.getDiffConfirmAmount().abs()) == 0 ? 1 : 0) != 0, (String)"\u62b5\u6263\u91d1\u989d\u4e4b\u548c\u5fc5\u987b\u4e0e\u5dee\u5f02\u786e\u8ba4\u91d1\u989d\u7edd\u5bf9\u503c\u76f8\u7b49", (Object[])new Object[0]);
                List feeDiffLedgerCodeList = diffCatchDtoList.stream().peek(e -> e.setCode(entity.getCode())).map(AuditFeeSettlementCheckDiffDto::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());
                this.auditFeeSettlementCheckDiffRepository.removeByCodes(Lists.newArrayList((Object[])new String[]{entity.getCode()}));
                List diffList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)diffCatchDtoList, AuditFeeSettlementCheckDiffDto.class, AuditFeeSettlementCheckDiff.class, HashSet.class, ArrayList.class, new String[0]);
                this.auditFeeSettlementCheckDiffRepository.saveWithShare(diffList);
                Validate.isTrue((boolean)this.auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 1), (String)"\u6263\u51cf\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (Object[])new Object[0]);
                for (AuditFeeSettlementCheckDiff diff : diffList) {
                    AuditFeeDiffLedgerDeductionDto deductionDto = new AuditFeeDiffLedgerDeductionDto();
                    deductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                    deductionDto.setFeeDiffLedgerCode(diff.getFeeDiffLedgerCode());
                    deductionDto.setBusinessCode(entity.getCode());
                    deductionDto.setRecoveredAmount(diff.getDeductAmount());
                    AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
                    deductionDto.setOperatorAccount(loginUser.getAccount());
                    deductionDto.setOperatorName(loginUser.getRealName());
                    deductionDto.setRemark(entity.getRemark());
                    deductionDto.setResaleCommercialCode(entity.getSystemCode());
                    deductionDto.setResaleCommercialName(entity.getSystemName());
                    if (detailPlanDto != null) {
                        deductionDto.setTerminalCode(detailPlanDto.getTerminalCode());
                        deductionDto.setTerminalName(detailPlanDto.getTerminalName());
                        deductionDto.setActivityFormCode(detailPlanDto.getActivityFormCode());
                        deductionDto.setActivityFormName(detailPlanDto.getActivityFormName());
                        deductionDto.setActivityTypeCode(detailPlanDto.getActivityTypeCode());
                        deductionDto.setActivityTypeName(detailPlanDto.getActivityTypeName());
                    }
                    deductionDto.setDataSource(DiffLedgerDataSourceEnum.FINAL_STATEMENT_COLLATE.getCode());
                    this.auditFeeDiffLedgerVoService.useAmount(deductionDto);
                }
                this.auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            }
        }
        this.auditFeeSettlementCheckRepository.updateById((Object)entity);
    }

    @Override
    public AuditFeeSettlementCheckDto compute(AuditFeeSettlementCheckDto dto) {
        log.info("\u5f00\u59cb\u8ba1\u7b97\uff1a{}", (Object)dto);
        String code = dto.getCode();
        String cacheKey = dto.getCacheKey();
        List settlementDtoList = this.auditFeeSettlementCheckSettlementService.findCacheList(cacheKey);
        List feeDtoList = this.auditFeeSettlementCheckFeeService.findCacheList(cacheKey);
        List detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(cacheKey);
        if (Boolean.TRUE.equals(dto.getRematchDetailPlan())) {
            AuditFeeSettlementCheck settlementCheck;
            List<AuditFeeSettlementCheckDetailPlan> detailPlanList;
            TpmDeductionMatchingTemplateVo template;
            log.info("\u91cd\u65b0\u5339\u914d\u6d3b\u52a8");
            detailPlanDtoList.clear();
            this.auditFeeSettlementCheckDetailPlanService.clearCache(cacheKey);
            Set<String> feeDetailCodeSet = feeDtoList.stream().map(AuditFeeSettlementCheckFeeDto::getFeeDetailCode).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(feeDetailCodeSet) && (template = this.tpmDeductionMatchingTemplateService.findByCode(dto.getMatchTemplateCode())) != null && template.getFeeAccording() != null && !CollectionUtils.isEmpty(detailPlanList = this.matchDetailPlan(feeDetailCodeSet, settlementCheck = (AuditFeeSettlementCheck)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AuditFeeSettlementCheck.class, HashSet.class, ArrayList.class, new String[0])), template))) {
                BeanUtils.copyProperties((Object)((Object)settlementCheck), (Object)dto);
                detailPlanDtoList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(detailPlanList, AuditFeeSettlementCheckDetailPlan.class, AuditFeeSettlementCheckDetailPlanDto.class, HashSet.class, ArrayList.class, new String[0]));
            }
            this.auditFeeSettlementCheckDetailPlanService.saveListCache(cacheKey, detailPlanDtoList);
        }
        log.info("\u8ba1\u7b97settlement\u7f13\u5b58\u6761\u6570\uff1a{}", (Object)settlementDtoList.size());
        log.info("\u8ba1\u7b97fee\u7f13\u5b58\u6761\u6570\uff1a{}", (Object)feeDtoList.size());
        log.info("\u8ba1\u7b97detailPlan\u7f13\u5b58\u6761\u6570\uff1a{}", (Object)detailPlanDtoList.size());
        dto.setSettlementAmount(settlementDtoList.stream().map(AuditFeeSettlementCheckSettlementDto::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setFeeAmount(feeDtoList.stream().map(AuditFeeSettlementCheckFeeDto::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setDetailPlanAmount(detailPlanDtoList.stream().map(AuditFeeSettlementCheckDetailPlanDto::getCanAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setSettlementFeeDiff(dto.getSettlementAmount().subtract(dto.getFeeAmount()));
        dto.setSettlementDetailPlanDiff(dto.getSettlementAmount().subtract(dto.getDetailPlanAmount()));
        dto.setMatchStatus(CollectionUtils.isEmpty((Collection)detailPlanDtoList) ? MatchStatusEnum.WAIT_MATCH.getCode() : MatchStatusEnum.MATCHED.getCode());
        dto.setMatchResult(BigDecimal.ZERO.compareTo(dto.getDiffConfirmAmount()) == 0 ? MatchResultEnum.NO_DIFFERENCE.getCode() : MatchResultEnum.HAVE_DIFFERENCE.getCode());
        dto.setMatchActivity(CollectionUtils.isEmpty((Collection)detailPlanDtoList) ? Boolean.FALSE : Boolean.TRUE);
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void findFeeInfo(AuditFeeSettlementCheckFindFeeDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getMatchTemplateCode(), (String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateVo templateVo = this.tpmDeductionMatchingTemplateService.findByCode(dto.getMatchTemplateCode());
        Validate.notNull((Object)templateVo, (String)"\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        List mappingVoList = this.tpmDeductionDetailMappingService.findByCodes((List)Lists.newArrayList((Object[])new String[]{templateVo.getApplyMappingCode()}));
        Validate.notEmpty((Collection)mappingVoList, (String)"\u672a\u627e\u5230\u6620\u5c04\u4fe1\u606f", (Object[])new Object[0]);
        TpmDeductionDetailMappingVo mappingVo = (TpmDeductionDetailMappingVo)mappingVoList.get(0);
        this.removeAllExtConfirm(templateVo.getCode());
        this.generateSettlement(templateVo, mappingVo, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(String ids) {
        Validate.notEmpty((CharSequence)ids, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        ArrayList array = Lists.newArrayList((Object[])ids.split(","));
        List list = this.auditFeeSettlementCheckRepository.listByIds(array);
        Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList codes = Lists.newArrayList();
        list.forEach(e -> {
            Validate.isTrue((!YesOrNoEnum.YES.getCode().equals(e.getIsConfirm()) ? 1 : 0) != 0, (String)(e.getCode() + "\u5df2\u786e\u8ba4\u4e0d\u80fd\u5220\u9664"), (Object[])new Object[0]);
            Validate.isTrue((!AuditStateEnum.CONFIRMED.getCode().equals(e.getDiffStatus()) ? 1 : 0) != 0, (String)(e.getCode() + "\u5df2\u786e\u8ba4\u5dee\u5f02\u4e0d\u80fd\u5220\u9664"), (Object[])new Object[0]);
            codes.add(e.getCode());
        });
        this.auditFeeSettlementCheckRepository.removeByIds(array);
        this.auditFeeSettlementCheckSettlementRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
    }

    @Override
    public void updateApportionAmount(AuditFeeSettlementCheckDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCode(), (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCacheKey(), (String)"\u8bf7\u4f20\u5165cacheKey", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSettlementAmount(), (String)"\u8bf7\u4f20\u5165\u7ed3\u7b97\u5355\u91d1\u989d", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSettlementFeeDiff(), (String)"\u8bf7\u4f20\u5165\u7ed3\u7b97\u5355-\u8d39\u7528\u5dee\u5f02", (Object[])new Object[0]);
        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.findByCode(dto.getCode());
        Validate.notNull((Object)((Object)entity), (String)"\u7ed3\u7b97\u6838\u5bf9\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        entity.setSettlementAmount(dto.getSettlementAmount());
        entity.setSettlementFeeDiff(dto.getSettlementFeeDiff());
        String cacheKey = dto.getCacheKey();
        List detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(cacheKey);
        Validate.notEmpty((Collection)detailPlanDtoList, (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u7ec6\u6848\u4fe1\u606f", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateVo templateVo = this.tpmDeductionMatchingTemplateService.findByCode(entity.getMatchTemplateCode());
        Validate.notNull((Object)templateVo, (String)"\u672a\u627e\u5230\u7ed3\u7b97\u6838\u5bf9\u5173\u8054\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        List detailPlanList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)detailPlanDtoList, AuditFeeSettlementCheckDetailPlanDto.class, AuditFeeSettlementCheckDetailPlan.class, HashSet.class, ArrayList.class, new String[0]);
        List<AuditFeeSettlementCheckDetailPlan> checkDetailPlans = this.doShare(detailPlanList, entity, templateVo);
        if (!CollectionUtils.isEmpty((Collection)detailPlanDtoList)) {
            detailPlanDtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(checkDetailPlans, AuditFeeSettlementCheckDetailPlan.class, AuditFeeSettlementCheckDetailPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeSettlementCheckDetailPlanService.saveListCache(cacheKey, detailPlanDtoList);
        }
    }

    private List<AuditFeeSettlementCheckDetailPlan> matchDetailPlan(Set<String> feeCodes, AuditFeeSettlementCheck entity, TpmDeductionMatchingTemplateVo templateVo) {
        log.info("\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)templateVo));
        log.info("\u5934\u8868\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        log.info("\u8d39\u7528\u5355code\u4fe1\u606f\uff1a{}", (Object)feeCodes.size());
        if (CollectionUtils.isEmpty(feeCodes) || Objects.isNull((Object)entity) || Objects.isNull(templateVo)) {
            return new ArrayList<AuditFeeSettlementCheckDetailPlan>(0);
        }
        List detailPLanItemCodeList = this.auditFeeCheckVoService.findDetailPlanItemCodeByCost(feeCodes);
        log.info("1234567890-size-of-activity-matched-by-check:{}-{}", (Object)detailPLanItemCodeList.size(), (Object)entity.getMd5UniqueKey());
        if (CollectionUtils.isEmpty((Collection)detailPLanItemCodeList)) {
            return new ArrayList<AuditFeeSettlementCheckDetailPlan>(0);
        }
        List<AuditFeePredictionVo> predictionVoList = this.auditFeePredictionService.findByActivityDetailPlanItemCodes(detailPLanItemCodeList);
        log.info("1234567890-size-of-predict-activity-matched-by-check:{}-{}", (Object)predictionVoList.size(), (Object)entity.getMd5UniqueKey());
        if (CollectionUtils.isEmpty(predictionVoList)) {
            return new ArrayList<AuditFeeSettlementCheckDetailPlan>(0);
        }
        ArrayList detailPlanList = Lists.newArrayList();
        for (AuditFeePredictionVo predictionVo : predictionVoList) {
            AuditFeeSettlementCheckDetailPlan vo = (AuditFeeSettlementCheckDetailPlan)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)predictionVo, AuditFeeSettlementCheckDetailPlan.class, HashSet.class, ArrayList.class, new String[0]));
            vo.setId(null);
            vo.setCode(entity.getCode());
            detailPlanList.add(vo);
        }
        return this.doShare(detailPlanList, entity, templateVo);
    }

    private List<AuditFeeSettlementCheckDetailPlan> doShare(List<AuditFeeSettlementCheckDetailPlan> detailPlanList, AuditFeeSettlementCheck entity, TpmDeductionMatchingTemplateVo templateVo) {
        if (CollectionUtils.isEmpty(detailPlanList)) {
            entity.setDetailPlanAmount(BigDecimal.ZERO);
            entity.setSettlementDetailPlanDiff(entity.getSettlementAmount());
            entity.setMatchActivity(Boolean.FALSE);
            return new ArrayList<AuditFeeSettlementCheckDetailPlan>(0);
        }
        log.info("\u5f00\u59cb\u5206\u644a\u7684\u6d3b\u52a8\uff1a{}", (Object)detailPlanList.size());
        log.info("\u5f00\u59cb\u5206\u644a\u7684\u7ed3\u7b97\u6838\u5bf9KEY\uff1a{}", (Object)entity.getMd5UniqueKey());
        AtomicReference<BigDecimal> beShareAmount = null;
        if (FeeAccordingEnum.INVOICES.getCode().equals(templateVo.getFeeAccording())) {
            beShareAmount = new AtomicReference<BigDecimal>(entity.getSettlementAmount());
        } else if (FeeAccordingEnum.FEE_INVOICE.getCode().equals(templateVo.getFeeAccording())) {
            beShareAmount = new AtomicReference<BigDecimal>(entity.getSettlementFeeDiff());
        } else {
            entity.setMatchActivity(Boolean.TRUE);
            return detailPlanList.stream().peek(e -> e.setRemark("\u6a21\u677f\u6263\u8d39\u4f9d\u636e\u9519\u8bef\uff0c\u65e0\u6cd5\u8fdb\u884c\u91d1\u989d\u5206\u644a")).collect(Collectors.toList());
        }
        log.info("\u5f00\u59cb\u5206\u644a\u7684\u6263\u8d39\u4f9d\u636e\uff1a{}\uff0c\u5206\u644a\u91d1\u989d\uff1a{}", (Object)templateVo.getFeeAccording(), beShareAmount);
        List<AuditFeeSettlementCheckDetailPlan> sortList = detailPlanList.stream().filter(e -> Objects.nonNull(e.getCanAuditAmount())).sorted(Comparator.comparing(AuditFeeSettlementCheckDetailPlan::getDetailPlanItemCode)).collect(Collectors.toList());
        for (int i = 0; i < sortList.size(); ++i) {
            BigDecimal toBeSupplementedAmount;
            AuditFeeSettlementCheckDetailPlan detailPlan = (AuditFeeSettlementCheckDetailPlan)((Object)sortList.get(i));
            BigDecimal canAuditAmount = detailPlan.getCanAuditAmount();
            if (beShareAmount.get().compareTo(BigDecimal.ZERO) > 0) {
                if (beShareAmount.get().compareTo(canAuditAmount) >= 0) {
                    detailPlan.setAuditFeeCheckShareAmount(canAuditAmount);
                    beShareAmount.set(beShareAmount.get().subtract(canAuditAmount));
                } else {
                    detailPlan.setAuditFeeCheckShareAmount(beShareAmount.get());
                    beShareAmount.set(BigDecimal.ZERO);
                }
                if (i + 1 == sortList.size() && beShareAmount.get().compareTo(BigDecimal.ZERO) > 0) {
                    detailPlan.setAuditFeeCheckShareAmount(beShareAmount.get().add(detailPlan.getAuditFeeCheckShareAmount()));
                    beShareAmount.set(BigDecimal.ZERO);
                }
            } else {
                detailPlan.setAuditFeeCheckShareAmount(BigDecimal.ZERO);
            }
            if ((toBeSupplementedAmount = Optional.ofNullable(detailPlan.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).add(detailPlan.getAuditFeeCheckShareAmount()).subtract(Optional.ofNullable(detailPlan.getApplyAmount()).orElse(BigDecimal.ZERO))).compareTo(BigDecimal.ZERO) > 0) {
                detailPlan.setToBeSupplementedAmount(toBeSupplementedAmount);
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(entity.getBusinessUnitCode())) {
                BigDecimal subtract = Optional.ofNullable(detailPlan.getApplyAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(detailPlan.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO));
                detailPlan.setThisAuditAmount(subtract.compareTo(detailPlan.getAuditFeeCheckShareAmount()) < 0 ? subtract : detailPlan.getAuditFeeCheckShareAmount());
                continue;
            }
            detailPlan.setThisAuditAmount(detailPlan.getAuditFeeCheckShareAmount());
        }
        sortList = sortList.stream().filter(e -> e.getAuditFeeCheckShareAmount() != null).collect(Collectors.toList());
        log.info("\u5206\u644a\u5b8c\u6210\u4f7f\u7528\u7684\u6d3b\u52a8\uff1a{}", (Object)sortList.size());
        BigDecimal detailPlanAmount = sortList.stream().map(AuditFeeSettlementCheckDetailPlan::getCanAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setDetailPlanAmount(detailPlanAmount);
        entity.setSettlementDetailPlanDiff(entity.getSettlementAmount().subtract(entity.getDetailPlanAmount()));
        entity.setMatchActivity(Boolean.TRUE);
        return sortList;
    }

    private void matchFee(TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo, AuditFeeSettlementCheck entity, AuditFeeSettlementCheckSettlement settlement) {
        List statementAllowancesList = templateVo.getStatementAllowances();
        List feeAllowanceVoList = templateVo.getFeeAllowances();
        log.info("\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)templateVo));
        if (CollectionUtils.isEmpty((Collection)statementAllowancesList)) {
            log.info("\u6263\u8d39\u5339\u914d\u6a21\u677f-\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\u7f3a\u5931");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)feeAllowanceVoList)) {
            log.info("\u6263\u8d39\u5339\u914d\u6a21\u677f-\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\u9002\u7528\u8303\u56f4\u7f3a\u5931");
            return;
        }
        ArrayList feeAllowancesDateSource = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)feeAllowanceVoList)) {
            feeAllowancesDateSource.addAll(feeAllowanceVoList.stream().map(TpmDeductionMatchingTemplateAllowanceVo::getDataSource).collect(Collectors.toList()));
        }
        AuditFeeReqDto dto = new AuditFeeReqDto();
        String feeMatchingCondition = templateVo.getFeeMatchingCondition();
        TpmDeductionMatchingTemplateAllowanceVo feeAllowance = null;
        log.info("\u5339\u914d\u8d39\u7528\u5355-\u8d39\u7528\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e:{}", (Object)JSON.toJSONString((Object)feeMatchingCondition));
        log.info("\u5339\u914d\u8d39\u7528\u5355-\u8d39\u7528\u5bb9\u5dee\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)feeAllowanceVoList));
        if (feeMatchingCondition.contains(ConditionsEnum.AREA_CODE.getCode())) {
            for (TpmDeductionMatchingTemplateAllowanceVo feeAllowanceVo : feeAllowanceVoList) {
                if (StringUtils.isBlank((CharSequence)feeAllowanceVo.getApplyBusinessAreaCode())) {
                    feeAllowance = feeAllowanceVo;
                } else {
                    if (!StringUtils.isNotBlank((CharSequence)settlement.getBusinessArea()) || !feeAllowanceVo.getApplyBusinessAreaCode().contains(settlement.getBusinessArea())) continue;
                    feeAllowance = feeAllowanceVo;
                }
                break;
            }
        } else {
            feeAllowance = (TpmDeductionMatchingTemplateAllowanceVo)feeAllowanceVoList.get(0);
        }
        log.info("\u5339\u914d\u8d39\u7528\u5355-\u5339\u914d\u7684\u8d39\u7528\u5bb9\u5dee:{}", (Object)JSON.toJSONString((Object)feeAllowance));
        if (feeAllowance == null) {
            log.info("\u5339\u914d\u8d39\u7528\u5355\uff0c\u6309\u533a\u57df\u672a\u627e\u5230\u8d39\u7528\u5355\u5bb9\u5dee");
            return;
        }
        dto.setDataSource(feeAllowance.getDataSource());
        for (TpmDeductionMatchingTemplateAllowanceVo e : statementAllowancesList) {
            String[] conditions;
            List customerErpCodeList;
            String applyBusinessAreaCode;
            String statementMatchingCondition = templateVo.getStatementMatchingCondition();
            if (statementMatchingCondition.contains(ConditionsEnum.AREA_CODE.getCode()) && statementMatchingCondition.contains(ConditionsEnum.YEAR_MONTH.getCode()) && (applyBusinessAreaCode = e.getApplyBusinessAreaCode()) != null && !applyBusinessAreaCode.contains(settlement.getBusinessArea())) continue;
            dto.setCostIsMatch(AuditFeeMatchStatusEnum.WITH.getCode());
            dto.setOnlyKey(entity.getMd5UniqueKey());
            dto.setCustomerRetailerCode(mappingVo.getResaleCommercialCode());
            dto.setDemander("tpm_audit_fee_statement_match_cost");
            if (StringUtils.isNotEmpty((CharSequence)templateVo.getStatementMatchingCondition())) {
                List matchSummaryCodes = Arrays.stream(templateVo.getStatementMatchingCondition().split(",")).collect(Collectors.toList());
                dto.setMatchSummaryCondition(matchSummaryCodes);
            }
            dto.setBusinessFormatCode(templateVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(templateVo.getBusinessUnitCode());
            if (!CollectionUtils.isEmpty((Collection)mappingVo.getDeductionDetailMappingTextList())) {
                List deductionNames = mappingVo.getDeductionDetailMappingTextList().stream().map(TpmDeductionDetailMappingTextVo::getText).collect(Collectors.toList());
                dto.setDeductionNameList(deductionNames);
            }
            if (!CollectionUtils.isEmpty((Collection)mappingVo.getCustomerList()) && !CollectionUtils.isEmpty(customerErpCodeList = mappingVo.getCustomerList().stream().map(TpmDeductionDetailMappingCustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                dto.setSoldToPartyCodeList(customerErpCodeList);
            }
            dto.setMatchTemplateCode(templateVo.getCode());
            dto.setMatchTemplateName(templateVo.getName());
            dto.setFeeDataSourceList((List)feeAllowancesDateSource);
            String queryStartDate = entity.getQueryStartDate();
            String queryEndDate = entity.getQueryEndDate();
            dto.setOrderDateBegin(queryStartDate);
            dto.setOrderDateEnd(queryEndDate);
            block10: for (String condition : conditions = templateVo.getStatementMatchingCondition().split(",")) {
                ConditionsEnum conditionsEnum = ConditionsEnum.codeToEnum((String)condition);
                if (ConditionsEnum.EMPTY.equals((Object)conditionsEnum)) continue;
                switch (conditionsEnum) {
                    case PRODUCT_CODE: {
                        if (null == settlement.getProductCode()) continue block10;
                        dto.setProductCode(settlement.getProductCode());
                        continue block10;
                    }
                    case TERMINAL_CODE: {
                        if (null == settlement.getDeliveryPartyCode()) continue block10;
                        dto.setDeliveryPartyCode(settlement.getDeliveryPartyCode());
                        continue block10;
                    }
                    case YEAR_MONTH: {
                        if (settlement.getOrderYearMonth() == null) continue block10;
                        String timeAllowanceType = e.getTimeAllowanceType();
                        if (timeAllowanceType == null) {
                            log.error("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u7c7b\u578b\u914d\u7f6e\u9519\u8bef;");
                            continue block10;
                        }
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(e.getTimeAllowanceType()) && !TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue().equals(e.getTimeAllowanceUnit())) {
                            log.error("\u9002\u7528\u8303\u56f4\u65e5\u671f\u7c7b\u578b\u5f02\u5e38");
                            continue block10;
                        }
                        Integer timeAllowanceValue = e.getTimeAllowanceValue();
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(e.getTimeAllowanceType()) && timeAllowanceValue == null) {
                            log.error("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u503c\u914d\u7f6e\u9519\u8bef;");
                            continue block10;
                        }
                        String orderDate = settlement.getOrderDate();
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE.getValue().equals(timeAllowanceType)) {
                            dto.setOrderDateBegin(this.adjustMonth(orderDate, 0, true));
                            dto.setOrderDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE_POINT.getValue().equals(timeAllowanceType)) {
                            dto.setOrderDateBegin(this.adjustMonth(orderDate, timeAllowanceValue, true));
                            dto.setOrderDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE.getValue().equals(timeAllowanceType)) {
                            dto.setOrderDateBegin(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                            dto.setOrderDateEnd(this.adjustMonth(orderDate, 0, false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE_POINT.getValue().equals(timeAllowanceType)) {
                            dto.setOrderDateBegin(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                            dto.setOrderDateEnd(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), false));
                            continue block10;
                        }
                        if (TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue().equals(timeAllowanceType)) {
                            dto.setOrderDateBegin(this.adjustMonth(orderDate, -timeAllowanceValue.intValue(), true));
                            dto.setOrderDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                            continue block10;
                        }
                        if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(timeAllowanceType)) continue block10;
                        if (e.getBeginDate() == null || e.getEndDate() == null) {
                            log.info("\u6a21\u677f\u65f6\u95f4\u5bb9\u5dee\u6307\u5b9a\u533a\u95f4\u914d\u7f6e\u9519\u8bef;");
                            continue block10;
                        }
                        dto.setOrderDateBegin(this.adjustMonth(e.getBeginDate() + "-01", 0, true));
                        dto.setOrderDateEnd(this.adjustMonth(e.getEndDate() + "-01", 0, false));
                        continue block10;
                    }
                    case PROVINCE: {
                        if (null == settlement.getProvinceCode()) continue block10;
                        dto.setProvinceCode(settlement.getProvinceCode());
                        continue block10;
                    }
                    case AREA_CODE: {
                        if (null == settlement.getBusinessArea()) continue block10;
                        dto.setBusinessArea(settlement.getBusinessArea());
                        continue block10;
                    }
                    case ACTIVITY_FORM_DESC: {
                        if (null == settlement.getActivityFormDesc()) continue block10;
                        dto.setActivityFormDesc(settlement.getActivityFormDesc());
                        continue block10;
                    }
                }
            }
            log.info("\u5339\u914d\u8d39\u7528\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
            this.auditFeeStatementService.statementMatchFeeByConditions(dto);
            break;
        }
    }

    private void generateSettlement(TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo, AuditFeeSettlementCheckFindFeeDto queryDto) {
        List statementAllowancesList = templateVo.getStatementAllowances();
        List feeAllowanceVoList = templateVo.getFeeAllowances();
        log.info("\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)templateVo));
        log.info("\u6620\u5c04\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)mappingVo));
        if (CollectionUtils.isEmpty((Collection)statementAllowancesList)) {
            log.info("\u6263\u8d39\u5339\u914d\u6a21\u677f-\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\u7f3a\u5931");
            return;
        }
        ArrayList feeAllowancesDateSource = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)feeAllowanceVoList)) {
            feeAllowancesDateSource.addAll(feeAllowanceVoList.stream().map(TpmDeductionMatchingTemplateAllowanceVo::getDataSource).collect(Collectors.toList()));
        }
        Map statementAllowanceMap = statementAllowancesList.stream().collect(Collectors.toMap(e -> e.getDataSource() + "_" + e.getApplyBusinessAreaCode(), Function.identity(), (a, b) -> a));
        log.info("\u62c9\u53d6\u7ed3\u7b97\u5355\u6a21\u677f\u53bb\u91cd\u5bb9\u5dee:{}\u4e2a\u6570:{}", (Object)JSON.toJSONString(statementAllowanceMap.keySet()), (Object)statementAllowanceMap.size());
        statementAllowanceMap.forEach((k, v) -> {
            List customerErpCodeList;
            AuditFeeReqDto dto = new AuditFeeReqDto();
            dto.setStatementIsMatch(AuditFeeMatchStatusEnum.WITH.getCode());
            if (Objects.nonNull(queryDto)) {
                dto.setOrderDateBegin(DateFormatUtils.format((Date)queryDto.getStartDate(), (String)"yyyy-MM-dd"));
                dto.setOrderDateEnd(DateFormatUtils.format((Date)queryDto.getEndDate(), (String)"yyyy-MM-dd"));
                dto.setDeliveryPartyCode(queryDto.getTerminalCode());
            } else {
                DateTime lastTwoMonth = cn.hutool.core.date.DateUtil.offsetMonth((Date)new DateTime(), (int)-2);
                dto.setOrderDateBegin(DateFormatUtils.format((Date)DateUtil.getFirstDayOfMonth((Date)lastTwoMonth), (String)"yyyy-MM-dd"));
                dto.setOrderDateEnd(DateFormatUtils.format((Date)DateUtil.getFirstDayOfMonth((Date)new Date()), (String)"yyyy-MM-dd"));
            }
            dto.setCustomerRetailerCode(mappingVo.getResaleCommercialCode());
            dto.setDemander("tpm_audit_fee_statement");
            if (StringUtils.isNotEmpty((CharSequence)templateVo.getStatementMatchingCondition())) {
                List matchSummaryCodes = Arrays.stream(templateVo.getStatementMatchingCondition().split(",")).collect(Collectors.toList());
                dto.setMatchSummaryCondition(matchSummaryCodes);
            }
            dto.setBusinessFormatCode(templateVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(templateVo.getBusinessUnitCode());
            if (!CollectionUtils.isEmpty((Collection)mappingVo.getDeductionDetailMappingTextList())) {
                List deductionNames = mappingVo.getDeductionDetailMappingTextList().stream().map(TpmDeductionDetailMappingTextVo::getText).collect(Collectors.toList());
                dto.setDeductionNameList(deductionNames);
            }
            if (!CollectionUtils.isEmpty((Collection)mappingVo.getCustomerList()) && !CollectionUtils.isEmpty(customerErpCodeList = mappingVo.getCustomerList().stream().map(TpmDeductionDetailMappingCustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                dto.setSoldToPartyCodeList(customerErpCodeList);
            }
            dto.setMatchTemplateCode(templateVo.getCode());
            dto.setMatchTemplateName(templateVo.getName());
            dto.setFeeDataSourceList(feeAllowancesDateSource);
            dto.setDataSource(v.getDataSource());
            String[] areaArray = null;
            areaArray = StringUtils.isNotBlank((CharSequence)v.getApplyBusinessAreaCode()) ? v.getApplyBusinessAreaCode().split(",") : new String[]{null};
            for (String areaCode : areaArray) {
                dto.setBusinessArea(areaCode);
                log.info("\u67e5\u8be2\u7ed3\u7b97\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
                this.auditFeeStatementService.matchByConditions(dto);
            }
        });
    }

    public String adjustMonth(String dateStr, Integer span, boolean begin) {
        DateTime adjustedDate = cn.hutool.core.date.DateUtil.offsetMonth((Date)DateUtil.parse((String)dateStr, (String)"yyyy-MM-dd"), (int)span);
        DateTime headOrTail = begin ? cn.hutool.core.date.DateUtil.beginOfDay((Date)cn.hutool.core.date.DateUtil.beginOfMonth((Date)adjustedDate)) : cn.hutool.core.date.DateUtil.endOfDay((Date)cn.hutool.core.date.DateUtil.endOfMonth((Date)adjustedDate));
        return cn.hutool.core.date.DateUtil.format((Date)headOrTail, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private String getLastMonthStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        return DateFormatUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
    }

    private String getLastMonthEndDate() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateFormatUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
    }

    private void updateKMSStatus(List<String> tpmDeductionCodeList, String statementIsMatch, String costIsMatch) {
        if (CollectionUtils.isEmpty(tpmDeductionCodeList)) {
            return;
        }
        if (StringUtils.equalsAny((CharSequence)AuditFeeMatchStatusEnum.CONFIRM.getCode(), (CharSequence[])new CharSequence[]{statementIsMatch, costIsMatch})) {
            AuditFeeSettlementCheckFee fee;
            AuditFeeReqDto reqDto = new AuditFeeReqDto();
            reqDto.setTpmDeductionCodeList(tpmDeductionCodeList);
            reqDto.setStatementIsMatch(statementIsMatch);
            reqDto.setCostIsMatch(costIsMatch);
            String dataSource = null;
            if (statementIsMatch != null) {
                AuditFeeSettlementCheckSettlement settlement = this.auditFeeSettlementCheckSettlementRepository.findByDetailCode(tpmDeductionCodeList.get(0));
                if (settlement != null) {
                    dataSource = settlement.getDataSource();
                }
            } else if (costIsMatch != null && (fee = this.auditFeeSettlementCheckFeeRepository.findByDetailCode(tpmDeductionCodeList.get(0))) != null) {
                dataSource = fee.getDataSource();
            }
            reqDto.setDataSource(dataSource);
            log.info("\u7ed3\u7b97\u6838\u5bf9-\u66f4\u65b0KMS\u7ed3\u7b97\u5355/\u8d39\u7528\u5355\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            this.kmsFeeUpdateAsync.updateKMSStatusAsync(reqDto);
        }
    }
}

