/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.alibaba.excel.util.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckUpdateMatched;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckUpdateMatchedRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckUpdateMatchedService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

@Service
public class AuditFeeSettlementCheckUpdateMatchedServiceImpl
implements AuditFeeSettlementCheckUpdateMatchedService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeSettlementCheckUpdateMatchedServiceImpl.class);
    @Autowired(required=false)
    private AuditFeeSettlementCheckUpdateMatchedRepository updateMatchedRepository;
    @Autowired(required=false)
    private AuditFeeCostService auditFeeCostService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @DynamicTaskService(cornExpression="0 0 7 * * ?", taskDesc="\u5b9a\u65f6\u66f4\u65b0\u7ed3\u7b97\u5355\u5339\u914d\u72b6\u6001")
    public void autoUpdateMatchedStatus() {
        this.loginUserService.refreshAuthentication(null);
        String date = DateUtil.getDate((String)"yyyy-MM-dd");
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock("settlement_cache_update_matched:lock:" + date, TimeUnit.HOURS, 2L);
            if (!lock) {
                throw new RuntimeException("\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d...");
            }
            this.updateMatchedStatus(date, AuditFeeMatchStatusEnum.MATCH.getCode());
        }
        catch (Exception e) {
            log.info("\u5b9a\u65f6\u66f4\u65b0\u7ed3\u7b97\u5355\u5339\u914d\u72b6\u6001\u5931\u8d25");
            e.printStackTrace();
            throw e;
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("settlement_cache_update_matched:lock:" + date);
            }
        }
    }

    @Override
    public void updateMatchedStatus(String date, String status) {
        if (StringUtils.isBlank((CharSequence)date) || StringUtils.isBlank((CharSequence)status)) {
            return;
        }
        PageRequest pageable = PageRequest.of((int)1, (int)1000);
        Page<AuditFeeSettlementCheckUpdateMatched> pageResult = null;
        do {
            if (!CollectionUtils.isEmpty((Collection)(pageResult = this.updateMatchedRepository.findByCondition(pageable, date)).getRecords())) {
                Map<String, List<AuditFeeSettlementCheckUpdateMatched>> updateMap = pageResult.getRecords().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getDataSource())).collect(Collectors.groupingBy(AuditFeeSettlementCheckUpdateMatched::getDataSource));
                for (String key : updateMap.keySet()) {
                    List<AuditFeeSettlementCheckUpdateMatched> updateMatchedList = updateMap.get(key);
                    List tpmDeductionCodeList = updateMatchedList.stream().map(AuditFeeSettlementCheckUpdateMatched::getTpmDeductionCode).filter(Objects::nonNull).collect(Collectors.toList());
                    AuditFeeReqDto updateDto = new AuditFeeReqDto();
                    updateDto.setTpmDeductionCodeList(tpmDeductionCodeList);
                    updateDto.setDataSource(key);
                    updateDto.setStatementIsMatch(status);
                    this.auditFeeCostService.updateStatus(updateDto);
                }
            }
            pageable = pageable.next();
        } while (pageResult.hasNext() && pageable.getPageNumber() < AuditFeeSettlementConstant.LOOP_TIMES_MAX);
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 4 ? * 7", taskDesc="\u7ed3\u7b97\u5355\u5339\u914d\u6570\u636e\u4e34\u65f6\u8868,\u6bcf\u54687\u5929\u5b9a\u65f6\u5220\u9664\u4e00\u6b216\u5929\u5df2\u524d\u7684\u6570\u636e")
    public void clearData() {
        this.loginUserService.refreshAuthentication(null);
        String date = DateUtil.getDate((String)"yyyy-MM-dd");
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock("settlement_cache_update_matched:lock:" + date, TimeUnit.HOURS, 2L);
            if (!lock) {
                throw new RuntimeException("\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d...");
            }
            this.deleteMatchedData(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (lock) {
                this.redisLockService.unlock("settlement_cache_update_matched:lock:" + date);
            }
        }
    }

    private void deleteMatchedData(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return;
        }
        this.updateMatchedRepository.deleteMatchedData(date);
    }
}

