/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeMatchedDetailRespDto;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeMatchedRespDto;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeePushMatchedKmsDataEventDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.DataSourceEnum;
import com.biz.crm.kms.business.audit.fee.sdk.event.PushMatchedKmsDataToStatementEvent;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckUpdateMatched;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckUpdateMatchedRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckService;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.PullKmsDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushMatchedKmsDataToStatementEventImpl
implements PushMatchedKmsDataToStatementEvent {
    private static final Logger log = LoggerFactory.getLogger(PushMatchedKmsDataToStatementEventImpl.class);
    @Autowired
    private AuditFeeSettlementCheckService service;
    @Autowired(required=false)
    private AuditFeeSettlementCheckUpdateMatchedRepository updateMatchedRepository;

    public void pushMatchedKmsData(AuditFeePushMatchedKmsDataEventDto dto) {
        log.info("kms\u63a8\u9001\u7ed3\u7b97\u5355\u6570\u636e\u4e8b\u4ef6,\u63a5\u53d7\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        if (Objects.isNull(dto)) {
            return;
        }
        if (!dto.isSuccess()) {
            log.info("kms\u63a8\u9001\u6570\u636e\u9519\u8bef\uff1a{}", (Object)dto.getMsg());
            return;
        }
        ArrayList updateMatchedList = new ArrayList();
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getResultList())) {
            dto.getResultList().forEach(e -> {
                AuditFeeSettlementCheckVo vo = this.buildCheckData((AuditFeeMatchedRespDto)e);
                list.add(vo);
                List<AuditFeeSettlementCheckUpdateMatched> updateMatcheds = this.buildUpdateMatched(e.getDataSource(), e.getDetailList());
                if (CollectionUtils.isNotEmpty(updateMatcheds)) {
                    updateMatchedList.addAll(updateMatcheds);
                }
            });
        }
        log.info("kms\u63a8\u9001\u7ed3\u7b97\u5355\u6570\u636e\u4e8b\u4ef6,\u6570\u636e\u6574\u7406\u5b8c\u6210\uff1a{}", (Object)JSONObject.toJSONString((Object)list));
        this.service.saveBatchForSettlementAndFee(list);
        if (CollectionUtils.isNotEmpty(updateMatchedList)) {
            this.updateMatchedRepository.saveBatch(updateMatchedList);
        }
    }

    private List<AuditFeeSettlementCheckUpdateMatched> buildUpdateMatched(String dataSource, List<AuditFeeMatchedDetailRespDto> detailList) {
        if (CollectionUtils.isEmpty(detailList) || StringUtils.isBlank((CharSequence)dataSource)) {
            return Lists.newArrayList();
        }
        ArrayList<AuditFeeSettlementCheckUpdateMatched> list = new ArrayList<AuditFeeSettlementCheckUpdateMatched>();
        detailList.forEach(d -> {
            DataSourceEnum datasource = DataSourceEnum.getTypeByCode((String)d.getDataSource());
            if (Objects.isNull(d)) {
                return;
            }
            AuditFeeSettlementCheckUpdateMatched updateMatched = new AuditFeeSettlementCheckUpdateMatched();
            switch (datasource) {
                case EXPENSE: {
                    if (StringUtils.isNotBlank((CharSequence)d.getInvoiceExpenseSheetCode())) {
                        if (StringUtils.isBlank((CharSequence)d.getItemIndex())) {
                            updateMatched.setTpmDeductionCode(d.getInvoiceExpenseSheetCode());
                        } else {
                            updateMatched.setTpmDeductionCode(d.getInvoiceExpenseSheetCode() + "-" + d.getItemIndex());
                        }
                    }
                }
                case ACCEPTANCE: {
                    if (StringUtils.isNotBlank((CharSequence)d.getOrderNumber())) {
                        if (StringUtils.isBlank((CharSequence)d.getItemIndex())) {
                            updateMatched.setTpmDeductionCode(d.getOrderNumber());
                        } else {
                            updateMatched.setTpmDeductionCode(d.getOrderNumber() + "-" + d.getItemIndex());
                        }
                    }
                }
                case RETURN: {
                    if (StringUtils.isNotBlank((CharSequence)d.getOrderNumber())) {
                        if (StringUtils.isBlank((CharSequence)d.getItemIndex())) {
                            updateMatched.setTpmDeductionCode(d.getOrderNumber());
                        } else {
                            updateMatched.setTpmDeductionCode(d.getOrderNumber() + "-" + d.getItemIndex());
                        }
                    }
                }
                case STATEMENT_RETURN: {
                    if (StringUtils.isNotBlank((CharSequence)d.getStatementCode())) {
                        if (StringUtils.isBlank((CharSequence)d.getDocumentCode())) {
                            updateMatched.setTpmDeductionCode(d.getStatementCode());
                        } else {
                            updateMatched.setTpmDeductionCode(d.getStatementCode() + "-" + d.getDocumentCode());
                        }
                    }
                }
                case STATEMENT_ACCEPTANCE: {
                    if (StringUtils.isNotBlank((CharSequence)d.getStatementCode())) {
                        if (StringUtils.isBlank((CharSequence)d.getDocumentCode())) {
                            updateMatched.setTpmDeductionCode(d.getStatementCode());
                        } else {
                            updateMatched.setTpmDeductionCode(d.getStatementCode() + "-" + d.getDocumentCode());
                        }
                    }
                }
                case STATEMENT_FEE: {
                    if (!StringUtils.isNotBlank((CharSequence)d.getStatementCode())) break;
                    if (StringUtils.isBlank((CharSequence)d.getDocumentCode())) {
                        updateMatched.setTpmDeductionCode(d.getStatementCode());
                        break;
                    }
                    updateMatched.setTpmDeductionCode(d.getStatementCode() + "-" + d.getDocumentCode());
                }
            }
            if (StringUtils.isBlank((CharSequence)updateMatched.getTpmDeductionCode())) {
                return;
            }
            updateMatched.setDataSource(dataSource);
            updateMatched.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            updateMatched.setTenantCode(TenantUtils.getTenantCode());
            list.add(updateMatched);
        });
        return list;
    }

    public void pushStatementMatchedFeeResult(AuditFeePushMatchedKmsDataEventDto dto) {
        log.info("kms\u63a8\u9001\u8d39\u7528\u5355\u6570\u636e\u4e8b\u4ef6,\u63a5\u53d7\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        if (Objects.isNull(dto)) {
            return;
        }
        if (!dto.isSuccess()) {
            log.info("kms\u63a8\u9001\u6570\u636e\u9519\u8bef\uff1a{}", (Object)dto.getMsg());
            return;
        }
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getResultList())) {
            dto.getResultList().forEach(e -> {
                AuditFeeSettlementCheckVo vo = this.buildDataForFee((AuditFeeMatchedRespDto)e);
                list.add(vo);
            });
        }
        this.service.saveBatchForFee(list);
    }

    private AuditFeeSettlementCheckVo buildCheckData(AuditFeeMatchedRespDto respDto) {
        AuditFeeSettlementCheckVo vo = new AuditFeeSettlementCheckVo();
        vo.setBusinessFormatCode(respDto.getBusinessFormatCode());
        vo.setBusinessUnitCode(respDto.getBusinessUnitCode());
        vo.setMatchTemplateCode(respDto.getMatchTemplateCode());
        vo.setMatchTemplateName(respDto.getMatchTemplateName());
        vo.setSystemCode(respDto.getCustomerRetailerCode());
        vo.setSystemName(respDto.getCustomerRetailerName());
        vo.setCustomerCode(respDto.getSoldToPartyCode());
        vo.setCustomerName(respDto.getSoldToPartyName());
        vo.setRegion(respDto.getBusinessArea());
        vo.setSettlementAmount(Optional.ofNullable(respDto.getStatementAmountTotal()).orElse(BigDecimal.ZERO));
        vo.setFeeAmount(BigDecimal.ZERO);
        vo.setDetailPlanAmount(BigDecimal.ZERO);
        vo.setSettlementFeeDiff(BigDecimal.ZERO);
        vo.setSettlementDetailPlanDiff(BigDecimal.ZERO);
        vo.setDiffConfirmAmount(BigDecimal.ZERO);
        vo.setMd5UniqueKey(respDto.getOnlyKey());
        vo.setMatchActivity(Boolean.FALSE);
        vo.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        vo.setSalesOrgCode(respDto.getSalesOrgCode());
        vo.setSalesOrgName(respDto.getSalesOrgName());
        vo.setQueryStartDate(respDto.getOrderDateBegin());
        vo.setQueryEndDate(respDto.getOrderDateEnd());
        if (CollectionUtils.isNotEmpty((Collection)respDto.getDetailList())) {
            ArrayList settlementVoList = Lists.newArrayList();
            if (Objects.nonNull(respDto.getStatementAmountTotal()) && respDto.getStatementAmountTotal().compareTo(BigDecimal.ZERO) != 0) {
                respDto.getDetailList().forEach(e -> {
                    if (Objects.nonNull(e.getAmount()) && e.getAmount().compareTo(BigDecimal.ZERO) != 0) {
                        AuditFeeSettlementCheckSettlementVo settlementVo = this.buildSettlementInfo(respDto, (AuditFeeMatchedDetailRespDto)e);
                        if (settlementVo.getSettlementDetailCode() == null) {
                            log.info("\u63a8\u9001\u7ed3\u7b97\u6570\u636e\u7f3a\u5931\uff0c\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)e));
                        }
                        settlementVoList.add(settlementVo);
                    }
                });
            }
            vo.setSettlementList((List)settlementVoList);
            if (CollectionUtils.isEmpty((Collection)vo.getSettlementList())) {
                vo.setRemark("\u63a8\u9001\u6570\u636e\u4e2d\uff0c\u65e0\u6709\u6548\u7ed3\u7b97\u5355\u660e\u7ec6");
            } else {
                AuditFeeSettlementCheckSettlementVo settlementVo = (AuditFeeSettlementCheckSettlementVo)vo.getSettlementList().get(0);
                vo.setDataSource(settlementVo.getDataSource());
                vo.setActualYearMonth(settlementVo.getActualYearMonth());
                vo.setOrderYearMonthStr(settlementVo.getOrderYearMonth());
                vo.setOrderDate(settlementVo.getOrderDate());
            }
        }
        return vo;
    }

    private AuditFeeSettlementCheckSettlementVo buildSettlementInfo(AuditFeeMatchedRespDto respDto, AuditFeeMatchedDetailRespDto e) {
        String[] str;
        AuditFeeSettlementCheckSettlementVo settlementVo = new AuditFeeSettlementCheckSettlementVo();
        if (PullKmsDataSourceEnum.FY.getCode().equals(e.getDataSource())) {
            settlementVo.setSettlementDetailCode(e.getItemIndex() == null ? e.getInvoiceExpenseSheetCode() : e.getInvoiceExpenseSheetCode() + "-" + e.getItemIndex());
        }
        if (PullKmsDataSourceEnum.YS.getCode().equals(e.getDataSource())) {
            settlementVo.setSettlementDetailCode(e.getItemIndex() == null ? e.getOrderNumber() : e.getOrderNumber() + "-" + e.getItemIndex());
        }
        if (PullKmsDataSourceEnum.TH.getCode().equals(e.getDataSource())) {
            settlementVo.setSettlementDetailCode(e.getItemIndex() == null ? e.getOrderNumber() : e.getOrderNumber() + "-" + e.getItemIndex());
        }
        if (StringUtils.equalsAny((CharSequence)e.getDataSource(), (CharSequence[])new CharSequence[]{PullKmsDataSourceEnum.JS_TH.getCode(), PullKmsDataSourceEnum.JS_YS.getCode(), PullKmsDataSourceEnum.JS_KF.getCode()})) {
            settlementVo.setSettlementDetailCode(e.getDocumentCode() == null ? e.getStatementCode() : e.getStatementCode() + "-" + e.getDocumentCode());
        }
        settlementVo.setBusinessArea(e.getBusinessArea());
        settlementVo.setDirectCode(respDto.getCustomerRetailerCode());
        settlementVo.setSupermarketName(respDto.getCustomerRetailerName());
        settlementVo.setProvinceCode(e.getProvinceCode());
        settlementVo.setProvinceName(e.getProvinceName());
        settlementVo.setDeliveryPartyCode(respDto.getDeliveryPartyCode());
        settlementVo.setDeliveryPartyName(respDto.getDeliveryPartyName());
        settlementVo.setProductCode(e.getProductCode());
        settlementVo.setProductName(e.getProductName());
        settlementVo.setSlotDateName(e.getSlotDateName());
        settlementVo.setActualYearMonth(DateUtil.format((Date)e.getCreateTime(), (String)"yyyy-MM"));
        settlementVo.setOrderDate(e.getOrderDate());
        if (StringUtils.isNotEmpty((CharSequence)e.getOrderDate()) && (str = e.getOrderDate().split("-")).length >= 2) {
            settlementVo.setOrderYearMonth(str[0] + "-" + str[1]);
        }
        if (DataSourceEnum.EXPENSE.getCode().equals(e.getDataSource())) {
            if (StringUtils.isNotEmpty((CharSequence)e.getItemIndex())) {
                settlementVo.setDeductionCode(e.getInvoiceExpenseSheetCode() + "-" + e.getItemIndex());
            }
        } else if (StringUtils.isNotEmpty((CharSequence)e.getDocumentCode())) {
            settlementVo.setDeductionCode(e.getStatementCode() + "-" + e.getDocumentCode());
        } else {
            settlementVo.setDeductionCode(e.getStatementCode());
        }
        settlementVo.setDeductionName(e.getDeductionName());
        settlementVo.setAuditWay(e.getAuditWay());
        settlementVo.setCashingType(e.getCashingType());
        settlementVo.setAmount(e.getAmount());
        settlementVo.setAmountNot(e.getAmountNot());
        settlementVo.setDataSource(e.getDataSource());
        return settlementVo;
    }

    private AuditFeeSettlementCheckVo buildDataForFee(AuditFeeMatchedRespDto respDto) {
        AuditFeeSettlementCheckVo vo = new AuditFeeSettlementCheckVo();
        vo.setMd5UniqueKey(respDto.getOnlyKey());
        vo.setFeeAmount(Optional.ofNullable(respDto.getFeeAmountTotal()).orElse(BigDecimal.ZERO));
        if (Objects.nonNull(respDto.getFeeAmountTotal()) && respDto.getFeeAmountTotal().compareTo(BigDecimal.ZERO) != 0 && CollectionUtils.isNotEmpty((Collection)respDto.getMatchedFeeList())) {
            ArrayList feeVoList = Lists.newArrayList();
            ArrayList incompleteList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)respDto.getMatchedFeeList())) {
                respDto.getMatchedFeeList().forEach(e -> {
                    if (Objects.nonNull(e.getAmount()) && e.getAmount().compareTo(BigDecimal.ZERO) != 0) {
                        AuditFeeSettlementCheckFeeVo feeVo = this.buildFeeInfo(respDto, (AuditFeeMatchedDetailRespDto)e);
                        if (feeVo.getFeeDetailCode() == null) {
                            incompleteList.add(e.getDataSource() + "_" + e.getStatementCode() + "_" + e.getOrderDate());
                        } else {
                            feeVoList.add(feeVo);
                        }
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)incompleteList)) {
                    log.info("\u63a8\u9001\u8d39\u7528\u6570\u636e\u7f3a\u5931\uff0c\u6570\u636e\uff1a{}", (Object)String.join((CharSequence)",", JSONObject.toJSONString((Object)incompleteList)));
                }
            }
            vo.setFeeList((List)feeVoList);
        }
        return vo;
    }

    private AuditFeeSettlementCheckFeeVo buildFeeInfo(AuditFeeMatchedRespDto respDto, AuditFeeMatchedDetailRespDto e) {
        String[] str;
        AuditFeeSettlementCheckFeeVo feeVo = new AuditFeeSettlementCheckFeeVo();
        if (PullKmsDataSourceEnum.FY.getCode().equals(e.getDataSource())) {
            feeVo.setFeeDetailCode(e.getItemIndex() == null ? e.getInvoiceExpenseSheetCode() : e.getInvoiceExpenseSheetCode() + "-" + e.getItemIndex());
        }
        if (PullKmsDataSourceEnum.YS.getCode().equals(e.getDataSource())) {
            feeVo.setFeeDetailCode(e.getItemIndex() == null ? e.getOrderNumber() : e.getOrderNumber() + "-" + e.getItemIndex());
        }
        if (PullKmsDataSourceEnum.TH.getCode().equals(e.getDataSource())) {
            feeVo.setFeeDetailCode(e.getItemIndex() == null ? e.getOrderNumber() : e.getOrderNumber() + "-" + e.getItemIndex());
        }
        if (StringUtils.equalsAny((CharSequence)e.getDataSource(), (CharSequence[])new CharSequence[]{PullKmsDataSourceEnum.JS_TH.getCode(), PullKmsDataSourceEnum.JS_YS.getCode(), PullKmsDataSourceEnum.JS_KF.getCode()})) {
            feeVo.setFeeDetailCode(e.getDocumentCode() == null ? e.getStatementCode() : e.getStatementCode() + "-" + e.getDocumentCode());
        }
        feeVo.setBusinessArea(e.getBusinessArea());
        feeVo.setDirectCode(respDto.getCustomerRetailerCode());
        feeVo.setSupermarketName(respDto.getCustomerRetailerName());
        feeVo.setProvinceCode(e.getProvinceCode());
        feeVo.setProvinceName(e.getProvinceName());
        feeVo.setDeliveryPartyCode(respDto.getDeliveryPartyCode());
        feeVo.setDeliveryPartyName(respDto.getDeliveryPartyName());
        feeVo.setProductCode(e.getProductCode());
        feeVo.setProductName(e.getProductName());
        feeVo.setSlotDateName(e.getSlotDateName());
        feeVo.setActualYearMonth(DateUtil.format((Date)e.getCreateTime(), (String)"yyyy-MM"));
        feeVo.setOrderDate(e.getOrderDate());
        if (StringUtils.isNotEmpty((CharSequence)e.getOrderDate()) && (str = e.getOrderDate().split("-")).length >= 2) {
            feeVo.setOrderYearMonth(str[0] + "-" + str[1]);
        }
        if (StringUtils.isNotEmpty((CharSequence)e.getItemIndex())) {
            feeVo.setDeductionCode(e.getInvoiceExpenseSheetCode() + "-" + e.getItemIndex());
        }
        feeVo.setDeductionName(e.getDeductionName());
        feeVo.setAuditWay(e.getAuditWay());
        feeVo.setCashingType(e.getCashingType());
        feeVo.setAmount(e.getAmount());
        feeVo.setDataSource(e.getDataSource());
        return feeVo;
    }
}

