/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.service.third;

import com.alibaba.fastjson.JSON;
import com.aliyun.tea.utils.StringUtils;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerCellActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerDisplayActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerDisplayActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerLongTermPersonnelActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerLongTermPersonnelActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerPromotionActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerPromotionActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerTemporaryPersonnelActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerTemporaryPersonnelActivityItemDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.service.CowManagerService;
import com.biz.crm.mn.third.system.cow.manager.sdk.vo.CowManagerVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DiffTrackPushCowManager {
    private static final Logger log = LoggerFactory.getLogger(DiffTrackPushCowManager.class);
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CowManagerService cowManagerService;

    public void passPush(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailPlanItemVoList = this.auditFeeDiffTrackDetailVoService.findDetailByPlanCodeList(planCodes);
        if (CollectionUtils.isEmpty((Collection)detailPlanItemVoList)) {
            return;
        }
        this.buildAndPush(detailPlanItemVoList, false);
    }

    public void passItemPush(List<AuditFeeDiffTrackDetailVo> detailPlanItemVoList) {
        if (CollectionUtils.isEmpty(detailPlanItemVoList)) {
            return;
        }
        this.buildAndPush(detailPlanItemVoList, false);
    }

    public void closePush(List<String> planCodes) {
        Validate.notEmpty(planCodes, (String)"\u4f20\u5165\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailPlanItemVoList = this.auditFeeDiffTrackDetailVoService.findDetailByPlanCodeList(planCodes);
        if (CollectionUtils.isEmpty((Collection)detailPlanItemVoList)) {
            return;
        }
        this.buildAndPush(detailPlanItemVoList, true);
    }

    public void closeItemPush(List<AuditFeeDiffTrackDetailVo> detailPlanItemVoList) {
        if (CollectionUtils.isEmpty(detailPlanItemVoList)) {
            return;
        }
        this.buildAndPush(detailPlanItemVoList, true);
    }

    private void buildAndPush(List<AuditFeeDiffTrackDetailVo> detailPlanItemVoList, boolean close) {
        Map formMap = this.activityFormService.findPushCowManager();
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u725b\u4eba\u7ba1\u5bb6_buildAndPush: {}", (Object)JSON.toJSONString((Object)formMap));
        if (CollectionUtils.isEmpty((Map)formMap)) {
            return;
        }
        Set activityFormCodeSet = formMap.keySet();
        detailPlanItemVoList.removeIf(e -> !activityFormCodeSet.contains(e.getActivityFormCode()));
        Map<String, List<AuditFeeDiffTrackDetailVo>> planItemMap = this.categorizeDetailPlanItem(formMap, detailPlanItemVoList);
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u725b\u4eba\u7ba1\u5bb6_\u5206\u7c7b\u5b8c\u6210");
        List<CowManagerCellActivityDto> marketingDataList = this.buildCellActivityInterfaceData(planItemMap.get(VerticalActivityTypeEnum.MARKETING.getCode()), close);
        List<CowManagerDisplayActivityDto> displayDataList = this.buildDisplayActivityInterfaceData(planItemMap.get(VerticalActivityTypeEnum.DISPLAY.getCode()), close);
        List<CowManagerPromotionActivityDto> promotionDataList = this.buildPromotionActivityInterfaceData(planItemMap.get(VerticalActivityTypeEnum.PROMOTION.getCode()), close);
        List<CowManagerTemporaryPersonnelActivityDto> temporaryDataList = this.buildTemporaryPersonnelActivity(planItemMap.get(VerticalActivityTypeEnum.TEMPORARY.getCode()), close);
        List<CowManagerLongTermPersonnelActivityDto> longPersonDataList = this.buildLongTermPersonnelActivity(planItemMap.get(VerticalActivityTypeEnum.LONG_PROMOTION.getCode()), close);
        List<List<String>> pair = this.pushData(marketingDataList, displayDataList, promotionDataList, temporaryDataList, longPersonDataList);
        List<String> successItemCodes = pair.get(0);
        List<String> failItemCodes = pair.get(1);
        log.info("\u63a8\u9001\u5b8c\u6bd5\u6210\u529f\u660e\u7ec6\u7f16\u7801_{}", successItemCodes);
        log.info("\u63a8\u9001\u5b8c\u6bd5\u5931\u8d25\u660e\u7ec6\u7f16\u7801_{}", failItemCodes);
        this.auditFeeDiffTrackDetailVoService.updateDetailPlanCowManagerState(successItemCodes, InterfacePushStateEnum.SUCCESS);
        this.auditFeeDiffTrackDetailVoService.updateDetailPlanCowManagerState(failItemCodes, InterfacePushStateEnum.FAIL);
    }

    private Map<String, List<AuditFeeDiffTrackDetailVo>> categorizeDetailPlanItem(Map<String, String> fromMap, List<AuditFeeDiffTrackDetailVo> detailPlanItemVoList) {
        if (CollectionUtils.isEmpty(detailPlanItemVoList) || CollectionUtils.isEmpty(fromMap)) {
            return Maps.newHashMap();
        }
        HashMap<String, List<AuditFeeDiffTrackDetailVo>> map = new HashMap<String, List<AuditFeeDiffTrackDetailVo>>(5);
        map.put(VerticalActivityTypeEnum.MARKETING.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.DISPLAY.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.PROMOTION.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.TEMPORARY.getCode(), new ArrayList());
        map.put(VerticalActivityTypeEnum.LONG_PROMOTION.getCode(), new ArrayList());
        detailPlanItemVoList.forEach(detailPlanItem -> {
            String activityType = (String)fromMap.get(detailPlanItem.getActivityFormCode());
            if (StringUtil.isNotBlank((CharSequence)activityType)) {
                if (VerticalActivityTypeEnum.MARKETING.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.MARKETING.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.DISPLAY.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.DISPLAY.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.PROMOTION.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.PROMOTION.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.TEMPORARY.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.TEMPORARY.getCode())).add(detailPlanItem);
                } else if (VerticalActivityTypeEnum.LONG_PROMOTION.getCode().equals(activityType)) {
                    ((List)map.get(VerticalActivityTypeEnum.LONG_PROMOTION.getCode())).add(detailPlanItem);
                }
            }
        });
        return map;
    }

    public List<CowManagerCellActivityDto> buildCellActivityInterfaceData(List<AuditFeeDiffTrackDetailVo> ItemList, boolean close) {
        if (CollectionUtils.isEmpty(ItemList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList<CowManagerCellActivityDto> cowManagerCellActivityDtoList = new ArrayList<CowManagerCellActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        ItemList.forEach(item -> {
            CowManagerCellActivityDto cowManagerCellActivity = new CowManagerCellActivityDto();
            if (close) {
                cowManagerCellActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                cowManagerCellActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                cowManagerCellActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                cowManagerCellActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            cowManagerCellActivity.setActivityNo(item.getPlanCode());
            cowManagerCellActivity.setActiveNumber(item.getDetailCode());
            cowManagerCellActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            cowManagerCellActivity.setRegionInfo(item.getRegion());
            cowManagerCellActivity.setSystemInfo(item.getSystemCode());
            cowManagerCellActivity.setStoreId(item.getTerminalCode());
            cowManagerCellActivity.setStoreName(item.getTerminalName());
            cowManagerCellActivity.setChannelFirst(item.getFirstChannelName());
            cowManagerCellActivity.setChannelSecond(item.getSecondChannelName());
            cowManagerCellActivity.setActivityBrand(item.getProductBrandName());
            cowManagerCellActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            cowManagerCellActivity.setActivityTypeCode(item.getActivityTypeCode());
            cowManagerCellActivity.setActivityTypeName(item.getActivityTypeName());
            cowManagerCellActivity.setActivityCode(item.getActivityFormCode());
            cowManagerCellActivity.setActivityName(item.getActivityFormName());
            cowManagerCellActivity.setActivityDesc(item.getActivityDesc());
            cowManagerCellActivity.setActivityIndicators(item.getQuantity() != null ? item.getQuantity().toString() : "");
            cowManagerCellActivity.setApplyTotalCost(item.getTotalFeeAmount() != null ? String.format("%.2f", item.getTotalFeeAmount()) : "0.00");
            cowManagerCellActivityDtoList.add(cowManagerCellActivity);
        });
        return cowManagerCellActivityDtoList;
    }

    public List<CowManagerDisplayActivityDto> buildDisplayActivityInterfaceData(List<AuditFeeDiffTrackDetailVo> ItemList, boolean close) {
        if (CollectionUtils.isEmpty(ItemList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        String BUY_WAY = "Purchase method";
        List dictList = this.dictDataVoService.findByDictTypeCode("Purchase method");
        log.info("\u63a8\u9001\u725b\u4eba\u7ba1\u5bb6\u8d2d\u4e70\u65b9\u5f0f\u5b57\u5178:{}", (Object)dictList);
        Map<String, String> dictMap = dictList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        ArrayList<CowManagerDisplayActivityDto> cowManagerDisplayActivityDtoList = new ArrayList<CowManagerDisplayActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        ItemList.forEach(detailPlanItem -> {
            CowManagerDisplayActivityDto cowManagerDisplayActivity = new CowManagerDisplayActivityDto();
            if (close) {
                cowManagerDisplayActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                cowManagerDisplayActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                cowManagerDisplayActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                cowManagerDisplayActivity.setActivityEndTime(detailPlanItem.getActivityEndDate() != null ? sif2.format(detailPlanItem.getActivityEndDate()) : "");
            }
            cowManagerDisplayActivity.setActivityNo(detailPlanItem.getPlanCode());
            cowManagerDisplayActivity.setActiveNumber(detailPlanItem.getDetailCode());
            cowManagerDisplayActivity.setCostYearMonth(detailPlanItem.getFeeYearMonth() != null ? sif.format(detailPlanItem.getFeeYearMonth()) : "");
            cowManagerDisplayActivity.setActivityStartTime(detailPlanItem.getActivityBeginDate() != null ? sif2.format(detailPlanItem.getActivityBeginDate()) : "");
            cowManagerDisplayActivity.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            cowManagerDisplayActivity.setActivityTypeName(detailPlanItem.getActivityTypeName());
            cowManagerDisplayActivity.setActivityCode(detailPlanItem.getActivityFormCode());
            cowManagerDisplayActivity.setActivityName(detailPlanItem.getActivityFormName());
            cowManagerDisplayActivity.setStoreId(detailPlanItem.getTerminalCode());
            cowManagerDisplayActivity.setStoreName(detailPlanItem.getTerminalName());
            cowManagerDisplayActivity.setActivityDesc(detailPlanItem.getActivityDesc());
            cowManagerDisplayActivity.setProcurementMethod((String)dictMap.getOrDefault(detailPlanItem.getBuyWay(), null));
            cowManagerDisplayActivity.setScheduleStartTime(detailPlanItem.getScheduleBeginDate() != null ? sif2.format(detailPlanItem.getScheduleBeginDate()) : "");
            cowManagerDisplayActivity.setScheduleEndTime(detailPlanItem.getScheduleEndDate() != null ? sif2.format(detailPlanItem.getScheduleEndDate()) : "");
            cowManagerDisplayActivity.setDisplayApplyNum(detailPlanItem.getDisplayQuantity() != null ? String.valueOf(detailPlanItem.getDisplayQuantity()) : "0.00");
            cowManagerDisplayActivity.setDisplayApplyCost(detailPlanItem.getTotalFeeAmount() != null ? String.format("%.2f", detailPlanItem.getTotalFeeAmount()) : "0.00");
            ArrayList<CowManagerDisplayActivityItemDto> cowManagerDisplayActivityItemList = new ArrayList<CowManagerDisplayActivityItemDto>();
            cowManagerDisplayActivity.setProductLists(cowManagerDisplayActivityItemList);
            CowManagerDisplayActivityItemDto cowManagerDisplayActivityItem = new CowManagerDisplayActivityItemDto();
            cowManagerDisplayActivityItem.setBranCode(detailPlanItem.getProductBrandCode());
            cowManagerDisplayActivityItem.setBranName(detailPlanItem.getProductBrandName());
            cowManagerDisplayActivityItem.setBrandItemCode(detailPlanItem.getProductItemCode());
            cowManagerDisplayActivityItem.setBrandItemName(detailPlanItem.getProductItemName());
            cowManagerDisplayActivityItem.setBrandTypeCode(detailPlanItem.getProductCategoryCode());
            cowManagerDisplayActivityItem.setBrandTypeName(detailPlanItem.getProductCategoryName());
            cowManagerDisplayActivityItem.setProductNo(detailPlanItem.getProductCode());
            cowManagerDisplayActivityItem.setProductName(detailPlanItem.getProductName());
            cowManagerDisplayActivityItemList.add(cowManagerDisplayActivityItem);
            cowManagerDisplayActivityDtoList.add(cowManagerDisplayActivity);
        });
        return cowManagerDisplayActivityDtoList;
    }

    public List<CowManagerPromotionActivityDto> buildPromotionActivityInterfaceData(List<AuditFeeDiffTrackDetailVo> itemList, boolean close) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Set productCodes = itemList.stream().map(AuditFeeDiffTrackDetailVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set giftCodes = itemList.stream().map(AuditFeeDiffTrackDetailVo::getGiftCode).filter(Objects::nonNull).collect(Collectors.toSet());
        productCodes.addAll(giftCodes);
        ArrayList productCodeList = new ArrayList(productCodes);
        List productMainList = this.productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        ArrayList<CowManagerPromotionActivityDto> cowManagerPromotionActivityDtoList = new ArrayList<CowManagerPromotionActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerPromotionActivityDto cowManagerPromotionActivity = new CowManagerPromotionActivityDto();
            if (close) {
                cowManagerPromotionActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                cowManagerPromotionActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                cowManagerPromotionActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                cowManagerPromotionActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            cowManagerPromotionActivity.setActivityNo(item.getPlanCode());
            cowManagerPromotionActivity.setActiveNumber(item.getDetailCode());
            cowManagerPromotionActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            cowManagerPromotionActivity.setRegionInfo(item.getRegion());
            cowManagerPromotionActivity.setSystemInfo(item.getSystemCode());
            cowManagerPromotionActivity.setStoreId(item.getTerminalCode());
            cowManagerPromotionActivity.setStoreName(item.getTerminalName());
            cowManagerPromotionActivity.setChannelFirst(item.getFirstChannelName());
            cowManagerPromotionActivity.setChannelSecond(item.getSecondChannelName());
            cowManagerPromotionActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            cowManagerPromotionActivity.setActivityTypeCode(item.getActivityTypeCode());
            cowManagerPromotionActivity.setActivityTypeName(item.getActivityTypeName());
            cowManagerPromotionActivity.setActivityCode(item.getActivityFormCode());
            cowManagerPromotionActivity.setActivityName(item.getActivityFormName());
            cowManagerPromotionActivity.setActivityDesc(item.getActivityDesc());
            cowManagerPromotionActivity.setOriginalPrice(item.getRetailPrice() != null ? String.format("%.2f", item.getRetailPrice()) : "0.00");
            cowManagerPromotionActivity.setPromotionalPrice(item.getPromotionalPrice() != null ? String.format("%.2f", item.getPromotionalPrice()) : "0.00");
            if (!StringUtils.isEmpty((CharSequence)item.getProductCode())) {
                ArrayList<CowManagerPromotionActivityItemDto> promotionActivityItemDtoList = new ArrayList<CowManagerPromotionActivityItemDto>();
                cowManagerPromotionActivity.setSalesPromotionProductList(promotionActivityItemDtoList);
                ProductVo productVo = productMainList.stream().filter(k -> k.getProductCode().equals(item.getProductCode())).findAny().orElse(null);
                CowManagerPromotionActivityItemDto productDto = new CowManagerPromotionActivityItemDto();
                productDto.setProductType("BP");
                productDto.setProductTypeName("\u672c\u54c1");
                productDto.setActivityBrand(productVo.getProductBrandName());
                productDto.setPackageNo(productVo.getCartonBarCode());
                productDto.setSapCode(productVo.getProductCode());
                productDto.setSapName(productVo.getProductName());
                productDto.setProdDate(item.getThisProductProductionDate() != null ? sif2.format(item.getThisProductProductionDate()) : null);
                promotionActivityItemDtoList.add(productDto);
                if (!StringUtils.isEmpty((CharSequence)item.getGiftCode())) {
                    ProductVo giftVo = productMainList.stream().filter(k -> k.getProductCode().equals(item.getGiftCode())).findAny().orElse(null);
                    CowManagerPromotionActivityItemDto giftDto = new CowManagerPromotionActivityItemDto();
                    giftDto.setProductType("ZP");
                    giftDto.setProductTypeName("\u8d60\u54c1");
                    giftDto.setActivityBrand(giftVo.getProductBrandName());
                    giftDto.setPackageNo(giftVo.getCartonBarCode());
                    giftDto.setSapCode(giftVo.getProductCode());
                    giftDto.setSapName(giftVo.getProductName());
                    giftDto.setProdDate(item.getGiftProductionDate() != null ? sif2.format(item.getGiftProductionDate()) : null);
                    promotionActivityItemDtoList.add(giftDto);
                }
            }
            cowManagerPromotionActivityDtoList.add(cowManagerPromotionActivity);
        });
        return cowManagerPromotionActivityDtoList;
    }

    public List<CowManagerTemporaryPersonnelActivityDto> buildTemporaryPersonnelActivity(List<AuditFeeDiffTrackDetailVo> itemList, boolean close) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList<CowManagerTemporaryPersonnelActivityDto> temporaryPersonnelActivityDtoList = new ArrayList<CowManagerTemporaryPersonnelActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerTemporaryPersonnelActivityDto temporaryPersonnelActivity = new CowManagerTemporaryPersonnelActivityDto();
            if (close) {
                temporaryPersonnelActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                temporaryPersonnelActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                temporaryPersonnelActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                temporaryPersonnelActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            temporaryPersonnelActivity.setActivityNo(item.getPlanCode());
            temporaryPersonnelActivity.setActiveNumber(item.getDetailCode());
            temporaryPersonnelActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            temporaryPersonnelActivity.setSystemInfo(item.getSystemCode());
            temporaryPersonnelActivity.setStoreId(item.getTerminalCode());
            temporaryPersonnelActivity.setStoreName(item.getTerminalName());
            temporaryPersonnelActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            temporaryPersonnelActivity.setActivityTypeCode(item.getActivityTypeCode());
            temporaryPersonnelActivity.setActivityTypeName(item.getActivityTypeName());
            temporaryPersonnelActivity.setActivityCode(item.getActivityFormCode());
            temporaryPersonnelActivity.setActivityName(item.getProductCategoryName());
            temporaryPersonnelActivity.setUserNum(item.getQuantity() != null ? item.getQuantity().toString() : "0.00");
            temporaryPersonnelActivity.setActivityDesc(item.getActivityDesc());
            if (!StringUtils.isEmpty((CharSequence)item.getProductCode())) {
                ArrayList<CowManagerTemporaryPersonnelActivityItemDto> productLists = new ArrayList<CowManagerTemporaryPersonnelActivityItemDto>();
                temporaryPersonnelActivity.setProductLists(productLists);
                CowManagerTemporaryPersonnelActivityItemDto tpProductDto = new CowManagerTemporaryPersonnelActivityItemDto();
                tpProductDto.setBranCode(item.getProductBrandCode());
                tpProductDto.setBranName(item.getProductBrandName());
                tpProductDto.setBrandItemCode(item.getProductItemCode());
                tpProductDto.setBrandItemName(item.getProductItemName());
                tpProductDto.setBrandTypeCode(item.getProductCategoryCode());
                tpProductDto.setBrandTypeName(item.getProductCategoryName());
                tpProductDto.setProductNo(item.getProductCode());
                tpProductDto.setProductName(item.getProductCode());
                productLists.add(tpProductDto);
            }
            temporaryPersonnelActivityDtoList.add(temporaryPersonnelActivity);
        });
        return temporaryPersonnelActivityDtoList;
    }

    public List<CowManagerLongTermPersonnelActivityDto> buildLongTermPersonnelActivity(List<AuditFeeDiffTrackDetailVo> itemList, boolean close) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList<CowManagerLongTermPersonnelActivityDto> longTermPersonnelActivityDtoList = new ArrayList<CowManagerLongTermPersonnelActivityDto>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerLongTermPersonnelActivityDto longTermPersonnelActivity = new CowManagerLongTermPersonnelActivityDto();
            if (close) {
                longTermPersonnelActivity.setActivityStatus("\u5df2\u5173\u95ed");
                Date currentDate = new Date();
                longTermPersonnelActivity.setActivityEndTime(sif2.format(currentDate));
            } else {
                longTermPersonnelActivity.setActivityStatus("\u5ba1\u6279\u901a\u8fc7");
                longTermPersonnelActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            longTermPersonnelActivity.setActivityNo(item.getPlanCode());
            longTermPersonnelActivity.setActiveNumber(item.getDetailCode());
            longTermPersonnelActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            longTermPersonnelActivity.setRegionInfo(item.getRegion());
            longTermPersonnelActivity.setSystemInfo(item.getSystemCode());
            longTermPersonnelActivity.setStoreId(item.getTerminalCode());
            longTermPersonnelActivity.setStoreName(item.getTerminalName());
            longTermPersonnelActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            longTermPersonnelActivity.setActivityTypeCode(item.getActivityTypeCode());
            longTermPersonnelActivity.setActivityTypeName(item.getActivityTypeName());
            longTermPersonnelActivity.setActivityCode(item.getActivityFormCode());
            longTermPersonnelActivity.setActivityName(item.getProductCategoryName());
            longTermPersonnelActivity.setUserName(item.getNameOfShoppingGuide());
            longTermPersonnelActivity.setUserId(item.getEmployeeId());
            longTermPersonnelActivity.setIdNumber(item.getPersonIdCard());
            longTermPersonnelActivity.setPhone(item.getTelephone());
            longTermPersonnelActivity.setActivityDesc(item.getActivityDesc());
            if (!StringUtils.isEmpty((CharSequence)item.getProductCode())) {
                ArrayList<CowManagerLongTermPersonnelActivityItemDto> productLists = new ArrayList<CowManagerLongTermPersonnelActivityItemDto>();
                longTermPersonnelActivity.setProductLists(productLists);
                CowManagerLongTermPersonnelActivityItemDto ltProductDto = new CowManagerLongTermPersonnelActivityItemDto();
                ltProductDto.setBranCode(item.getProductBrandCode());
                ltProductDto.setBranName(item.getProductBrandName());
                ltProductDto.setBrandItemCode(item.getProductItemCode());
                ltProductDto.setBrandItemName(item.getProductItemName());
                ltProductDto.setBrandTypeCode(item.getProductCategoryCode());
                ltProductDto.setBrandTypeName(item.getProductCategoryName());
                ltProductDto.setProductNo(item.getProductCode());
                ltProductDto.setProductName(item.getProductName());
                productLists.add(ltProductDto);
            }
            longTermPersonnelActivityDtoList.add(longTermPersonnelActivity);
        });
        return longTermPersonnelActivityDtoList;
    }

    private List<List<String>> pushData(List<CowManagerCellActivityDto> marketingDataList, List<CowManagerDisplayActivityDto> displayDataList, List<CowManagerPromotionActivityDto> promotionDataList, List<CowManagerTemporaryPersonnelActivityDto> temporaryDataList, List<CowManagerLongTermPersonnelActivityDto> longPersonDataList) {
        List itemCodes;
        log.info("marketingDataList_{}_displayDataList_{}_promotionDataList_{}_temporaryDataList_{}_longPersonDataList_{}", new Object[]{marketingDataList.size(), displayDataList.size(), promotionDataList.size(), temporaryDataList.size(), longPersonDataList.size()});
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u725b\u4eba\u7ba1\u5bb6_\u5f00\u59cb\u63a8\u9001");
        ArrayList successCodes = new ArrayList();
        ArrayList failCodes = new ArrayList();
        if (!CollectionUtils.isEmpty(marketingDataList)) {
            CowManagerVo mar = this.pushCellActivity(marketingDataList);
            itemCodes = marketingDataList.stream().map(CowManagerCellActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                if (!mar.isSuccess() || !((Boolean)mar.getData()).booleanValue()) {
                    throw new IllegalArgumentException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
                }
                successCodes.addAll(itemCodes);
            }
            catch (Exception e) {
                log.warn("\u884c\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! \u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)mar));
                log.warn("\u884c\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a{}", (Object)e.getMessage());
                failCodes.addAll(itemCodes);
            }
        }
        if (!CollectionUtils.isEmpty(displayDataList)) {
            CowManagerVo dis = this.pushDisplayActivity(displayDataList);
            itemCodes = displayDataList.stream().map(CowManagerDisplayActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                if (!dis.isSuccess() || !((Boolean)dis.getData()).booleanValue()) {
                    throw new IllegalArgumentException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
                }
                successCodes.addAll(itemCodes);
            }
            catch (Exception e) {
                log.warn("\u9648\u5217\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! \u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dis));
                log.warn("\u9648\u5217\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a{}", (Object)e.getMessage());
                failCodes.addAll(itemCodes);
            }
        }
        if (!CollectionUtils.isEmpty(promotionDataList)) {
            CowManagerVo pro = this.pushPromotionActivity(promotionDataList);
            itemCodes = promotionDataList.stream().map(CowManagerPromotionActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                if (!pro.isSuccess() || !((Boolean)pro.getData()).booleanValue()) {
                    throw new IllegalArgumentException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
                }
                successCodes.addAll(itemCodes);
            }
            catch (Exception e) {
                log.warn("\u4fc3\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! \u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pro));
                log.warn("\u4fc3\u9500\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a{}", (Object)e.getMessage());
                failCodes.addAll(itemCodes);
            }
        }
        if (!CollectionUtils.isEmpty(temporaryDataList)) {
            CowManagerVo tem = this.pushTemporaryPersonnelActivity(temporaryDataList);
            itemCodes = temporaryDataList.stream().map(CowManagerTemporaryPersonnelActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                if (!tem.isSuccess() || !((Boolean)tem.getData()).booleanValue()) {
                    throw new IllegalArgumentException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
                }
                successCodes.addAll(itemCodes);
            }
            catch (Exception e) {
                log.warn("\u4e34\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! \u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)tem));
                log.warn("\u4e34\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a{}", (Object)e.getMessage());
                failCodes.addAll(itemCodes);
            }
        }
        if (!CollectionUtils.isEmpty(longPersonDataList)) {
            CowManagerVo lon = this.pushLongTermPersonnelActivity(longPersonDataList);
            itemCodes = longPersonDataList.stream().map(CowManagerLongTermPersonnelActivityDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                if (!lon.isSuccess() || !((Boolean)lon.getData()).booleanValue()) {
                    throw new IllegalArgumentException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
                }
                successCodes.addAll(itemCodes);
            }
            catch (Exception e) {
                log.warn("\u957f\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! \u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)lon));
                log.warn("\u957f\u4fc3\u6d3b\u52a8\u63a8\u9001\u5931\u8d25! cause by\uff1a{}", (Object)e.getMessage());
                failCodes.addAll(itemCodes);
            }
        }
        return Lists.newArrayList((Object[])new List[]{successCodes, failCodes});
    }

    private CowManagerVo pushCellActivity(List<CowManagerCellActivityDto> marketingDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushCellActivity(marketingDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"false", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushDisplayActivity(List<CowManagerDisplayActivityDto> displayDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushDisplayActivity(displayDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"false", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushPromotionActivity(List<CowManagerPromotionActivityDto> promotionDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushPromotionActivity(promotionDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"false", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushTemporaryPersonnelActivity(List<CowManagerTemporaryPersonnelActivityDto> temporaryDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushTemporaryPersonnelActivity(temporaryDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"false", "\u5931\u8d25");
        }
    }

    private CowManagerVo pushLongTermPersonnelActivity(List<CowManagerLongTermPersonnelActivityDto> longPersonDataList) {
        try {
            CowManagerVo result = this.cowManagerService.pushLongTermPersonnelActivity(longPersonDataList);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CowManagerVo("2001", false, (Object)"false", "\u5931\u8d25");
        }
    }
}

