/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.template.service.internal;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplate;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplateAllowance;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplateRules;
import com.biz.crm.tpm.business.audit.fee.local.template.repository.TpmDeductionMatchingTemplateAllowanceRepository;
import com.biz.crm.tpm.business.audit.fee.local.template.repository.TpmDeductionMatchingTemplateRepository;
import com.biz.crm.tpm.business.audit.fee.local.template.repository.TpmDeductionMatchingTemplateRulesRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateAllowanceDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateRulesDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.log.TpmDeductionMatchingTemplateLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.AllowanceTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateConditionEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.log.TpmDeductionMatchingTemplateLogEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateRulesVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmDeductionMatchingTemplateService")
public class TpmDeductionMatchingTemplateServiceImpl
implements TpmDeductionMatchingTemplateService {
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateRepository tpmDeductionMatchingTemplateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateAllowanceRepository tpmDeductionMatchingTemplateAllowanceRepository;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateRulesRepository tpmDeductionMatchingTemplateRulesRepository;
    @Autowired(required=false)
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;

    public Page<TpmDeductionMatchingTemplateVo> findByConditions(Pageable pageable, TpmDeductionMatchingTemplateDto dto) {
        Page<TpmDeductionMatchingTemplateVo> result = this.tpmDeductionMatchingTemplateRepository.findByConditions(pageable, dto);
        if (Objects.isNull(result) || CollectionUtils.isEmpty((Collection)result.getRecords())) {
            return result;
        }
        List templateVoList = result.getRecords();
        List codes = templateVoList.stream().map(TpmDeductionMatchingTemplateVo::getCode).distinct().collect(Collectors.toList());
        TpmDeductionMatchingTemplateAllowanceDto allowanceDto = new TpmDeductionMatchingTemplateAllowanceDto();
        allowanceDto.setCodeList(codes);
        allowanceDto.setAllowanceType(dto.getAllowanceType());
        List<TpmDeductionMatchingTemplateAllowanceVo> allowanceVos = this.tpmDeductionMatchingTemplateAllowanceRepository.findListAnywayByCodeOrCodes(allowanceDto);
        if (CollectionUtils.isEmpty(allowanceVos)) {
            return result;
        }
        Map<String, List<TpmDeductionMatchingTemplateAllowanceVo>> allowanceMap = allowanceVos.stream().collect(Collectors.groupingBy(a -> a.getCode() + "-" + a.getAllowanceType()));
        for (TpmDeductionMatchingTemplateVo templateVo : templateVoList) {
            List<TpmDeductionMatchingTemplateAllowanceVo> posAllowanceList = allowanceMap.get(templateVo.getCode() + "-" + AllowanceTypeEnum.POS.getCode());
            List<TpmDeductionMatchingTemplateAllowanceVo> feeAllowanceList = allowanceMap.get(templateVo.getCode() + "-" + AllowanceTypeEnum.FEE.getCode());
            List<TpmDeductionMatchingTemplateAllowanceVo> statementAllowanceList = allowanceMap.get(templateVo.getCode() + "-" + AllowanceTypeEnum.STATEMENT.getCode());
            if (CollectionUtils.isNotEmpty(posAllowanceList)) {
                templateVo.setPosAllowances(posAllowanceList);
            }
            if (CollectionUtils.isNotEmpty(feeAllowanceList)) {
                templateVo.setFeeAllowances(feeAllowanceList);
            }
            if (!CollectionUtils.isNotEmpty(statementAllowanceList)) continue;
            templateVo.setStatementAllowances(statementAllowanceList);
        }
        return result;
    }

    public List<TpmDeductionMatchingTemplateVo> findAllListByConditions(TpmDeductionMatchingTemplateDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        List<TpmDeductionMatchingTemplateVo> voList = this.tpmDeductionMatchingTemplateRepository.findAllListByConditions(dto);
        if (CollectionUtils.isEmpty(voList)) {
            return voList;
        }
        List<TpmDeductionMatchingTemplateAllowanceVo> allowances = this.tpmDeductionMatchingTemplateAllowanceRepository.findByCodeList(voList.stream().map(TpmDeductionMatchingTemplateVo::getCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(allowances)) {
            return voList;
        }
        Map<String, List<TpmDeductionMatchingTemplateAllowanceVo>> allowanceMap = allowances.stream().collect(Collectors.groupingBy(a -> a.getCode() + "-" + a.getAllowanceType()));
        for (TpmDeductionMatchingTemplateVo templateVo : voList) {
            List<TpmDeductionMatchingTemplateAllowanceVo> posAllowanceList = allowanceMap.get(templateVo.getCode() + "-" + AllowanceTypeEnum.POS.getCode());
            List<TpmDeductionMatchingTemplateAllowanceVo> feeAllowanceList = allowanceMap.get(templateVo.getCode() + "-" + AllowanceTypeEnum.FEE.getCode());
            List<TpmDeductionMatchingTemplateAllowanceVo> statementAllowanceList = allowanceMap.get(templateVo.getCode() + "-" + AllowanceTypeEnum.STATEMENT.getCode());
            if (CollectionUtils.isNotEmpty(posAllowanceList)) {
                templateVo.setPosAllowances(posAllowanceList);
            }
            if (CollectionUtils.isNotEmpty(feeAllowanceList)) {
                templateVo.setFeeAllowances(feeAllowanceList);
            }
            if (!CollectionUtils.isNotEmpty(statementAllowanceList)) continue;
            templateVo.setStatementAllowances(statementAllowanceList);
        }
        return voList;
    }

    public TpmDeductionMatchingTemplateVo findById(String id) {
        List<TpmDeductionMatchingTemplateRules> rulesList;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmDeductionMatchingTemplate entity = (TpmDeductionMatchingTemplate)((Object)this.tpmDeductionMatchingTemplateRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateVo vo = (TpmDeductionMatchingTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmDeductionMatchingTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmDeductionMatchingTemplateAllowanceVo> allowances = this.tpmDeductionMatchingTemplateAllowanceRepository.findByCode(entity.getCode());
        if (CollectionUtils.isNotEmpty(allowances)) {
            Map<String, List<TpmDeductionMatchingTemplateAllowanceVo>> allowancesMap = allowances.stream().collect(Collectors.groupingBy(TpmDeductionMatchingTemplateAllowanceVo::getAllowanceType));
            for (String key : allowancesMap.keySet()) {
                if (AllowanceTypeEnum.POS.getCode().equals(key)) {
                    vo.setPosAllowances(allowancesMap.get(key));
                }
                if (AllowanceTypeEnum.FEE.getCode().equals(key)) {
                    vo.setFeeAllowances(allowancesMap.get(key));
                }
                if (!AllowanceTypeEnum.STATEMENT.getCode().equals(key)) continue;
                vo.setStatementAllowances(allowancesMap.get(key));
            }
        }
        if (CollectionUtils.isNotEmpty(rulesList = this.tpmDeductionMatchingTemplateRulesRepository.findByCode(entity.getCode()))) {
            List rulesVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(rulesList, TpmDeductionMatchingTemplateRules.class, TpmDeductionMatchingTemplateRulesVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setRulesList(rulesVoList);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmDeductionMatchingTemplateVo create(TpmDeductionMatchingTemplateDto dto) {
        this.createValidate(dto);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u6263\u8d39\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u6263\u8d39\u6a21\u677f\u540d\u79f0\u6700\u5927\u957f\u5ea6\u4e3a255", (Object[])new Object[0]);
        TpmDeductionDetailMappingVo mappingVo = this.tpmDeductionDetailMappingService.findByCode(dto.getApplyMappingCode());
        Validate.notNull((Object)mappingVo, (String)("\u672a\u627e\u5230\u6263\u8d39\u6620\u5c04\u3010" + dto.getApplyMappingCode() + "\u3011"), (Object[])new Object[0]);
        dto.setSalesInstitutionCode(mappingVo.getSalesInstitutionCode());
        dto.setSalesInstitutionName(mappingVo.getSalesInstitutionName());
        dto.setSalesInstitutionErpCode(mappingVo.getSalesInstitutionErpCode());
        dto.setResaleCommercialCode(mappingVo.getResaleCommercialCode());
        dto.setResaleCommercialName(mappingVo.getResaleCommercialName());
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), TpmDeductionMatchingTemplate::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), TpmDeductionMatchingTemplate::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getDeductionMatchingTemplateType()), TpmDeductionMatchingTemplate::getDeductionMatchingTemplateType, (Object)dto.getDeductionMatchingTemplateType())).eq(StringUtils.isNotBlank((CharSequence)dto.getSalesInstitutionCode()), TpmDeductionMatchingTemplate::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getApplyMappingCode()), TpmDeductionMatchingTemplate::getApplyMappingCode, (Object)dto.getApplyMappingCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u673a\u6784+\u6a21\u677f\u7c7b\u578b+\u9002\u7528\u6620\u5c04\u91cd\u590d\u65b0\u589e", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        String code = (String)this.generateCodeService.generateCode("MB", 1, Integer.valueOf(10), 2L, TimeUnit.DAYS).get(0);
        dto.setCode(code);
        ArrayList<TpmDeductionMatchingTemplateAllowance> allowances = new ArrayList<TpmDeductionMatchingTemplateAllowance>();
        if (!CollectionUtils.isEmpty((Collection)dto.getPosAllowances())) {
            allowances.addAll(this.buildAllowanceData(dto, dto.getPosAllowances(), AllowanceTypeEnum.POS));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getFeeAllowances())) {
            allowances.addAll(this.buildAllowanceData(dto, dto.getFeeAllowances(), AllowanceTypeEnum.FEE));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getStatementAllowances())) {
            allowances.addAll(this.buildAllowanceData(dto, dto.getStatementAllowances(), AllowanceTypeEnum.STATEMENT));
        }
        ArrayList<TpmDeductionMatchingTemplateRules> rulesList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)dto.getRulesList())) {
            dto.getRulesList().forEach(rules -> {
                rules.setTenantCode(TenantUtils.getTenantCode());
                rules.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                rules.setCode(dto.getCode());
            });
            rulesList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getRulesList(), TpmDeductionMatchingTemplateRulesDto.class, TpmDeductionMatchingTemplateRules.class, HashSet.class, ArrayList.class, new String[0]);
        }
        TpmDeductionMatchingTemplate entity = (TpmDeductionMatchingTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionMatchingTemplate.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.saveOrUpdateTpmDeductionMatchingTemplate(true, dto, null, entity, rulesList, allowances);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateTpmDeductionMatchingTemplate(boolean flag, TpmDeductionMatchingTemplateDto dto, TpmDeductionMatchingTemplateDto old, TpmDeductionMatchingTemplate entity, Collection<TpmDeductionMatchingTemplateRules> rulesList, List<TpmDeductionMatchingTemplateAllowance> allowances) {
        if (!Objects.isNull(dto) || !Objects.isNull((Object)entity)) {
            this.tpmDeductionMatchingTemplateRepository.saveOrUpdate((Object)entity);
            if (CollectionUtils.isNotEmpty(rulesList)) {
                if (!flag) {
                    this.tpmDeductionMatchingTemplateRulesRepository.removeByCode(entity.getCode());
                }
                this.tpmDeductionMatchingTemplateRulesRepository.saveBatch(rulesList);
            }
            if (CollectionUtils.isNotEmpty(allowances)) {
                if (!flag) {
                    this.tpmDeductionMatchingTemplateAllowanceRepository.removeByCode(entity.getCode());
                }
                this.tpmDeductionMatchingTemplateAllowanceRepository.saveBatch(allowances);
            }
            if (flag) {
                TpmDeductionMatchingTemplateLogEventDto logEventDto = new TpmDeductionMatchingTemplateLogEventDto();
                logEventDto.setOriginal(null);
                logEventDto.setNewest(dto);
                SerializableBiConsumer & Serializable onCreate = TpmDeductionMatchingTemplateLogEventListener::onCreate;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionMatchingTemplateLogEventListener.class, (SerializableBiConsumer)onCreate);
            } else {
                TpmDeductionMatchingTemplateLogEventDto logEventDto = new TpmDeductionMatchingTemplateLogEventDto();
                logEventDto.setOriginal(old);
                logEventDto.setNewest(dto);
                SerializableBiConsumer & Serializable onUpdate = TpmDeductionMatchingTemplateLogEventListener::onUpdate;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionMatchingTemplateLogEventListener.class, (SerializableBiConsumer)onUpdate);
            }
        }
    }

    private List<TpmDeductionMatchingTemplateAllowance> buildAllowanceData(TpmDeductionMatchingTemplateDto dto, List<TpmDeductionMatchingTemplateAllowanceDto> allowanceDto, AllowanceTypeEnum allowanceType) {
        if (CollectionUtils.isEmpty(allowanceDto) || Objects.isNull(allowanceType)) {
            return Lists.newArrayList();
        }
        List allowances = (List)this.nebulaToolkitService.copyCollectionByWhiteList(allowanceDto, TpmDeductionMatchingTemplateAllowanceDto.class, TpmDeductionMatchingTemplateAllowance.class, HashSet.class, ArrayList.class, new String[0]);
        HashMap<String, Integer> applyBusinessAreaCodeMap = new HashMap<String, Integer>();
        for (TpmDeductionMatchingTemplateAllowance allowance : allowances) {
            StringBuilder uniqueKeyBuilder = new StringBuilder();
            uniqueKeyBuilder.append(dto.getCode()).append("_").append(StringUtils.isNotBlank((CharSequence)allowance.getApplyMappingCode()) ? allowance.getApplyMappingCode() : "").append("_").append(allowanceType).append("_").append(allowance.getApplyBusinessAreaCode());
            allowance.setDeductionUniqueKey(uniqueKeyBuilder.toString());
            if (StringUtils.isNotBlank((CharSequence)allowance.getApplyBusinessAreaCode())) {
                String[] split = allowance.getApplyBusinessAreaCode().split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (Objects.isNull(applyBusinessAreaCodeMap.get(split[i]))) {
                        applyBusinessAreaCodeMap.put(split[i], 0);
                    }
                    Integer num = (Integer)applyBusinessAreaCodeMap.get(split[i]);
                    num = num + 1;
                    applyBusinessAreaCodeMap.put(split[i], num);
                }
            }
            allowance.setTenantCode(TenantUtils.getTenantCode());
            allowance.setCode(dto.getCode());
            allowance.setAllowanceType(allowanceType.getCode());
        }
        applyBusinessAreaCodeMap.forEach((k, v) -> Validate.isTrue((!Objects.isNull(v) && v == 1 ? 1 : 0) != 0, (String)(allowanceType.getDesc() + "\u9002\u7528\u8303\u56f4\u4e2d\uff0c\u4e1a\u52a1\u533a\u57df\u5b58\u5728\u91cd\u590d\u533a\u57df\uff0c\u8bf7\u68c0\u67e5"), (Object[])new Object[0]));
        return allowances;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmDeductionMatchingTemplateVo update(TpmDeductionMatchingTemplateDto dto) {
        this.updateValidate(dto);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u6263\u8d39\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u6263\u8d39\u6a21\u677f\u540d\u79f0\u6700\u5927\u957f\u5ea6\u4e3a255", (Object[])new Object[0]);
        TpmDeductionMatchingTemplate oldEntity = (TpmDeductionMatchingTemplate)((Object)this.tpmDeductionMatchingTemplateRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(oldEntity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(oldEntity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateDto oldDto = (TpmDeductionMatchingTemplateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, TpmDeductionMatchingTemplateDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), TpmDeductionMatchingTemplate::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), TpmDeductionMatchingTemplate::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getSalesInstitutionCode()), TpmDeductionMatchingTemplate::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getApplyMappingCode()), TpmDeductionMatchingTemplate::getApplyMappingCode, (Object)dto.getApplyMappingCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getDeductionMatchingTemplateType()), TpmDeductionMatchingTemplate::getDeductionMatchingTemplateType, (Object)dto.getDeductionMatchingTemplateType())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).ne(UuidEntity::getId, (Object)dto.getId())).list();
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u673a\u6784+\u6a21\u677f\u7c7b\u578b+\u9002\u7528\u6620\u5c04\u91cd\u590d\u65b0\u589e", (Object[])new Object[0]);
        TpmDeductionDetailMappingVo mappingVo = this.tpmDeductionDetailMappingService.findByCode(dto.getApplyMappingCode());
        Validate.notNull((Object)mappingVo, (String)("\u672a\u627e\u5230\u6263\u8d39\u6620\u5c04\u3010" + dto.getApplyMappingCode() + "\u3011"), (Object[])new Object[0]);
        dto.setSalesInstitutionCode(mappingVo.getSalesInstitutionCode());
        dto.setSalesInstitutionName(mappingVo.getSalesInstitutionName());
        dto.setSalesInstitutionErpCode(mappingVo.getSalesInstitutionErpCode());
        dto.setResaleCommercialCode(mappingVo.getResaleCommercialCode());
        dto.setResaleCommercialName(mappingVo.getResaleCommercialName());
        TpmDeductionMatchingTemplate newEntity = (TpmDeductionMatchingTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionMatchingTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        String code = newEntity.getCode();
        ArrayList<TpmDeductionMatchingTemplateAllowance> allowances = new ArrayList<TpmDeductionMatchingTemplateAllowance>();
        if (!CollectionUtils.isEmpty((Collection)dto.getPosAllowances())) {
            allowances.addAll(this.buildAllowanceData(dto, dto.getPosAllowances(), AllowanceTypeEnum.POS));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getFeeAllowances())) {
            allowances.addAll(this.buildAllowanceData(dto, dto.getFeeAllowances(), AllowanceTypeEnum.FEE));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getStatementAllowances())) {
            allowances.addAll(this.buildAllowanceData(dto, dto.getStatementAllowances(), AllowanceTypeEnum.STATEMENT));
        }
        Collection<TpmDeductionMatchingTemplateRules> rulesList = new ArrayList<TpmDeductionMatchingTemplateRules>();
        if (!CollectionUtils.isEmpty((Collection)dto.getRulesList())) {
            dto.getRulesList().forEach(rules -> {
                rules.setTenantCode(TenantUtils.getTenantCode());
                rules.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                rules.setCode(dto.getCode());
            });
            rulesList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getRulesList(), TpmDeductionMatchingTemplateRulesDto.class, TpmDeductionMatchingTemplateRules.class, HashSet.class, ArrayList.class, new String[0]);
        }
        this.saveOrUpdateTpmDeductionMatchingTemplate(false, dto, oldDto, newEntity, rulesList, allowances);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().select(new SFunction[]{TpmDeductionMatchingTemplate::getCode, UuidFlagOpEntity::getEnableStatus}).in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        Validate.notEmpty((Collection)list, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        list.forEach(e -> {
            if (EnableStatusEnum.ENABLE.getCode().equals(e.getEnableStatus())) {
                throw new RuntimeException("\u542f\u7528\u4e2d\u7684\u6a21\u677f\u4e0d\u53ef\u5220\u9664\uff01");
            }
        });
        List codeList = list.stream().map(TpmDeductionMatchingTemplate::getCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaUpdate().in(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateAllowanceRepository.lambdaUpdate().in(TpmDeductionMatchingTemplateAllowance::getCode, codeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void disableOrEnable(List<String> idList, String code) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().in(UuidEntity::getId, idList)).list();
        Validate.noNullElements((Iterable)list, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List codeList = list.stream().map(TpmDeductionMatchingTemplate::getCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getEnableStatus, (Object)code)).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateAllowanceRepository.lambdaUpdate().in(TpmDeductionMatchingTemplateAllowance::getCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getEnableStatus, (Object)code)).update();
        ArrayList oldDtos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmDeductionMatchingTemplate.class, TpmDeductionMatchingTemplateDto.class, HashSet.class, ArrayList.class, new String[0]));
        oldDtos.forEach(oldDto -> {
            TpmDeductionMatchingTemplateLogEventDto logEventDto = new TpmDeductionMatchingTemplateLogEventDto();
            logEventDto.setOriginal(oldDto);
            TpmDeductionMatchingTemplateDto newDto = (TpmDeductionMatchingTemplateDto)this.nebulaToolkitService.copyObjectByWhiteList(oldDto, TpmDeductionMatchingTemplateDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            newDto.setEnableStatus(code);
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onUpdateEnable = TpmDeductionMatchingTemplateLogEventListener::onUpdateEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionMatchingTemplateLogEventListener.class, (SerializableBiConsumer)onUpdateEnable);
        });
    }

    public TpmDeductionMatchingTemplateVo findByCode(String matchTemplateCode) {
        TpmDeductionMatchingTemplate template = this.tpmDeductionMatchingTemplateRepository.findByCode(matchTemplateCode);
        if (Objects.isNull((Object)template)) {
            return null;
        }
        TpmDeductionMatchingTemplateVo templateVo = (TpmDeductionMatchingTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)template, TpmDeductionMatchingTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmDeductionMatchingTemplateAllowanceVo> allowances = this.tpmDeductionMatchingTemplateAllowanceRepository.findByCode(templateVo.getCode());
        if (CollectionUtils.isNotEmpty(allowances)) {
            Map<String, List<TpmDeductionMatchingTemplateAllowanceVo>> allowancesMap = allowances.stream().collect(Collectors.groupingBy(TpmDeductionMatchingTemplateAllowanceVo::getAllowanceType));
            for (String key : allowancesMap.keySet()) {
                if (AllowanceTypeEnum.POS.getCode().equals(key)) {
                    templateVo.setPosAllowances(allowancesMap.get(key));
                }
                if (AllowanceTypeEnum.FEE.getCode().equals(key)) {
                    templateVo.setFeeAllowances(allowancesMap.get(key));
                }
                if (!AllowanceTypeEnum.STATEMENT.getCode().equals(key)) continue;
                templateVo.setStatementAllowances(allowancesMap.get(key));
            }
        }
        return templateVo;
    }

    public List<TpmDeductionMatchingTemplateVo> findByCodes(List<String> matchTemplateCodes) {
        if (CollectionUtils.isEmpty(matchTemplateCodes)) {
            return Lists.newArrayList();
        }
        List<TpmDeductionMatchingTemplate> templates = this.tpmDeductionMatchingTemplateRepository.findByCodes(matchTemplateCodes);
        if (CollectionUtils.isEmpty(templates)) {
            return Lists.newArrayList();
        }
        List templateVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(templates, TpmDeductionMatchingTemplate.class, TpmDeductionMatchingTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<TpmDeductionMatchingTemplateRules> rulesList = this.tpmDeductionMatchingTemplateRulesRepository.findByCodes(matchTemplateCodes);
        if (CollectionUtils.isNotEmpty(rulesList)) {
            List rulesVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(rulesList, TpmDeductionMatchingTemplateRules.class, TpmDeductionMatchingTemplateRulesVo.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<TpmDeductionMatchingTemplateRulesVo>> ruleVoMap = rulesVoList.stream().collect(Collectors.groupingBy(TpmDeductionMatchingTemplateRulesVo::getCode));
            templateVoList.forEach(e -> {
                if (ruleVoMap.containsKey(e.getCode())) {
                    e.setRulesList((List)ruleVoMap.get(e.getCode()));
                }
            });
        }
        return templateVoList;
    }

    private void createValidate(TpmDeductionMatchingTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDeductionMatchingTemplateType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u5339\u914d\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeMatchingCondition(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5355\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStatementMatchingCondition(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u7b97\u5355\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList feeMatchList = Lists.newArrayList((Object[])dto.getFeeMatchingCondition().split(","));
        ArrayList statementMatchList = Lists.newArrayList((Object[])dto.getStatementMatchingCondition().split(","));
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
            throw new IllegalArgumentException("\u5e74\u6708\u65e5\u548c\u5e74\u6708\u4e0d\u53ef\u540c\u65f6\u9009\u62e9");
        }
        if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
            throw new IllegalArgumentException("\u5e74\u6708\u65e5\u548c\u5e74\u6708\u4e0d\u53ef\u540c\u65f6\u9009\u62e9");
        }
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.EMPTY.getCode())) {
            Validate.isTrue((feeMatchList.size() == 1 ? 1 : 0) != 0, (String)"\u8d39\u7528\u5355\u5339\u914d\u6761\u4ef6\u914d\u7f6e\uff0c'\u65e0\u6761\u4ef6'\u53ea\u53ef\u5355\u9009", (Object[])new Object[0]);
        }
        if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.EMPTY.getCode())) {
            Validate.isTrue((statementMatchList.size() == 1 ? 1 : 0) != 0, (String)"\u7ed3\u7b97\u5355\u5339\u914d\u6761\u4ef6\u914d\u7f6e\uff0c'\u65e0\u6761\u4ef6'\u53ea\u53ef\u5355\u9009", (Object[])new Object[0]);
        }
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
            dto.setIsAddUpMapping(BooleanEnum.FALSE.getCapital());
        }
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.SETTLEMENT_CODE.getCode()) || dto.getFeeMatchingCondition().contains(DeductionMatchingTemplateConditionEnum.FEE_CODE.getCode())) {
            Validate.isTrue((feeMatchList.size() == 1 ? 1 : 0) != 0, (String)"\u9009\u62e9\u8d39\u7528\u5355\u7f16\u7801\u6216\u7ed3\u7b97\u5355\u7f16\u7801\u65f6\uff0c\u4e0d\u53ef\u9009\u62e9\u5176\u4ed6\u5339\u914d\u6761\u4ef6", (Object[])new Object[0]);
        }
        if (DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(dto.getDeductionMatchingTemplateType())) {
            Validate.noNullElements((Iterable)dto.getPosAllowances(), (String)"POS\u5355\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.getPosAllowances().forEach(a -> Validate.notBlank((CharSequence)a.getDataSource(), (String)"POS\u9002\u7528\u8303\u56f4\u7684\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        Validate.noNullElements((Iterable)dto.getFeeAllowances(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.getFeeAllowances().forEach(a -> {
            Validate.notBlank((CharSequence)a.getDataSource(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\u7684\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue());
                a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.DAY.getValue());
                a.setTimeAllowanceValue(Integer.valueOf(0));
            }
            if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
                Validate.notBlank((CharSequence)a.getTimeAllowanceType(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(a.getTimeAllowanceType())) {
                    Validate.notBlank((CharSequence)a.getBeginDate(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)a.getEndDate(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                } else {
                    a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue());
                    Validate.notNull((Object)a.getTimeAllowanceValue(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.isTrue((a.getTimeAllowanceValue() >= 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
                }
            }
            if (!feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && !feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(null);
                a.setTimeAllowanceUnit(null);
                a.setTimeAllowanceValue(null);
            }
        });
        Validate.noNullElements((Iterable)dto.getStatementAllowances(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.getStatementAllowances().forEach(a -> {
            Validate.notBlank((CharSequence)a.getDataSource(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\u7684\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue());
                a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.DAY.getValue());
                a.setTimeAllowanceValue(Integer.valueOf(0));
            }
            if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
                Validate.notBlank((CharSequence)a.getTimeAllowanceType(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(a.getTimeAllowanceType())) {
                    Validate.notBlank((CharSequence)a.getBeginDate(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)a.getEndDate(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                } else {
                    a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue());
                    Validate.notNull((Object)a.getTimeAllowanceValue(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.isTrue((a.getTimeAllowanceValue() >= 0 ? 1 : 0) != 0, (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
                }
            }
            if (!statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && !feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(null);
                a.setTimeAllowanceUnit(null);
                a.setTimeAllowanceValue(null);
            }
        });
    }

    private void updateValidate(TpmDeductionMatchingTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeMatchingCondition(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5355\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStatementMatchingCondition(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ed3\u7b97\u5355\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList feeMatchList = Lists.newArrayList((Object[])dto.getFeeMatchingCondition().split(","));
        ArrayList statementMatchList = Lists.newArrayList((Object[])dto.getStatementMatchingCondition().split(","));
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
            throw new IllegalArgumentException("\u5e74\u6708\u65e5\u548c\u5e74\u6708\u4e0d\u53ef\u540c\u65f6\u9009\u62e9");
        }
        if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
            throw new IllegalArgumentException("\u5e74\u6708\u65e5\u548c\u5e74\u6708\u4e0d\u53ef\u540c\u65f6\u9009\u62e9");
        }
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.EMPTY.getCode())) {
            Validate.isTrue((feeMatchList.size() == 1 ? 1 : 0) != 0, (String)"\u8d39\u7528\u5355\u5339\u914d\u6761\u4ef6\u914d\u7f6e\uff0c'\u65e0\u6761\u4ef6'\u53ea\u53ef\u5355\u9009", (Object[])new Object[0]);
        }
        if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.EMPTY.getCode())) {
            Validate.isTrue((statementMatchList.size() == 1 ? 1 : 0) != 0, (String)"\u7ed3\u7b97\u5355\u5339\u914d\u6761\u4ef6\u914d\u7f6e\uff0c'\u65e0\u6761\u4ef6'\u53ea\u53ef\u5355\u9009", (Object[])new Object[0]);
        }
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
            dto.setIsAddUpMapping(BooleanEnum.FALSE.getCapital());
        }
        if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.SETTLEMENT_CODE.getCode()) || dto.getFeeMatchingCondition().contains(DeductionMatchingTemplateConditionEnum.FEE_CODE.getCode())) {
            Validate.isTrue((feeMatchList.size() == 1 ? 1 : 0) != 0, (String)"\u9009\u62e9\u8d39\u7528\u5355\u7f16\u7801\u6216\u7ed3\u7b97\u5355\u7f16\u7801\u65f6\uff0c\u4e0d\u53ef\u9009\u62e9\u5176\u4ed6\u5339\u914d\u6761\u4ef6", (Object[])new Object[0]);
        }
        if (DeductionMatchingTemplateTypeEnum.DETAIL_POS_FEE_DETAIL_FEE_SETATEMENT.getCode().equals(dto.getDeductionMatchingTemplateType())) {
            Validate.noNullElements((Iterable)dto.getPosAllowances(), (String)"POS\u5355\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.getPosAllowances().forEach(a -> Validate.notBlank((CharSequence)a.getDataSource(), (String)"POS\u5355\u9002\u7528\u8303\u56f4\u7684\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        Validate.noNullElements((Iterable)dto.getFeeAllowances(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.getFeeAllowances().forEach(a -> {
            Validate.notBlank((CharSequence)a.getDataSource(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\u7684\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue());
                a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.DAY.getValue());
                a.setTimeAllowanceValue(Integer.valueOf(0));
            }
            if (feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
                Validate.notBlank((CharSequence)a.getTimeAllowanceType(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(a.getTimeAllowanceType())) {
                    Validate.notBlank((CharSequence)a.getBeginDate(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)a.getEndDate(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                } else {
                    a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue());
                    Validate.notNull((Object)a.getTimeAllowanceValue(), (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.isTrue((a.getTimeAllowanceValue() >= 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
                }
            }
            if (!feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && !feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(null);
                a.setTimeAllowanceUnit(null);
                a.setTimeAllowanceValue(null);
            }
        });
        Validate.noNullElements((Iterable)dto.getStatementAllowances(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.getStatementAllowances().forEach(a -> {
            Validate.notBlank((CharSequence)a.getDataSource(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\u7684\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue());
                a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.DAY.getValue());
                a.setTimeAllowanceValue(Integer.valueOf(0));
            }
            if (statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
                Validate.notBlank((CharSequence)a.getTimeAllowanceType(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(a.getTimeAllowanceType())) {
                    Validate.notBlank((CharSequence)a.getBeginDate(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)a.getEndDate(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e3a'\u6307\u5b9a\u8303\u56f4',\u65e5\u671f\u8303\u56f4-\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                } else {
                    a.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue());
                    Validate.notNull((Object)a.getTimeAllowanceValue(), (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.isTrue((a.getTimeAllowanceValue() >= 0 ? 1 : 0) != 0, (String)"\u7ed3\u7b97\u5355\u9002\u7528\u8303\u56f4\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
                }
            }
            if (!statementMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && !feeMatchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                a.setTimeAllowanceType(null);
                a.setTimeAllowanceUnit(null);
                a.setTimeAllowanceValue(null);
            }
        });
    }

    public Page<TpmDeductionMatchingTemplateVo> findByConditionsWithResaleCommercial(Pageable pageable, TpmDeductionMatchingTemplateSelectDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionMatchingTemplateSelectDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.tpmDeductionMatchingTemplateRepository.findByConditionsWithResaleCommercial(pageable, dto);
    }

    public List<TpmDeductionMatchingTemplateVo> findByDto(TpmDeductionMatchingTemplateDto dto) {
        List<TpmDeductionMatchingTemplate> list;
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionMatchingTemplateDto();
        }
        if (CollectionUtils.isEmpty(list = this.tpmDeductionMatchingTemplateRepository.findByDto(dto))) {
            return Lists.newArrayList();
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmDeductionMatchingTemplate.class, TpmDeductionMatchingTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> codes = voList.stream().map(TpmDeductionMatchingTemplateVo::getCode).collect(Collectors.toList());
        List<TpmDeductionMatchingTemplateRules> rulesList = this.tpmDeductionMatchingTemplateRulesRepository.findByCodes(codes);
        if (CollectionUtils.isNotEmpty(rulesList)) {
            List rulesVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(rulesList, TpmDeductionMatchingTemplateRules.class, TpmDeductionMatchingTemplateRulesVo.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<TpmDeductionMatchingTemplateRulesVo>> rulesVoMap = rulesVoList.stream().collect(Collectors.groupingBy(TpmDeductionMatchingTemplateRulesVo::getCode));
            voList.forEach(e -> {
                if (rulesVoMap.containsKey(e.getCode())) {
                    e.setRulesList((List)rulesVoMap.get(e.getCode()));
                }
            });
        }
        return voList;
    }

    public void updateByMappingUpdate(TpmDeductionMatchingTemplateDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getApplyMappingCode())) {
            return;
        }
        this.tpmDeductionMatchingTemplateRepository.updateByMappingUpdate(dto);
    }
}

