/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackForecastDto;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AuditFeeDiffTrackPassDetailedForecastUtil {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffTrackPassDetailedForecastUtil.class);
    @Autowired(required=false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private DetailedForecastRepository detailedForecastRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;
    @Autowired(required=false)
    private BusinessPolicyService businessPolicyService;
    @Autowired(required=false)
    private DetailedForecastMapper detailedForecastMapper;

    @Async(value="asyncThread")
    public void buildUnit1Param(AuditFeeDiffTrackForecastDto activityDetailPlanDto, DetailedForecastDto detailedForecastDto, AuditFeeDiffTrackDetailDto item, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u4e3b\u4f53\u65b0\u589e\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        if (StringUtils.isNotEmpty((CharSequence)item.getAuditType())) {
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
                dto.setAuditType(item.getAuditType());
                dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(detailedForecastDto.getRtmMode());
                dto.setFirstChannel(detailedForecastDto.getFirstChannelCode());
                dto.setSecondChannel(detailedForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(detailedForecastDto.getCustomerAccount());
                dto.setDisplayNumber(detailedForecastDto.getDisplayNumber());
                dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
                List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    CalculateDto calDto = this.buildCalParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                    this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, calDto);
                } else {
                    detailedForecastDto.setAuditFormulaCode(null);
                }
            } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
                AuditFormulaMainVo auditFormulaMainVo = null;
                try {
                    auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
                }
                catch (Exception e2) {
                    log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u7ec6\u6848\u9884\u6d4b\u4e3b\u4f53\u65b0\u589e\u8ba1\u7b97" + e2.getMessage(), (Throwable)e2);
                }
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
                this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
            } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
                detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
                detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
            }
        }
        this.insert(detailedForecastDto);
    }

    @Async(value="asyncThread")
    public void buildUnit3Param(DetailedForecastDto detailedForecastDto, AuditFeeDiffTrackDetailDto item, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditType());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97:\u67e5\u8be2\u6838\u9500\u516c\u5f0f\u4e3b\u8868{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString((Object)dto)});
            List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97:\u67e5\u8be2\u6838\u9500\u516c\u5f0f\u4e3b\u8868\u7ed3\u679c1{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString(formulaMainVoList.get(0))});
                CalculateDto calDto = this.buildCalParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
            }
            catch (Exception e2) {
                log.error("\u7ec6\u6848\u7f16\u7801[" + detailedForecastDto.getDetailedCaseCode() + "]\u660e\u7ec6\u7f16\u7801[" + detailedForecastDto.getActivityDetailItemCode() + "]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97" + e2.getMessage(), (Throwable)e2);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
        }
        this.insert(detailedForecastDto);
    }

    public CalculateDto buildCalParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, String auditType) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty((Collection)auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(detailedForecastDto.getCustomerCode());
            dto.setCustomerErpCode(detailedForecastDto.getCustomerErpCode());
            dto.setCustomerName(detailedForecastDto.getCustomer());
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityTypeName(detailedForecastDto.getActivityTypeName());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityFormName(detailedForecastDto.getActivityFormName());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(detailedForecastDto.getSaleOrgCode());
            dto.setSalesOrgErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setSalesOrganizationCode(detailedForecastDto.getSalesInstitutionCode());
            dto.setSalesOrganizationErpCode(detailedForecastDto.getSalesInstitutionErpCode());
            dto.setSalesRegionCode(detailedForecastDto.getSalesRegionCode());
            dto.setSalesRegionErpCode(detailedForecastDto.getSalesRegionErpCode());
            dto.setSalesGroupCode(detailedForecastDto.getSalesGroupCode());
            dto.setSalesGroupErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setProductCode(detailedForecastDto.getProductCode());
            dto.setYearMonthLy(detailedForecastDto.getYearMonthStr());
            dto.setStoresCode(detailedForecastDto.getTerminalCode());
            dto.setBrandCode(detailedForecastDto.getProductBrandCode());
            dto.setCategoryCode(detailedForecastDto.getProductCategoryCode());
            dto.setItemCode(detailedForecastDto.getProductItemCode());
            dto.setDetailPlanItemCode(detailedForecastDto.getActivityDetailItemCode());
            dto.setPlanItemCode(detailedForecastDto.getDetailedCaseCode());
            dto.setActivityOrgCode(detailedForecastDto.getRegion());
            dto.setActivityOrgName(detailedForecastDto.getRegionName());
            dto.setRetailBusinessmanCode(detailedForecastDto.getSystemCode());
            dto.setRetailBusinessmanName(detailedForecastDto.getSystemName());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setPersonCode(detailedForecastDto.getPersonCode());
            dto.setIdentityCard(detailedForecastDto.getIdentityCard());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setEstoreCustomerLevel(detailedForecastDto.getEstoreCustomerLevel());
            if (Objects.nonNull(detailedForecastDto.getActivityStartTime())) {
                String date = DateUtil.format((Date)detailedForecastDto.getActivityStartTime(), (String)"yyyy-MM-dd");
                if (date.length() == 10) {
                    dto.setDate(DateUtil.parse((String)date, (String)"yyyy-MM-dd"));
                } else if (date.length() == 19) {
                    dto.setDate(DateUtil.parse((String)date, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            dto.setDealerCode(detailedForecastDto.getCustomerErpCode());
            dto.setChannel(detailedForecastDto.getChannelCode());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setPersonIdCard(detailedForecastDto.getIdentityCard());
            dto.setFirstChannelCode(detailedForecastDto.getFirstChannelCode());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setHeadBudgetItemCode(detailedForecastDto.getHeadBudgetItemCode());
            dto.setMonthBudgetCode(detailedForecastDto.getMonthBudgetCode());
            dto.setSpecification(detailedForecastDto.getFormDescription());
            dto.setIsTemporary(detailedForecastDto.getIsTemporary());
            dto.setCusCreateTime(detailedForecastDto.getCusCreateTime());
            dto.setDistributionChannel(detailedForecastDto.getDistributionChannelCode());
            if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) && BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
                Map map = this.tpmCustomerSummaryConfigureService.configureIncludeMap((List)Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
                if (map.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerCodeList((Set)map.get(dto.getCustomerCode()));
                } else {
                    dto.setCustomerCodeList((Set)Sets.newHashSet((Object[])new String[]{dto.getCustomerCode()}));
                }
            }
            return dto;
        }
        log.info("\u7ec6\u6848\u9884\u6d4b=====\u300b\u6838\u9500\u6761\u4ef6\u4e3a\u7a7a");
        return null;
    }

    public void setParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, CalculateDto calDto) {
        if (Objects.isNull(calDto)) {
            return;
        }
        detailedForecastDto.setCalEx("");
        List calculateVos = Lists.newArrayList();
        try {
            calDto.setIsDiffTrack(Boolean.valueOf(true));
            log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97:\u83b7\u53d6\u8ba1\u7b97\u6761\u4ef6&\u516c\u5f0f\u53c2\u6570{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString((Object)calDto)});
            calculateVos = this.variableService.orCalculateConditionAndExpression((List)Lists.newArrayList((Object[])new CalculateDto[]{calDto}));
            log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u5782\u76f4\u65b0\u589e\u8ba1\u7b97:\u83b7\u53d6\u8ba1\u7b97\u6761\u4ef6&\u516c\u5f0f\u8fd4\u56de{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString(calculateVos)});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (StringUtils.isNotEmpty((CharSequence)ex.getMessage())) {
                int length = Math.min(ex.getMessage().length(), 200);
                detailedForecastDto.setCalEx(ex.getMessage().substring(0, length));
            } else {
                detailedForecastDto.setCalEx("NPE");
            }
            log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u8ba1\u7b97\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), ex.getMessage()});
        }
        AtomicReference<String> filterCondition = new AtomicReference<String>();
        List filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("\u6838\u9500\u516c\u5f0f\u7f16\u7801 [" + auditFormulaMainVo.getAuditFormulaCode() + "] \u8ba1\u7b97\u7ed3\u679c\uff1a\u591a\u4e2a\u6838\u9500\u516c\u5f0f\u6761\u4ef6\u540c\u65f6\u6ee1\u8db3\uff01");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(((CalculateVo)filterVos.get(0)).getFormulaConditionName());
        }
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = ((CalculateVo)filterVos.get(0)).getFormulaValue();
        } else {
            log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u672a\u6ee1\u8db3\u516c\u5f0f\u4efb\u4f55\u6761\u4ef6\uff0c\u9ed8\u8ba4\u9884\u6838\u9500\u91d1\u989d\u4e3a0\uff01", (Object)detailedForecastDto.getDetailedCaseCode(), (Object)detailedForecastDto.getActivityDetailItemCode());
        }
        HashMap variableValueMap = new HashMap();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });
        ArrayList variableCodeList = new ArrayList();
        for (CalculateVo calculateVo : calculateVos) {
            if (!Objects.nonNull(calculateVo.getVariableValueMap())) continue;
            variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
        }
        Map variableNameMap = this.variableService.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);
        HashMap conditionValueMap = new HashMap();
        HashMap formulaValueMap = new HashMap();
        ArrayList canAuditPreList = new ArrayList();
        auditFormulaMainVo.getAuditFormulaInfoVoList().forEach(formula -> {
            Set formulaCondition = MathUtil.getFormulaReplace((String)formula.getAuditFormulaCondition());
            formulaCondition.forEach(v -> {
                if (conditionValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + ((BigDecimal)variableValueMap.get(v)).toString());
                    return;
                }
                conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
            });
            Set auditFormula = MathUtil.getFormulaReplace((String)formula.getAuditFormula());
            auditFormula.forEach(v -> {
                if (formulaValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + ((BigDecimal)variableValueMap.get(v)).toString());
                    return;
                }
                formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                canAuditPreList.add(variableNameMap.getOrDefault(v, v) + "\u8fbe\u6807");
            });
        });
        detailedForecastDto.setCalParam(JSON.toJSONString((Object)calDto));
        detailedForecastDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        detailedForecastDto.setWriteOffConditions(auditFormulaMainVo.getAuditFormulaInfoVoList().stream().filter(e -> StringUtils.equals((CharSequence)e.getAuditFormulaConditionName(), (CharSequence)((CharSequence)filterCondition.get()))).map(AuditFormulaInfoVo::getAuditFormulaConditionName).filter(Objects::nonNull).collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffFormula(auditFormulaMainVo.getAuditFormulaInfoVoList().stream().filter(e -> StringUtils.equals((CharSequence)e.getAuditFormulaConditionName(), (CharSequence)((CharSequence)filterCondition.get()))).map(AuditFormulaInfoVo::getAuditFormulaName).filter(Objects::nonNull).collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffConditionValue(String.join((CharSequence)" , ", conditionValueMap.values()));
        detailedForecastDto.setWriteOffFormulaValue(String.join((CharSequence)" , ", formulaValueMap.values()));
        detailedForecastDto.setEstimatedWriteOffAmount(estimatedWriteOffAmount);
        detailedForecastDto.setWriteOffPremise(String.join((CharSequence)" , ", canAuditPreList));
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(DetailedForecastDto detailedForecastDto) {
        DetailedForecastEntity detailedForecastEntity = (DetailedForecastEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailedForecastDto, DetailedForecastEntity.class, null, null, new String[0]);
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        detailedForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailedForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailedForecastEntity.setShowFlag(YesOrNoEnum.YES.getCode());
        if (StringUtils.isNotEmpty((CharSequence)detailedForecastEntity.getYearMonthStr())) {
            detailedForecastEntity.setYearMonthLy(DateUtil.parse((String)(detailedForecastEntity.getYearMonthStr() + "-01 00:00:00"), (String)"yyyy-MM"));
        }
        detailedForecastEntity.setOnlyKey(this.packageOnlyKey(detailedForecastEntity, null));
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer & Serializable onCreate = DetailedForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DetailedForecastLogEventListener.class, (SerializableBiConsumer)onCreate);
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4bdto insert", (Object)JSON.toJSONString((Object)detailedForecastDto));
        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4binsert", (Object)JSON.toJSONString((Object)detailedForecastEntity));
        this.detailedForecastRepository.save(detailedForecastEntity);
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        ArrayList<FormulaInfoDto> list = new ArrayList<FormulaInfoDto>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }

    public String packageOnlyKey(DetailedForecastEntity entity, String timeStamp) {
        if (StringUtils.isEmpty((CharSequence)timeStamp)) {
            timeStamp = "";
        }
        return DigestUtils.md5Hex((String)(entity.getDetailedCaseCode() + entity.getActivityDetailItemCode() + timeStamp));
    }
}

